# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2011 Kristian Høgsberg
# Copyright © 2010-2011 Intel Corporation
# Copyright © 2012-2013 Collabora, Ltd.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice (including the
# next paragraph) shall be included in all copies or substantial
# portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class WlDataSource(Interface):
    """Offer to transfer data

    The :class:`WlDataSource` object is the source side of a
    :class:`~pywayland.protocol.wayland.WlDataOffer`. It is created by the
    source client in a data transfer and provides a way to describe the offered
    data and a way to respond to requests to transfer the data.
    """

    name = "wl_data_source"
    version = 3

    class error(enum.IntEnum):
        invalid_action_mask = 0
        invalid_source = 1


class WlDataSourceProxy(Proxy[WlDataSource]):
    interface = WlDataSource

    @WlDataSource.request(
        Argument(ArgumentType.String),
    )
    def offer(self, mime_type: str) -> None:
        """Add an offered mime type

        This request adds a mime type to the set of mime types advertised to
        targets.  Can be called several times to offer multiple types.

        :param mime_type:
            mime type offered by the data source
        :type mime_type:
            `ArgumentType.String`
        """
        self._marshal(0, mime_type)

    @WlDataSource.request()
    def destroy(self) -> None:
        """Destroy the data source

        Destroy the data source.
        """
        self._marshal(1)
        self._destroy()

    @WlDataSource.request(
        Argument(ArgumentType.Uint),
        version=3,
    )
    def set_actions(self, dnd_actions: int) -> None:
        """Set the available drag-and-drop actions

        Sets the actions that the source side client supports for this
        operation. This request may trigger :func:`WlDataSource.action()` and
        :func:`WlDataOffer.action()
        <pywayland.protocol.wayland.WlDataOffer.action>` events if the
        compositor needs to change the selected action.

        The dnd_actions argument must contain only values expressed in the
        :func:`WlDataDeviceManager.dnd_actions()
        <pywayland.protocol.wayland.WlDataDeviceManager.dnd_actions>` enum,
        otherwise it will result in a protocol error.

        This request must be made once only, and can only be made on sources
        used in drag-and-drop, so it must be performed before
        :func:`WlDataDevice.start_drag()
        <pywayland.protocol.wayland.WlDataDevice.start_drag>`. Attempting to
        use the source other than for drag-and-drop will raise a protocol
        error.

        :param dnd_actions:
            actions supported by the data source
        :type dnd_actions:
            `ArgumentType.Uint`
        """
        self._marshal(2, dnd_actions)


class WlDataSourceResource(Resource):
    interface = WlDataSource

    @WlDataSource.event(
        Argument(ArgumentType.String, nullable=True),
    )
    def target(self, mime_type: str | None) -> None:
        """A target accepts an offered mime type

        Sent when a target accepts pointer_focus or motion events.  If a target
        does not accept any of the offered types, type is NULL.

        Used for feedback during drag-and-drop.

        :param mime_type:
            mime type accepted by the target
        :type mime_type:
            `ArgumentType.String` or `None`
        """
        self._post_event(0, mime_type)

    @WlDataSource.event(
        Argument(ArgumentType.String),
        Argument(ArgumentType.FileDescriptor),
    )
    def send(self, mime_type: str, fd: int) -> None:
        """Send the data

        Request for data from the client.  Send the data as the specified mime
        type over the passed file descriptor, then close it.

        :param mime_type:
            mime type for the data
        :type mime_type:
            `ArgumentType.String`
        :param fd:
            file descriptor for the data
        :type fd:
            `ArgumentType.FileDescriptor`
        """
        self._post_event(1, mime_type, fd)

    @WlDataSource.event()
    def cancelled(self) -> None:
        """Selection was cancelled

        This data source is no longer valid. There are several reasons why this
        could happen:

        - The data source has been replaced by another data source.

        - The drag-and-drop operation was performed, but the drop destination
          did not accept any of the mime types offered through
          :func:`WlDataSource.target()`.

        - The drag-and-drop operation was performed, but the drop destination
          did not select any of the actions present in the mask offered through
          :func:`WlDataSource.action()`.

        - The drag-and-drop operation was performed but didn't happen over a
          surface.

        - The compositor cancelled the drag-and-drop operation (e.g. compositor
          dependent timeouts to avoid stale drag-and-drop transfers).

        The client should clean up and destroy this data source.

        For objects of version 2 or older, :func:`WlDataSource.cancelled()`
        will only be emitted if the data source was replaced by another data
        source.
        """
        self._post_event(2)

    @WlDataSource.event(version=3)
    def dnd_drop_performed(self) -> None:
        """The drag-and-drop operation physically finished

        The user performed the drop action. This event does not indicate
        acceptance, :func:`WlDataSource.cancelled()` may still be emitted
        afterwards if the drop destination does not accept any mime type.

        However, this event might however not be received if the compositor
        cancelled the drag-and-drop operation before this event could happen.

        Note that the data_source may still be used in the future and should
        not be destroyed here.
        """
        self._post_event(3)

    @WlDataSource.event(version=3)
    def dnd_finished(self) -> None:
        """The drag-and-drop operation concluded

        The drop destination finished interoperating with this data source, so
        the client is now free to destroy this data source and free all
        associated data.

        If the action used to perform the operation was "move", the source can
        now delete the transferred data.
        """
        self._post_event(4)

    @WlDataSource.event(
        Argument(ArgumentType.Uint),
        version=3,
    )
    def action(self, dnd_action: int) -> None:
        """Notify the selected action

        This event indicates the action selected by the compositor after
        matching the source/destination side actions. Only one action (or none)
        will be offered here.

        This event can be emitted multiple times during the drag-and-drop
        operation, mainly in response to destination side changes through
        :func:`WlDataOffer.set_actions()
        <pywayland.protocol.wayland.WlDataOffer.set_actions>`, and as the data
        device enters/leaves surfaces.

        It is only possible to receive this event after
        :func:`WlDataSource.dnd_drop_performed()` if the drag-and-drop
        operation ended in an "ask" action, in which case the final
        :func:`WlDataSource.action()` event will happen immediately before
        :func:`WlDataSource.dnd_finished()`.

        Compositors may also change the selected action on the fly, mainly in
        response to keyboard modifier changes during the drag-and-drop
        operation.

        The most recent action received is always the valid one. The chosen
        action may change alongside negotiation (e.g. an "ask" action can turn
        into a "move" operation), so the effects of the final action must
        always be applied in :func:`WlDataOffer.dnd_finished()
        <pywayland.protocol.wayland.WlDataOffer.dnd_finished>`.

        Clients can trigger cursor surface changes from this point, so they
        reflect the current action.

        :param dnd_action:
            action selected by the compositor
        :type dnd_action:
            `ArgumentType.Uint`
        """
        self._post_event(5, dnd_action)


class WlDataSourceGlobal(Global):
    interface = WlDataSource


WlDataSource._gen_c()
WlDataSource.proxy_class = WlDataSourceProxy
WlDataSource.resource_class = WlDataSourceResource
WlDataSource.global_class = WlDataSourceGlobal
