/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.escape;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.firebirdsql.jdbc.escape.CharacterLengthFunction;
import org.firebirdsql.jdbc.escape.ConstantSQLFunction;
import org.firebirdsql.jdbc.escape.ConvertFunction;
import org.firebirdsql.jdbc.escape.FBEscapedParser;
import org.firebirdsql.jdbc.escape.FBSQLParseException;
import org.firebirdsql.jdbc.escape.LengthFunction;
import org.firebirdsql.jdbc.escape.LocateFunction;
import org.firebirdsql.jdbc.escape.PatternSQLFunction;
import org.firebirdsql.jdbc.escape.PositionFunction;
import org.firebirdsql.jdbc.escape.SQLFunction;
import org.firebirdsql.jdbc.escape.TimestampAddFunction;
import org.firebirdsql.jdbc.escape.TimestampDiffFunction;

public class FBEscapedFunctionHelper {
    private static final Map<String, SQLFunction> FUNCTION_MAP;
    private static final Set<String> SUPPORTED_NUMERIC_FUNCTIONS;
    private static final Set<String> SUPPORTED_STRING_FUNCTIONS;
    private static final Set<String> SUPPORTED_TIME_DATE_FUNCTIONS;
    private static final Set<String> SUPPORTED_SYSTEM_FUNCTIONS;

    private static Map<String, SQLFunction> getNumericFunctions() {
        HashMap<String, SQLFunction> functionMap = new HashMap<String, SQLFunction>(32);
        functionMap.put("ABS", null);
        functionMap.put("ACOS", null);
        functionMap.put("ASIN", null);
        functionMap.put("ATAN", null);
        functionMap.put("ATAN2", null);
        functionMap.put("CEILING", null);
        functionMap.put("COS", null);
        functionMap.put("COT", null);
        functionMap.put("DEGREES", new PatternSQLFunction("(({0})*180.0/PI())"));
        functionMap.put("EXP", null);
        functionMap.put("FLOOR", null);
        functionMap.put("LOG", new PatternSQLFunction("LN({0})"));
        functionMap.put("LOG10", null);
        functionMap.put("MOD", null);
        functionMap.put("PI", null);
        functionMap.put("POWER", null);
        functionMap.put("RADIANS", new PatternSQLFunction("(({0})*PI()/180.0)"));
        functionMap.put("ROUND", null);
        functionMap.put("SIGN", null);
        functionMap.put("SIN", null);
        functionMap.put("SQRT", null);
        functionMap.put("TAN", null);
        functionMap.put("TRUNCATE", new PatternSQLFunction("TRUNC({0},{1})"));
        return functionMap;
    }

    private static Map<String, SQLFunction> getStringFunctions() {
        HashMap<String, SQLFunction> functionMap = new HashMap<String, SQLFunction>(32);
        functionMap.put("ASCII", new PatternSQLFunction("ASCII_VAL({0})"));
        functionMap.put("CHAR", new PatternSQLFunction("ASCII_CHAR({0})"));
        CharacterLengthFunction characterLengthFunction = new CharacterLengthFunction();
        functionMap.put("CHAR_LENGTH", characterLengthFunction);
        functionMap.put("CHARACTER_LENGTH", characterLengthFunction);
        functionMap.put("CONCAT", new PatternSQLFunction("({0}||{1})"));
        functionMap.put("INSERT", new PatternSQLFunction("OVERLAY({0} PLACING {3} FROM {1} FOR {2})"));
        functionMap.put("LCASE", new PatternSQLFunction("LOWER({0})"));
        functionMap.put("LEFT", null);
        functionMap.put("LENGTH", new LengthFunction());
        functionMap.put("LOCATE", new LocateFunction());
        functionMap.put("LTRIM", new PatternSQLFunction("TRIM(LEADING FROM {0})"));
        functionMap.put("OCTET_LENGTH", null);
        functionMap.put("POSITION", new PositionFunction());
        functionMap.put("REPEAT", new PatternSQLFunction("RPAD('''',{1},{0})"));
        functionMap.put("REPLACE", null);
        functionMap.put("RIGHT", null);
        functionMap.put("RTRIM", new PatternSQLFunction("TRIM(TRAILING FROM {0})"));
        functionMap.put("SPACE", new PatternSQLFunction("RPAD('''',{0})"));
        functionMap.put("SUBSTRING", new PatternSQLFunction("SUBSTRING({0} FROM {1} FOR {2})"));
        functionMap.put("UCASE", new PatternSQLFunction("UPPER({0})"));
        return functionMap;
    }

    private static Map<String, SQLFunction> getTimeDateFunctions() {
        HashMap<String, SQLFunction> functionMap = new HashMap<String, SQLFunction>(32);
        ConstantSQLFunction currentDate = new ConstantSQLFunction("CURRENT_DATE");
        functionMap.put("CURRENT_DATE", currentDate);
        ConstantSQLFunction currentTime = new ConstantSQLFunction("CURRENT_TIME");
        functionMap.put("CURRENT_TIME", currentTime);
        ConstantSQLFunction currentTimestamp = new ConstantSQLFunction("CURRENT_TIMESTAMP");
        functionMap.put("CURRENT_TIMESTAMP", currentTimestamp);
        functionMap.put("CURDATE", currentDate);
        functionMap.put("CURTIME", currentTime);
        functionMap.put("DAYNAME", new PatternSQLFunction("trim(decode(extract(weekday from {0}), 0, ''Sunday'', 1, ''Monday'', 2, ''Tuesday'', 3, ''Wednesday'', 4, ''Thursday'', 5, ''Friday'', 6, ''Saturday''))"));
        functionMap.put("DAYOFMONTH", new PatternSQLFunction("EXTRACT(DAY FROM {0})"));
        functionMap.put("DAYOFWEEK", new PatternSQLFunction("EXTRACT(WEEKDAY FROM {0})+1"));
        functionMap.put("DAYOFYEAR", new PatternSQLFunction("EXTRACT(YEARDAY FROM {0})+1"));
        functionMap.put("EXTRACT", null);
        functionMap.put("HOUR", new PatternSQLFunction("EXTRACT(HOUR FROM {0})"));
        functionMap.put("MINUTE", new PatternSQLFunction("EXTRACT(MINUTE FROM {0})"));
        functionMap.put("MONTH", new PatternSQLFunction("EXTRACT(MONTH FROM {0})"));
        functionMap.put("MONTHNAME", new PatternSQLFunction("trim(decode(extract(month from {0}), 1, ''January'', 2, ''February'', 3, ''March'', 4, ''April'', 5, ''May'', 6, ''June'', 7, ''July'', 8, ''August'', 9, ''September'', 10, ''October'', 11, ''November'', 12, ''December''))"));
        functionMap.put("NOW", currentTimestamp);
        functionMap.put("QUARTER", new PatternSQLFunction("(1+(EXTRACT(MONTH FROM {0})-1)/3)"));
        functionMap.put("SECOND", new PatternSQLFunction("EXTRACT(SECOND FROM {0})"));
        functionMap.put("TIMESTAMPADD", new TimestampAddFunction());
        functionMap.put("TIMESTAMPDIFF", new TimestampDiffFunction());
        functionMap.put("WEEK", new PatternSQLFunction("EXTRACT(WEEK FROM {0})"));
        functionMap.put("YEAR", new PatternSQLFunction("EXTRACT(YEAR FROM {0})"));
        return functionMap;
    }

    private static Map<String, SQLFunction> getSystemFunctions() {
        HashMap<String, SQLFunction> functionMap = new HashMap<String, SQLFunction>(4, 1.0f);
        functionMap.put("DATABASE", new ConstantSQLFunction("RDB$GET_CONTEXT('SYSTEM', 'DB_NAME')"));
        functionMap.put("IFNULL", new PatternSQLFunction("COALESCE({0}, {1})"));
        functionMap.put("USER", new ConstantSQLFunction("USER"));
        return functionMap;
    }

    private static void checkSyntax(String functionCall) throws FBSQLParseException {
        int parenthesisStart = functionCall.indexOf(40);
        if (parenthesisStart != -1 && functionCall.charAt(functionCall.length() - 1) != ')') {
            throw new FBSQLParseException("No closing parenthesis found, not a function call.");
        }
    }

    public static String parseFunction(String functionCall) throws FBSQLParseException {
        functionCall = functionCall.trim();
        FBEscapedFunctionHelper.checkSyntax(functionCall);
        int parenthesisStart = functionCall.indexOf(40);
        return parenthesisStart != -1 ? functionCall.substring(0, parenthesisStart) : functionCall;
    }

    public static List<String> parseArguments(String functionCall) throws FBSQLParseException {
        functionCall = functionCall.trim();
        FBEscapedFunctionHelper.checkSyntax(functionCall);
        int parenthesisStart = functionCall.indexOf(40);
        if (parenthesisStart == -1) {
            return Collections.emptyList();
        }
        String paramsString = functionCall.substring(parenthesisStart + 1, functionCall.length() - 1);
        ArrayList<String> params = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean inQuotes = false;
        boolean inDoubleQuotes = false;
        boolean coalesceSpace = true;
        int nestedParentheses = 0;
        int n = paramsString.length();
        block7: for (int i = 0; i < n; ++i) {
            char currentChar = paramsString.charAt(i);
            if (Character.isWhitespace(currentChar)) {
                if (inQuotes || inDoubleQuotes) {
                    sb.append(currentChar);
                    continue;
                }
                if (coalesceSpace) continue;
                sb.append(' ');
                coalesceSpace = true;
                continue;
            }
            switch (currentChar) {
                case '\'': {
                    sb.append(currentChar);
                    if (!inDoubleQuotes) {
                        inQuotes = !inQuotes;
                    }
                    coalesceSpace = false;
                    continue block7;
                }
                case '\"': {
                    sb.append(currentChar);
                    if (!inQuotes) {
                        inDoubleQuotes = !inDoubleQuotes;
                    }
                    coalesceSpace = false;
                    continue block7;
                }
                case '(': {
                    if (!inQuotes && !inDoubleQuotes) {
                        ++nestedParentheses;
                    }
                    sb.append('(');
                    coalesceSpace = false;
                    continue block7;
                }
                case ')': {
                    if (!inQuotes && !inDoubleQuotes && --nestedParentheses < 0) {
                        throw new FBSQLParseException("Unbalanced parentheses in parameters at position " + i);
                    }
                    sb.append(')');
                    coalesceSpace = false;
                    continue block7;
                }
                case ',': {
                    if (inQuotes || inDoubleQuotes || nestedParentheses > 0) {
                        sb.append(currentChar);
                        continue block7;
                    }
                    params.add(sb.toString());
                    sb.setLength(0);
                    coalesceSpace = true;
                    continue block7;
                }
                default: {
                    sb.append(currentChar);
                    coalesceSpace = false;
                }
            }
        }
        if (sb.length() > 0) {
            params.add(sb.toString());
        }
        if (inQuotes || inDoubleQuotes) {
            throw new FBSQLParseException("String literal is not properly closed.");
        }
        if (nestedParentheses != 0) {
            throw new FBSQLParseException("Unbalanced parentheses in parameters.");
        }
        return params;
    }

    public static String convertTemplate(String functionCall, FBEscapedParser.EscapeParserMode mode) throws FBSQLParseException {
        String functionName = FBEscapedFunctionHelper.parseFunction(functionCall).toUpperCase(Locale.ROOT);
        String[] params = FBEscapedFunctionHelper.parseArguments(functionCall).toArray(new String[0]);
        if (!FUNCTION_MAP.containsKey(functionName)) {
            throw new FBSQLParseException("Unsupported JDBC function escape: " + functionName);
        }
        SQLFunction firebirdTemplate = FUNCTION_MAP.get(functionName);
        if (firebirdTemplate != null) {
            return firebirdTemplate.apply(params);
        }
        if (mode == FBEscapedParser.EscapeParserMode.USE_STANDARD_UDF) {
            return FBEscapedFunctionHelper.convertUsingStandardUDF(functionName, params);
        }
        return null;
    }

    private static String convertUsingStandardUDF(String name, String[] params) throws FBSQLParseException {
        try {
            name = name.toLowerCase(Locale.ROOT);
            Method method = FBEscapedFunctionHelper.class.getMethod(name, String[].class);
            return (String)method.invoke(null, new Object[]{params});
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new FBSQLParseException("Error when converting function " + name + ". Error " + ex.getClass().getName() + " : " + ex.getMessage());
        }
    }

    public static String abs(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function abs : " + params.length);
        }
        return "abs(" + params[0] + ")";
    }

    public static String acos(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function acos : " + params.length);
        }
        return "acos(" + params[0] + ")";
    }

    public static String asin(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function asin : " + params.length);
        }
        return "asin(" + params[0] + ")";
    }

    public static String atan(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function atan : " + params.length);
        }
        return "atan(" + params[0] + ")";
    }

    public static String atan2(String[] params) throws FBSQLParseException {
        if (params.length != 2) {
            throw new FBSQLParseException("Incorrect number of parameters of function atan2 : " + params.length);
        }
        return "atan2(" + params[0] + ", " + params[1] + ")";
    }

    public static String ceiling(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function ceiling : " + params.length);
        }
        return "ceiling(" + params[0] + ")";
    }

    public static String cos(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function cos : " + params.length);
        }
        return "cos(" + params[0] + ")";
    }

    public static String cot(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function cot : " + params.length);
        }
        return "cot(" + params[0] + ")";
    }

    public static String floor(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function floor : " + params.length);
        }
        return "floor(" + params[0] + ")";
    }

    public static String log10(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function log10 : " + params.length);
        }
        return "log10(" + params[0] + ")";
    }

    public static String mod(String[] params) throws FBSQLParseException {
        if (params.length != 2) {
            throw new FBSQLParseException("Incorrect number of parameters of function mod : " + params.length);
        }
        return "mod(" + params[0] + ", " + params[1] + ")";
    }

    public static String pi(String[] params) throws FBSQLParseException {
        if (params.length != 0) {
            throw new FBSQLParseException("Incorrect number of parameters of function pi : " + params.length);
        }
        return "pi()";
    }

    public static String rand(String[] params) throws FBSQLParseException {
        if (params.length != 0) {
            throw new FBSQLParseException("Incorrect number of parameters of function rand : " + params.length);
        }
        return "rand()";
    }

    public static String sign(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function sign : " + params.length);
        }
        return "sign(" + params[0] + ")";
    }

    public static String sin(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function sin : " + params.length);
        }
        return "sin(" + params[0] + ")";
    }

    public static String sqrt(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function sqrt : " + params.length);
        }
        return "sqrt(" + params[0] + ")";
    }

    public static String tan(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function tan : " + params.length);
        }
        return "tan(" + params[0] + ")";
    }

    public static Set<String> getSupportedNumericFunctions() {
        return SUPPORTED_NUMERIC_FUNCTIONS;
    }

    public static Set<String> getSupportedStringFunctions() {
        return SUPPORTED_STRING_FUNCTIONS;
    }

    public static Set<String> getSupportedTimeDateFunctions() {
        return SUPPORTED_TIME_DATE_FUNCTIONS;
    }

    public static Set<String> getSupportedSystemFunctions() {
        return SUPPORTED_SYSTEM_FUNCTIONS;
    }

    static {
        HashMap<String, SQLFunction> functionMap = new HashMap<String, SQLFunction>(71);
        Map<String, SQLFunction> numericFunctionMap = FBEscapedFunctionHelper.getNumericFunctions();
        SUPPORTED_NUMERIC_FUNCTIONS = Collections.unmodifiableSet(new HashSet<String>(numericFunctionMap.keySet()));
        functionMap.putAll(numericFunctionMap);
        Map<String, SQLFunction> stringFunctionMap = FBEscapedFunctionHelper.getStringFunctions();
        SUPPORTED_STRING_FUNCTIONS = Collections.unmodifiableSet(new HashSet<String>(stringFunctionMap.keySet()));
        functionMap.putAll(stringFunctionMap);
        Map<String, SQLFunction> timeDateFunctionMap = FBEscapedFunctionHelper.getTimeDateFunctions();
        SUPPORTED_TIME_DATE_FUNCTIONS = Collections.unmodifiableSet(new HashSet<String>(timeDateFunctionMap.keySet()));
        functionMap.putAll(timeDateFunctionMap);
        Map<String, SQLFunction> systemFunctionMap = FBEscapedFunctionHelper.getSystemFunctions();
        SUPPORTED_SYSTEM_FUNCTIONS = Collections.unmodifiableSet(new HashSet<String>(systemFunctionMap.keySet()));
        functionMap.putAll(systemFunctionMap);
        functionMap.put("CONVERT", new ConvertFunction());
        functionMap.put("RAND", null);
        functionMap.put("DIFFERENCE", null);
        functionMap.put("SOUNDEX", null);
        FUNCTION_MAP = Collections.unmodifiableMap(functionMap);
    }
}

