/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OCI_INTERNAL})
class T2CPlsqlIndexTableAccessor
extends PlsqlIndexTableAccessor {
    int ibtMetaIndex;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    T2CPlsqlIndexTableAccessor(OracleStatement stmt, PlsqlIbtBindInfo ibtBindInfo_, short form) throws SQLException {
        super(stmt, ibtBindInfo_, form);
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$3, null, stmt, ibtBindInfo_, form);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$3, null);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$3, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$0, this, n2, n3, string);
            }
            this.unimpl("initForDataAccess");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object[] getPlsqlIndexTable(int n2) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            Object[] result;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$1, this, n2);
            }
            short[] ibtBindIndicators = this.statement.ibtBindIndicators;
            int actualElements = ((ibtBindIndicators[this.ibtMetaIndex + 4] & 0xFFFF) << 16) + (ibtBindIndicators[this.ibtMetaIndex + 5] & 0xFFFF);
            long offset = this.getOffset((int)currentRow);
            int maxLength = this.ibtBindInfo.elemMaxLen;
            switch (this.ibtBindInfo.element_internal_type) {
                case 9: {
                    int[] out_lengthInChars = new int[1];
                    result = new String[actualElements];
                    for (int i2 = 0; i2 < actualElements; ++i2) {
                        this.rowData.setPosition(offset);
                        char[] c2 = this.rowData.getChars(offset, 1, this.statement.connection.conversion.getCharacterSet((short)1), out_lengthInChars);
                        int len = c2[0] / 2;
                        this.rowData.setPosition(offset + 1L);
                        result[i2] = len == 0 ? null : this.rowData.getString(len, this.statement.connection.conversion.getCharacterSet((short)1));
                        offset += (long)maxLength;
                    }
                    break;
                }
                case 6: {
                    result = new BigDecimal[actualElements];
                    for (int i3 = 0; i3 < actualElements; ++i3) {
                        this.rowData.setPosition(offset);
                        int len = this.rowData.get() & 0xFF;
                        result[i3] = len == 0 ? null : oracle.sql.NUMBER.toBigDecimal(this.rowData.getBytes(len));
                        offset += (long)maxLength;
                    }
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$1, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            Object[] objectArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$1, this, objectArray);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$1, this, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Datum[] getOraclePlsqlIndexTable(int n2) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$2, this, n2);
            }
            short[] ibtBindIndicators = this.statement.ibtBindIndicators;
            int actualElements = ((ibtBindIndicators[this.ibtMetaIndex + 4] & 0xFFFF) << 16) + (ibtBindIndicators[this.ibtMetaIndex + 5] & 0xFFFF);
            long offset = this.getOffset((int)currentRow);
            int maxLength = this.ibtBindInfo.elemMaxLen;
            Datum[] result = null;
            switch (this.ibtBindInfo.element_internal_type) {
                case 9: {
                    int[] out_lengthInChars = new int[1];
                    result = new CHAR[actualElements];
                    CharacterSet charset = this.statement.connection.conversion.getDriverCharSetObj();
                    for (int i2 = 0; i2 < actualElements; ++i2) {
                        this.rowData.setPosition(offset);
                        char[] c2 = this.rowData.getChars(offset, 1, this.statement.connection.conversion.getCharacterSet((short)1), out_lengthInChars);
                        int len = c2[0] / 2;
                        this.rowData.setPosition(offset + 1L);
                        if (len == 0) {
                            result[i2] = null;
                        } else {
                            String s2 = this.rowData.getString(len, this.statement.connection.conversion.getCharacterSet((short)1));
                            result[i2] = new CHAR(s2, charset);
                        }
                        offset += (long)maxLength;
                    }
                    break;
                }
                case 6: {
                    result = new NUMBER[actualElements];
                    for (int i3 = 0; i3 < actualElements; ++i3) {
                        this.rowData.setPosition(offset);
                        int len = this.rowData.get() & 0xFF;
                        result[i3] = len == 0 ? null : new NUMBER(this.rowData.getBytes(len));
                        offset += (long)maxLength;
                    }
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$2, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            Datum[] datumArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$2, this, datumArray);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$2, this, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T2CPlsqlIndexTableAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$3 = T2CPlsqlIndexTableAccessor.class.getDeclaredConstructor(OracleStatement.class, PlsqlIbtBindInfo.class, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T2CPlsqlIndexTableAccessor.class.getDeclaredMethod("getOraclePlsqlIndexTable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T2CPlsqlIndexTableAccessor.class.getDeclaredMethod("getPlsqlIndexTable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T2CPlsqlIndexTableAccessor.class.getDeclaredMethod("initForDataAccess", Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

