/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;
import us.fatehi.utility.Utility;

public abstract class BaseCommandProvider
implements CommandProvider {
    private final Collection<CommandDescription> supportedCommands;

    public BaseCommandProvider(Collection<CommandDescription> supportedCommands) {
        this.supportedCommands = Objects.requireNonNull(supportedCommands, "No supported commands provided");
    }

    public BaseCommandProvider(CommandDescription supportedCommand) {
        this(Arrays.asList(Objects.requireNonNull(supportedCommand, "No command provided")));
    }

    @Override
    public PluginCommand getCommandLineCommand() {
        return PluginCommand.empty();
    }

    @Override
    public final Collection<CommandDescription> getSupportedCommands() {
        return new ArrayList<CommandDescription>(this.supportedCommands);
    }

    @Override
    public boolean supportsSchemaCrawlerCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, Config additionalConfig, OutputOptions outputOptions) {
        return this.supportsCommand(command);
    }

    protected final boolean supportsCommand(String command) {
        if (Utility.isBlank((CharSequence)command)) {
            return false;
        }
        for (CommandDescription commandDescription : this.supportedCommands) {
            if (commandDescription == null || !command.equalsIgnoreCase(commandDescription.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean supportsOutputFormat(String command, OutputOptions outputOptions, Predicate<String> outputFormatValuePredicate) {
        Objects.requireNonNull(outputFormatValuePredicate, "No output format value predicate provided");
        if (outputOptions == null) {
            return false;
        }
        String format = outputOptions.getOutputFormatValue();
        if (Utility.isBlank((CharSequence)format)) {
            return false;
        }
        return outputFormatValuePredicate.test(format);
    }
}

