/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint;

import java.io.Serializable;
import java.sql.Connection;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.AttributedObject;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.NamedObject;
import schemacrawler.tools.lint.Lint;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.tools.lint.LintObjectType;
import schemacrawler.tools.lint.LintSeverity;
import schemacrawler.tools.lint.config.LinterConfig;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.string.StringFormat;

public abstract class Linter {
    private static final Logger LOGGER = Logger.getLogger(Linter.class.getName());
    private LintCollector collector;
    private LintSeverity severity = LintSeverity.medium;
    private int threshold = Integer.MAX_VALUE;
    private int lintCount;

    protected Linter() {
    }

    public final boolean exceedsThreshold() {
        return this.lintCount > this.threshold;
    }

    public String getDescription() {
        String descriptionResource = String.format("/help/%s.txt", this.getLinterId());
        if (Linter.class.getResource(descriptionResource) == null) {
            return this.getSummary();
        }
        String descriptionText = IOUtility.readResourceFully((String)descriptionResource);
        return descriptionText;
    }

    public final int getLintCount() {
        return this.lintCount;
    }

    public String getLinterId() {
        return this.getClass().getName();
    }

    public final String getLinterInstanceId() {
        return super.toString();
    }

    public final LintSeverity getSeverity() {
        return this.severity;
    }

    public abstract String getSummary();

    public String toString() {
        return String.format("%s [%s] - %s", new Object[]{this.getLinterInstanceId(), this.getSeverity(), this.getSummary()});
    }

    protected final <N extends NamedObject & AttributedObject, V extends Serializable> void addLint(LintObjectType objectType, N namedObject, String message, V value) {
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Found lint for %s: %s --> %s", new Object[]{namedObject, message, value}));
        if (this.collector != null) {
            Lint<V> lint = new Lint<V>(this.getLinterId(), this.getLinterInstanceId(), objectType, namedObject, this.getSeverity(), message, value);
            this.collector.addLint(namedObject, lint);
            ++this.lintCount;
        }
    }

    protected void configure(Config config) {
    }

    protected final void setSeverity(LintSeverity severity) {
        if (severity != null) {
            this.severity = severity;
        }
    }

    void configure(LinterConfig linterConfig) {
        if (linterConfig != null) {
            this.setSeverity(linterConfig.getSeverity());
            this.setThreshold(linterConfig.getThreshold());
            this.configure(linterConfig.getConfig());
        }
    }

    abstract void lint(Catalog var1, Connection var2);

    final void setLintCollector(LintCollector lintCollector) {
        this.collector = lintCollector;
    }

    private void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

