/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.utility;

import java.util.Optional;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schemacrawler.DatabaseObjectRuleForInclusion;
import schemacrawler.schemacrawler.GrepOptions;
import schemacrawler.schemacrawler.GrepOptionsBuilder;
import schemacrawler.schemacrawler.LimitOptions;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.LoadOptions;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.tools.options.Config;

public final class SchemaCrawlerOptionsConfig {
    public static GrepOptionsBuilder fromConfig(GrepOptionsBuilder providedBuilder, Config config) {
        GrepOptionsBuilder builder = providedBuilder == null ? GrepOptionsBuilder.builder() : providedBuilder;
        if (config == null) {
            return builder;
        }
        String SC_GREP_TABLE_PATTERN_EXCLUDE = "schemacrawler.grep.table.pattern.exclude";
        String SC_GREP_TABLE_PATTERN_INCLUDE = "schemacrawler.grep.table.pattern.include";
        String SC_GREP_COLUMN_PATTERN_EXCLUDE = "schemacrawler.grep.column.pattern.exclude";
        String SC_GREP_COLUMN_PATTERN_INCLUDE = "schemacrawler.grep.column.pattern.include";
        String SC_GREP_DEFINITION_PATTERN_EXCLUDE = "schemacrawler.grep.definition.pattern.exclude";
        String SC_GREP_DEFINITION_PATTERN_INCLUDE = "schemacrawler.grep.definition.pattern.include";
        String SC_GREP_ROUTINE_PARAMETER_PATTERN_EXCLUDE = "schemacrawler.grep.routine.inout.pattern.exclude";
        String SC_GREP_ROUTINE_PARAMETER_PATTERN_INCLUDE = "schemacrawler.grep.routine.inout.pattern.include";
        builder.includeGreppedTables((InclusionRule)config.getOptionalInclusionRule("schemacrawler.grep.table.pattern.include", "schemacrawler.grep.table.pattern.exclude").orElse(null));
        builder.includeGreppedColumns((InclusionRule)config.getOptionalInclusionRule("schemacrawler.grep.column.pattern.include", "schemacrawler.grep.column.pattern.exclude").orElse(null));
        builder.includeGreppedRoutineParameters((InclusionRule)config.getOptionalInclusionRule("schemacrawler.grep.routine.inout.pattern.include", "schemacrawler.grep.routine.inout.pattern.exclude").orElse(null));
        builder.includeGreppedDefinitions((InclusionRule)config.getOptionalInclusionRule("schemacrawler.grep.definition.pattern.include", "schemacrawler.grep.definition.pattern.exclude").orElse(null));
        return builder;
    }

    public static LimitOptionsBuilder fromConfig(LimitOptionsBuilder providedBuilder, Config config) {
        LimitOptionsBuilder builder = providedBuilder == null ? LimitOptionsBuilder.builder() : providedBuilder;
        if (config == null) {
            return builder;
        }
        for (DatabaseObjectRuleForInclusion ruleForInclusion : DatabaseObjectRuleForInclusion.values()) {
            Optional optionalInclusionRule = config.getOptionalInclusionRule(SchemaCrawlerOptionsConfig.getIncludePatternProperty(ruleForInclusion), SchemaCrawlerOptionsConfig.getExcludePatternProperty(ruleForInclusion));
            if (!optionalInclusionRule.isPresent()) continue;
            InclusionRule inclusionRule = (InclusionRule)optionalInclusionRule.get();
            builder.include(ruleForInclusion, inclusionRule);
        }
        return builder;
    }

    public static LoadOptionsBuilder fromConfig(LoadOptionsBuilder providedBuilder, Config config) {
        LoadOptionsBuilder builder = providedBuilder == null ? LoadOptionsBuilder.builder() : providedBuilder;
        if (config == null) {
            return builder;
        }
        String SC_LOAD_MAX_THREADS = "schemacrawler.load.max_threads";
        builder.withMaxThreads(config.getIntegerValue("schemacrawler.load.max_threads", 5));
        return builder;
    }

    public static SchemaCrawlerOptions fromConfig(SchemaCrawlerOptions providedOptions, Config config) {
        SchemaCrawlerOptions schemaCrawlerOptions = providedOptions == null ? SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions() : providedOptions;
        if (config == null) {
            return schemaCrawlerOptions;
        }
        LoadOptionsBuilder loadOptionsBuilder = LoadOptionsBuilder.builder().fromOptions(schemaCrawlerOptions.getLoadOptions());
        LoadOptions loadOptions = SchemaCrawlerOptionsConfig.fromConfig(loadOptionsBuilder, config).toOptions();
        schemaCrawlerOptions = schemaCrawlerOptions.withLoadOptions(loadOptions);
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().fromOptions(schemaCrawlerOptions.getLimitOptions());
        LimitOptions limitOptions = SchemaCrawlerOptionsConfig.fromConfig(limitOptionsBuilder, config).toOptions();
        schemaCrawlerOptions = schemaCrawlerOptions.withLimitOptions(limitOptions);
        GrepOptionsBuilder grepOptionsBuilder = GrepOptionsBuilder.builder().fromOptions(schemaCrawlerOptions.getGrepOptions());
        GrepOptions grepOptions = SchemaCrawlerOptionsConfig.fromConfig(grepOptionsBuilder, config).toOptions();
        schemaCrawlerOptions = schemaCrawlerOptions.withGrepOptions(grepOptions);
        return schemaCrawlerOptions;
    }

    private static String getExcludePatternProperty(DatabaseObjectRuleForInclusion ruleForInclusion) {
        return String.format("schemacrawler.%s.pattern.exclude", ruleForInclusion.getKey());
    }

    private static String getIncludePatternProperty(DatabaseObjectRuleForInclusion ruleForInclusion) {
        return String.format("schemacrawler.%s.pattern.include", ruleForInclusion.getKey());
    }
}

