/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEHeader;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.ByteUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.IntegerOverflowException;

public class AAD {
    public static byte[] compute(JWEHeader jweHeader) {
        return AAD.compute(jweHeader.toBase64URL());
    }

    public static byte[] compute(Base64URL encodedJWEHeader) {
        return encodedJWEHeader.toString().getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[] computeLength(byte[] aad) throws IntegerOverflowException {
        int bitLength = ByteUtils.safeBitLength(aad);
        return ByteBuffer.allocate(8).putLong(bitLength).array();
    }
}

