/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.client.auth.oauth;

import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.client.jdbc.internal.google.api.client.auth.oauth.OAuthParameters;
import net.snowflake.client.jdbc.internal.google.api.client.auth.oauth.OAuthSigner;
import net.snowflake.client.jdbc.internal.google.api.client.util.StringUtils;
import net.snowflake.client.jdbc.internal.google.common.io.BaseEncoding;

public final class OAuthHmacSha256Signer
implements OAuthSigner {
    private final String clientSharedSecret;
    private String tokenSharedSecret;

    public void setTokenSecret(String tokenSecret) {
        this.tokenSharedSecret = tokenSecret;
    }

    public OAuthHmacSha256Signer(String clientSecret) {
        this.clientSharedSecret = clientSecret;
    }

    @Override
    public String getSignatureMethod() {
        return "HMAC-SHA256";
    }

    @Override
    public String computeSignature(String signatureBaseString) throws GeneralSecurityException {
        StringBuilder keyBuffer = new StringBuilder();
        if (this.clientSharedSecret != null) {
            keyBuffer.append(OAuthParameters.escape(this.clientSharedSecret));
        }
        keyBuffer.append('&');
        if (this.tokenSharedSecret != null) {
            keyBuffer.append(OAuthParameters.escape(this.tokenSharedSecret));
        }
        String key = keyBuffer.toString();
        SecretKeySpec secretKey = new SecretKeySpec(StringUtils.getBytesUtf8(key), "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(secretKey);
        return BaseEncoding.base64().encode(mac.doFinal(StringUtils.getBytesUtf8(signatureBaseString)));
    }
}

