/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.catalogloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.tools.catalogloader.CatalogLoader;
import schemacrawler.tools.catalogloader.ChainedCatalogLoader;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.commandline.PluginCommand;
import us.fatehi.utility.string.StringFormat;

public final class CatalogLoaderRegistry {
    private static final Logger LOGGER = Logger.getLogger(CatalogLoaderRegistry.class.getName());

    public Collection<PluginCommand> getCommandLineCommands() {
        HashSet<PluginCommand> commandLineCommands = new HashSet<PluginCommand>();
        for (CatalogLoader catalogLoader : this.instantiateCatalogLoaders()) {
            commandLineCommands.add(catalogLoader.getCommandLineCommand());
        }
        return commandLineCommands;
    }

    public Collection<PluginCommand> getHelpCommands() {
        HashSet<PluginCommand> commandLineCommands = new HashSet<PluginCommand>();
        for (CatalogLoader catalogLoader : this.instantiateCatalogLoaders()) {
            commandLineCommands.add(catalogLoader.getHelpCommand());
        }
        return commandLineCommands;
    }

    public Collection<CommandDescription> getSupportedCatalogLoaders() {
        HashSet<CommandDescription> commandLineCommands = new HashSet<CommandDescription>();
        for (CatalogLoader catalogLoader : this.instantiateCatalogLoaders()) {
            CommandDescription commandDescription = catalogLoader.getCommandDescription();
            commandLineCommands.add(new CommandDescription(commandDescription.getName(), commandDescription.getDescription()));
        }
        return commandLineCommands;
    }

    public ChainedCatalogLoader newChainedCatalogLoader() {
        List<CatalogLoader> chainedCatalogLoaders = this.instantiateCatalogLoaders();
        return new ChainedCatalogLoader(chainedCatalogLoaders);
    }

    private List<CatalogLoader> instantiateCatalogLoaders() {
        ArrayList<CatalogLoader> catalogLoaderRegistry = new ArrayList<CatalogLoader>();
        try {
            ServiceLoader<CatalogLoader> serviceLoader = ServiceLoader.load(CatalogLoader.class, CatalogLoaderRegistry.class.getClassLoader());
            for (CatalogLoader catalogLoader : serviceLoader) {
                LOGGER.log(Level.CONFIG, new StringFormat("Loading catalog loader, %s", catalogLoader.getClass().getName()));
                catalogLoaderRegistry.add(catalogLoader);
            }
        }
        catch (Throwable e) {
            throw new InternalRuntimeException("Could not load catalog loader registry", e);
        }
        Collections.sort(catalogLoaderRegistry);
        return catalogLoaderRegistry;
    }
}

