SELECT
  NULLIF(1, 1)
    AS TRIGGER_CATALOG,
  STRIP(SYSCAT.TRIGGERS.TRIGSCHEMA)
    AS TRIGGER_SCHEMA,
  STRIP(SYSCAT.TRIGGERS.TRIGNAME)
    AS TRIGGER_NAME,
  CASE STRIP(SYSCAT.TRIGGERS.TRIGEVENT)
    WHEN 'I' THEN 'INSERT'
    WHEN 'D' THEN 'DELETE'
    WHEN 'U' THEN 'UPDATE'
    ELSE ''
  END
    AS EVENT_MANIPULATION,
  NULLIF(1, 1)
    AS EVENT_OBJECT_CATALOG,
  SYSCAT.TRIGGERS.TABSCHEMA
    AS EVENT_OBJECT_SCHEMA,
  SYSCAT.TRIGGERS.TABNAME
    AS EVENT_OBJECT_TABLE,
  1
    AS ACTION_ORDER,
  NULLIF(1, 1)
    AS ACTION_CONDITION,
  SYSCAT.TRIGGERS.TEXT
    AS ACTION_STATEMENT,
  CASE WHEN STRIP(SYSCAT.TRIGGERS.GRANULARITY) = 'R' THEN 'ROW' ELSE 'STATEMENT' END
    AS ACTION_ORIENTATION,
  CASE STRIP(SYSCAT.TRIGGERS.TRIGTIME)
    WHEN 'A' THEN 'AFTER'
    WHEN 'B' THEN 'BEFORE'
    WHEN 'I' THEN 'INSTEAD OF'
    ELSE ''
  END
    AS CONDITION_TIMING
FROM
  SYSCAT.TRIGGERS
WHERE
  STRIP(SYSCAT.TRIGGERS.VALID) = 'Y'
ORDER BY
  SYSCAT.TRIGGERS.TRIGSCHEMA,
  SYSCAT.TRIGGERS.TRIGNAME
WITH UR  
