/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.jar.Manifest;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.AbstractResource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JarResourceRoot
extends AbstractResource {
    private static final Log log = LogFactory.getLog(JarResourceRoot.class);
    private final File base;
    private final String baseUrl;
    private final String name;

    public JarResourceRoot(WebResourceRoot webResourceRoot, File file, String string, String string2) {
        super(webResourceRoot, string2);
        if (!string2.endsWith("/")) {
            throw new IllegalArgumentException(sm.getString("jarResourceRoot.invalidWebAppPath", new Object[]{string2}));
        }
        this.base = file;
        this.baseUrl = "jar:" + string;
        String string3 = string2.substring(0, string2.length() - 1);
        int n = string3.lastIndexOf(47);
        if (n > -1) {
            string3 = string3.substring(n + 1);
        }
        this.name = string3;
    }

    @Override
    public long getLastModified() {
        return this.base.lastModified();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public String getCanonicalPath() {
        return null;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    protected InputStream doGetInputStream() {
        return null;
    }

    @Override
    public byte[] getContent() {
        return null;
    }

    @Override
    public long getCreation() {
        return this.base.lastModified();
    }

    @Override
    public URL getURL() {
        String string = this.baseUrl + "!/";
        try {
            return new URI(string).toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("fileResource.getUrlFail", new Object[]{string}), (Throwable)exception);
            }
            return null;
        }
    }

    @Override
    public URL getCodeBase() {
        try {
            return new URI(this.baseUrl).toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)sm.getString("fileResource.getUrlFail", new Object[]{this.baseUrl}), (Throwable)exception);
            }
            return null;
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public Certificate[] getCertificates() {
        return null;
    }

    @Override
    public Manifest getManifest() {
        return null;
    }
}

