/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.estimate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.RangeStatsWithGradients;
import tim.prune.data.Selection;
import tim.prune.data.Unit;
import tim.prune.function.estimate.EstimationParameters;
import tim.prune.gui.DecimalNumberField;
import tim.prune.gui.DisplayUtils;
import tim.prune.gui.GuiGridLayout;
import tim.prune.undo.UndoApplyTimestamps;

public class EstimateTime
extends GenericFunction {
    private JDialog _dialog = null;
    private JLabel _distanceLabel = null;
    private JLabel _estimatedDurationLabel = null;
    private JLabel _actualDurationLabel = null;
    private JLabel _gentleClimbLabel = null;
    private JLabel _steepClimbLabel = null;
    private JLabel _gentleDescentLabel = null;
    private JLabel _steepDescentLabel = null;
    private JLabel _flatSpeedLabel = null;
    private DecimalNumberField _flatSpeedField = null;
    private JLabel _climbParamLabel = null;
    private DecimalNumberField _gentleClimbField = null;
    private DecimalNumberField _steepClimbField = null;
    private JLabel _descentParamLabel = null;
    private DecimalNumberField _gentleDescentField = null;
    private DecimalNumberField _steepDescentField = null;
    private RangeStatsWithGradients _stats = null;
    private JButton _applyButton = null;

    public EstimateTime(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.estimatetime";
    }

    @Override
    public void begin() {
        Selection selection = this._app.getTrackInfo().getSelection();
        this._stats = new RangeStatsWithGradients(this._app.getTrackInfo().getTrack(), selection.getStart(), selection.getEnd());
        if (this._stats.getMovingDistance() < 0.01) {
            this._app.showErrorMessage(this.getNameKey(), "dialog.estimatetime.error.nodistance");
            return;
        }
        if (this._dialog == null) {
            this.showTip();
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.updateDetails();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.fullrangedetails.intro")) + ":");
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jLabel.setAlignmentX(0.0f);
        jPanel2.add(jLabel);
        jPanel2.add(Box.createVerticalStrut(4));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 4, 6, 2));
        jPanel3.setBorder(BorderFactory.createTitledBorder(I18nManager.getText("dialog.estimatetime.details")));
        JLabel jLabel2 = new JLabel(String.valueOf(I18nManager.getText("fieldname.distance")) + ": ");
        jLabel2.setHorizontalAlignment(4);
        jPanel3.add(jLabel2);
        this._distanceLabel = new JLabel("5 km");
        jPanel3.add(this._distanceLabel);
        jPanel3.add(new JLabel(""));
        jPanel3.add(new JLabel(""));
        jPanel3.add(new JLabel(""));
        jPanel3.add(new JLabel(I18nManager.getText("dialog.estimatetime.gentle")));
        jPanel3.add(new JLabel(I18nManager.getText("dialog.estimatetime.steep")));
        jPanel3.add(new JLabel(""));
        JLabel jLabel3 = new JLabel(String.valueOf(I18nManager.getText("dialog.estimatetime.climb")) + ": ");
        jLabel3.setHorizontalAlignment(4);
        jPanel3.add(jLabel3);
        this._gentleClimbLabel = new JLabel("1500 m");
        jPanel3.add(this._gentleClimbLabel);
        this._steepClimbLabel = new JLabel("1500 m");
        jPanel3.add(this._steepClimbLabel);
        jPanel3.add(new JLabel(""));
        JLabel jLabel4 = new JLabel(String.valueOf(I18nManager.getText("dialog.estimatetime.descent")) + ": ");
        jLabel4.setHorizontalAlignment(4);
        jPanel3.add(jLabel4);
        this._gentleDescentLabel = new JLabel("1500 m");
        jPanel3.add(this._gentleDescentLabel);
        this._steepDescentLabel = new JLabel("1500 m");
        jPanel3.add(this._steepDescentLabel);
        jPanel3.add(new JLabel(""));
        jPanel3.setAlignmentX(0.0f);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createVerticalStrut(4));
        JPanel jPanel4 = new JPanel();
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel4, new double[]{1.5, 0.2, 1.0, 0.2, 0.5}, blArray);
        jPanel4.setBorder(BorderFactory.createTitledBorder(I18nManager.getText("dialog.estimatetime.parameters")));
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EstimateTime.this.calculateEstimatedTime();
                    }
                });
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    EstimateTime.this._dialog.dispose();
                }
            }
        };
        this._flatSpeedLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.estimatetime.parameters.timefor")) + ": ");
        this._flatSpeedLabel.setHorizontalAlignment(4);
        guiGridLayout.add(this._flatSpeedLabel);
        this._flatSpeedField = new DecimalNumberField();
        this._flatSpeedField.addKeyListener(keyAdapter);
        guiGridLayout.add(this._flatSpeedField);
        JLabel jLabel5 = new JLabel(I18nManager.getText("units.minutes"));
        guiGridLayout.add(jLabel5);
        guiGridLayout.nextRow();
        guiGridLayout.add(new JLabel(""));
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.estimatetime.gentle")));
        guiGridLayout.add(new JLabel(""));
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.estimatetime.steep")));
        guiGridLayout.nextRow();
        this._climbParamLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.estimatetime.parameters.timefor")) + ": ");
        this._climbParamLabel.setHorizontalAlignment(4);
        guiGridLayout.add(this._climbParamLabel);
        this._gentleClimbField = new DecimalNumberField(true);
        this._gentleClimbField.addKeyListener(keyAdapter);
        guiGridLayout.add(this._gentleClimbField);
        guiGridLayout.add(new JLabel(jLabel5.getText()));
        this._steepClimbField = new DecimalNumberField(true);
        this._steepClimbField.addKeyListener(keyAdapter);
        guiGridLayout.add(this._steepClimbField);
        guiGridLayout.add(new JLabel(jLabel5.getText()));
        this._descentParamLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.estimatetime.parameters.timefor")) + ": ");
        this._descentParamLabel.setHorizontalAlignment(4);
        guiGridLayout.add(this._descentParamLabel);
        this._gentleDescentField = new DecimalNumberField(true);
        this._gentleDescentField.addKeyListener(keyAdapter);
        guiGridLayout.add(this._gentleDescentField);
        guiGridLayout.add(new JLabel(jLabel5.getText()));
        this._steepDescentField = new DecimalNumberField(true);
        this._steepDescentField.addKeyListener(keyAdapter);
        guiGridLayout.add(this._steepDescentField);
        guiGridLayout.add(new JLabel(jLabel5.getText()));
        jPanel4.setAlignmentX(0.0f);
        jPanel2.add(jPanel4);
        jPanel2.add(Box.createVerticalStrut(12));
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder(I18nManager.getText("dialog.estimatetime.results")));
        jPanel5.setLayout(new GridLayout(0, 2, 3, 3));
        this._estimatedDurationLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.estimatetime.results.estimatedtime")) + ": ");
        Font font = this._estimatedDurationLabel.getFont();
        this._estimatedDurationLabel.setFont(font.deriveFont(1, font.getSize2D() + 2.0f));
        jPanel5.add(this._estimatedDurationLabel);
        this._actualDurationLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.estimatetime.results.actualtime")) + ": ");
        jPanel5.add(this._actualDurationLabel);
        jPanel5.setAlignmentX(0.0f);
        jPanel2.add(jPanel5);
        jPanel2.add(Box.createVerticalStrut(4));
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this._applyButton = new JButton(I18nManager.getText("button.apply"));
        this._applyButton.addActionListener(actionEvent -> this.applyTimestampsToRange());
        jPanel6.add(this._applyButton);
        jPanel6.add(Box.createGlue());
        JButton jButton = new JButton(I18nManager.getText("button.close"));
        jButton.addActionListener(actionEvent -> this.finishDialog());
        jButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    EstimateTime.this._dialog.dispose();
                }
            }
        });
        jPanel6.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel6.add(jButton2);
        jPanel.add((Component)jPanel6, "South");
        return jPanel;
    }

    private void updateDetails() {
        if (!this._stats.getMovingAltitudeRange().hasRange()) {
            this._app.showErrorMessage(this.getNameKey(), "dialog.estimatetime.error.noaltitudes");
        }
        Unit unit = Config.getUnitSet().getDistanceUnit();
        String string = I18nManager.getText(unit.getShortnameKey());
        double d = this._stats.getMovingDistance();
        this._distanceLabel.setText(String.valueOf(DisplayUtils.roundedNumber(d)) + " " + string);
        Unit unit2 = Config.getUnitSet().getAltitudeUnit();
        String string2 = " " + I18nManager.getText(unit2.getShortnameKey());
        this._gentleClimbLabel.setText(String.valueOf(this._stats.getGentleAltitudeRange().getClimb(unit2)) + string2);
        this._steepClimbLabel.setText(String.valueOf(this._stats.getSteepAltitudeRange().getClimb(unit2)) + string2);
        this._gentleDescentLabel.setText(String.valueOf(this._stats.getGentleAltitudeRange().getDescent(unit2)) + string2);
        this._steepDescentLabel.setText(String.valueOf(this._stats.getSteepAltitudeRange().getDescent(unit2)) + string2);
        EstimationParameters estimationParameters = EstimationParameters.fromConfigString(Config.getConfigString("prune.estimationparams"));
        if (estimationParameters == null) {
            estimationParameters = EstimationParameters.DEFAULT_PARAMS;
        }
        this._flatSpeedLabel.setText(String.valueOf(I18nManager.getText("dialog.estimatetime.parameters.timefor")) + " " + EstimationParameters.getStandardDistance() + ": ");
        this._flatSpeedField.setValue(estimationParameters.getFlatMinutesLocal());
        String string3 = " " + EstimationParameters.getStandardClimb() + ": ";
        this._climbParamLabel.setText(String.valueOf(I18nManager.getText("dialog.estimatetime.climb")) + string3);
        this._gentleClimbField.setValue(estimationParameters.getGentleClimbMinutesLocal());
        this._steepClimbField.setValue(estimationParameters.getSteepClimbMinutesLocal());
        this._descentParamLabel.setText(String.valueOf(I18nManager.getText("dialog.estimatetime.descent")) + string3);
        this._gentleDescentField.setValue(estimationParameters.getGentleDescentMinutesLocal());
        this._steepDescentField.setValue(estimationParameters.getSteepDescentMinutesLocal());
        this.calculateEstimatedTime();
        if (this._stats.getMovingDurationInSeconds() > 0L) {
            this._actualDurationLabel.setText(String.valueOf(I18nManager.getText("dialog.estimatetime.results.actualtime")) + ": " + DisplayUtils.buildDurationString(this._stats.getMovingDurationInSeconds()));
        } else {
            this._actualDurationLabel.setText("");
        }
    }

    private void calculateEstimatedTime() {
        EstimationParameters estimationParameters = EstimationParameters.fromLocalUnits(this._flatSpeedField.getValue(), this._gentleClimbField.getValue(), this._steepClimbField.getValue(), this._gentleDescentField.getValue(), this._steepDescentField.getValue());
        if (estimationParameters == null) {
            this._estimatedDurationLabel.setText("- - -");
            this._applyButton.setEnabled(false);
        } else {
            long l = (long)(estimationParameters.applyToStats(this._stats) * 60.0);
            this._estimatedDurationLabel.setText(String.valueOf(I18nManager.getText("dialog.estimatetime.results.estimatedtime")) + ": " + DisplayUtils.buildDurationString(l));
            this._applyButton.setEnabled(l > 0L);
        }
    }

    private void finishDialog() {
        EstimationParameters estimationParameters = EstimationParameters.fromLocalUnits(this._flatSpeedField.getValue(), this._gentleClimbField.getValue(), this._steepClimbField.getValue(), this._gentleDescentField.getValue(), this._steepDescentField.getValue());
        if (estimationParameters != null) {
            Config.setConfigString("prune.estimationparams", estimationParameters.toConfigString());
        }
        this._dialog.dispose();
    }

    private void showTip() {
        EstimationParameters estimationParameters = EstimationParameters.fromConfigString(Config.getConfigString("prune.estimationparams"));
        if (estimationParameters == null || estimationParameters.sameAsDefaults()) {
            this._app.showTip(1);
        }
    }

    private void applyTimestampsToRange() {
        EstimationParameters estimationParameters = EstimationParameters.fromLocalUnits(this._flatSpeedField.getValue(), this._gentleClimbField.getValue(), this._steepClimbField.getValue(), this._gentleDescentField.getValue(), this._steepDescentField.getValue());
        UndoApplyTimestamps undoApplyTimestamps = new UndoApplyTimestamps(this._app.getTrackInfo());
        long l = EstimateTime.getTimeAtMidnight();
        RangeStatsWithGradients rangeStatsWithGradients = new RangeStatsWithGradients();
        Selection selection = this._app.getTrackInfo().getSelection();
        int n = selection.getStart();
        while (n <= selection.getEnd()) {
            DataPoint dataPoint = this._app.getTrackInfo().getTrack().getPoint(n);
            if (!dataPoint.isWaypoint()) {
                rangeStatsWithGradients.addPoint(dataPoint);
                double d = estimationParameters.applyToStats(rangeStatsWithGradients) * 60.0;
                long l2 = l + (long)(d * 1000.0);
                dataPoint.setFieldValue(Field.TIMESTAMP, "" + l2, false);
            }
            ++n;
        }
        UpdateMessageBroker.informSubscribers();
        this._app.completeFunction(undoApplyTimestamps, I18nManager.getText("confirm.applytimestamps"));
    }

    private static long getTimeAtMidnight() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }
}

