/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.printer.lexicalpreservation;

import com.github.javaparser.GeneratedJavaParserConstants;
import com.github.javaparser.JavaToken;
import com.github.javaparser.TokenTypes;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.printer.concretesyntaxmodel.CsmElement;
import com.github.javaparser.printer.concretesyntaxmodel.CsmIndent;
import com.github.javaparser.printer.concretesyntaxmodel.CsmMix;
import com.github.javaparser.printer.concretesyntaxmodel.CsmToken;
import com.github.javaparser.printer.concretesyntaxmodel.CsmUnindent;
import com.github.javaparser.printer.lexicalpreservation.Added;
import com.github.javaparser.printer.lexicalpreservation.ChildTextElement;
import com.github.javaparser.printer.lexicalpreservation.DifferenceElement;
import com.github.javaparser.printer.lexicalpreservation.DifferenceElementCalculator;
import com.github.javaparser.printer.lexicalpreservation.Kept;
import com.github.javaparser.printer.lexicalpreservation.LexicalDifferenceCalculator;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import com.github.javaparser.printer.lexicalpreservation.NodeText;
import com.github.javaparser.printer.lexicalpreservation.Removed;
import com.github.javaparser.printer.lexicalpreservation.RemovedGroup;
import com.github.javaparser.printer.lexicalpreservation.Reshuffled;
import com.github.javaparser.printer.lexicalpreservation.TextElement;
import com.github.javaparser.printer.lexicalpreservation.TokenTextElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;

public class Difference {
    public static final int STANDARD_INDENTATION_SIZE = 4;
    private final NodeText nodeText;
    private final Node node;
    private final List<DifferenceElement> diffElements;
    private final List<TextElement> originalElements;
    private int originalIndex = 0;
    private int diffIndex = 0;
    private final List<TokenTextElement> indentation;
    private boolean addedIndentation = false;

    Difference(List<DifferenceElement> diffElements, NodeText nodeText, Node node) {
        if (nodeText == null) {
            throw new NullPointerException("nodeText can not be null");
        }
        this.nodeText = nodeText;
        this.node = node;
        this.diffElements = diffElements;
        this.originalElements = nodeText.getElements();
        this.indentation = LexicalPreservingPrinter.findIndentation(node);
    }

    private List<TextElement> processIndentation(List<TokenTextElement> indentation, List<TextElement> prevElements) {
        TextElement elem;
        LinkedList<TextElement> res = new LinkedList<TextElement>(indentation);
        int index = this.lastIndexOfEol(prevElements);
        if (index < 0) {
            return res;
        }
        res.clear();
        for (int i = index + 1; i < prevElements.size() && (elem = prevElements.get(i)).isWhiteSpace(); ++i) {
            res.add(elem);
        }
        return res;
    }

    private int posOfNextComment(int fromIndex, List<TextElement> elements) {
        if (!this.isValidIndex(fromIndex, elements)) {
            return -1;
        }
        ReadOnlyListIterator<TextElement> iterator = new ReadOnlyListIterator<TextElement>(elements, fromIndex);
        while (iterator.hasNext()) {
            TextElement element = iterator.next();
            if (element.isSpaceOrTab()) continue;
            if (!element.isComment()) break;
            return iterator.index();
        }
        return -1;
    }

    private boolean isFollowedByComment(int fromIndex, List<TextElement> elements) {
        return this.posOfNextComment(fromIndex, elements) != -1;
    }

    private void removeElements(int fromIndex, int toIndex, List<TextElement> elements) {
        if (!this.isValidIndex(fromIndex, elements) || !this.isValidIndex(toIndex, elements) || fromIndex > toIndex) {
            return;
        }
        ListIterator<TextElement> iterator = elements.listIterator(fromIndex);
        for (int count = fromIndex; iterator.hasNext() && count <= toIndex; ++count) {
            TextElement element = iterator.next();
            iterator.remove();
        }
    }

    private boolean isValidIndex(int index, List<?> elements) {
        return index >= 0 && index <= elements.size();
    }

    int lastIndexOfEol(List<TextElement> source) {
        ListIterator<TextElement> listIterator = source.listIterator(source.size());
        int lastIndex = source.size() - 1;
        while (listIterator.hasPrevious()) {
            TextElement elem = listIterator.previous();
            if (elem.isNewline()) {
                return lastIndex;
            }
            --lastIndex;
        }
        return -1;
    }

    private List<TextElement> indentationBlock() {
        LinkedList<TextElement> res = new LinkedList<TextElement>();
        res.add(new TokenTextElement(1));
        res.add(new TokenTextElement(1));
        res.add(new TokenTextElement(1));
        res.add(new TokenTextElement(1));
        return res;
    }

    private boolean isAfterLBrace(NodeText nodeText, int nodeTextIndex) {
        if (nodeTextIndex > 0 && nodeText.getTextElement(nodeTextIndex - 1).isToken(99)) {
            return true;
        }
        if (nodeTextIndex > 0 && nodeText.getTextElement(nodeTextIndex - 1).isSpaceOrTab()) {
            return this.isAfterLBrace(nodeText, nodeTextIndex - 1);
        }
        return false;
    }

    private int considerEnforcingIndentation(NodeText nodeText, int nodeTextIndex) {
        EnforcingIndentationContext enforcingIndentationContext = this.defineEnforcingIndentationContext(nodeText, nodeTextIndex);
        int res = nodeTextIndex;
        if (enforcingIndentationContext.extraCharacters > 0) {
            int extraCharacters = enforcingIndentationContext.extraCharacters > this.indentation.size() ? enforcingIndentationContext.extraCharacters - this.indentation.size() : 0;
            res = this.removeExtraCharacters(nodeText, enforcingIndentationContext.start, extraCharacters);
            int n = res = extraCharacters > 0 ? res + this.indentation.size() : res;
        }
        if (res < 0) {
            throw new IllegalStateException();
        }
        return res;
    }

    private int removeExtraCharacters(NodeText nodeText, int nodeTextIndex, int extraCharacters) {
        int pos = nodeTextIndex;
        int count = 0;
        for (int i = nodeTextIndex; i >= 0 && i < nodeText.numberOfElements() && count < extraCharacters && !nodeText.getTextElement(i).isNewline(); ++count, ++i) {
            nodeText.removeElement(pos);
        }
        return pos;
    }

    private EnforcingIndentationContext defineEnforcingIndentationContext(NodeText nodeText, int nodeTextIndex) {
        EnforcingIndentationContext ctx = new EnforcingIndentationContext(nodeTextIndex);
        if (nodeTextIndex < nodeText.numberOfElements()) {
            int i = nodeTextIndex;
            while (i >= 0 && i < nodeText.numberOfElements() && !nodeText.getTextElement(i).isNewline()) {
                if (!nodeText.getTextElement(i).isSpaceOrTab()) {
                    ctx = new EnforcingIndentationContext(nodeTextIndex);
                    break;
                }
                ctx.start = i--;
                ++ctx.extraCharacters;
            }
            if (nodeText.getTextElement(nodeTextIndex).isSpaceOrTab()) {
                for (i = nodeTextIndex + 1; i >= 0 && i < nodeText.numberOfElements() && nodeText.getTextElement(i).isSpaceOrTab(); ++i) {
                    ++ctx.extraCharacters;
                }
            }
        }
        return ctx;
    }

    void apply() {
        this.extractReshuffledDiffElements(this.diffElements);
        Map<Removed, RemovedGroup> removedGroups = this.combineRemovedElementsToRemovedGroups();
        do {
            boolean isLeftOverDiffElement = this.applyLeftOverDiffElements();
            boolean isLeftOverOriginalElement = this.applyLeftOverOriginalElements();
            if (isLeftOverDiffElement || isLeftOverOriginalElement) continue;
            DifferenceElement diffElement = this.diffElements.get(this.diffIndex);
            if (diffElement.isAdded()) {
                this.applyAddedDiffElement((Added)diffElement);
                continue;
            }
            TextElement originalElement = this.originalElements.get(this.originalIndex);
            boolean originalElementIsChild = originalElement instanceof ChildTextElement;
            boolean originalElementIsToken = originalElement instanceof TokenTextElement;
            if (diffElement.isKept()) {
                this.applyKeptDiffElement((Kept)diffElement, originalElement, originalElementIsChild, originalElementIsToken);
                continue;
            }
            if (diffElement.isRemoved()) {
                Removed removed = (Removed)diffElement;
                this.applyRemovedDiffElement(removedGroups.get(removed), removed, originalElement, originalElementIsChild, originalElementIsToken);
                continue;
            }
            throw new UnsupportedOperationException("" + diffElement + " vs " + originalElement);
        } while (this.diffIndex < this.diffElements.size() || this.originalIndex < this.originalElements.size());
    }

    private boolean applyLeftOverOriginalElements() {
        boolean isLeftOverElement = false;
        if (this.diffIndex >= this.diffElements.size() && this.originalIndex < this.originalElements.size()) {
            TextElement originalElement = this.originalElements.get(this.originalIndex);
            if (originalElement.isWhiteSpaceOrComment()) {
                ++this.originalIndex;
            } else {
                throw new UnsupportedOperationException("NodeText: " + this.nodeText + ". Difference: " + this + " " + originalElement);
            }
            isLeftOverElement = true;
        }
        return isLeftOverElement;
    }

    private boolean applyLeftOverDiffElements() {
        boolean isLeftOverElement = false;
        if (this.diffIndex < this.diffElements.size() && this.originalIndex >= this.originalElements.size()) {
            DifferenceElement diffElement = this.diffElements.get(this.diffIndex);
            if (diffElement.isKept()) {
                ++this.diffIndex;
            } else if (diffElement.isAdded()) {
                Added addedElement = (Added)diffElement;
                this.nodeText.addElement(this.originalIndex, addedElement.toTextElement());
                ++this.originalIndex;
                ++this.diffIndex;
            } else {
                ++this.diffIndex;
            }
            isLeftOverElement = true;
        }
        return isLeftOverElement;
    }

    private void extractReshuffledDiffElements(List<DifferenceElement> diffElements) {
        for (int index = 0; index < diffElements.size(); ++index) {
            DifferenceElement diffElement = diffElements.get(index);
            if (!(diffElement instanceof Reshuffled)) continue;
            Reshuffled reshuffled = (Reshuffled)diffElement;
            CsmMix elementsFromPreviousOrder = reshuffled.getPreviousOrder();
            CsmMix elementsFromNextOrder = reshuffled.getNextOrder();
            Map<Integer, Integer> correspondanceBetweenNextOrderAndPreviousOrder = this.getCorrespondanceBetweenNextOrderAndPreviousOrder(elementsFromPreviousOrder, elementsFromNextOrder);
            List<Integer> nodeTextIndexOfPreviousElements = this.findIndexOfCorrespondingNodeTextElement(elementsFromPreviousOrder.getElements(), this.nodeText, this.originalIndex, this.node);
            HashMap<Integer, Integer> nodeTextIndexToPreviousCSMIndex = new HashMap<Integer, Integer>();
            for (int i = 0; i < nodeTextIndexOfPreviousElements.size(); ++i) {
                int value = nodeTextIndexOfPreviousElements.get(i);
                if (value == -1) continue;
                nodeTextIndexToPreviousCSMIndex.put(value, i);
            }
            int lastNodeTextIndex = nodeTextIndexOfPreviousElements.stream().max(Integer::compareTo).orElse(-1);
            LinkedList<CsmElement> elementsToBeAddedAtTheEnd = new LinkedList<CsmElement>();
            List<CsmElement> nextOrderElements = elementsFromNextOrder.getElements();
            HashMap elementsToAddBeforeGivenOriginalCSMElement = new HashMap();
            for (int ni = 0; ni < nextOrderElements.size(); ++ni) {
                if (correspondanceBetweenNextOrderAndPreviousOrder.containsKey(ni)) continue;
                int originalCsmIndex = -1;
                for (int nj = ni + 1; nj < nextOrderElements.size() && originalCsmIndex == -1; ++nj) {
                    if (!correspondanceBetweenNextOrderAndPreviousOrder.containsKey(nj)) continue;
                    originalCsmIndex = correspondanceBetweenNextOrderAndPreviousOrder.get(nj);
                    if (!elementsToAddBeforeGivenOriginalCSMElement.containsKey(originalCsmIndex)) {
                        elementsToAddBeforeGivenOriginalCSMElement.put(originalCsmIndex, new LinkedList());
                    }
                    ((List)elementsToAddBeforeGivenOriginalCSMElement.get(originalCsmIndex)).add(nextOrderElements.get(ni));
                }
                if (originalCsmIndex != -1) continue;
                elementsToBeAddedAtTheEnd.add(nextOrderElements.get(ni));
            }
            diffElements.remove(index);
            int diffElIterator = index;
            if (lastNodeTextIndex != -1) {
                for (int ntIndex = this.originalIndex; ntIndex <= lastNodeTextIndex; ++ntIndex) {
                    if (!nodeTextIndexToPreviousCSMIndex.containsKey(ntIndex)) continue;
                    int indexOfOriginalCSMElement = (Integer)nodeTextIndexToPreviousCSMIndex.get(ntIndex);
                    if (elementsToAddBeforeGivenOriginalCSMElement.containsKey(indexOfOriginalCSMElement)) {
                        for (CsmElement elementToAdd : (List)elementsToAddBeforeGivenOriginalCSMElement.get(indexOfOriginalCSMElement)) {
                            diffElements.add(diffElIterator++, new Added(elementToAdd));
                        }
                    }
                    CsmElement originalCSMElement = elementsFromPreviousOrder.getElements().get(indexOfOriginalCSMElement);
                    boolean toBeKept = correspondanceBetweenNextOrderAndPreviousOrder.containsValue(indexOfOriginalCSMElement);
                    if (toBeKept) {
                        diffElements.add(diffElIterator++, new Kept(originalCSMElement));
                        continue;
                    }
                    diffElements.add(diffElIterator++, new Removed(originalCSMElement));
                }
            }
            for (CsmElement elementToAdd : elementsToBeAddedAtTheEnd) {
                diffElements.add(diffElIterator++, new Added(elementToAdd));
            }
        }
    }

    private Map<Removed, RemovedGroup> combineRemovedElementsToRemovedGroups() {
        Map<Integer, List<Removed>> removedElementsMap = this.groupConsecutiveRemovedElements();
        ArrayList<RemovedGroup> removedGroups = new ArrayList<RemovedGroup>();
        for (Map.Entry<Integer, List<Removed>> entry : removedElementsMap.entrySet()) {
            removedGroups.add(RemovedGroup.of(entry.getKey(), entry.getValue()));
        }
        HashMap<Removed, RemovedGroup> map = new HashMap<Removed, RemovedGroup>();
        for (RemovedGroup removedGroup : removedGroups) {
            for (Removed index : removedGroup) {
                map.put(index, removedGroup);
            }
        }
        return map;
    }

    private Map<Integer, List<Removed>> groupConsecutiveRemovedElements() {
        HashMap<Integer, List<Removed>> removedElementsMap = new HashMap<Integer, List<Removed>>();
        Integer firstElement = null;
        for (int i = 0; i < this.diffElements.size(); ++i) {
            DifferenceElement diffElement = this.diffElements.get(i);
            if (diffElement.isRemoved()) {
                if (firstElement == null) {
                    firstElement = i;
                }
                removedElementsMap.computeIfAbsent(firstElement, key -> new ArrayList()).add((Removed)diffElement);
                continue;
            }
            firstElement = null;
        }
        return removedElementsMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyRemovedDiffElement(RemovedGroup removedGroup, Removed removed, TextElement originalElement, boolean originalElementIsChild, boolean originalElementIsToken) {
        if (removed.isChild() && originalElementIsChild) {
            ChildTextElement originalElementChild = (ChildTextElement)originalElement;
            if (originalElementChild.isComment()) {
                Comment comment = (Comment)originalElementChild.getChild();
                if (!comment.isOrphan() && comment.getCommentedNode().isPresent() && comment.getCommentedNode().get().equals(removed.getChild())) {
                    this.nodeText.removeElement(this.originalIndex);
                } else {
                    ++this.originalIndex;
                }
            } else {
                this.nodeText.removeElement(this.originalIndex);
                if (!(this.diffIndex + 1 < this.diffElements.size() && this.diffElements.get(this.diffIndex + 1).isAdded() || removedGroup.isACompleteLine())) {
                    this.originalIndex = this.considerEnforcingIndentation(this.nodeText, this.originalIndex);
                }
                if (this.originalElements.size() > this.originalIndex && this.originalIndex > 0 && this.originalElements.get(this.originalIndex).isWhiteSpace() && this.originalElements.get(this.originalIndex - 1).isWhiteSpace() && (this.diffIndex + 1 == this.diffElements.size() || this.diffElements.get(this.diffIndex + 1).isKept())) {
                    this.originalElements.remove(this.originalIndex--);
                }
                if (this.isFollowedByComment(this.originalIndex, this.originalElements)) {
                    int indexOfNextComment = this.posOfNextComment(this.originalIndex, this.originalElements);
                    this.removeElements(this.originalIndex, indexOfNextComment, this.originalElements);
                }
                ++this.diffIndex;
            }
        } else if (removed.isToken() && originalElementIsToken && (removed.getTokenType() == ((TokenTextElement)originalElement).getTokenKind() || ((TokenTextElement)originalElement).getToken().getCategory().isEndOfLine() && removed.isNewLine())) {
            this.nodeText.removeElement(this.originalIndex);
            ++this.diffIndex;
        } else if (originalElementIsToken && originalElement.isWhiteSpaceOrComment()) {
            ++this.originalIndex;
            if (removed.isNewLine()) {
                ++this.diffIndex;
            }
        } else if (originalElement.isLiteral()) {
            this.nodeText.removeElement(this.originalIndex);
            ++this.diffIndex;
        } else if (removed.isPrimitiveType()) {
            if (!originalElement.isPrimitive()) throw new UnsupportedOperationException("removed " + removed.getElement() + " vs " + originalElement);
            this.nodeText.removeElement(this.originalIndex);
            ++this.diffIndex;
        } else if (removed.isWhiteSpace() || removed.getElement() instanceof CsmIndent || removed.getElement() instanceof CsmUnindent) {
            ++this.diffIndex;
        } else if (originalElement.isWhiteSpace()) {
            ++this.originalIndex;
        } else {
            if (!removed.isChild()) throw new UnsupportedOperationException("removed " + removed.getElement() + " vs " + originalElement);
            this.nodeText.removeElement(this.originalIndex);
            ++this.diffIndex;
        }
        this.cleanTheLineOfLeftOverSpace(removedGroup, removed);
    }

    private void cleanTheLineOfLeftOverSpace(RemovedGroup removedGroup, Removed removed) {
        if (this.originalIndex >= this.originalElements.size()) {
            return;
        }
        if (!removedGroup.isProcessed() && removedGroup.getLastElement() == removed && removedGroup.isACompleteLine()) {
            Integer lastElementIndex = removedGroup.getLastElementIndex();
            Optional<Integer> indentation = removedGroup.getIndentation();
            if (indentation.isPresent() && !this.isReplaced(lastElementIndex)) {
                for (int i = 0; i < indentation.get(); ++i) {
                    int n;
                    if (this.originalElements.get(this.originalIndex).isSpaceOrTab()) {
                        this.nodeText.removeElement(this.originalIndex);
                    } else if (this.originalIndex >= 1 && this.originalElements.get(this.originalIndex - 1).isSpaceOrTab()) {
                        this.nodeText.removeElement(this.originalIndex - 1);
                        --this.originalIndex;
                    }
                    if (!this.nodeText.getTextElement(this.originalIndex).isNewline()) continue;
                    this.nodeText.removeElement(this.originalIndex);
                    if (this.originalIndex > 0) {
                        int n2 = this.originalIndex;
                        n = n2;
                        this.originalIndex = n2 - 1;
                    } else {
                        n = 0;
                    }
                    this.originalIndex = n;
                }
            }
            removedGroup.processed();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyKeptDiffElement(Kept kept, TextElement originalElement, boolean originalElementIsChild, boolean originalElementIsToken) {
        if (originalElement.isComment()) {
            ++this.originalIndex;
            return;
        } else if (kept.isChild() && ((LexicalDifferenceCalculator.CsmChild)kept.getElement()).getChild() instanceof Comment) {
            ++this.diffIndex;
            return;
        } else if (kept.isChild() && originalElementIsChild) {
            ++this.diffIndex;
            ++this.originalIndex;
            return;
        } else if (kept.isChild() && originalElementIsToken) {
            if (originalElement.isWhiteSpaceOrComment()) {
                ++this.originalIndex;
                return;
            } else if (originalElement.isIdentifier() && this.isNodeWithTypeArguments(kept)) {
                ++this.diffIndex;
                int step = this.getIndexToNextTokenElement((TokenTextElement)originalElement, 0);
                this.originalIndex += step;
                ++this.originalIndex;
                return;
            } else if (originalElement.isIdentifier() && this.isTypeWithFullyQualifiedName(kept)) {
                ++this.diffIndex;
                int step = this.getIndexToNextTokenElement((TokenTextElement)originalElement, kept);
                this.originalIndex += step;
                ++this.originalIndex;
                return;
            } else if ((originalElement.isIdentifier() || originalElement.isKeyword()) && this.isArrayType(kept)) {
                int tokenToSkip = this.getIndexToNextTokenElementInArrayType((TokenTextElement)originalElement, this.getArrayLevel(kept));
                ++this.diffIndex;
                this.originalIndex += tokenToSkip;
                ++this.originalIndex;
                return;
            } else if (originalElement.isIdentifier()) {
                ++this.originalIndex;
                ++this.diffIndex;
                return;
            } else {
                if (!kept.isPrimitiveType()) throw new UnsupportedOperationException("kept " + kept.getElement() + " vs " + originalElement);
                ++this.originalIndex;
                ++this.diffIndex;
            }
            return;
        } else if (kept.isToken() && originalElementIsToken) {
            TokenTextElement originalTextToken = (TokenTextElement)originalElement;
            if (kept.getTokenType() == originalTextToken.getTokenKind()) {
                ++this.originalIndex;
                ++this.diffIndex;
                return;
            } else if (kept.isNewLine() && originalTextToken.isNewline()) {
                ++this.originalIndex;
                ++this.diffIndex;
                return;
            } else if (kept.isNewLine() && originalTextToken.isSpaceOrTab()) {
                ++this.originalIndex;
                return;
            } else if (kept.isWhiteSpaceOrComment()) {
                ++this.diffIndex;
                return;
            } else if (originalTextToken.isWhiteSpaceOrComment()) {
                ++this.originalIndex;
                return;
            } else {
                if (kept.isNewLine() || !originalTextToken.isSeparator()) throw new UnsupportedOperationException("Csm token " + kept.getElement() + " NodeText TOKEN " + originalTextToken);
                ++this.originalIndex;
            }
            return;
        } else if (kept.isToken() && originalElementIsChild) {
            ++this.diffIndex;
            return;
        } else if (kept.isWhiteSpace()) {
            ++this.diffIndex;
            return;
        } else if (kept.isIndent()) {
            ++this.diffIndex;
            return;
        } else {
            if (!kept.isUnindent()) throw new UnsupportedOperationException("kept " + kept.getElement() + " vs " + originalElement);
            ++this.diffIndex;
        }
    }

    private int getArrayLevel(DifferenceElement element) {
        CsmElement csmElem = element.getElement();
        if (this.isArrayType(element)) {
            Node child = ((LexicalDifferenceCalculator.CsmChild)csmElem).getChild();
            return ((ArrayType)child).getArrayLevel();
        }
        return 0;
    }

    private boolean isArrayType(DifferenceElement element) {
        CsmElement csmElem = element.getElement();
        return csmElem instanceof LexicalDifferenceCalculator.CsmChild && ((LexicalDifferenceCalculator.CsmChild)csmElem).getChild() instanceof ArrayType;
    }

    private boolean isTypeWithFullyQualifiedName(DifferenceElement element) {
        if (!element.isChild()) {
            return false;
        }
        LexicalDifferenceCalculator.CsmChild child = (LexicalDifferenceCalculator.CsmChild)element.getElement();
        if (!ClassOrInterfaceType.class.isAssignableFrom(child.getChild().getClass())) {
            return false;
        }
        return ((ClassOrInterfaceType)child.getChild()).getScope().isPresent();
    }

    private boolean isNodeWithTypeArguments(DifferenceElement element) {
        if (!element.isChild()) {
            return false;
        }
        LexicalDifferenceCalculator.CsmChild child = (LexicalDifferenceCalculator.CsmChild)element.getElement();
        if (!NodeWithTypeArguments.class.isAssignableFrom(child.getChild().getClass())) {
            return false;
        }
        Optional<NodeList<Type>> typeArgs = ((NodeWithTypeArguments)((Object)child.getChild())).getTypeArguments();
        return typeArgs.isPresent() && typeArgs.get().size() > 0;
    }

    private int getIndexToNextTokenElement(TokenTextElement element, DifferenceElement kept) {
        int step = 0;
        if (!this.isTypeWithFullyQualifiedName(kept)) {
            return 0;
        }
        LexicalDifferenceCalculator.CsmChild child = (LexicalDifferenceCalculator.CsmChild)kept.getElement();
        String[] parts = ((ClassOrInterfaceType)child.getChild()).getNameWithScope().split("\\.");
        JavaToken token = element.getToken();
        for (String part : parts) {
            if (part.equals(token.asString())) {
                if (!(token = token.getNextToken().get()).asString().equals(".")) break;
                token = token.getNextToken().get();
                step += 2;
                continue;
            }
            step = 0;
            break;
        }
        return step;
    }

    private int getIndexToNextTokenElement(TokenTextElement element, int nestedDiamondOperator) {
        int step = 0;
        Optional<JavaToken> next = element.getToken().getNextToken();
        if (!next.isPresent()) {
            return step;
        }
        ++step;
        JavaToken nextToken = next.get();
        JavaToken.Kind kind = JavaToken.Kind.valueOf(nextToken.getKind());
        if (this.isDiamondOperator(kind)) {
            nestedDiamondOperator = JavaToken.Kind.GT.equals((Object)kind) ? --nestedDiamondOperator : ++nestedDiamondOperator;
        }
        if (nestedDiamondOperator == 0 && !nextToken.getCategory().isWhitespace()) {
            return step;
        }
        return step += this.getIndexToNextTokenElement(new TokenTextElement(nextToken), nestedDiamondOperator);
    }

    private int getIndexToNextTokenElementInArrayType(TokenTextElement element, int arrayLevel) {
        int step = 0;
        Optional<JavaToken> next = element.getToken().getNextToken();
        if (!next.isPresent()) {
            return step;
        }
        ++step;
        JavaToken nextToken = next.get();
        JavaToken.Kind kind = JavaToken.Kind.valueOf(nextToken.getKind());
        if (this.isBracket(kind)) {
            if (JavaToken.Kind.RBRACKET.equals((Object)kind)) {
                --arrayLevel;
            }
        }
        if (arrayLevel == 0 && !nextToken.getCategory().isWhitespace()) {
            return step;
        }
        return step += this.getIndexToNextTokenElementInArrayType(new TokenTextElement(nextToken), arrayLevel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDiamondOperator(JavaToken.Kind kind) {
        if (JavaToken.Kind.GT.equals((Object)kind)) return true;
        if (!JavaToken.Kind.LT.equals((Object)kind)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isBracket(JavaToken.Kind kind) {
        if (JavaToken.Kind.LBRACKET.equals((Object)kind)) return true;
        if (!JavaToken.Kind.RBRACKET.equals((Object)kind)) return false;
        return true;
    }

    private boolean openBraceWasOnSameLine() {
        for (int index = this.originalIndex; index >= 0 && !this.nodeText.getTextElement(index).isNewline(); --index) {
            if (!this.nodeText.getTextElement(index).isToken(99)) continue;
            return true;
        }
        return false;
    }

    private boolean wasSpaceBetweenBraces() {
        return this.nodeText.getTextElement(this.originalIndex).isToken(100) && this.doWeHaveLeftBraceFollowedBySpace(this.originalIndex - 1) && (this.diffIndex < 2 || !this.diffElements.get(this.diffIndex - 2).isRemoved());
    }

    private boolean doWeHaveLeftBraceFollowedBySpace(int index) {
        index = this.rewindSpace(index);
        return this.nodeText.getTextElement(index).isToken(99);
    }

    private int rewindSpace(int index) {
        if (index <= 0) {
            return index;
        }
        if (this.nodeText.getTextElement(index).isWhiteSpace()) {
            return this.rewindSpace(index - 1);
        }
        return index;
    }

    private boolean nextIsRightBrace(int index) {
        List<TextElement> elements = this.originalElements.subList(index, this.originalElements.size());
        for (TextElement element : elements) {
            if (element.isSpaceOrTab()) continue;
            return element.isToken(100);
        }
        return false;
    }

    private void applyAddedDiffElement(Added added) {
        boolean nextIsRightBrace;
        boolean isPreviousElementNewline;
        if (added.isIndent()) {
            for (int i = 0; i < 4; ++i) {
                this.indentation.add(new TokenTextElement(1));
            }
            this.addedIndentation = true;
            ++this.diffIndex;
            return;
        }
        if (added.isUnindent()) {
            for (int i = 0; i < 4 && !this.indentation.isEmpty(); ++i) {
                this.indentation.remove(this.indentation.size() - 1);
            }
            this.addedIndentation = false;
            ++this.diffIndex;
            return;
        }
        TextElement addedTextElement = added.toTextElement();
        boolean used = false;
        boolean bl = isPreviousElementNewline = this.originalIndex > 0 && this.originalElements.get(this.originalIndex - 1).isNewline();
        if (isPreviousElementNewline) {
            Iterator<TextElement> elements = this.processIndentation(this.indentation, this.originalElements.subList(0, this.originalIndex - 1));
            nextIsRightBrace = this.nextIsRightBrace(this.originalIndex);
            Iterator<TextElement> iterator = elements.iterator();
            while (iterator.hasNext()) {
                TextElement e = iterator.next();
                if (!nextIsRightBrace && e instanceof TokenTextElement && this.originalElements.get(this.originalIndex).isToken(((TokenTextElement)e).getTokenKind())) {
                    ++this.originalIndex;
                    continue;
                }
                this.nodeText.addElement(this.originalIndex++, e);
            }
        } else if (this.isAfterLBrace(this.nodeText, this.originalIndex) && !this.isAReplacement(this.diffIndex)) {
            if (addedTextElement.isNewline()) {
                used = true;
            }
            this.nodeText.addElement(this.originalIndex++, new TokenTextElement(TokenTypes.eolTokenKind()));
            while (this.originalIndex >= 2 && this.originalElements.get(this.originalIndex - 2).isSpaceOrTab()) {
                this.originalElements.remove(this.originalIndex - 2);
                --this.originalIndex;
            }
            for (TextElement e : this.processIndentation(this.indentation, this.originalElements.subList(0, this.originalIndex - 1))) {
                this.nodeText.addElement(this.originalIndex++, e);
            }
            if (!this.addedIndentation) {
                for (TextElement e : this.indentationBlock()) {
                    this.nodeText.addElement(this.originalIndex++, e);
                }
            }
        }
        if (!used) {
            boolean commentIsBeforeAddedElement;
            boolean sufficientTokensRemainToSkip = this.nodeText.numberOfElements() > this.originalIndex + 2;
            boolean currentIsAComment = this.nodeText.getTextElement(this.originalIndex).isComment();
            boolean previousIsAComment = this.originalIndex > 0 && this.nodeText.getTextElement(this.originalIndex - 1).isComment();
            boolean currentIsNewline = this.nodeText.getTextElement(this.originalIndex).isNewline();
            boolean isFirstElement = this.originalIndex == 0;
            boolean previousIsWhiteSpace = this.originalIndex > 0 && this.nodeText.getTextElement(this.originalIndex - 1).isWhiteSpace();
            boolean bl2 = commentIsBeforeAddedElement = currentIsAComment && addedTextElement.getRange().isPresent() && this.nodeText.getTextElement(this.originalIndex).getRange().map(range -> range.isBefore(addedTextElement.getRange().get())).orElse(false) != false;
            if (sufficientTokensRemainToSkip && currentIsAComment && commentIsBeforeAddedElement) {
                this.originalIndex += 2;
                this.nodeText.addElement(this.originalIndex, addedTextElement);
                this.originalIndex = this.adjustIndentation(this.indentation, this.nodeText, this.originalIndex, false);
                ++this.originalIndex;
            } else if (currentIsNewline && previousIsAComment) {
                ++this.originalIndex;
                this.originalIndex = this.adjustIndentation(this.indentation, this.nodeText, this.originalIndex, false);
                this.nodeText.addElement(this.originalIndex, addedTextElement);
                ++this.originalIndex;
            } else if (currentIsNewline && addedTextElement.isChild()) {
                if (!(isPreviousElementNewline || isFirstElement || previousIsWhiteSpace)) {
                    ++this.originalIndex;
                }
                this.nodeText.addElement(this.originalIndex, addedTextElement);
                ++this.originalIndex;
            } else {
                this.nodeText.addElement(this.originalIndex, addedTextElement);
                ++this.originalIndex;
            }
        }
        if (addedTextElement.isNewline()) {
            boolean followedByUnindent = this.isFollowedByUnindent(this.diffElements, this.diffIndex);
            nextIsRightBrace = this.nextIsRightBrace(this.originalIndex);
            boolean nextIsNewLine = this.originalElements.get(this.originalIndex).isNewline();
            if (!nextIsNewLine && !nextIsRightBrace || followedByUnindent) {
                this.originalIndex = this.adjustIndentation(this.indentation, this.nodeText, this.originalIndex, followedByUnindent);
            }
        }
        ++this.diffIndex;
    }

    private String tokenDescription(int kind) {
        return GeneratedJavaParserConstants.tokenImage[kind];
    }

    private Map<Integer, Integer> getCorrespondanceBetweenNextOrderAndPreviousOrder(CsmMix elementsFromPreviousOrder, CsmMix elementsFromNextOrder) {
        HashMap<Integer, Integer> correspondanceBetweenNextOrderAndPreviousOrder = new HashMap<Integer, Integer>();
        ReadOnlyListIterator<CsmElement> previousOrderElementsIterator = new ReadOnlyListIterator<CsmElement>(elementsFromPreviousOrder.getElements());
        int syncNextIndex = 0;
        block0: while (previousOrderElementsIterator.hasNext()) {
            CsmElement pe = previousOrderElementsIterator.next();
            ReadOnlyListIterator<CsmElement> nextOrderElementsIterator = new ReadOnlyListIterator<CsmElement>(elementsFromNextOrder.getElements(), syncNextIndex);
            while (nextOrderElementsIterator.hasNext()) {
                CsmElement ne = nextOrderElementsIterator.next();
                if (correspondanceBetweenNextOrderAndPreviousOrder.values().contains(previousOrderElementsIterator.index()) || !DifferenceElementCalculator.matching(ne, pe)) continue;
                correspondanceBetweenNextOrderAndPreviousOrder.put(nextOrderElementsIterator.index(), previousOrderElementsIterator.index());
                syncNextIndex = nextOrderElementsIterator.index();
                continue block0;
            }
        }
        return correspondanceBetweenNextOrderAndPreviousOrder;
    }

    private boolean isFollowedByUnindent(List<DifferenceElement> diffElements, int diffIndex) {
        int nextIndexValue = diffIndex + 1;
        return nextIndexValue < diffElements.size() && diffElements.get(nextIndexValue).isAdded() && diffElements.get(nextIndexValue).getElement() instanceof CsmUnindent;
    }

    private List<Integer> findIndexOfCorrespondingNodeTextElement(List<CsmElement> elements, NodeText nodeText, int startIndex, Node node) {
        ArrayList<Integer> correspondingIndices = new ArrayList<Integer>();
        ListIterator<CsmElement> csmElementListIterator = elements.listIterator();
        while (csmElementListIterator.hasNext()) {
            int previousCsmElementIndex = csmElementListIterator.previousIndex();
            CsmElement csmElement = csmElementListIterator.next();
            int nextCsmElementIndex = csmElementListIterator.nextIndex();
            EnumMap<MatchClassification, Integer> potentialMatches = new EnumMap<MatchClassification, Integer>(MatchClassification.class);
            for (int i = startIndex; i < nodeText.numberOfElements(); ++i) {
                if (correspondingIndices.contains(i)) continue;
                TextElement textElement = nodeText.getTextElement(i);
                boolean isCorresponding = this.isCorrespondingElement(textElement, csmElement, node);
                if (isCorresponding) {
                    boolean hasSamePreviousElement = false;
                    if (i > 0 && previousCsmElementIndex > -1) {
                        TextElement previousTextElement = nodeText.getTextElement(i - 1);
                        hasSamePreviousElement = this.isCorrespondingElement(previousTextElement, elements.get(previousCsmElementIndex), node);
                    }
                    boolean hasSameNextElement = false;
                    if (i < nodeText.numberOfElements() - 1 && nextCsmElementIndex < elements.size()) {
                        TextElement nextTextElement = nodeText.getTextElement(i + 1);
                        hasSameNextElement = this.isCorrespondingElement(nextTextElement, elements.get(nextCsmElementIndex), node);
                    }
                    if (hasSamePreviousElement && hasSameNextElement) {
                        potentialMatches.putIfAbsent(MatchClassification.ALL, i);
                        continue;
                    }
                    if (hasSamePreviousElement) {
                        potentialMatches.putIfAbsent(MatchClassification.PREVIOUS_AND_SAME, i);
                        continue;
                    }
                    if (hasSameNextElement) {
                        potentialMatches.putIfAbsent(MatchClassification.NEXT_AND_SAME, i);
                        continue;
                    }
                    potentialMatches.putIfAbsent(MatchClassification.SAME_ONLY, i);
                    continue;
                }
                if (!this.isAlmostCorrespondingElement(textElement, csmElement, node)) continue;
                potentialMatches.putIfAbsent(MatchClassification.ALMOST, i);
            }
            Optional<MatchClassification> bestMatchKey = potentialMatches.keySet().stream().min(Comparator.comparing(MatchClassification::getPriority));
            if (bestMatchKey.isPresent()) {
                correspondingIndices.add((Integer)potentialMatches.get((Object)bestMatchKey.get()));
                continue;
            }
            correspondingIndices.add(-1);
        }
        return correspondingIndices;
    }

    private boolean isCorrespondingElement(TextElement textElement, CsmElement csmElement, Node node) {
        if (csmElement instanceof CsmToken) {
            CsmToken csmToken = (CsmToken)csmElement;
            if (textElement instanceof TokenTextElement) {
                TokenTextElement tokenTextElement = (TokenTextElement)textElement;
                return tokenTextElement.getTokenKind() == csmToken.getTokenType() && tokenTextElement.getText().equals(csmToken.getContent(node));
            }
        } else if (csmElement instanceof LexicalDifferenceCalculator.CsmChild) {
            LexicalDifferenceCalculator.CsmChild csmChild = (LexicalDifferenceCalculator.CsmChild)csmElement;
            if (textElement instanceof ChildTextElement) {
                ChildTextElement childTextElement = (ChildTextElement)textElement;
                return childTextElement.getChild() == csmChild.getChild();
            }
        } else {
            throw new UnsupportedOperationException();
        }
        return false;
    }

    private boolean isAlmostCorrespondingElement(TextElement textElement, CsmElement csmElement, Node node) {
        if (this.isCorrespondingElement(textElement, csmElement, node)) {
            return false;
        }
        return textElement.isWhiteSpace() && csmElement instanceof CsmToken && ((CsmToken)csmElement).isWhiteSpace();
    }

    private int adjustIndentation(List<TokenTextElement> indentation, NodeText nodeText, int nodeTextIndex, boolean followedByUnindent) {
        List<TextElement> indentationAdj = this.processIndentation(indentation, nodeText.getElements().subList(0, nodeTextIndex - 1));
        if (nodeTextIndex < nodeText.numberOfElements() && nodeText.getTextElement(nodeTextIndex).isToken(100)) {
            indentationAdj = indentationAdj.subList(0, indentationAdj.size() - Math.min(4, indentationAdj.size()));
        } else if (followedByUnindent) {
            indentationAdj = indentationAdj.subList(0, Math.max(0, indentationAdj.size() - 4));
        }
        for (TextElement e : indentationAdj) {
            if (nodeTextIndex < nodeText.numberOfElements() && nodeText.getTextElement(nodeTextIndex).isSpaceOrTab()) {
                ++nodeTextIndex;
                continue;
            }
            nodeText.getElements().add(nodeTextIndex++, e);
        }
        if (nodeTextIndex < 0) {
            throw new IllegalStateException();
        }
        return nodeTextIndex;
    }

    private boolean isAReplacement(int diffIndex) {
        return diffIndex > 0 && this.diffElements.get(diffIndex).isAdded() && this.diffElements.get(diffIndex - 1).isRemoved();
    }

    private boolean isReplaced(int diffIndex) {
        return diffIndex < this.diffElements.size() - 1 && this.diffElements.get(diffIndex + 1).isAdded() && this.diffElements.get(diffIndex).isRemoved();
    }

    public String toString() {
        return "Difference{" + this.diffElements + '}';
    }

    private static enum MatchClassification {
        ALL(1),
        PREVIOUS_AND_SAME(2),
        NEXT_AND_SAME(3),
        SAME_ONLY(4),
        ALMOST(5);

        private final int priority;

        private MatchClassification(int priority) {
            this.priority = priority;
        }

        int getPriority() {
            return this.priority;
        }
    }

    private class ReadOnlyListIterator<T>
    implements ListIterator<T> {
        ListIterator<T> elements;

        public ReadOnlyListIterator(List<T> elements) {
            this(elements, 0);
        }

        public ReadOnlyListIterator(List<T> elements, int index) {
            this.elements = elements.listIterator(index);
        }

        @Override
        public boolean hasNext() {
            return this.elements.hasNext();
        }

        @Override
        public T next() {
            return this.elements.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.elements.hasPrevious();
        }

        @Override
        public T previous() {
            return this.elements.previous();
        }

        @Override
        public int nextIndex() {
            return this.elements.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.elements.previousIndex();
        }

        public int index() {
            return this.elements.nextIndex() - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException();
        }
    }

    private class EnforcingIndentationContext {
        int start;
        int extraCharacters;

        public EnforcingIndentationContext(int start) {
            this.start = start;
            this.extraCharacters = 0;
        }
    }
}

