'use strict';

const Command = require('./command.js');
const CommandCode = require('../constants/commands.js');
const Packet = require('../packets/packet.js');

class Quit extends Command {
  constructor(callback) {
    super();
    this.done = callback;
  }

  start(packet, connection) {
    connection._closing = true;
    const quit = new Packet(
      0,
      Buffer.from([1, 0, 0, 0, CommandCode.QUIT]),
      0,
      5
    );
    if (this.done) {
      this.done();
    }
    connection.writePacket(quit);
    return null;
  }
}

module.exports = Quit;
