/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder;

import com.headius.invokebinder.InvalidTransformException;
import com.headius.invokebinder.SmartHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Signature {
    private final MethodType methodType;
    private final String[] argNames;

    Signature(Class<?> retval) {
        this(MethodType.methodType(retval), new String[0]);
    }

    Signature(Class<?> retval, Class<?>[] argTypes, String ... argNames) {
        this(MethodType.methodType(retval, argTypes), argNames);
    }

    Signature(Class<?> retval, Class<?> firstArg, Class<?>[] restArgs, String ... argNames) {
        this(MethodType.methodType(retval, firstArg, restArgs), argNames);
    }

    Signature(MethodType methodType, String ... argNames) {
        assert (methodType.parameterCount() == argNames.length) : "arg name count " + argNames.length + " does not match parameter count " + methodType.parameterCount();
        this.methodType = methodType;
        this.argNames = argNames;
    }

    Signature(MethodType methodType, String firstName, String ... restNames) {
        assert (methodType.parameterCount() == restNames.length + 1) : "arg name count " + (restNames.length + 1) + " does not match parameter count " + methodType.parameterCount();
        this.methodType = methodType;
        this.argNames = new String[restNames.length + 1];
        this.argNames[0] = firstName;
        System.arraycopy(restNames, 0, this.argNames, 1, restNames.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        for (int i2 = 0; i2 < this.argNames.length; ++i2) {
            sb.append(((Class)this.methodType.parameterType(i2)).getSimpleName()).append(' ').append(this.argNames[i2]);
            if (i2 + 1 >= this.argNames.length) continue;
            sb.append(", ");
        }
        sb.append(")").append(((Class)this.methodType.returnType()).getSimpleName());
        return sb.toString();
    }

    public static Signature returning(Class<?> retval) {
        Signature sig = new Signature(retval);
        return sig;
    }

    public static Signature from(Class<?> retval, Class<?>[] argTypes, String ... argNames) {
        assert (argTypes.length == argNames.length);
        return new Signature(retval, argTypes, argNames);
    }

    public Signature changeReturn(Class<?> retval) {
        return new Signature(this.methodType.changeReturnType(retval), this.argNames);
    }

    public Signature asFold(Class<?> retval) {
        return new Signature(this.methodType.changeReturnType(retval), this.argNames);
    }

    public Signature appendArg(String name2, Class<?> type2) {
        String[] newArgNames = new String[this.argNames.length + 1];
        System.arraycopy(this.argNames, 0, newArgNames, 0, this.argNames.length);
        newArgNames[this.argNames.length] = name2;
        MethodType newMethodType = this.methodType.appendParameterTypes(type2);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature appendArgs(String[] names2, Class<?> ... types) {
        assert (names2.length == types.length) : "names and types must be of the same length";
        String[] newArgNames = new String[this.argNames.length + names2.length];
        System.arraycopy(this.argNames, 0, newArgNames, 0, this.argNames.length);
        System.arraycopy(names2, 0, newArgNames, this.argNames.length, names2.length);
        MethodType newMethodType = this.methodType.appendParameterTypes(types);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature prependArg(String name2, Class<?> type2) {
        String[] newArgNames = new String[this.argNames.length + 1];
        System.arraycopy(this.argNames, 0, newArgNames, 1, this.argNames.length);
        newArgNames[0] = name2;
        MethodType newMethodType = this.methodType.insertParameterTypes(0, type2);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature prependArgs(String[] names2, Class<?> ... types) {
        String[] newArgNames = new String[this.argNames.length + names2.length];
        System.arraycopy(this.argNames, 0, newArgNames, names2.length, this.argNames.length);
        System.arraycopy(names2, 0, newArgNames, 0, names2.length);
        MethodType newMethodType = this.methodType.insertParameterTypes(0, types);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature insertArg(int index2, String name2, Class<?> type2) {
        return this.insertArgs(index2, new String[]{name2}, type2);
    }

    public Signature insertArg(String beforeName, String name2, Class<?> type2) {
        return this.insertArgs(this.argOffset(beforeName), new String[]{name2}, type2);
    }

    public Signature insertArgs(int index2, String[] names2, Class<?> ... types) {
        assert (names2.length == types.length) : "names and types must be of the same length";
        String[] newArgNames = new String[this.argNames.length + names2.length];
        System.arraycopy(names2, 0, newArgNames, index2, names2.length);
        if (index2 != 0) {
            System.arraycopy(this.argNames, 0, newArgNames, 0, index2);
        }
        if (this.argNames.length - index2 != 0) {
            System.arraycopy(this.argNames, index2, newArgNames, index2 + names2.length, this.argNames.length - index2);
        }
        MethodType newMethodType = this.methodType.insertParameterTypes(index2, types);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature insertArgs(String beforeName, String[] names2, Class<?> ... types) {
        return this.insertArgs(this.argOffset(beforeName), names2, types);
    }

    public Signature dropArg(String name2) {
        String[] newArgNames = new String[this.argNames.length - 1];
        MethodType newType = this.methodType;
        int j = 0;
        for (int i2 = 0; i2 < this.argNames.length; ++i2) {
            if (this.argNames[i2].equals(name2)) {
                newType = newType.dropParameterTypes(j, j + 1);
                continue;
            }
            newArgNames[j++] = this.argNames[i2];
        }
        if (newType == null) {
            return this;
        }
        return new Signature(newType, newArgNames);
    }

    public Signature dropArg(int index2) {
        assert (index2 < this.argNames.length);
        String[] newArgNames = new String[this.argNames.length - 1];
        if (index2 > 0) {
            System.arraycopy(this.argNames, 0, newArgNames, 0, index2);
        }
        if (index2 < this.argNames.length - 1) {
            System.arraycopy(this.argNames, index2 + 1, newArgNames, index2, this.argNames.length - (index2 + 1));
        }
        MethodType newType = this.methodType.dropParameterTypes(index2, index2 + 1);
        return new Signature(newType, newArgNames);
    }

    public Signature dropLast() {
        return this.dropLast(1);
    }

    public Signature dropLast(int n) {
        return new Signature(this.methodType.dropParameterTypes(this.methodType.parameterCount() - n, this.methodType.parameterCount()), Arrays.copyOfRange(this.argNames, 0, this.argNames.length - n));
    }

    public Signature dropFirst() {
        return this.dropFirst(1);
    }

    public Signature dropFirst(int n) {
        return new Signature(this.methodType.dropParameterTypes(0, n), Arrays.copyOfRange(this.argNames, n, this.argNames.length));
    }

    public Signature replaceArg(String oldName, String newName, Class<?> newType) {
        int offset2 = this.argOffset(oldName);
        String[] newArgNames = this.argNames;
        if (!oldName.equals(newName)) {
            newArgNames = Arrays.copyOf(this.argNames, this.argNames.length);
            newArgNames[offset2] = newName;
        }
        TypeDescriptor.OfField oldType = this.methodType.parameterType(offset2);
        MethodType newMethodType = this.methodType;
        if (!oldType.equals(newType)) {
            newMethodType = this.methodType.changeParameterType(offset2, newType);
        }
        return new Signature(newMethodType, newArgNames);
    }

    public Signature spread(String[] names2, Class<?> ... types) {
        assert (names2.length == types.length) : "names and types must be of the same length";
        String[] newArgNames = new String[this.argNames.length - 1 + names2.length];
        System.arraycopy(names2, 0, newArgNames, newArgNames.length - names2.length, names2.length);
        System.arraycopy(this.argNames, 0, newArgNames, 0, this.argNames.length - 1);
        MethodType newMethodType = this.methodType.dropParameterTypes(this.methodType.parameterCount() - 1, this.methodType.parameterCount()).appendParameterTypes(types);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature spread(String ... names2) {
        Class<?> aryType = this.lastArgType();
        assert (this.lastArgType().isArray());
        Object[] newTypes = new Class[names2.length];
        Arrays.fill(newTypes, aryType.getComponentType());
        return this.spread(names2, (Class<?>[])newTypes);
    }

    public Signature spread(String baseName, int count2) {
        String[] spreadNames = new String[count2];
        for (int i2 = 0; i2 < count2; ++i2) {
            spreadNames[i2] = baseName + i2;
        }
        return this.spread(spreadNames);
    }

    public Signature collect(String newName, String oldPattern) {
        int start2 = -1;
        int newCount = 0;
        int gatherCount = 0;
        Class<?> type2 = null;
        Pattern pattern = Pattern.compile(oldPattern);
        MethodType newType = this.type();
        for (int i2 = 0; i2 < this.argNames.length; ++i2) {
            if (pattern.matcher(this.argName(i2)).matches()) {
                ++gatherCount;
                newType = newType.dropParameterTypes(newCount, newCount + 1);
                Class<?> argType = this.argType(i2);
                if (start2 == -1) {
                    start2 = i2;
                }
                if (type2 == null) {
                    type2 = argType;
                    continue;
                }
                if (argType == type2) continue;
                throw new InvalidTransformException("arguments matching " + pattern + " are not all of the same type");
            }
            ++newCount;
        }
        if (start2 != -1) {
            String[] newNames = new String[newCount + 1];
            System.arraycopy(this.argNames, 0, newNames, 0, start2);
            newNames[start2] = newName;
            newType = newType.insertParameterTypes(start2, Array.newInstance(type2, 0).getClass());
            if (newCount + 1 > start2) {
                System.arraycopy(this.argNames, start2 + gatherCount, newNames, start2 + 1, newCount - start2);
            }
            return new Signature(newType, newNames);
        }
        return this;
    }

    public MethodType type() {
        return this.methodType;
    }

    public int argCount() {
        return this.argNames.length;
    }

    public String[] argNames() {
        return this.argNames;
    }

    public String argName(int index2) {
        return this.argNames[index2];
    }

    public int argOffset(String name2) {
        for (int i2 = 0; i2 < this.argNames.length; ++i2) {
            if (!this.argNames[i2].equals(name2)) continue;
            return i2;
        }
        return -1;
    }

    public int argOffsets(String pattern) {
        for (int i2 = 0; i2 < this.argNames.length; ++i2) {
            if (!Pattern.compile(pattern).matcher(this.argNames[i2]).find()) continue;
            return i2;
        }
        return -1;
    }

    public String firstArgName() {
        return this.argNames[0];
    }

    public String lastArgName() {
        return this.argNames[this.argNames.length - 1];
    }

    public Signature argName(int index2, String name2) {
        String[] argNames = Arrays.copyOf(this.argNames(), this.argNames().length);
        argNames[index2] = name2;
        return new Signature(this.type(), argNames);
    }

    public Class<?> argType(int index2) {
        return this.methodType.parameterType(index2);
    }

    public Class<?> firstArgType() {
        return this.methodType.parameterType(0);
    }

    public Class<?> lastArgType() {
        return this.argType(this.methodType.parameterCount() - 1);
    }

    public Signature argType(int index2, Class<?> type2) {
        return new Signature(this.type().changeParameterType(index2, type2), this.argNames());
    }

    public Signature permute(String ... permuteArgs) {
        Pattern[] patterns = new Pattern[permuteArgs.length];
        for (int i2 = 0; i2 < permuteArgs.length; ++i2) {
            patterns[i2] = Pattern.compile(permuteArgs[i2]);
        }
        ArrayList<TypeDescriptor.OfField> types = new ArrayList<TypeDescriptor.OfField>(this.argNames.length);
        ArrayList<String> names2 = new ArrayList<String>(this.argNames.length);
        for (Pattern pattern : patterns) {
            for (int argOffset = 0; argOffset < this.argNames.length; ++argOffset) {
                String arg2 = this.argNames[argOffset];
                Matcher matcher = pattern.matcher(arg2);
                if (!matcher.find()) continue;
                types.add(this.methodType.parameterType(argOffset));
                names2.add(arg2);
            }
        }
        return new Signature(MethodType.methodType(this.methodType.returnType(), types.toArray(new Class[0])), names2.toArray(new String[0]));
    }

    public Signature exclude(String ... excludeArgs) {
        Pattern[] patterns = new Pattern[excludeArgs.length];
        for (int i2 = 0; i2 < excludeArgs.length; ++i2) {
            patterns[i2] = Pattern.compile(excludeArgs[i2]);
        }
        ArrayList<TypeDescriptor.OfField> types = new ArrayList<TypeDescriptor.OfField>(this.argNames.length);
        ArrayList<String> names2 = new ArrayList<String>(this.argNames.length);
        block1: for (int argOffset = 0; argOffset < this.argNames.length; ++argOffset) {
            String arg2 = this.argNames[argOffset];
            for (Pattern pattern : patterns) {
                Matcher matcher = pattern.matcher(arg2);
                if (matcher.find()) continue block1;
            }
            types.add(this.methodType.parameterType(argOffset));
            names2.add(arg2);
        }
        return new Signature(MethodType.methodType(this.methodType.returnType(), types.toArray(new Class[0])), names2.toArray(new String[0]));
    }

    public MethodHandle permuteWith(MethodHandle target, String ... permuteArgs) {
        return MethodHandles.permuteArguments(target, this.methodType, this.to(this.permute(permuteArgs)));
    }

    public SmartHandle permuteWith(SmartHandle target) {
        String[] argNames = target.signature().argNames();
        return new SmartHandle(this, this.permuteWith(target.handle(), argNames));
    }

    public int[] to(Signature other) {
        return this.nonMatchingTo(other.argNames);
    }

    public int[] to(String ... otherArgPatterns) {
        return this.to(this.permute(otherArgPatterns));
    }

    private int[] nonMatchingTo(String ... otherArgNames) {
        int[] offsets2 = new int[otherArgNames.length];
        int i2 = 0;
        for (String arg2 : otherArgNames) {
            int pos2 = -1;
            for (int offset2 = 0; offset2 < this.argNames.length; ++offset2) {
                if (!this.argNames[offset2].equals(arg2)) continue;
                pos2 = offset2;
                break;
            }
            assert (pos2 >= 0) : "argument not found: \"" + arg2 + "\"";
            offsets2[i2++] = pos2;
        }
        return offsets2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature signature = (Signature)o;
        if (!this.methodType.equals((Object)signature.methodType)) {
            return false;
        }
        return Arrays.equals(this.argNames, signature.argNames);
    }

    public int hashCode() {
        int result2 = this.methodType.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.argNames);
        return result2;
    }
}

