/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.ad.model.Entity;
import org.opensearch.ad.settings.EnabledSetting;
import org.opensearch.ad.transport.GetAnomalyDetectorAction;
import org.opensearch.ad.transport.GetAnomalyDetectorRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.Strings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestToXContentListener;

public class RestGetAnomalyDetectorAction
extends BaseRestHandler {
    private static final String GET_ANOMALY_DETECTOR_ACTION = "get_anomaly_detector";
    private static final Logger logger = LogManager.getLogger(RestGetAnomalyDetectorAction.class);

    public String getName() {
        return GET_ANOMALY_DETECTOR_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!EnabledSetting.isADPluginEnabled()) {
            throw new IllegalStateException("AD plugin is disabled. To enable update plugins.anomaly_detection.enabled to true");
        }
        String detectorId = request.param("detectorID");
        String typesStr = request.param("type");
        String rawPath = request.rawPath();
        boolean returnJob = request.paramAsBoolean("job", false);
        boolean returnTask = request.paramAsBoolean("task", false);
        boolean all = request.paramAsBoolean("_all", false);
        GetAnomalyDetectorRequest getAnomalyDetectorRequest = new GetAnomalyDetectorRequest(detectorId, RestActions.parseVersion((RestRequest)request), returnJob, returnTask, typesStr, rawPath, all, this.buildEntity(request, detectorId));
        return channel -> client.execute((ActionType)GetAnomalyDetectorAction.INSTANCE, (ActionRequest)getAnomalyDetectorRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_plugins/_anomaly_detection/detectors", "detectorID", "_profile")), (Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s/{%s}", "/_plugins/_anomaly_detection/detectors", "detectorID", "_profile", "type")));
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        String path = String.format(Locale.ROOT, "%s/{%s}", "/_opendistro/_anomaly_detection/detectors", "detectorID");
        String newPath = String.format(Locale.ROOT, "%s/{%s}", "/_plugins/_anomaly_detection/detectors", "detectorID");
        return ImmutableList.of((Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, newPath, RestRequest.Method.GET, path), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.HEAD, newPath, RestRequest.Method.HEAD, path), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{%s}/%s", "/_plugins/_anomaly_detection/detectors", "detectorID", "_profile"), RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{%s}/%s", "/_opendistro/_anomaly_detection/detectors", "detectorID", "_profile")), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{%s}/%s/{%s}", "/_plugins/_anomaly_detection/detectors", "detectorID", "_profile", "type"), RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{%s}/%s/{%s}", "/_opendistro/_anomaly_detection/detectors", "detectorID", "_profile", "type")));
    }

    private Entity buildEntity(RestRequest request, String detectorId) throws IOException {
        Optional<Entity> entity;
        if (Strings.isEmpty((CharSequence)detectorId)) {
            throw new IllegalStateException("AD ID is missing");
        }
        String entityName = request.param("category_field");
        String entityValue = request.param("entity");
        if (entityName != null && entityValue != null) {
            return Entity.createSingleAttributeEntity(entityName, entityValue);
        }
        if (request.hasContent() && (entity = Entity.fromJsonObject(request.contentParser())).isPresent()) {
            return entity.get();
        }
        return null;
    }
}

