"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeWithDefaultTheme = exports.mergeWithDefaultAnnotationRect = exports.mergeWithDefaultAnnotationLine = exports.DEFAULT_ANNOTATION_RECT_STYLE = exports.DEFAULT_ANNOTATION_LINE_STYLE = void 0;
var common_1 = require("../common");
var light_theme_1 = require("./light_theme");
exports.DEFAULT_ANNOTATION_LINE_STYLE = {
    line: {
        stroke: '#777',
        strokeWidth: 1,
        opacity: 1,
    },
    details: {
        fontSize: 10,
        fontFamily: 'sans-serif',
        fontStyle: 'normal',
        fill: '#777',
        padding: 0,
    },
};
exports.DEFAULT_ANNOTATION_RECT_STYLE = {
    stroke: '#FFEEBC',
    strokeWidth: 0,
    opacity: 0.25,
    fill: '#FFEEBC',
};
function mergeWithDefaultAnnotationLine(config) {
    var defaultLine = exports.DEFAULT_ANNOTATION_LINE_STYLE.line;
    var defaultDetails = exports.DEFAULT_ANNOTATION_LINE_STYLE.details;
    var mergedConfig = __assign({}, exports.DEFAULT_ANNOTATION_LINE_STYLE);
    if (!config) {
        return mergedConfig;
    }
    if (config.line) {
        mergedConfig.line = __assign(__assign({}, defaultLine), config.line);
    }
    if (config.details) {
        mergedConfig.details = __assign(__assign({}, defaultDetails), config.details);
    }
    return mergedConfig;
}
exports.mergeWithDefaultAnnotationLine = mergeWithDefaultAnnotationLine;
function mergeWithDefaultAnnotationRect(config) {
    if (!config) {
        return exports.DEFAULT_ANNOTATION_RECT_STYLE;
    }
    return __assign(__assign({}, exports.DEFAULT_ANNOTATION_RECT_STYLE), config);
}
exports.mergeWithDefaultAnnotationRect = mergeWithDefaultAnnotationRect;
function mergeWithDefaultTheme(theme, defaultTheme, axillaryThemes) {
    if (defaultTheme === void 0) { defaultTheme = light_theme_1.LIGHT_THEME; }
    if (axillaryThemes === void 0) { axillaryThemes = []; }
    return common_1.mergePartial(defaultTheme, theme, { mergeOptionalPartialValues: true }, axillaryThemes);
}
exports.mergeWithDefaultTheme = mergeWithDefaultTheme;
//# sourceMappingURL=merge_utils.js.map