/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.transport.action.removepolicy;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.index.Index;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.indexmanagement.indexstatemanagement.DefaultIndexMetadataService;
import org.opensearch.indexmanagement.indexstatemanagement.IndexMetadataProvider;
import org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.ISMStatusResponse;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexAction;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexRequest;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.removepolicy.RemovePolicyRequest;
import org.opensearch.indexmanagement.indexstatemanagement.util.FailedIndex;
import org.opensearch.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import org.opensearch.indexmanagement.indexstatemanagement.util.RestHandlerUtilsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.IndexMetadataService;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ISMIndexMetadata;
import org.opensearch.indexmanagement.util.IndexManagementException;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.rest.RestStatus;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001bB'\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001aH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/removepolicy/TransportRemovePolicyAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/removepolicy/RemovePolicyRequest;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/ISMStatusResponse;", "client", "Lorg/opensearch/client/node/NodeClient;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "indexMetadataProvider", "Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;", "(Lorg/opensearch/client/node/NodeClient;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;)V", "getClient", "()Lorg/opensearch/client/node/NodeClient;", "getIndexMetadataProvider", "()Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/action/ActionListener;", "RemovePolicyHandler", "opensearch-index-management"})
public final class TransportRemovePolicyAction
extends HandledTransportAction<RemovePolicyRequest, ISMStatusResponse> {
    @NotNull
    private final NodeClient client;
    @NotNull
    private final IndexMetadataProvider indexMetadataProvider;
    private final Logger log;

    @Inject
    public TransportRemovePolicyAction(@NotNull NodeClient client, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull IndexMetadataProvider indexMetadataProvider) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)indexMetadataProvider, (String)"indexMetadataProvider");
        super("cluster:admin/opendistro/ism/managedindex/remove", transportService, actionFilters, RemovePolicyRequest::new);
        this.client = client;
        this.indexMetadataProvider = indexMetadataProvider;
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public final NodeClient getClient() {
        return this.client;
    }

    @NotNull
    public final IndexMetadataProvider getIndexMetadataProvider() {
        return this.indexMetadataProvider;
    }

    protected void doExecute(@NotNull Task task, @NotNull RemovePolicyRequest request, @NotNull ActionListener<ISMStatusResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        new RemovePolicyHandler(this.client, listener, request, null, 8, null).start();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\u0006\u0010\u001a\u001a\u00020\u0017J\u0014\u0010\u001b\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\u0006\u0010\u001f\u001a\u00020\u0017J\u001c\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001dJ\u001a\u0010%\u001a\u00020\u00172\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110&J\b\u0010'\u001a\u00020\u0017H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/removepolicy/TransportRemovePolicyAction$RemovePolicyHandler;", "", "client", "Lorg/opensearch/client/node/NodeClient;", "actionListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/ISMStatusResponse;", "request", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/removepolicy/RemovePolicyRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "(Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/removepolicy/TransportRemovePolicyAction;Lorg/opensearch/client/node/NodeClient;Lorg/opensearch/action/ActionListener;Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/removepolicy/RemovePolicyRequest;Lorg/opensearch/commons/authuser/User;)V", "failedIndices", "", "Lorg/opensearch/indexmanagement/indexstatemanagement/util/FailedIndex;", "indicesToRemove", "", "", "indicesWithAutoManageFalseBlock", "", "indicesWithReadOnlyAllowDeleteBlock", "indicesWithReadOnlyBlock", "getClusterState", "", "getExistingManagedIndices", "getIndicesToRemove", "removeManagedIndices", "removeMetadatas", "indices", "", "Lorg/opensearch/index/Index;", "start", "updateSettingCallChain", "current", "", "updateSettingReqsList", "Lorg/opensearch/action/admin/indices/settings/put/UpdateSettingsRequest;", "updateSettings", "", "validateAndGetIndices", "opensearch-index-management"})
    public final class RemovePolicyHandler {
        @NotNull
        private final NodeClient client;
        @NotNull
        private final ActionListener<ISMStatusResponse> actionListener;
        @NotNull
        private final RemovePolicyRequest request;
        @Nullable
        private final User user;
        @NotNull
        private final List<FailedIndex> failedIndices;
        @NotNull
        private final Map<String, String> indicesToRemove;
        @NotNull
        private final Set<String> indicesWithAutoManageFalseBlock;
        @NotNull
        private final Set<String> indicesWithReadOnlyBlock;
        @NotNull
        private final Set<String> indicesWithReadOnlyAllowDeleteBlock;

        public RemovePolicyHandler(@NotNull NodeClient client, @NotNull ActionListener<ISMStatusResponse> actionListener, @Nullable RemovePolicyRequest request, User user) {
            Intrinsics.checkNotNullParameter((Object)((Object)TransportRemovePolicyAction.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
            this.failedIndices = new ArrayList();
            this.indicesToRemove = new LinkedHashMap();
            this.indicesWithAutoManageFalseBlock = new LinkedHashSet();
            this.indicesWithReadOnlyBlock = new LinkedHashSet();
            this.indicesWithReadOnlyAllowDeleteBlock = new LinkedHashSet();
        }

        public /* synthetic */ RemovePolicyHandler(NodeClient nodeClient, ActionListener actionListener, RemovePolicyRequest removePolicyRequest, User user, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                ThreadContext threadContext = nodeClient.threadPool().getThreadContext();
                Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"class RemovePolicyHandle\u2026        )\n        }\n    }");
                user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
            }
            this(nodeClient, (ActionListener<ISMStatusResponse>)actionListener, removePolicyRequest, user);
        }

        public final void start() {
            TransportRemovePolicyAction.this.log.debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            if (this.user == null) {
                this.getIndicesToRemove();
            } else {
                this.validateAndGetIndices();
            }
        }

        private final void validateAndGetIndices() {
            Collection $this$toTypedArray$iv = this.request.getIndices();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            String[] stringArray2 = stringArray;
            ManagedIndexRequest managedIndexRequest = (ManagedIndexRequest)new ManagedIndexRequest(new String[0]).indices(Arrays.copyOf(stringArray2, stringArray2.length));
            this.client.execute((ActionType)ManagedIndexAction.Companion.getINSTANCE(), (ActionRequest)managedIndexRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(this){
                final /* synthetic */ RemovePolicyHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull AcknowledgedResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    RemovePolicyHandler.access$getIndicesToRemove(this.this$0);
                }

                public void onFailure(@NotNull Exception e) {
                    Exception exception;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ActionListener actionListener = RemovePolicyHandler.access$getActionListener$p(this.this$0);
                    boolean bl = e instanceof OpenSearchSecurityException;
                    if (bl) {
                        exception = (Exception)new OpenSearchStatusException("User doesn't have required index permissions on one or more requested indices: " + ((OpenSearchSecurityException)((Object)e)).getLocalizedMessage(), RestStatus.FORBIDDEN, new Object[0]);
                    } else if (!bl) {
                        exception = e;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    actionListener.onFailure((Exception)((Object)IndexManagementException.Companion.wrap(exception)));
                }
            });
        }

        private final void getIndicesToRemove() {
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(TransportRemovePolicyAction.this, this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ TransportRemovePolicyAction this$0;
                final /* synthetic */ RemovePolicyHandler this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            indexNameToMetadata = new HashMap<K, V>();
                            var12_4 = indexNameToMetadata;
                            this.L$0 = indexNameToMetadata;
                            this.L$1 = var12_4;
                            this.label = 1;
                            v0 = this.this$0.getIndexMetadataProvider().getISMIndexMetadataByType(RemovePolicyHandler.access$getRequest$p(this.this$1).getIndexType(), RemovePolicyHandler.access$getRequest$p(this.this$1).getIndices(), (Continuation<? super Map<String, ISMIndexMetadata>>)((Continuation)this));
                            ** if (v0 != var13_2) goto lbl15
lbl14:
                            // 1 sources

                            return var13_2;
lbl15:
                            // 1 sources

                            ** GOTO lbl23
                        }
                        case 1: {
                            var12_4 = (Map)this.L$1;
                            indexNameToMetadata = (Map)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl23:
                                // 2 sources

                                var12_4.putAll((Map)v0);
                            }
                            catch (Exception e) {
                                v1 = ExceptionsHelper.unwrapCause((Throwable)e);
                                if (v1 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                                }
                                RemovePolicyHandler.access$getActionListener$p(this.this$1).onFailure((Exception)v1);
                                return Unit.INSTANCE;
                            }
                            e = indexNameToMetadata;
                            var4_7 = this.this$1;
                            $i$f$forEach = false;
                            var6_9 = $this$forEach$iv.entrySet().iterator();
                            while (var6_9.hasNext()) {
                                $dstr$indexName$indexMetadata = element$iv = var6_9.next();
                                $i$a$-forEach-TransportRemovePolicyAction$RemovePolicyHandler$getIndicesToRemove$1$1 = false;
                                indexName = (String)$dstr$indexName$indexMetadata.getKey();
                                indexMetadata = (ISMIndexMetadata)$dstr$indexName$indexMetadata.getValue();
                                RemovePolicyHandler.access$getIndicesToRemove$p(var4_7).putIfAbsent(indexMetadata.getIndexUuid(), indexName);
                            }
                            if (Intrinsics.areEqual((Object)RemovePolicyHandler.access$getRequest$p(this.this$1).getIndexType(), (Object)"_default")) {
                                RemovePolicyHandler.access$getClusterState(this.this$1);
                            } else {
                                RemovePolicyHandler.access$getExistingManagedIndices(this.this$1);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void getClusterState() {
            IndicesOptions strictExpandOptions = IndicesOptions.strictExpand();
            Collection $this$toTypedArray$iv = this.request.getIndices();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            Object object = stringArray;
            ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(Arrays.copyOf(object, ((String[])object).length)).metadata(true).local(false)).indicesOptions(strictExpandOptions);
            object = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
            TransportRemovePolicyAction transportRemovePolicyAction = TransportRemovePolicyAction.this;
            Throwable throwable = null;
            try {
                ThreadContext.StoredContext it = (ThreadContext.StoredContext)object;
                boolean bl = false;
                this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(transportRemovePolicyAction, this){
                    final /* synthetic */ TransportRemovePolicyAction this$0;
                    final /* synthetic */ RemovePolicyHandler this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void onResponse(@NotNull ClusterStateResponse response2) {
                        void $this$forEach$iv;
                        void $this$forEach$iv2;
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        ImmutableOpenMap indexMetadatas2 = response2.getState().getMetadata().getIndices();
                        Intrinsics.checkNotNullExpressionValue((Object)indexMetadatas2, (String)"indexMetadatas");
                        Iterable iterable = (Iterable)indexMetadatas2;
                        Object object = this.this$1;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv2) {
                            String string;
                            ObjectObjectCursor it = (ObjectObjectCursor)element$iv;
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)((IndexMetadata)it.value).getSettings().get(ManagedIndexSettings.Companion.getAUTO_MANAGE().getKey()), (Object)"false")) {
                                Set set = RemovePolicyHandler.access$getIndicesWithAutoManageFalseBlock$p((RemovePolicyHandler)object);
                                string = ((IndexMetadata)it.value).getIndexUUID();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.value.indexUUID");
                                set.add(string);
                            }
                            if (Intrinsics.areEqual((Object)((IndexMetadata)it.value).getSettings().get(IndexMetadata.SETTING_READ_ONLY), (Object)"true")) {
                                Set set = RemovePolicyHandler.access$getIndicesWithReadOnlyBlock$p((RemovePolicyHandler)object);
                                string = ((IndexMetadata)it.value).getIndexUUID();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.value.indexUUID");
                                set.add(string);
                            }
                            if (!Intrinsics.areEqual((Object)((IndexMetadata)it.value).getSettings().get(IndexMetadata.SETTING_READ_ONLY_ALLOW_DELETE), (Object)"true")) continue;
                            Set set = RemovePolicyHandler.access$getIndicesWithReadOnlyAllowDeleteBlock$p((RemovePolicyHandler)object);
                            string = ((IndexMetadata)it.value).getIndexUUID();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.value.indexUUID");
                            set.add(string);
                        }
                        IndexMetadataService indexMetadataService = this.this$0.getIndexMetadataProvider().getServices().get("_default");
                        if (indexMetadataService == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.opensearch.indexmanagement.indexstatemanagement.DefaultIndexMetadataService");
                        }
                        DefaultIndexMetadataService defaultIndexMetadataService = (DefaultIndexMetadataService)indexMetadataService;
                        object = response2.getState();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.state");
                        object = OpenSearchExtensionsKt.getUuidsForClosedIndices((ClusterState)object, defaultIndexMetadataService);
                        RemovePolicyHandler removePolicyHandler = this.this$1;
                        boolean $i$f$forEach2 = false;
                        for (T element$iv : $this$forEach$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            V v = RemovePolicyHandler.access$getIndicesToRemove$p(removePolicyHandler).get(it);
                            if (v == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                            }
                            RemovePolicyHandler.access$getFailedIndices$p(removePolicyHandler).add(new FailedIndex((String)v, it, "This index is closed"));
                            RemovePolicyHandler.access$getIndicesToRemove$p(removePolicyHandler).remove(it);
                        }
                        RemovePolicyHandler.access$getExistingManagedIndices(this.this$1);
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                        if (throwable == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                        }
                        RemovePolicyHandler.access$getActionListener$p(this.this$1).onFailure((Exception)throwable);
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
        }

        private final void getExistingManagedIndices() {
            if (this.indicesToRemove.isEmpty()) {
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
                return;
            }
            MultiGetRequest multiGetReq = new MultiGetRequest();
            Map<String, String> $this$forEach$iv = this.indicesToRemove;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> it = element$iv = iterator.next();
                boolean bl = false;
                multiGetReq.add(".opendistro-ism-config", it.getKey());
            }
            this.client.multiGet(multiGetReq, (ActionListener)new ActionListener<MultiGetResponse>(this){
                final /* synthetic */ RemovePolicyHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull MultiGetResponse response2) {
                    Iterable $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    Object object = response2.getResponses();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.responses");
                    MultiGetItemResponse f = (MultiGetItemResponse)ArraysKt.first((Object[])object);
                    if (f.isFailed() && f.getFailure().getFailure() instanceof IndexNotFoundException) {
                        object = RemovePolicyHandler.access$getIndicesToRemove$p(this.this$0);
                        RemovePolicyHandler removePolicyHandler = this.this$0;
                        boolean $i$f$forEach = false;
                        Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<K, V> element$iv;
                            Map.Entry<K, V> $dstr$uuid$name = element$iv = iterator.next();
                            boolean bl = false;
                            String uuid = (String)$dstr$uuid$name.getKey();
                            String name = (String)$dstr$uuid$name.getValue();
                            RemovePolicyHandler.access$getFailedIndices$p(removePolicyHandler).add(new FailedIndex(name, uuid, "This index does not have a policy to remove"));
                        }
                        RemovePolicyHandler.access$getActionListener$p(this.this$0).onResponse((Object)((Object)new ISMStatusResponse(0, RemovePolicyHandler.access$getFailedIndices$p(this.this$0))));
                        return;
                    }
                    $this$forEach$iv = (Iterable)response2;
                    RemovePolicyHandler removePolicyHandler = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        MultiGetItemResponse it = (MultiGetItemResponse)element$iv;
                        boolean bl = false;
                        if (it.getResponse().isExists()) continue;
                        String docId2 = it.getId();
                        List list = RemovePolicyHandler.access$getFailedIndices$p(removePolicyHandler);
                        V v = RemovePolicyHandler.access$getIndicesToRemove$p(removePolicyHandler).get(docId2);
                        if (v == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        String string = (String)v;
                        Intrinsics.checkNotNullExpressionValue((Object)docId2, (String)"docId");
                        list.add(new FailedIndex(string, docId2, "This index does not have a policy to remove"));
                        RemovePolicyHandler.access$getIndicesToRemove$p(removePolicyHandler).remove(docId2);
                    }
                    if (Intrinsics.areEqual((Object)RemovePolicyHandler.access$getRequest$p(this.this$0).getIndexType(), (Object)"_default")) {
                        this.this$0.updateSettings(RemovePolicyHandler.access$getIndicesToRemove$p(this.this$0));
                    } else {
                        this.this$0.removeManagedIndices();
                    }
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                    if (throwable == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    }
                    RemovePolicyHandler.access$getActionListener$p(this.this$0).onFailure((Exception)throwable);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        public final void updateSettings(@NotNull Map<String, String> indices) {
            UpdateSettingsRequest updateSettingsRequest;
            String[] stringArray;
            Iterable thisCollection$iv;
            String it;
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            List list;
            UpdateSettingsRequest updateSettingsRequest2;
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter(indices, (String)"indices");
            Set indicesUuidsSet = SetsKt.minus((Set)CollectionsKt.toSet((Iterable)indices.keySet()), (Iterable)this.indicesWithAutoManageFalseBlock);
            Iterable $this$filter$iv = indicesUuidsSet;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                String it2 = (String)element$iv$iv;
                boolean bl = false;
                if (!this.indicesWithReadOnlyBlock.contains(it2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List readOnlyIndices = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = SetsKt.minus((Set)indicesUuidsSet, (Iterable)readOnlyIndices);
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it3 = (String)element$iv$iv;
                boolean bl = false;
                if (!this.indicesWithReadOnlyAllowDeleteBlock.contains(it3)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List readOnlyAllowDeleteIndices = (List)destination$iv$iv2;
            Set normalIndices = SetsKt.minus((Set)SetsKt.minus((Set)indicesUuidsSet, (Iterable)readOnlyIndices), (Iterable)readOnlyAllowDeleteIndices);
            List updateSettingReqsList = new ArrayList();
            if (!((Collection)readOnlyIndices).isEmpty()) {
                void $this$toTypedArray$iv;
                Collection $this$map$iv;
                Object element$iv$iv;
                Iterable $i$f$filterTo22 = readOnlyIndices;
                updateSettingsRequest2 = new UpdateSettingsRequest();
                list = updateSettingReqsList;
                boolean $i$f$map = false;
                element$iv$iv = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl = false;
                    collection.add(indices.get(it));
                }
                collection = (List)destination$iv$iv3;
                $this$map$iv = collection;
                boolean $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                if (stringArray2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                stringArray = stringArray2;
                updateSettingsRequest = updateSettingsRequest2.indices(Arrays.copyOf(stringArray, stringArray.length)).settings(Settings.builder().put(ManagedIndexSettings.Companion.getAUTO_MANAGE().getKey(), false).put(IndexMetadata.INDEX_READ_ONLY_SETTING.getKey(), true));
                Intrinsics.checkNotNullExpressionValue((Object)updateSettingsRequest, (String)"UpdateSettingsRequest().\u2026                        )");
                list.add(updateSettingsRequest);
            }
            if (!((Collection)readOnlyAllowDeleteIndices).isEmpty()) {
                Collection $this$map$iv;
                Iterable $this$toTypedArray$iv = readOnlyAllowDeleteIndices;
                updateSettingsRequest2 = new UpdateSettingsRequest();
                list = updateSettingReqsList;
                boolean $i$f$map = false;
                thisCollection$iv = $this$map$iv;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (String)item$iv$iv;
                    collection = destination$iv$iv4;
                    boolean bl = false;
                    collection.add(indices.get(it));
                }
                collection = (List)destination$iv$iv4;
                $this$map$iv = collection;
                boolean $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
                if (stringArray3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                stringArray = stringArray3;
                updateSettingsRequest = updateSettingsRequest2.indices(Arrays.copyOf(stringArray, stringArray.length)).settings(Settings.builder().put(ManagedIndexSettings.Companion.getAUTO_MANAGE().getKey(), false).put(IndexMetadata.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING.getKey(), true));
                Intrinsics.checkNotNullExpressionValue((Object)updateSettingsRequest, (String)"UpdateSettingsRequest().\u2026                        )");
                list.add(updateSettingsRequest);
            }
            if (!((Collection)normalIndices).isEmpty()) {
                Collection<String> $this$map$iv;
                Iterable $this$toTypedArray$iv = normalIndices;
                updateSettingsRequest2 = new UpdateSettingsRequest();
                list = updateSettingReqsList;
                boolean $i$f$map = false;
                thisCollection$iv = $this$map$iv;
                Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (String)item$iv$iv;
                    collection = destination$iv$iv5;
                    boolean bl = false;
                    collection.add(indices.get(it));
                }
                $this$map$iv = collection = (List)destination$iv$iv5;
                boolean $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray4 = thisCollection$iv.toArray(new String[0]);
                if (stringArray4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                stringArray = stringArray4;
                updateSettingsRequest = updateSettingsRequest2.indices(Arrays.copyOf(stringArray, stringArray.length)).settings(Settings.builder().put(ManagedIndexSettings.Companion.getAUTO_MANAGE().getKey(), false));
                Intrinsics.checkNotNullExpressionValue((Object)updateSettingsRequest, (String)"UpdateSettingsRequest().\u2026.AUTO_MANAGE.key, false))");
                list.add(updateSettingsRequest);
            }
            this.updateSettingCallChain(0, updateSettingReqsList);
        }

        public final void updateSettingCallChain(int current, @NotNull List<? extends UpdateSettingsRequest> updateSettingReqsList) {
            Intrinsics.checkNotNullParameter(updateSettingReqsList, (String)"updateSettingReqsList");
            if (updateSettingReqsList.isEmpty()) {
                this.removeManagedIndices();
                return;
            }
            this.client.admin().indices().updateSettings(updateSettingReqsList.get(current), (ActionListener)new ActionListener<AcknowledgedResponse>(this, current, updateSettingReqsList){
                final /* synthetic */ RemovePolicyHandler this$0;
                final /* synthetic */ int $current;
                final /* synthetic */ List<UpdateSettingsRequest> $updateSettingReqsList;
                {
                    this.this$0 = $receiver;
                    this.$current = $current;
                    this.$updateSettingReqsList = $updateSettingReqsList;
                }

                public void onResponse(@NotNull AcknowledgedResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (!response2.isAcknowledged()) {
                        RemovePolicyHandler.access$getActionListener$p(this.this$0).onFailure((Exception)((Object)IndexManagementException.Companion.wrap(new Exception("Failed to remove policy because ISM auto_manage setting update requests are not fully acknowledged."))));
                        return;
                    }
                    if (this.$current < this.$updateSettingReqsList.size() - 1) {
                        this.this$0.updateSettingCallChain(this.$current + 1, this.$updateSettingReqsList);
                    } else {
                        this.this$0.removeManagedIndices();
                    }
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                    if (throwable == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    }
                    Exception ex = (Exception)throwable;
                    RemovePolicyHandler.access$getActionListener$p(this.this$0).onFailure((Exception)((Object)IndexManagementException.Companion.wrap(new Exception("Failed to remove policy because ISM auto_manage setting update requests failed with exception:", ex))));
                }
            });
        }

        public final void removeManagedIndices() {
            if (!this.indicesToRemove.isEmpty()) {
                BulkRequest bulkReq = new BulkRequest();
                Map<String, String> $this$forEach$iv = this.indicesToRemove;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> element$iv;
                    Map.Entry<String, String> it = element$iv = iterator.next();
                    boolean bl = false;
                    bulkReq.add(ManagedIndexUtils.deleteManagedIndexRequest(it.getKey()));
                }
                this.client.bulk(bulkReq, (ActionListener)new ActionListener<BulkResponse>(this, TransportRemovePolicyAction.this){
                    final /* synthetic */ RemovePolicyHandler this$0;
                    final /* synthetic */ TransportRemovePolicyAction this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void onResponse(@NotNull BulkResponse response2) {
                        void $this$mapTo$iv$iv;
                        void $this$forEach$iv;
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        Iterable iterable = (Iterable)response2;
                        RemovePolicyHandler removePolicyHandler = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            BulkItemResponse it = (BulkItemResponse)element$iv;
                            boolean bl = false;
                            String docId2 = it.getId();
                            if (!it.isFailed()) continue;
                            List list = RemovePolicyHandler.access$getFailedIndices$p(removePolicyHandler);
                            V v = RemovePolicyHandler.access$getIndicesToRemove$p(removePolicyHandler).get(docId2);
                            if (v == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                            }
                            String string = (String)v;
                            Intrinsics.checkNotNullExpressionValue((Object)docId2, (String)"docId");
                            list.add(new FailedIndex(string, docId2, "Failed to remove policy"));
                            RemovePolicyHandler.access$getIndicesToRemove$p(removePolicyHandler).remove(docId2);
                        }
                        Map $this$map$iv = RemovePolicyHandler.access$getIndicesToRemove$p(this.this$0);
                        boolean $i$f$map = false;
                        Map map = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                        boolean $i$f$mapTo = false;
                        Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void it;
                            Map.Entry<K, V> item$iv$iv;
                            Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(new Index((String)it.getValue(), (String)it.getKey()));
                        }
                        List indicesToRemoveMetadata = (List)destination$iv$iv;
                        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.this$1, (List<? extends Index>)indicesToRemoveMetadata, null){
                            int label;
                            final /* synthetic */ RemovePolicyHandler this$0;
                            final /* synthetic */ TransportRemovePolicyAction this$1;
                            final /* synthetic */ List<Index> $indicesToRemoveMetadata;
                            {
                                this.this$0 = $receiver;
                                this.this$1 = $receiver2;
                                this.$indicesToRemoveMetadata = $indicesToRemoveMetadata;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        Client client = (Client)RemovePolicyHandler.access$getClient$p(this.this$0);
                                        Logger logger = TransportRemovePolicyAction.access$getLog$p(this.this$1);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
                                        this.label = 1;
                                        Object object3 = RestHandlerUtilsKt.removeClusterStateMetadatas(client, logger, this.$indicesToRemoveMetadata, (Continuation<? super Unit>)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        this.this$0.removeMetadatas(indicesToRemoveMetadata);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        if (t instanceof ClusterBlockException) {
                            void $this$forEach$iv;
                            Map map = RemovePolicyHandler.access$getIndicesToRemove$p(this.this$0);
                            RemovePolicyHandler removePolicyHandler = this.this$0;
                            boolean $i$f$forEach = false;
                            Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry<K, V> element$iv;
                                Map.Entry<K, V> $dstr$uuid$name = element$iv = iterator.next();
                                boolean bl = false;
                                String uuid = (String)$dstr$uuid$name.getKey();
                                String name = (String)$dstr$uuid$name.getValue();
                                RemovePolicyHandler.access$getFailedIndices$p(removePolicyHandler).add(new FailedIndex(name, uuid, "Failed to remove policy due to ClusterBlockingException: " + t.getMessage()));
                            }
                            RemovePolicyHandler.access$getActionListener$p(this.this$0).onResponse((Object)((Object)new ISMStatusResponse(0, RemovePolicyHandler.access$getFailedIndices$p(this.this$0))));
                        } else {
                            Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                            if (throwable == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                            }
                            RemovePolicyHandler.access$getActionListener$p(this.this$0).onFailure((Exception)throwable);
                        }
                    }
                });
            } else {
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void removeMetadatas(@NotNull List<? extends Index> indices) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(indices, (String)"indices");
            Iterable $this$map$iv = indices;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Index index2 = (Index)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.uuid");
                collection.add(ManagedIndexUtils.deleteManagedIndexMetadataRequest(string));
            }
            List request = (List)destination$iv$iv;
            BulkRequest bulkReq = new BulkRequest().add((Iterable)request);
            this.client.bulk(bulkReq, (ActionListener)new ActionListener<BulkResponse>(this){
                final /* synthetic */ RemovePolicyHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onResponse(@NotNull BulkResponse response2) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    Iterable iterable = (Iterable)response2;
                    RemovePolicyHandler removePolicyHandler = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        BulkItemResponse it = (BulkItemResponse)element$iv;
                        boolean bl = false;
                        String docId2 = it.getId();
                        if (!it.isFailed()) continue;
                        List list = RemovePolicyHandler.access$getFailedIndices$p(removePolicyHandler);
                        V v = RemovePolicyHandler.access$getIndicesToRemove$p(removePolicyHandler).get(docId2);
                        if (v == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        String string = (String)v;
                        Intrinsics.checkNotNullExpressionValue((Object)docId2, (String)"docId");
                        list.add(new FailedIndex(string, docId2, "Failed to clean metadata due to: " + it.getFailureMessage()));
                        RemovePolicyHandler.access$getIndicesToRemove$p(removePolicyHandler).remove(docId2);
                    }
                    RemovePolicyHandler.access$getActionListener$p(this.this$0).onResponse((Object)((Object)new ISMStatusResponse(RemovePolicyHandler.access$getIndicesToRemove$p(this.this$0).size(), RemovePolicyHandler.access$getFailedIndices$p(this.this$0))));
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    RemovePolicyHandler.access$getActionListener$p(this.this$0).onFailure((Exception)((Object)IndexManagementException.Companion.wrap(new Exception("Failed to clean metadata for remove policy indices.", e))));
                }
            });
        }

        public static final /* synthetic */ void access$getIndicesToRemove(RemovePolicyHandler $this) {
            $this.getIndicesToRemove();
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(RemovePolicyHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ RemovePolicyRequest access$getRequest$p(RemovePolicyHandler $this) {
            return $this.request;
        }

        public static final /* synthetic */ void access$getClusterState(RemovePolicyHandler $this) {
            $this.getClusterState();
        }

        public static final /* synthetic */ void access$getExistingManagedIndices(RemovePolicyHandler $this) {
            $this.getExistingManagedIndices();
        }

        public static final /* synthetic */ Map access$getIndicesToRemove$p(RemovePolicyHandler $this) {
            return $this.indicesToRemove;
        }

        public static final /* synthetic */ List access$getFailedIndices$p(RemovePolicyHandler $this) {
            return $this.failedIndices;
        }

        public static final /* synthetic */ NodeClient access$getClient$p(RemovePolicyHandler $this) {
            return $this.client;
        }

        public static final /* synthetic */ Set access$getIndicesWithAutoManageFalseBlock$p(RemovePolicyHandler $this) {
            return $this.indicesWithAutoManageFalseBlock;
        }

        public static final /* synthetic */ Set access$getIndicesWithReadOnlyBlock$p(RemovePolicyHandler $this) {
            return $this.indicesWithReadOnlyBlock;
        }

        public static final /* synthetic */ Set access$getIndicesWithReadOnlyAllowDeleteBlock$p(RemovePolicyHandler $this) {
            return $this.indicesWithReadOnlyAllowDeleteBlock;
        }
    }
}

