/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input.parameter.ad;

import java.io.IOException;
import java.util.Locale;
import lombok.Generated;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.annotation.MLAlgoParameter;
import org.opensearch.ml.common.input.parameter.MLAlgoParams;

@MLAlgoParameter(algorithms={FunctionName.AD_LIBSVM})
public class AnomalyDetectionLibSVMParams
implements MLAlgoParams {
    public static final String PARSE_FIELD_NAME = FunctionName.AD_LIBSVM.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(MLAlgoParams.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> AnomalyDetectionLibSVMParams.parse(it));
    public static final String KERNEL_FIELD = "kernel";
    public static final String GAMMA_FIELD = "gamma";
    public static final String NU_FIELD = "nu";
    public static final String COST_FIELD = "cost";
    public static final String COEFF_FIELD = "coeff";
    public static final String EPSILON_FIELD = "epsilon";
    public static final String DEGREE_FIELD = "degree";
    private ADKernelType kernelType;
    private Double gamma;
    private Double nu;
    private Double cost;
    private Double coeff;
    private Double epsilon;
    private Integer degree;

    public AnomalyDetectionLibSVMParams(ADKernelType kernelType, Double gamma, Double nu, Double cost, Double coeff, Double epsilon, Integer degree) {
        this.kernelType = kernelType;
        this.gamma = gamma;
        this.nu = nu;
        this.cost = cost;
        this.coeff = coeff;
        this.epsilon = epsilon;
        this.degree = degree;
    }

    public AnomalyDetectionLibSVMParams(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.kernelType = (ADKernelType)in.readEnum(ADKernelType.class);
        }
        this.gamma = in.readOptionalDouble();
        this.nu = in.readOptionalDouble();
        this.cost = in.readOptionalDouble();
        this.coeff = in.readOptionalDouble();
        this.epsilon = in.readOptionalDouble();
        this.degree = in.readOptionalInt();
    }

    public static MLAlgoParams parse(XContentParser parser) throws IOException {
        ADKernelType kernelType = null;
        Double gamma = null;
        Double nu = null;
        Double cost = null;
        Double coeff = null;
        Double epsilon = null;
        Integer degree = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "kernel": {
                    kernelType = ADKernelType.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block18;
                }
                case "gamma": {
                    gamma = parser.doubleValue(false);
                    continue block18;
                }
                case "nu": {
                    nu = parser.doubleValue(false);
                    continue block18;
                }
                case "cost": {
                    cost = parser.doubleValue(false);
                    continue block18;
                }
                case "coeff": {
                    coeff = parser.doubleValue(false);
                    continue block18;
                }
                case "epsilon": {
                    epsilon = parser.doubleValue(false);
                    continue block18;
                }
                case "degree": {
                    degree = parser.intValue(false);
                    continue block18;
                }
            }
            parser.skipChildren();
        }
        return new AnomalyDetectionLibSVMParams(kernelType, gamma, nu, cost, coeff, epsilon, degree);
    }

    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.kernelType == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.kernelType);
        }
        out.writeOptionalDouble(this.gamma);
        out.writeOptionalDouble(this.nu);
        out.writeOptionalDouble(this.cost);
        out.writeOptionalDouble(this.coeff);
        out.writeOptionalDouble(this.epsilon);
        out.writeOptionalInt(this.degree);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.kernelType != null) {
            builder.field(KERNEL_FIELD, (Object)this.kernelType);
        }
        if (this.gamma != null) {
            builder.field(GAMMA_FIELD, this.gamma);
        }
        if (this.nu != null) {
            builder.field(NU_FIELD, this.nu);
        }
        if (this.cost != null) {
            builder.field(COST_FIELD, this.cost);
        }
        if (this.coeff != null) {
            builder.field(COEFF_FIELD, this.coeff);
        }
        if (this.epsilon != null) {
            builder.field(EPSILON_FIELD, this.epsilon);
        }
        if (this.degree != null) {
            builder.field(DEGREE_FIELD, this.degree);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Generated
    public static AnomalyDetectionLibSVMParamsBuilder builder() {
        return new AnomalyDetectionLibSVMParamsBuilder();
    }

    @Generated
    public AnomalyDetectionLibSVMParamsBuilder toBuilder() {
        return new AnomalyDetectionLibSVMParamsBuilder().kernelType(this.kernelType).gamma(this.gamma).nu(this.nu).cost(this.cost).coeff(this.coeff).epsilon(this.epsilon).degree(this.degree);
    }

    @Generated
    public ADKernelType getKernelType() {
        return this.kernelType;
    }

    @Generated
    public Double getGamma() {
        return this.gamma;
    }

    @Generated
    public Double getNu() {
        return this.nu;
    }

    @Generated
    public Double getCost() {
        return this.cost;
    }

    @Generated
    public Double getCoeff() {
        return this.coeff;
    }

    @Generated
    public Double getEpsilon() {
        return this.epsilon;
    }

    @Generated
    public Integer getDegree() {
        return this.degree;
    }

    @Generated
    public void setKernelType(ADKernelType kernelType) {
        this.kernelType = kernelType;
    }

    @Generated
    public void setGamma(Double gamma) {
        this.gamma = gamma;
    }

    @Generated
    public void setNu(Double nu) {
        this.nu = nu;
    }

    @Generated
    public void setCost(Double cost) {
        this.cost = cost;
    }

    @Generated
    public void setCoeff(Double coeff) {
        this.coeff = coeff;
    }

    @Generated
    public void setEpsilon(Double epsilon) {
        this.epsilon = epsilon;
    }

    @Generated
    public void setDegree(Integer degree) {
        this.degree = degree;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnomalyDetectionLibSVMParams)) {
            return false;
        }
        AnomalyDetectionLibSVMParams other = (AnomalyDetectionLibSVMParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$gamma = this.getGamma();
        Double other$gamma = other.getGamma();
        if (this$gamma == null ? other$gamma != null : !((Object)this$gamma).equals(other$gamma)) {
            return false;
        }
        Double this$nu = this.getNu();
        Double other$nu = other.getNu();
        if (this$nu == null ? other$nu != null : !((Object)this$nu).equals(other$nu)) {
            return false;
        }
        Double this$cost = this.getCost();
        Double other$cost = other.getCost();
        if (this$cost == null ? other$cost != null : !((Object)this$cost).equals(other$cost)) {
            return false;
        }
        Double this$coeff = this.getCoeff();
        Double other$coeff = other.getCoeff();
        if (this$coeff == null ? other$coeff != null : !((Object)this$coeff).equals(other$coeff)) {
            return false;
        }
        Double this$epsilon = this.getEpsilon();
        Double other$epsilon = other.getEpsilon();
        if (this$epsilon == null ? other$epsilon != null : !((Object)this$epsilon).equals(other$epsilon)) {
            return false;
        }
        Integer this$degree = this.getDegree();
        Integer other$degree = other.getDegree();
        if (this$degree == null ? other$degree != null : !((Object)this$degree).equals(other$degree)) {
            return false;
        }
        ADKernelType this$kernelType = this.getKernelType();
        ADKernelType other$kernelType = other.getKernelType();
        return !(this$kernelType == null ? other$kernelType != null : !((Object)((Object)this$kernelType)).equals((Object)other$kernelType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnomalyDetectionLibSVMParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $gamma = this.getGamma();
        result = result * 59 + ($gamma == null ? 43 : ((Object)$gamma).hashCode());
        Double $nu = this.getNu();
        result = result * 59 + ($nu == null ? 43 : ((Object)$nu).hashCode());
        Double $cost = this.getCost();
        result = result * 59 + ($cost == null ? 43 : ((Object)$cost).hashCode());
        Double $coeff = this.getCoeff();
        result = result * 59 + ($coeff == null ? 43 : ((Object)$coeff).hashCode());
        Double $epsilon = this.getEpsilon();
        result = result * 59 + ($epsilon == null ? 43 : ((Object)$epsilon).hashCode());
        Integer $degree = this.getDegree();
        result = result * 59 + ($degree == null ? 43 : ((Object)$degree).hashCode());
        ADKernelType $kernelType = this.getKernelType();
        result = result * 59 + ($kernelType == null ? 43 : ((Object)((Object)$kernelType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AnomalyDetectionLibSVMParams(kernelType=" + this.getKernelType() + ", gamma=" + this.getGamma() + ", nu=" + this.getNu() + ", cost=" + this.getCost() + ", coeff=" + this.getCoeff() + ", epsilon=" + this.getEpsilon() + ", degree=" + this.getDegree() + ")";
    }

    public static enum ADKernelType {
        LINEAR,
        POLY,
        RBF,
        SIGMOID;


        public static ADKernelType from(String value) {
            try {
                return ADKernelType.valueOf(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Wrong AD kernel type");
            }
        }
    }

    @Generated
    public static class AnomalyDetectionLibSVMParamsBuilder {
        @Generated
        private ADKernelType kernelType;
        @Generated
        private Double gamma;
        @Generated
        private Double nu;
        @Generated
        private Double cost;
        @Generated
        private Double coeff;
        @Generated
        private Double epsilon;
        @Generated
        private Integer degree;

        @Generated
        AnomalyDetectionLibSVMParamsBuilder() {
        }

        @Generated
        public AnomalyDetectionLibSVMParamsBuilder kernelType(ADKernelType kernelType) {
            this.kernelType = kernelType;
            return this;
        }

        @Generated
        public AnomalyDetectionLibSVMParamsBuilder gamma(Double gamma) {
            this.gamma = gamma;
            return this;
        }

        @Generated
        public AnomalyDetectionLibSVMParamsBuilder nu(Double nu) {
            this.nu = nu;
            return this;
        }

        @Generated
        public AnomalyDetectionLibSVMParamsBuilder cost(Double cost) {
            this.cost = cost;
            return this;
        }

        @Generated
        public AnomalyDetectionLibSVMParamsBuilder coeff(Double coeff) {
            this.coeff = coeff;
            return this;
        }

        @Generated
        public AnomalyDetectionLibSVMParamsBuilder epsilon(Double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        @Generated
        public AnomalyDetectionLibSVMParamsBuilder degree(Integer degree) {
            this.degree = degree;
            return this;
        }

        @Generated
        public AnomalyDetectionLibSVMParams build() {
            return new AnomalyDetectionLibSVMParams(this.kernelType, this.gamma, this.nu, this.cost, this.coeff, this.epsilon, this.degree);
        }

        @Generated
        public String toString() {
            return "AnomalyDetectionLibSVMParams.AnomalyDetectionLibSVMParamsBuilder(kernelType=" + this.kernelType + ", gamma=" + this.gamma + ", nu=" + this.nu + ", cost=" + this.cost + ", coeff=" + this.coeff + ", epsilon=" + this.epsilon + ", degree=" + this.degree + ")";
        }
    }
}

