# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
BRepLib module, see official documentation at
https://www.opencascade.com/doc/occt-7.6.0/refman/html/package_breplib.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _BRepLib
else:
    import _BRepLib

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BRepLib.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _BRepLib.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _BRepLib.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _BRepLib.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _BRepLib.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _BRepLib.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _BRepLib.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _BRepLib.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _BRepLib.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _BRepLib.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _BRepLib.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _BRepLib.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _BRepLib.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _BRepLib.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _BRepLib.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _BRepLib.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _BRepLib.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _BRepLib:
_BRepLib.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _BRepLib.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.GeomAbs
import OCC.Core.Geom2d
import OCC.Core.TColgp
import OCC.Core.TopTools
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.Adaptor2d
import OCC.Core.math
import OCC.Core.BRepTools
import OCC.Core.Bnd
import OCC.Core.BVH
import OCC.Core.BRep
import OCC.Core.Poly
import OCC.Core.TShort

from enum import IntEnum
from OCC.Core.Exception import *

BRepLib_EdgeDone = _BRepLib.BRepLib_EdgeDone
BRepLib_PointProjectionFailed = _BRepLib.BRepLib_PointProjectionFailed
BRepLib_ParameterOutOfRange = _BRepLib.BRepLib_ParameterOutOfRange
BRepLib_DifferentPointsOnClosedCurve = _BRepLib.BRepLib_DifferentPointsOnClosedCurve
BRepLib_PointWithInfiniteParameter = _BRepLib.BRepLib_PointWithInfiniteParameter
BRepLib_DifferentsPointAndParameter = _BRepLib.BRepLib_DifferentsPointAndParameter
BRepLib_LineThroughIdenticPoints = _BRepLib.BRepLib_LineThroughIdenticPoints
BRepLib_ShellDone = _BRepLib.BRepLib_ShellDone
BRepLib_EmptyShell = _BRepLib.BRepLib_EmptyShell
BRepLib_DisconnectedShell = _BRepLib.BRepLib_DisconnectedShell
BRepLib_ShellParametersOutOfRange = _BRepLib.BRepLib_ShellParametersOutOfRange
BRepLib_Preserved = _BRepLib.BRepLib_Preserved
BRepLib_Deleted = _BRepLib.BRepLib_Deleted
BRepLib_Trimmed = _BRepLib.BRepLib_Trimmed
BRepLib_Merged = _BRepLib.BRepLib_Merged
BRepLib_BoundaryModified = _BRepLib.BRepLib_BoundaryModified
BRepLib_WireDone = _BRepLib.BRepLib_WireDone
BRepLib_EmptyWire = _BRepLib.BRepLib_EmptyWire
BRepLib_DisconnectedWire = _BRepLib.BRepLib_DisconnectedWire
BRepLib_NonManifoldWire = _BRepLib.BRepLib_NonManifoldWire
BRepLib_FaceDone = _BRepLib.BRepLib_FaceDone
BRepLib_NoFace = _BRepLib.BRepLib_NoFace
BRepLib_NotPlanar = _BRepLib.BRepLib_NotPlanar
BRepLib_CurveProjectionFailed = _BRepLib.BRepLib_CurveProjectionFailed
BRepLib_ParametersOutOfRange = _BRepLib.BRepLib_ParametersOutOfRange


class BRepLib_EdgeError(IntEnum):
	BRepLib_EdgeDone = 0
	BRepLib_PointProjectionFailed = 1
	BRepLib_ParameterOutOfRange = 2
	BRepLib_DifferentPointsOnClosedCurve = 3
	BRepLib_PointWithInfiniteParameter = 4
	BRepLib_DifferentsPointAndParameter = 5
	BRepLib_LineThroughIdenticPoints = 6
BRepLib_EdgeDone = BRepLib_EdgeError.BRepLib_EdgeDone
BRepLib_PointProjectionFailed = BRepLib_EdgeError.BRepLib_PointProjectionFailed
BRepLib_ParameterOutOfRange = BRepLib_EdgeError.BRepLib_ParameterOutOfRange
BRepLib_DifferentPointsOnClosedCurve = BRepLib_EdgeError.BRepLib_DifferentPointsOnClosedCurve
BRepLib_PointWithInfiniteParameter = BRepLib_EdgeError.BRepLib_PointWithInfiniteParameter
BRepLib_DifferentsPointAndParameter = BRepLib_EdgeError.BRepLib_DifferentsPointAndParameter
BRepLib_LineThroughIdenticPoints = BRepLib_EdgeError.BRepLib_LineThroughIdenticPoints

class BRepLib_ShellError(IntEnum):
	BRepLib_ShellDone = 0
	BRepLib_EmptyShell = 1
	BRepLib_DisconnectedShell = 2
	BRepLib_ShellParametersOutOfRange = 3
BRepLib_ShellDone = BRepLib_ShellError.BRepLib_ShellDone
BRepLib_EmptyShell = BRepLib_ShellError.BRepLib_EmptyShell
BRepLib_DisconnectedShell = BRepLib_ShellError.BRepLib_DisconnectedShell
BRepLib_ShellParametersOutOfRange = BRepLib_ShellError.BRepLib_ShellParametersOutOfRange

class BRepLib_ShapeModification(IntEnum):
	BRepLib_Preserved = 0
	BRepLib_Deleted = 1
	BRepLib_Trimmed = 2
	BRepLib_Merged = 3
	BRepLib_BoundaryModified = 4
BRepLib_Preserved = BRepLib_ShapeModification.BRepLib_Preserved
BRepLib_Deleted = BRepLib_ShapeModification.BRepLib_Deleted
BRepLib_Trimmed = BRepLib_ShapeModification.BRepLib_Trimmed
BRepLib_Merged = BRepLib_ShapeModification.BRepLib_Merged
BRepLib_BoundaryModified = BRepLib_ShapeModification.BRepLib_BoundaryModified

class BRepLib_WireError(IntEnum):
	BRepLib_WireDone = 0
	BRepLib_EmptyWire = 1
	BRepLib_DisconnectedWire = 2
	BRepLib_NonManifoldWire = 3
BRepLib_WireDone = BRepLib_WireError.BRepLib_WireDone
BRepLib_EmptyWire = BRepLib_WireError.BRepLib_EmptyWire
BRepLib_DisconnectedWire = BRepLib_WireError.BRepLib_DisconnectedWire
BRepLib_NonManifoldWire = BRepLib_WireError.BRepLib_NonManifoldWire

class BRepLib_FaceError(IntEnum):
	BRepLib_FaceDone = 0
	BRepLib_NoFace = 1
	BRepLib_NotPlanar = 2
	BRepLib_CurveProjectionFailed = 3
	BRepLib_ParametersOutOfRange = 4
BRepLib_FaceDone = BRepLib_FaceError.BRepLib_FaceDone
BRepLib_NoFace = BRepLib_FaceError.BRepLib_NoFace
BRepLib_NotPlanar = BRepLib_FaceError.BRepLib_NotPlanar
BRepLib_CurveProjectionFailed = BRepLib_FaceError.BRepLib_CurveProjectionFailed
BRepLib_ParametersOutOfRange = BRepLib_FaceError.BRepLib_ParametersOutOfRange

class breplib(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def BoundingVertex(*args) -> "Standard_Real &":
        r"""
        Calculates the bounding sphere around the set of vertexes from the thelv list. returns the center (thenewcenter) and the radius (thenewtol) of this sphere. this can be used to construct the new vertex which covers the given set of other vertices.

        Parameters
        ----------
        theLV: NCollection_List<TopoDS_Shape>
        theNewCenter: gp_Pnt

        Returns
        -------
        theNewTol: float

        """
        return _BRepLib.breplib_BoundingVertex(*args)

    @staticmethod
    def BuildCurve3d(*args) -> "Standard_Boolean":
        r"""
        Computes the 3d curve for the edge <e> if it does not exist. returns true if the curve was computed or existed. returns false if there is no planar pcurve or the computation failed. <maxsegment> >= 30 in approximation.

        Parameters
        ----------
        E: TopoDS_Edge
        Tolerance: float,optional
        	default value is 1.0e-5
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C1
        MaxDegree: int,optional
        	default value is 14
        MaxSegment: int,optional
        	default value is 0

        Returns
        -------
        bool

        """
        return _BRepLib.breplib_BuildCurve3d(*args)

    @staticmethod
    def BuildCurves3d(*args) -> "Standard_Boolean":
        r"""
        Computes the 3d curves for all the edges of <s> return false if one of the computation failed. <maxsegment> >= 30 in approximation.

        Parameters
        ----------
        S: TopoDS_Shape
        Tolerance: float
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C1
        MaxDegree: int,optional
        	default value is 14
        MaxSegment: int,optional
        	default value is 0

        Returns
        -------
        bool
        Computes the 3d curves for all the edges of <s> return false if one of the computation failed.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        bool

        """
        return _BRepLib.breplib_BuildCurves3d(*args)

    @staticmethod
    def BuildPCurveForEdgeOnPlane(*args) -> "Standard_Boolean &":
        r"""
        Builds pcurve of edge on face if the surface is plane, and updates the edge.

        Parameters
        ----------
        theE: TopoDS_Edge
        theF: TopoDS_Face

        Returns
        -------
        None
        Builds pcurve of edge on face if the surface is plane, but does not update the edge. the output are the pcurve and the flag telling that pcurve was built.

        Parameters
        ----------
        theE: TopoDS_Edge
        theF: TopoDS_Face
        aC2D: Geom2d_Curve

        Returns
        -------
        bToUpdate: bool

        """
        return _BRepLib.breplib_BuildPCurveForEdgeOnPlane(*args)

    @staticmethod
    def CheckSameRange(*args) -> "Standard_Boolean":
        r"""
        Checks if the edge is same range ignoring the same range flag of the edge confusion argument is to compare real numbers idenpendently of any model space tolerance.

        Parameters
        ----------
        E: TopoDS_Edge
        Confusion: float,optional
        	default value is 1.0e-12

        Returns
        -------
        bool

        """
        return _BRepLib.breplib_CheckSameRange(*args)

    @staticmethod
    def ContinuityOfFaces(*args) -> "GeomAbs_Shape":
        r"""
        Returns the order of continuity between two faces connected by an edge.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theFace1: TopoDS_Face
        theFace2: TopoDS_Face
        theAngleTol: float

        Returns
        -------
        GeomAbs_Shape

        """
        return _BRepLib.breplib_ContinuityOfFaces(*args)

    @staticmethod
    def EncodeRegularity(*args) -> "void":
        r"""
        Encodes the regularity of edges on a shape. warning: <tolang> is an angular tolerance, expressed in rad. warning: if the edges's regularity are coded before, nothing is done.

        Parameters
        ----------
        S: TopoDS_Shape
        TolAng: float,optional
        	default value is 1.0e-10

        Returns
        -------
        None
        Encodes the regularity of edges in list <le> on the shape <s> warning: <tolang> is an angular tolerance, expressed in rad. warning: if the edges's regularity are coded before, nothing is done.

        Parameters
        ----------
        S: TopoDS_Shape
        LE: TopTools_ListOfShape
        TolAng: float,optional
        	default value is 1.0e-10

        Returns
        -------
        None
        Encodes the regularity between <f1> and <f2> by <e> warning: <tolang> is an angular tolerance, expressed in rad. warning: if the edge's regularity is coded before, nothing is done.

        Parameters
        ----------
        E: TopoDS_Edge
        F1: TopoDS_Face
        F2: TopoDS_Face
        TolAng: float,optional
        	default value is 1.0e-10

        Returns
        -------
        None

        """
        return _BRepLib.breplib_EncodeRegularity(*args)

    @staticmethod
    def EnsureNormalConsistency(*args) -> "Standard_Boolean":
        r"""
        Corrects the normals in poly_triangulation of faces, in such way that normals at nodes lying along smooth edges have the same value on both adjacent triangulations. returns true if any correction is done.

        Parameters
        ----------
        S: TopoDS_Shape
        theAngTol: float,optional
        	default value is 0.001
        ForceComputeNormals: bool,optional
        	default value is Standard_False

        Returns
        -------
        bool

        """
        return _BRepLib.breplib_EnsureNormalConsistency(*args)

    @staticmethod
    def ExtendFace(*args) -> "void":
        r"""
        Enlarges the face on the given value. @param thef [in] the face to extend @param theextval [in] the extension value @param theextumin [in] defines whether to extend the face in umin direction @param theextumax [in] defines whether to extend the face in umax direction @param theextvmin [in] defines whether to extend the face in vmin direction @param theextvmax [in] defines whether to extend the face in vmax direction @param thefextended [in] the extended face.

        Parameters
        ----------
        theF: TopoDS_Face
        theExtVal: float
        theExtUMin: bool
        theExtUMax: bool
        theExtVMin: bool
        theExtVMax: bool
        theFExtended: TopoDS_Face

        Returns
        -------
        None

        """
        return _BRepLib.breplib_ExtendFace(*args)

    @staticmethod
    def FindValidRange(*args) -> "Standard_Real &, Standard_Real &":
        r"""
        For an edge defined by 3d curve and tolerance and vertices defined by points, parameters on curve and tolerances, finds a range of curve between vertices not covered by vertices tolerances. returns false if there is no such range. otherwise, sets thefirst and thelast as its bounds.

        Parameters
        ----------
        theCurve: Adaptor3d_Curve
        theTolE: float
        theParV1: float
        thePntV1: gp_Pnt
        theTolV1: float
        theParV2: float
        thePntV2: gp_Pnt
        theTolV2: float

        Returns
        -------
        theFirst: float
        theLast: float
        Finds a range of 3d curve of the edge not covered by vertices tolerances. returns false if there is no such range. otherwise, sets thefirst and thelast as its bounds.

        Parameters
        ----------
        theEdge: TopoDS_Edge

        Returns
        -------
        theFirst: float
        theLast: float

        """
        return _BRepLib.breplib_FindValidRange(*args)

    @staticmethod
    def OrientClosedSolid(*args) -> "Standard_Boolean":
        r"""
        Orients the solid forward and the shell with the orientation to have matter in the solid. returns false if the solid is unorientable (open or incoherent).

        Parameters
        ----------
        solid: TopoDS_Solid

        Returns
        -------
        bool

        """
        return _BRepLib.breplib_OrientClosedSolid(*args)

    @staticmethod
    def Plane(*args) -> "opencascade::handle< Geom_Plane > const &":
        r"""
        Sets the current plane to p.

        Parameters
        ----------
        P: Geom_Plane

        Returns
        -------
        None
        Returns the current plane.

        Returns
        -------
        opencascade::handle<Geom_Plane>

        """
        return _BRepLib.breplib_Plane(*args)

    @staticmethod
    def Precision(*args) -> "Standard_Real":
        r"""
        Computes the max distance between edge and its 2d representation on the face. sets the default precision. the current precision is returned.

        Parameters
        ----------
        P: float

        Returns
        -------
        None
        Returns the default precision.

        Returns
        -------
        float

        """
        return _BRepLib.breplib_Precision(*args)

    @staticmethod
    def ReverseSortFaces(*args) -> "void":
        r"""
        Sorts in lf the faces of s on the reverse complexity of their surfaces (other,torus,sphere,cone,cylinder,plane).

        Parameters
        ----------
        S: TopoDS_Shape
        LF: TopTools_ListOfShape

        Returns
        -------
        None

        """
        return _BRepLib.breplib_ReverseSortFaces(*args)

    @staticmethod
    def SameParameter(*args) -> "void":
        r"""
        Computes new 2d curve(s) for the edge <theedge> to have the same parameter as the 3d curve. the algorithm is not done if the flag sameparameter was true on the edge.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        Tolerance: float,optional
        	default value is 1.0e-5

        Returns
        -------
        None
        Computes new 2d curve(s) for the edge <theedge> to have the same parameter as the 3d curve. the algorithm is not done if the flag sameparameter was true on the edge. thenewtol is a new tolerance of vertices of the input edge (not applied inside the algorithm, but pre-computed). if isuseoldedge is true then the input edge will be modified, otherwise the new copy of input edge will be created. returns the new edge as a result, can be ignored if isuseoldedge is true.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theTolerance: float
        IsUseOldEdge: bool

        Returns
        -------
        theNewTol: float
        Computes new 2d curve(s) for all the edges of <s> to have the same parameter as the 3d curve. the algorithm is not done if the flag sameparameter was true on an edge.

        Parameters
        ----------
        S: TopoDS_Shape
        Tolerance: float,optional
        	default value is 1.0e-5
        forced: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        Computes new 2d curve(s) for all the edges of <s> to have the same parameter as the 3d curve. the algorithm is not done if the flag sameparameter was true on an edge. thereshaper is used to record the modifications of input shape <s> to prevent any modifications on the shape itself. thus the input shape (and its subshapes) will not be modified, instead the reshaper will contain a modified empty-copies of original subshapes as substitutions.

        Parameters
        ----------
        S: TopoDS_Shape
        theReshaper: BRepTools_ReShape
        Tolerance: float,optional
        	default value is 1.0e-5
        forced: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _BRepLib.breplib_SameParameter(*args)

    @staticmethod
    def SameRange(*args) -> "void":
        r"""
        Will make all the curve representation have the same range domain for the parameters. this will ignore the same range flag value to proceed. if there is a 3d curve there it will the range of that curve. if not the first curve representation encountered in the list will give its range to the all the other curves.

        Parameters
        ----------
        E: TopoDS_Edge
        Tolerance: float,optional
        	default value is 1.0e-5

        Returns
        -------
        None

        """
        return _BRepLib.breplib_SameRange(*args)

    @staticmethod
    def SortFaces(*args) -> "void":
        r"""
        Sorts in lf the faces of s on the complexity of their surfaces (plane,cylinder,cone,sphere,torus,other).

        Parameters
        ----------
        S: TopoDS_Shape
        LF: TopTools_ListOfShape

        Returns
        -------
        None

        """
        return _BRepLib.breplib_SortFaces(*args)

    @staticmethod
    def UpdateDeflection(*args) -> "void":
        r"""
        Updates value of deflection in poly_triangulation of faces by the maximum deviation measured on existing triangulation.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BRepLib.breplib_UpdateDeflection(*args)

    @staticmethod
    def UpdateEdgeTol(*args) -> "Standard_Boolean":
        r"""
        Checks if the edge has a tolerance smaller than -- -- -- -- maxtolerancetocheck if so it will compute the radius of -- the cylindrical pipe surface that mintolerancerequest is the minimum tolerance before it is useful to start testing. usually it should be around 10e-5 contains all -- the curve representation of the edge returns true if the edge tolerance had to be updated.

        Parameters
        ----------
        E: TopoDS_Edge
        MinToleranceRequest: float
        MaxToleranceToCheck: float

        Returns
        -------
        bool

        """
        return _BRepLib.breplib_UpdateEdgeTol(*args)

    @staticmethod
    def UpdateEdgeTolerance(*args) -> "Standard_Boolean":
        r"""
        -- checks all the edges of the shape whose -- -- -- tolerance is smaller than maxtolerancetocheck -- returns true if at least one edge was updated -- mintolerancerequest is the minimum tolerance before -- it -- is useful to start testing. usually it should be around -- 10e-5-- //! warning :the method is very slow as it checks all. use only in interfaces or processing assimilate batch.

        Parameters
        ----------
        S: TopoDS_Shape
        MinToleranceRequest: float
        MaxToleranceToCheck: float

        Returns
        -------
        bool

        """
        return _BRepLib.breplib_UpdateEdgeTolerance(*args)

    @staticmethod
    def UpdateInnerTolerances(*args) -> "void":
        r"""
        Checks tolerances of edges (including inner points) and vertices of a shape and updates them to satisfy 'sameparameter' condition.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BRepLib.breplib_UpdateInnerTolerances(*args)

    @staticmethod
    def UpdateTolerances(*args) -> "void":
        r"""
        Replaces tolerance of face edge vertex by the tolerance max of their connected handling shapes. it is not necessary to use this call after sameparameter. (called in).

        Parameters
        ----------
        S: TopoDS_Shape
        verifyFaceTolerance: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        Replaces tolerance of face edge vertex by the tolerance max of their connected handling shapes. it is not necessary to use this call after sameparameter. (called in) thereshaper is used to record the modifications of input shape <s> to prevent any modifications on the shape itself. thus the input shape (and its subshapes) will not be modified, instead the reshaper will contain a modified empty-copies of original subshapes as substitutions.

        Parameters
        ----------
        S: TopoDS_Shape
        theReshaper: BRepTools_ReShape
        verifyFaceTolerance: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _BRepLib.breplib_UpdateTolerances(*args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def BuildPCurveForEdgesOnPlane(self):
    	pass


    def __init__(self):
        _BRepLib.breplib_swiginit(self, _BRepLib.new_breplib())
    __swig_destroy__ = _BRepLib.delete_breplib

# Register breplib in _BRepLib:
_BRepLib.breplib_swigregister(breplib)

def breplib_BoundingVertex(*args) -> "Standard_Real &":
    r"""
    Calculates the bounding sphere around the set of vertexes from the thelv list. returns the center (thenewcenter) and the radius (thenewtol) of this sphere. this can be used to construct the new vertex which covers the given set of other vertices.

    Parameters
    ----------
    theLV: NCollection_List<TopoDS_Shape>
    theNewCenter: gp_Pnt

    Returns
    -------
    theNewTol: float

    """
    return _BRepLib.breplib_BoundingVertex(*args)

def breplib_BuildCurve3d(*args) -> "Standard_Boolean":
    r"""
    Computes the 3d curve for the edge <e> if it does not exist. returns true if the curve was computed or existed. returns false if there is no planar pcurve or the computation failed. <maxsegment> >= 30 in approximation.

    Parameters
    ----------
    E: TopoDS_Edge
    Tolerance: float,optional
    	default value is 1.0e-5
    Continuity: GeomAbs_Shape,optional
    	default value is GeomAbs_C1
    MaxDegree: int,optional
    	default value is 14
    MaxSegment: int,optional
    	default value is 0

    Returns
    -------
    bool

    """
    return _BRepLib.breplib_BuildCurve3d(*args)

def breplib_BuildCurves3d(*args) -> "Standard_Boolean":
    r"""
    Computes the 3d curves for all the edges of <s> return false if one of the computation failed. <maxsegment> >= 30 in approximation.

    Parameters
    ----------
    S: TopoDS_Shape
    Tolerance: float
    Continuity: GeomAbs_Shape,optional
    	default value is GeomAbs_C1
    MaxDegree: int,optional
    	default value is 14
    MaxSegment: int,optional
    	default value is 0

    Returns
    -------
    bool
    Computes the 3d curves for all the edges of <s> return false if one of the computation failed.

    Parameters
    ----------
    S: TopoDS_Shape

    Returns
    -------
    bool

    """
    return _BRepLib.breplib_BuildCurves3d(*args)

def breplib_BuildPCurveForEdgeOnPlane(*args) -> "Standard_Boolean &":
    r"""
    Builds pcurve of edge on face if the surface is plane, and updates the edge.

    Parameters
    ----------
    theE: TopoDS_Edge
    theF: TopoDS_Face

    Returns
    -------
    None
    Builds pcurve of edge on face if the surface is plane, but does not update the edge. the output are the pcurve and the flag telling that pcurve was built.

    Parameters
    ----------
    theE: TopoDS_Edge
    theF: TopoDS_Face
    aC2D: Geom2d_Curve

    Returns
    -------
    bToUpdate: bool

    """
    return _BRepLib.breplib_BuildPCurveForEdgeOnPlane(*args)

def breplib_CheckSameRange(*args) -> "Standard_Boolean":
    r"""
    Checks if the edge is same range ignoring the same range flag of the edge confusion argument is to compare real numbers idenpendently of any model space tolerance.

    Parameters
    ----------
    E: TopoDS_Edge
    Confusion: float,optional
    	default value is 1.0e-12

    Returns
    -------
    bool

    """
    return _BRepLib.breplib_CheckSameRange(*args)

def breplib_ContinuityOfFaces(*args) -> "GeomAbs_Shape":
    r"""
    Returns the order of continuity between two faces connected by an edge.

    Parameters
    ----------
    theEdge: TopoDS_Edge
    theFace1: TopoDS_Face
    theFace2: TopoDS_Face
    theAngleTol: float

    Returns
    -------
    GeomAbs_Shape

    """
    return _BRepLib.breplib_ContinuityOfFaces(*args)

def breplib_EncodeRegularity(*args) -> "void":
    r"""
    Encodes the regularity of edges on a shape. warning: <tolang> is an angular tolerance, expressed in rad. warning: if the edges's regularity are coded before, nothing is done.

    Parameters
    ----------
    S: TopoDS_Shape
    TolAng: float,optional
    	default value is 1.0e-10

    Returns
    -------
    None
    Encodes the regularity of edges in list <le> on the shape <s> warning: <tolang> is an angular tolerance, expressed in rad. warning: if the edges's regularity are coded before, nothing is done.

    Parameters
    ----------
    S: TopoDS_Shape
    LE: TopTools_ListOfShape
    TolAng: float,optional
    	default value is 1.0e-10

    Returns
    -------
    None
    Encodes the regularity between <f1> and <f2> by <e> warning: <tolang> is an angular tolerance, expressed in rad. warning: if the edge's regularity is coded before, nothing is done.

    Parameters
    ----------
    E: TopoDS_Edge
    F1: TopoDS_Face
    F2: TopoDS_Face
    TolAng: float,optional
    	default value is 1.0e-10

    Returns
    -------
    None

    """
    return _BRepLib.breplib_EncodeRegularity(*args)

def breplib_EnsureNormalConsistency(*args) -> "Standard_Boolean":
    r"""
    Corrects the normals in poly_triangulation of faces, in such way that normals at nodes lying along smooth edges have the same value on both adjacent triangulations. returns true if any correction is done.

    Parameters
    ----------
    S: TopoDS_Shape
    theAngTol: float,optional
    	default value is 0.001
    ForceComputeNormals: bool,optional
    	default value is Standard_False

    Returns
    -------
    bool

    """
    return _BRepLib.breplib_EnsureNormalConsistency(*args)

def breplib_ExtendFace(*args) -> "void":
    r"""
    Enlarges the face on the given value. @param thef [in] the face to extend @param theextval [in] the extension value @param theextumin [in] defines whether to extend the face in umin direction @param theextumax [in] defines whether to extend the face in umax direction @param theextvmin [in] defines whether to extend the face in vmin direction @param theextvmax [in] defines whether to extend the face in vmax direction @param thefextended [in] the extended face.

    Parameters
    ----------
    theF: TopoDS_Face
    theExtVal: float
    theExtUMin: bool
    theExtUMax: bool
    theExtVMin: bool
    theExtVMax: bool
    theFExtended: TopoDS_Face

    Returns
    -------
    None

    """
    return _BRepLib.breplib_ExtendFace(*args)

def breplib_FindValidRange(*args) -> "Standard_Real &, Standard_Real &":
    r"""
    For an edge defined by 3d curve and tolerance and vertices defined by points, parameters on curve and tolerances, finds a range of curve between vertices not covered by vertices tolerances. returns false if there is no such range. otherwise, sets thefirst and thelast as its bounds.

    Parameters
    ----------
    theCurve: Adaptor3d_Curve
    theTolE: float
    theParV1: float
    thePntV1: gp_Pnt
    theTolV1: float
    theParV2: float
    thePntV2: gp_Pnt
    theTolV2: float

    Returns
    -------
    theFirst: float
    theLast: float
    Finds a range of 3d curve of the edge not covered by vertices tolerances. returns false if there is no such range. otherwise, sets thefirst and thelast as its bounds.

    Parameters
    ----------
    theEdge: TopoDS_Edge

    Returns
    -------
    theFirst: float
    theLast: float

    """
    return _BRepLib.breplib_FindValidRange(*args)

def breplib_OrientClosedSolid(*args) -> "Standard_Boolean":
    r"""
    Orients the solid forward and the shell with the orientation to have matter in the solid. returns false if the solid is unorientable (open or incoherent).

    Parameters
    ----------
    solid: TopoDS_Solid

    Returns
    -------
    bool

    """
    return _BRepLib.breplib_OrientClosedSolid(*args)

def breplib_Plane(*args) -> "opencascade::handle< Geom_Plane > const &":
    r"""
    Sets the current plane to p.

    Parameters
    ----------
    P: Geom_Plane

    Returns
    -------
    None
    Returns the current plane.

    Returns
    -------
    opencascade::handle<Geom_Plane>

    """
    return _BRepLib.breplib_Plane(*args)

def breplib_Precision(*args) -> "Standard_Real":
    r"""
    Computes the max distance between edge and its 2d representation on the face. sets the default precision. the current precision is returned.

    Parameters
    ----------
    P: float

    Returns
    -------
    None
    Returns the default precision.

    Returns
    -------
    float

    """
    return _BRepLib.breplib_Precision(*args)

def breplib_ReverseSortFaces(*args) -> "void":
    r"""
    Sorts in lf the faces of s on the reverse complexity of their surfaces (other,torus,sphere,cone,cylinder,plane).

    Parameters
    ----------
    S: TopoDS_Shape
    LF: TopTools_ListOfShape

    Returns
    -------
    None

    """
    return _BRepLib.breplib_ReverseSortFaces(*args)

def breplib_SameParameter(*args) -> "void":
    r"""
    Computes new 2d curve(s) for the edge <theedge> to have the same parameter as the 3d curve. the algorithm is not done if the flag sameparameter was true on the edge.

    Parameters
    ----------
    theEdge: TopoDS_Edge
    Tolerance: float,optional
    	default value is 1.0e-5

    Returns
    -------
    None
    Computes new 2d curve(s) for the edge <theedge> to have the same parameter as the 3d curve. the algorithm is not done if the flag sameparameter was true on the edge. thenewtol is a new tolerance of vertices of the input edge (not applied inside the algorithm, but pre-computed). if isuseoldedge is true then the input edge will be modified, otherwise the new copy of input edge will be created. returns the new edge as a result, can be ignored if isuseoldedge is true.

    Parameters
    ----------
    theEdge: TopoDS_Edge
    theTolerance: float
    IsUseOldEdge: bool

    Returns
    -------
    theNewTol: float
    Computes new 2d curve(s) for all the edges of <s> to have the same parameter as the 3d curve. the algorithm is not done if the flag sameparameter was true on an edge.

    Parameters
    ----------
    S: TopoDS_Shape
    Tolerance: float,optional
    	default value is 1.0e-5
    forced: bool,optional
    	default value is Standard_False

    Returns
    -------
    None
    Computes new 2d curve(s) for all the edges of <s> to have the same parameter as the 3d curve. the algorithm is not done if the flag sameparameter was true on an edge. thereshaper is used to record the modifications of input shape <s> to prevent any modifications on the shape itself. thus the input shape (and its subshapes) will not be modified, instead the reshaper will contain a modified empty-copies of original subshapes as substitutions.

    Parameters
    ----------
    S: TopoDS_Shape
    theReshaper: BRepTools_ReShape
    Tolerance: float,optional
    	default value is 1.0e-5
    forced: bool,optional
    	default value is Standard_False

    Returns
    -------
    None

    """
    return _BRepLib.breplib_SameParameter(*args)

def breplib_SameRange(*args) -> "void":
    r"""
    Will make all the curve representation have the same range domain for the parameters. this will ignore the same range flag value to proceed. if there is a 3d curve there it will the range of that curve. if not the first curve representation encountered in the list will give its range to the all the other curves.

    Parameters
    ----------
    E: TopoDS_Edge
    Tolerance: float,optional
    	default value is 1.0e-5

    Returns
    -------
    None

    """
    return _BRepLib.breplib_SameRange(*args)

def breplib_SortFaces(*args) -> "void":
    r"""
    Sorts in lf the faces of s on the complexity of their surfaces (plane,cylinder,cone,sphere,torus,other).

    Parameters
    ----------
    S: TopoDS_Shape
    LF: TopTools_ListOfShape

    Returns
    -------
    None

    """
    return _BRepLib.breplib_SortFaces(*args)

def breplib_UpdateDeflection(*args) -> "void":
    r"""
    Updates value of deflection in poly_triangulation of faces by the maximum deviation measured on existing triangulation.

    Parameters
    ----------
    S: TopoDS_Shape

    Returns
    -------
    None

    """
    return _BRepLib.breplib_UpdateDeflection(*args)

def breplib_UpdateEdgeTol(*args) -> "Standard_Boolean":
    r"""
    Checks if the edge has a tolerance smaller than -- -- -- -- maxtolerancetocheck if so it will compute the radius of -- the cylindrical pipe surface that mintolerancerequest is the minimum tolerance before it is useful to start testing. usually it should be around 10e-5 contains all -- the curve representation of the edge returns true if the edge tolerance had to be updated.

    Parameters
    ----------
    E: TopoDS_Edge
    MinToleranceRequest: float
    MaxToleranceToCheck: float

    Returns
    -------
    bool

    """
    return _BRepLib.breplib_UpdateEdgeTol(*args)

def breplib_UpdateEdgeTolerance(*args) -> "Standard_Boolean":
    r"""
    -- checks all the edges of the shape whose -- -- -- tolerance is smaller than maxtolerancetocheck -- returns true if at least one edge was updated -- mintolerancerequest is the minimum tolerance before -- it -- is useful to start testing. usually it should be around -- 10e-5-- //! warning :the method is very slow as it checks all. use only in interfaces or processing assimilate batch.

    Parameters
    ----------
    S: TopoDS_Shape
    MinToleranceRequest: float
    MaxToleranceToCheck: float

    Returns
    -------
    bool

    """
    return _BRepLib.breplib_UpdateEdgeTolerance(*args)

def breplib_UpdateInnerTolerances(*args) -> "void":
    r"""
    Checks tolerances of edges (including inner points) and vertices of a shape and updates them to satisfy 'sameparameter' condition.

    Parameters
    ----------
    S: TopoDS_Shape

    Returns
    -------
    None

    """
    return _BRepLib.breplib_UpdateInnerTolerances(*args)

def breplib_UpdateTolerances(*args) -> "void":
    r"""
    Replaces tolerance of face edge vertex by the tolerance max of their connected handling shapes. it is not necessary to use this call after sameparameter. (called in).

    Parameters
    ----------
    S: TopoDS_Shape
    verifyFaceTolerance: bool,optional
    	default value is Standard_False

    Returns
    -------
    None
    Replaces tolerance of face edge vertex by the tolerance max of their connected handling shapes. it is not necessary to use this call after sameparameter. (called in) thereshaper is used to record the modifications of input shape <s> to prevent any modifications on the shape itself. thus the input shape (and its subshapes) will not be modified, instead the reshaper will contain a modified empty-copies of original subshapes as substitutions.

    Parameters
    ----------
    S: TopoDS_Shape
    theReshaper: BRepTools_ReShape
    verifyFaceTolerance: bool,optional
    	default value is Standard_False

    Returns
    -------
    None

    """
    return _BRepLib.breplib_UpdateTolerances(*args)

class BRepLib_CheckCurveOnSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Default constructor.

        Returns
        -------
        None
        Constructor.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theFace: TopoDS_Face

        Returns
        -------
        None

        """
        _BRepLib.BRepLib_CheckCurveOnSurface_swiginit(self, _BRepLib.new_BRepLib_CheckCurveOnSurface(*args))

    def ErrorStatus(self, *args) -> "Standard_Integer":
        r"""
        Returns error status the possible values are: 0 - ok; 1 - null curve or surface or 2d curve; 2 - invalid parametric range; 3 - error in calculations.

        Returns
        -------
        int

        """
        return _BRepLib.BRepLib_CheckCurveOnSurface_ErrorStatus(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Sets the data for the algorithm.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theFace: TopoDS_Face

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_CheckCurveOnSurface_Init(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the max distance has been found.

        Returns
        -------
        bool

        """
        return _BRepLib.BRepLib_CheckCurveOnSurface_IsDone(self, *args)

    def MaxDistance(self, *args) -> "Standard_Real":
        r"""
        Returns max distance.

        Returns
        -------
        float

        """
        return _BRepLib.BRepLib_CheckCurveOnSurface_MaxDistance(self, *args)

    def MaxParameter(self, *args) -> "Standard_Real":
        r"""
        Returns parameter in which the distance is maximal.

        Returns
        -------
        float

        """
        return _BRepLib.BRepLib_CheckCurveOnSurface_MaxParameter(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        Performs the calculation if ismultithread == standard_true then computation will be performed in parallel.

        Parameters
        ----------
        isMultiThread: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_CheckCurveOnSurface_Perform(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_CheckCurveOnSurface

# Register BRepLib_CheckCurveOnSurface in _BRepLib:
_BRepLib.BRepLib_CheckCurveOnSurface_swigregister(BRepLib_CheckCurveOnSurface)

class BRepLib_Command(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Check(self, *args) -> "void":
        r"""
        Raises notdone if done is false.

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_Command_Check(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _BRepLib.BRepLib_Command_IsDone(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_Command

# Register BRepLib_Command in _BRepLib:
_BRepLib.BRepLib_Command_swigregister(BRepLib_Command)

class BRepLib_FindSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None
        Computes the surface from the edges of <s> with the given tolerance. if <onlyplane> is true, the computed surface will be a plane. if it is not possible to find a plane, the flag notdone will be set. if <onlyclosed> is true, then s should be a wire and the existing surface, on which wire s is not closed in 2d, will be ignored.

        Parameters
        ----------
        S: TopoDS_Shape
        Tol: float,optional
        	default value is -1
        OnlyPlane: bool,optional
        	default value is Standard_False
        OnlyClosed: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        _BRepLib.BRepLib_FindSurface_swiginit(self, _BRepLib.new_BRepLib_FindSurface(*args))

    def Existed(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _BRepLib.BRepLib_FindSurface_Existed(self, *args)

    def Found(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _BRepLib.BRepLib_FindSurface_Found(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Computes the surface from the edges of <s> with the given tolerance. if <onlyplane> is true, the computed surface will be a plane. if it is not possible to find a plane, the flag notdone will be set. if <onlyclosed> is true, then s should be a wire and the existing surface, on which wire s is not closed in 2d, will be ignored.

        Parameters
        ----------
        S: TopoDS_Shape
        Tol: float,optional
        	default value is -1
        OnlyPlane: bool,optional
        	default value is Standard_False
        OnlyClosed: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_FindSurface_Init(self, *args)

    def Location(self, *args) -> "TopLoc_Location":
        r"""
        No available documentation.

        Returns
        -------
        TopLoc_Location

        """
        return _BRepLib.BRepLib_FindSurface_Location(self, *args)

    def Surface(self, *args) -> "opencascade::handle< Geom_Surface >":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Geom_Surface>

        """
        return _BRepLib.BRepLib_FindSurface_Surface(self, *args)

    def Tolerance(self, *args) -> "Standard_Real":
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _BRepLib.BRepLib_FindSurface_Tolerance(self, *args)

    def ToleranceReached(self, *args) -> "Standard_Real":
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _BRepLib.BRepLib_FindSurface_ToleranceReached(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_FindSurface

# Register BRepLib_FindSurface in _BRepLib:
_BRepLib.BRepLib_FindSurface_swigregister(BRepLib_FindSurface)

class BRepLib_FuseEdges(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Initialise members and build construction of map of ancestors.

        Parameters
        ----------
        theShape: TopoDS_Shape
        PerformNow: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        _BRepLib.BRepLib_FuseEdges_swiginit(self, _BRepLib.new_BRepLib_FuseEdges(*args))

    def AvoidEdges(self, *args) -> "void":
        r"""
        Set edges to avoid being fused.

        Parameters
        ----------
        theMapEdg: TopTools_IndexedMapOfShape

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_FuseEdges_AvoidEdges(self, *args)

    def Edges(self, *args) -> "void":
        r"""
        Returns all the list of edges to be fused each list of the map represent a set of connex edges that can be fused.

        Parameters
        ----------
        theMapLstEdg: TopTools_DataMapOfIntegerListOfShape

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_FuseEdges_Edges(self, *args)

    def Faces(self, *args) -> "void":
        r"""
        Returns the map of modified faces.

        Parameters
        ----------
        theMapFac: TopTools_DataMapOfShapeShape

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_FuseEdges_Faces(self, *args)

    def NbVertices(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of vertices candidate to be removed.

        Returns
        -------
        int

        """
        return _BRepLib.BRepLib_FuseEdges_NbVertices(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        Using map of list of connex edges, fuse each list to one edge and then update myshape.

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_FuseEdges_Perform(self, *args)

    def ResultEdges(self, *args) -> "void":
        r"""
        Returns all the fused edges. each integer entry in the map corresponds to the integer in the datamapofintegerlistofshape we get in method edges. that is to say, to the list of edges in themaplstedg(i) corresponds the resulting edge themapedge(i).

        Parameters
        ----------
        theMapEdg: TopTools_DataMapOfIntegerShape

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_FuseEdges_ResultEdges(self, *args)

    def SetConcatBSpl(self, *args) -> "void":
        r"""
        Set mode to enable concatenation g1 bspline edges in one end modified by ifv 19.04.07.

        Parameters
        ----------
        theConcatBSpl: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_FuseEdges_SetConcatBSpl(self, *args)

    def Shape(self, *args) -> "TopoDS_Shape":
        r"""
        Returns myshape modified with the list of internal edges removed from it.

        Returns
        -------
        TopoDS_Shape

        """
        return _BRepLib.BRepLib_FuseEdges_Shape(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_FuseEdges

# Register BRepLib_FuseEdges in _BRepLib:
_BRepLib.BRepLib_FuseEdges_swigregister(BRepLib_FuseEdges)

class BRepLib_ValidateEdge(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Initialization constructor.

        Parameters
        ----------
        theReferenceCurve: Adaptor3d_Curve
        theOtherCurve: Adaptor3d_CurveOnSurface
        theSameParameter: bool

        Returns
        -------
        None

        """
        _BRepLib.BRepLib_ValidateEdge_swiginit(self, _BRepLib.new_BRepLib_ValidateEdge(*args))

    def CheckTolerance(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if computed distance is less than <thetolerancetocheck>.

        Parameters
        ----------
        theToleranceToCheck: float

        Returns
        -------
        bool

        """
        return _BRepLib.BRepLib_ValidateEdge_CheckTolerance(self, *args)

    def GetMaxDistance(self, *args) -> "Standard_Real":
        r"""
        Returns max distance.

        Returns
        -------
        float

        """
        return _BRepLib.BRepLib_ValidateEdge_GetMaxDistance(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the distance has been found for all points.

        Returns
        -------
        bool

        """
        return _BRepLib.BRepLib_ValidateEdge_IsDone(self, *args)

    def Process(self, *args) -> "void":
        r"""
        Computes the max distance for the 3d curve <myreferencecurve> and curve on surface <myothercurve>. if the setexitiftoleranceexceeded() function was called before <mycalculateddistance> contains first greater than setexitiftoleranceexceeded() parameter value.

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_ValidateEdge_Process(self, *args)

    def SetControlPointsNumber(self, *args) -> "void":
        r"""
        Set control points number (if you need a value other than 22).

        Parameters
        ----------
        theControlPointsNumber: int

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_ValidateEdge_SetControlPointsNumber(self, *args)

    def SetExitIfToleranceExceeded(self, *args) -> "void":
        r"""
        Sets the maximal allowed distance in the process() function. if the distance greater than thetoleranceforchecking the process() function stops. use this for best performance in case of checking of tolerance.

        Parameters
        ----------
        theToleranceForChecking: float

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_ValidateEdge_SetExitIfToleranceExceeded(self, *args)

    def UpdateTolerance(self, *args) -> "void":
        r"""
        Increase <thetolerancetoupdate> if max distance is greater than <thetolerancetoupdate>.

        Parameters
        ----------

        Returns
        -------
        theToleranceToUpdate: float

        """
        return _BRepLib.BRepLib_ValidateEdge_UpdateTolerance(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_ValidateEdge

# Register BRepLib_ValidateEdge in _BRepLib:
_BRepLib.BRepLib_ValidateEdge_swigregister(BRepLib_ValidateEdge)

class BRepLib_MakeShape(BRepLib_Command):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Build(self, *args) -> "void":
        r"""
        This is called by shape(). it does nothing but may be redefined.

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_MakeShape_Build(self, *args)

    def DescendantFaces(self, *args) -> "TopTools_ListOfShape const &":
        r"""
        Returns the list of generated faces.

        Parameters
        ----------
        F: TopoDS_Face

        Returns
        -------
        TopTools_ListOfShape

        """
        return _BRepLib.BRepLib_MakeShape_DescendantFaces(self, *args)

    def FaceStatus(self, *args) -> "BRepLib_ShapeModification":
        r"""
        Returns the status of the face after the shape creation.

        Parameters
        ----------
        F: TopoDS_Face

        Returns
        -------
        BRepLib_ShapeModification

        """
        return _BRepLib.BRepLib_MakeShape_FaceStatus(self, *args)

    def FacesFromEdges(self, *args) -> "TopTools_ListOfShape const &":
        r"""
        Returns a list of the created faces from the edge <e>.

        Parameters
        ----------
        E: TopoDS_Edge

        Returns
        -------
        TopTools_ListOfShape

        """
        return _BRepLib.BRepLib_MakeShape_FacesFromEdges(self, *args)

    def HasDescendants(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the face generates new topology.

        Parameters
        ----------
        F: TopoDS_Face

        Returns
        -------
        bool

        """
        return _BRepLib.BRepLib_MakeShape_HasDescendants(self, *args)

    def NbSurfaces(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of surfaces after the shape creation.

        Returns
        -------
        int

        """
        return _BRepLib.BRepLib_MakeShape_NbSurfaces(self, *args)

    def NewFaces(self, *args) -> "TopTools_ListOfShape const &":
        r"""
        Return the faces created for surface i.

        Parameters
        ----------
        I: int

        Returns
        -------
        TopTools_ListOfShape

        """
        return _BRepLib.BRepLib_MakeShape_NewFaces(self, *args)

    def Shape(self, *args) -> "TopoDS_Shape const":
        r"""
        No available documentation.

        Returns
        -------
        TopoDS_Shape

        """
        return _BRepLib.BRepLib_MakeShape_Shape(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakeShape

# Register BRepLib_MakeShape in _BRepLib:
_BRepLib.BRepLib_MakeShape_swigregister(BRepLib_MakeShape)

class BRepLib_MakeEdge(BRepLib_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Lin

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Lin
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Lin
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Lin
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Circ

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Circ
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Circ
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Circ
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Elips

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Elips
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Elips
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Elips
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Hypr

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Hypr
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Hypr
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Hypr
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Parab

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Parab
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Parab
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Parab
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom_Curve

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom_Curve
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom_Curve
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom_Curve
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom_Curve
        P1: gp_Pnt
        P2: gp_Pnt
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom_Curve
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        S: Geom_Surface

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        S: Geom_Surface
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        S: Geom_Surface
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        S: Geom_Surface
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        S: Geom_Surface
        P1: gp_Pnt
        P2: gp_Pnt
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        S: Geom_Surface
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex
        p1: float
        p2: float

        Returns
        -------
        None

        """
        _BRepLib.BRepLib_MakeEdge_swiginit(self, _BRepLib.new_BRepLib_MakeEdge(*args))

    def Edge(self, *args) -> "TopoDS_Edge const":
        r"""
        No available documentation.

        Returns
        -------
        TopoDS_Edge

        """
        return _BRepLib.BRepLib_MakeEdge_Edge(self, *args)

    def Error(self, *args) -> "BRepLib_EdgeError":
        r"""
        Returns the error description when notdone.

        Returns
        -------
        BRepLib_EdgeError

        """
        return _BRepLib.BRepLib_MakeEdge_Error(self, *args)

    def Init(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        C: Geom_Curve

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: Geom_Curve
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: Geom_Curve
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: Geom_Curve
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: Geom_Curve
        P1: gp_Pnt
        P2: gp_Pnt
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: Geom_Curve
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        S: Geom_Surface

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        S: Geom_Surface
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        S: Geom_Surface
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        S: Geom_Surface
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        S: Geom_Surface
        P1: gp_Pnt
        P2: gp_Pnt
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        S: Geom_Surface
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex
        p1: float
        p2: float

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_MakeEdge_Init(self, *args)

    def Vertex1(self, *args) -> "TopoDS_Vertex const":
        r"""
        Returns the first vertex of the edge. may be null.

        Returns
        -------
        TopoDS_Vertex

        """
        return _BRepLib.BRepLib_MakeEdge_Vertex1(self, *args)

    def Vertex2(self, *args) -> "TopoDS_Vertex const":
        r"""
        Returns the second vertex of the edge. may be null.

        Returns
        -------
        TopoDS_Vertex

        """
        return _BRepLib.BRepLib_MakeEdge_Vertex2(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakeEdge

# Register BRepLib_MakeEdge in _BRepLib:
_BRepLib.BRepLib_MakeEdge_swigregister(BRepLib_MakeEdge)

class BRepLib_MakeEdge2d(BRepLib_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Lin2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Lin2d
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Lin2d
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Lin2d
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Circ2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Circ2d
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Circ2d
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Circ2d
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Elips2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Elips2d
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Elips2d
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Elips2d
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Hypr2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Hypr2d
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Hypr2d
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Hypr2d
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Parab2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Parab2d
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Parab2d
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: gp_Parab2d
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        P1: gp_Pnt2d
        P2: gp_Pnt2d
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        L: Geom2d_Curve
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex
        p1: float
        p2: float

        Returns
        -------
        None

        """
        _BRepLib.BRepLib_MakeEdge2d_swiginit(self, _BRepLib.new_BRepLib_MakeEdge2d(*args))

    def Edge(self, *args) -> "TopoDS_Edge const":
        r"""
        No available documentation.

        Returns
        -------
        TopoDS_Edge

        """
        return _BRepLib.BRepLib_MakeEdge2d_Edge(self, *args)

    def Error(self, *args) -> "BRepLib_EdgeError":
        r"""
        Returns the error description when notdone.

        Returns
        -------
        BRepLib_EdgeError

        """
        return _BRepLib.BRepLib_MakeEdge2d_Error(self, *args)

    def Init(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        P1: gp_Pnt2d
        P2: gp_Pnt2d
        p1: float
        p2: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: Geom2d_Curve
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex
        p1: float
        p2: float

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_MakeEdge2d_Init(self, *args)

    def Vertex1(self, *args) -> "TopoDS_Vertex const":
        r"""
        Returns the first vertex of the edge. may be null.

        Returns
        -------
        TopoDS_Vertex

        """
        return _BRepLib.BRepLib_MakeEdge2d_Vertex1(self, *args)

    def Vertex2(self, *args) -> "TopoDS_Vertex const":
        r"""
        Returns the second vertex of the edge. may be null.

        Returns
        -------
        TopoDS_Vertex

        """
        return _BRepLib.BRepLib_MakeEdge2d_Vertex2(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakeEdge2d

# Register BRepLib_MakeEdge2d in _BRepLib:
_BRepLib.BRepLib_MakeEdge2d_swigregister(BRepLib_MakeEdge2d)

class BRepLib_MakeFace(BRepLib_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Not done.

        Returns
        -------
        None
        Load a face. useful to add wires.

        Parameters
        ----------
        F: TopoDS_Face

        Returns
        -------
        None
        Make a face from a plane.

        Parameters
        ----------
        P: gp_Pln

        Returns
        -------
        None
        Make a face from a cylinder.

        Parameters
        ----------
        C: gp_Cylinder

        Returns
        -------
        None
        Make a face from a cone.

        Parameters
        ----------
        C: gp_Cone

        Returns
        -------
        None
        Make a face from a sphere.

        Parameters
        ----------
        S: gp_Sphere

        Returns
        -------
        None
        Make a face from a torus.

        Parameters
        ----------
        C: gp_Torus

        Returns
        -------
        None
        Make a face from a surface. accepts tolerance value (toldegen) for resolution of degenerated edges.

        Parameters
        ----------
        S: Geom_Surface
        TolDegen: float

        Returns
        -------
        None
        Make a face from a plane.

        Parameters
        ----------
        P: gp_Pln
        UMin: float
        UMax: float
        VMin: float
        VMax: float

        Returns
        -------
        None
        Make a face from a cylinder.

        Parameters
        ----------
        C: gp_Cylinder
        UMin: float
        UMax: float
        VMin: float
        VMax: float

        Returns
        -------
        None
        Make a face from a cone.

        Parameters
        ----------
        C: gp_Cone
        UMin: float
        UMax: float
        VMin: float
        VMax: float

        Returns
        -------
        None
        Make a face from a sphere.

        Parameters
        ----------
        S: gp_Sphere
        UMin: float
        UMax: float
        VMin: float
        VMax: float

        Returns
        -------
        None
        Make a face from a torus.

        Parameters
        ----------
        C: gp_Torus
        UMin: float
        UMax: float
        VMin: float
        VMax: float

        Returns
        -------
        None
        Make a face from a surface. accepts min & max parameters to construct the face's bounds. also accepts tolerance value (toldegen) for resolution of degenerated edges.

        Parameters
        ----------
        S: Geom_Surface
        UMin: float
        UMax: float
        VMin: float
        VMax: float
        TolDegen: float

        Returns
        -------
        None
        Find a surface from the wire and make a face. if <onlyplane> is true, the computed surface will be a plane. if it is not possible to find a plane, the flag notdone will be set.

        Parameters
        ----------
        W: TopoDS_Wire
        OnlyPlane: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        Make a face from a plane and a wire.

        Parameters
        ----------
        P: gp_Pln
        W: TopoDS_Wire
        Inside: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        Make a face from a cylinder and a wire.

        Parameters
        ----------
        C: gp_Cylinder
        W: TopoDS_Wire
        Inside: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        Make a face from a cone and a wire.

        Parameters
        ----------
        C: gp_Cone
        W: TopoDS_Wire
        Inside: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        Make a face from a sphere and a wire.

        Parameters
        ----------
        S: gp_Sphere
        W: TopoDS_Wire
        Inside: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        Make a face from a torus and a wire.

        Parameters
        ----------
        C: gp_Torus
        W: TopoDS_Wire
        Inside: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        Make a face from a surface and a wire.

        Parameters
        ----------
        S: Geom_Surface
        W: TopoDS_Wire
        Inside: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        Adds the wire <w> in the face <f>.

        Parameters
        ----------
        F: TopoDS_Face
        W: TopoDS_Wire

        Returns
        -------
        None

        """
        _BRepLib.BRepLib_MakeFace_swiginit(self, _BRepLib.new_BRepLib_MakeFace(*args))

    def Add(self, *args) -> "void":
        r"""
        Adds the wire <w> in the current face.

        Parameters
        ----------
        W: TopoDS_Wire

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_MakeFace_Add(self, *args)

    def Error(self, *args) -> "BRepLib_FaceError":
        r"""
        No available documentation.

        Returns
        -------
        BRepLib_FaceError

        """
        return _BRepLib.BRepLib_MakeFace_Error(self, *args)

    def Face(self, *args) -> "TopoDS_Face const":
        r"""
        Returns the new face.

        Returns
        -------
        TopoDS_Face

        """
        return _BRepLib.BRepLib_MakeFace_Face(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Load the face.

        Parameters
        ----------
        F: TopoDS_Face

        Returns
        -------
        None
        Creates the face from the surface. if bound is true a wire is made from the natural bounds. accepts tolerance value (toldegen) for resolution of degenerated edges.

        Parameters
        ----------
        S: Geom_Surface
        Bound: bool
        TolDegen: float

        Returns
        -------
        None
        Creates the face from the surface and the min-max values. accepts tolerance value (toldegen) for resolution of degenerated edges.

        Parameters
        ----------
        S: Geom_Surface
        UMin: float
        UMax: float
        VMin: float
        VMax: float
        TolDegen: float

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_MakeFace_Init(self, *args)

    @staticmethod
    def IsDegenerated(*args) -> "Standard_Real &":
        r"""
        Checks the specified curve is degenerated according to specified tolerance. returns <theacttol> less than <themaxtol>, which shows actual tolerance to decide the curve is degenerated. warning: for internal use of breplib_makeface and breplib_makeshell.

        Parameters
        ----------
        theCurve: Geom_Curve
        theMaxTol: float

        Returns
        -------
        theActTol: float

        """
        return _BRepLib.BRepLib_MakeFace_IsDegenerated(*args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakeFace

# Register BRepLib_MakeFace in _BRepLib:
_BRepLib.BRepLib_MakeFace_swigregister(BRepLib_MakeFace)

def BRepLib_MakeFace_IsDegenerated(*args) -> "Standard_Real &":
    r"""
    Checks the specified curve is degenerated according to specified tolerance. returns <theacttol> less than <themaxtol>, which shows actual tolerance to decide the curve is degenerated. warning: for internal use of breplib_makeface and breplib_makeshell.

    Parameters
    ----------
    theCurve: Geom_Curve
    theMaxTol: float

    Returns
    -------
    theActTol: float

    """
    return _BRepLib.BRepLib_MakeFace_IsDegenerated(*args)

class BRepLib_MakePolygon(BRepLib_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty makepolygon.

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt
        Close: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt
        P4: gp_Pnt
        Close: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex
        V3: TopoDS_Vertex
        Close: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex
        V3: TopoDS_Vertex
        V4: TopoDS_Vertex
        Close: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        _BRepLib.BRepLib_MakePolygon_swiginit(self, _BRepLib.new_BRepLib_MakePolygon(*args))

    def Add(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        V: TopoDS_Vertex

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_MakePolygon_Add(self, *args)

    def Added(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the last vertex or point was successfully added.

        Returns
        -------
        bool

        """
        return _BRepLib.BRepLib_MakePolygon_Added(self, *args)

    def Close(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_MakePolygon_Close(self, *args)

    def Edge(self, *args) -> "TopoDS_Edge const":
        r"""
        Returns the last edge added to the polygon.

        Returns
        -------
        TopoDS_Edge

        """
        return _BRepLib.BRepLib_MakePolygon_Edge(self, *args)

    def FirstVertex(self, *args) -> "TopoDS_Vertex const":
        r"""
        No available documentation.

        Returns
        -------
        TopoDS_Vertex

        """
        return _BRepLib.BRepLib_MakePolygon_FirstVertex(self, *args)

    def LastVertex(self, *args) -> "TopoDS_Vertex const":
        r"""
        No available documentation.

        Returns
        -------
        TopoDS_Vertex

        """
        return _BRepLib.BRepLib_MakePolygon_LastVertex(self, *args)

    def Wire(self, *args) -> "TopoDS_Wire const":
        r"""
        No available documentation.

        Returns
        -------
        TopoDS_Wire

        """
        return _BRepLib.BRepLib_MakePolygon_Wire(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakePolygon

# Register BRepLib_MakePolygon in _BRepLib:
_BRepLib.BRepLib_MakePolygon_swigregister(BRepLib_MakePolygon)

class BRepLib_MakeShell(BRepLib_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Not done.

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        S: Geom_Surface
        Segment: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        S: Geom_Surface
        UMin: float
        UMax: float
        VMin: float
        VMax: float
        Segment: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        _BRepLib.BRepLib_MakeShell_swiginit(self, _BRepLib.new_BRepLib_MakeShell(*args))

    def Error(self, *args) -> "BRepLib_ShellError":
        r"""
        No available documentation.

        Returns
        -------
        BRepLib_ShellError

        """
        return _BRepLib.BRepLib_MakeShell_Error(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Creates the shell from the surface and the min-max values.

        Parameters
        ----------
        S: Geom_Surface
        UMin: float
        UMax: float
        VMin: float
        VMax: float
        Segment: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_MakeShell_Init(self, *args)

    def Shell(self, *args) -> "TopoDS_Shell const":
        r"""
        Returns the new shell.

        Returns
        -------
        TopoDS_Shell

        """
        return _BRepLib.BRepLib_MakeShell_Shell(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakeShell

# Register BRepLib_MakeShell in _BRepLib:
_BRepLib.BRepLib_MakeShell_swigregister(BRepLib_MakeShell)

class BRepLib_MakeSolid(BRepLib_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Solid covers whole space.

        Returns
        -------
        None
        Make a solid from a compsolid.

        Parameters
        ----------
        S: TopoDS_CompSolid

        Returns
        -------
        None
        Make a solid from a shell.

        Parameters
        ----------
        S: TopoDS_Shell

        Returns
        -------
        None
        Make a solid from two shells.

        Parameters
        ----------
        S1: TopoDS_Shell
        S2: TopoDS_Shell

        Returns
        -------
        None
        Make a solid from three shells.

        Parameters
        ----------
        S1: TopoDS_Shell
        S2: TopoDS_Shell
        S3: TopoDS_Shell

        Returns
        -------
        None
        Make a solid from a solid. useful for adding later.

        Parameters
        ----------
        So: TopoDS_Solid

        Returns
        -------
        None
        Add a shell to a solid.

        Parameters
        ----------
        So: TopoDS_Solid
        S: TopoDS_Shell

        Returns
        -------
        None

        """
        _BRepLib.BRepLib_MakeSolid_swiginit(self, _BRepLib.new_BRepLib_MakeSolid(*args))

    def Add(self, *args) -> "void":
        r"""
        Add the shell to the current solid.

        Parameters
        ----------
        S: TopoDS_Shell

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_MakeSolid_Add(self, *args)

    def Solid(self, *args) -> "TopoDS_Solid const":
        r"""
        Returns the new solid.

        Returns
        -------
        TopoDS_Solid

        """
        return _BRepLib.BRepLib_MakeSolid_Solid(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakeSolid

# Register BRepLib_MakeSolid in _BRepLib:
_BRepLib.BRepLib_MakeSolid_swigregister(BRepLib_MakeSolid)

class BRepLib_MakeVertex(BRepLib_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None

        """
        _BRepLib.BRepLib_MakeVertex_swiginit(self, _BRepLib.new_BRepLib_MakeVertex(*args))

    def Vertex(self, *args) -> "TopoDS_Vertex const":
        r"""
        No available documentation.

        Returns
        -------
        TopoDS_Vertex

        """
        return _BRepLib.BRepLib_MakeVertex_Vertex(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakeVertex

# Register BRepLib_MakeVertex in _BRepLib:
_BRepLib.BRepLib_MakeVertex_swigregister(BRepLib_MakeVertex)

class BRepLib_MakeWire(BRepLib_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Notdone makewire.

        Returns
        -------
        None
        Make a wire from an edge.

        Parameters
        ----------
        E: TopoDS_Edge

        Returns
        -------
        None
        Make a wire from two edges.

        Parameters
        ----------
        E1: TopoDS_Edge
        E2: TopoDS_Edge

        Returns
        -------
        None
        Make a wire from three edges.

        Parameters
        ----------
        E1: TopoDS_Edge
        E2: TopoDS_Edge
        E3: TopoDS_Edge

        Returns
        -------
        None
        Make a wire from four edges.

        Parameters
        ----------
        E1: TopoDS_Edge
        E2: TopoDS_Edge
        E3: TopoDS_Edge
        E4: TopoDS_Edge

        Returns
        -------
        None
        Make a wire from a wire. useful for adding later.

        Parameters
        ----------
        W: TopoDS_Wire

        Returns
        -------
        None
        Add an edge to a wire.

        Parameters
        ----------
        W: TopoDS_Wire
        E: TopoDS_Edge

        Returns
        -------
        None

        """
        _BRepLib.BRepLib_MakeWire_swiginit(self, _BRepLib.new_BRepLib_MakeWire(*args))

    def Add(self, *args) -> "void":
        r"""
        Add the edge <e> to the current wire.

        Parameters
        ----------
        E: TopoDS_Edge

        Returns
        -------
        None
        Add the edges of <w> to the current wire.

        Parameters
        ----------
        W: TopoDS_Wire

        Returns
        -------
        None
        Add the edges of <l> to the current wire. the edges are not to be consecutive. but they are to be all connected geometrically or topologically.

        Parameters
        ----------
        L: TopTools_ListOfShape

        Returns
        -------
        None

        """
        return _BRepLib.BRepLib_MakeWire_Add(self, *args)

    def Edge(self, *args) -> "TopoDS_Edge const":
        r"""
        Returns the last edge added to the wire.

        Returns
        -------
        TopoDS_Edge

        """
        return _BRepLib.BRepLib_MakeWire_Edge(self, *args)

    def Error(self, *args) -> "BRepLib_WireError":
        r"""
        No available documentation.

        Returns
        -------
        BRepLib_WireError

        """
        return _BRepLib.BRepLib_MakeWire_Error(self, *args)

    def Vertex(self, *args) -> "TopoDS_Vertex const":
        r"""
        Returns the last connecting vertex.

        Returns
        -------
        TopoDS_Vertex

        """
        return _BRepLib.BRepLib_MakeWire_Vertex(self, *args)

    def Wire(self, *args) -> "TopoDS_Wire const":
        r"""
        Returns the new wire.

        Returns
        -------
        TopoDS_Wire

        """
        return _BRepLib.BRepLib_MakeWire_Wire(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepLib.delete_BRepLib_MakeWire

# Register BRepLib_MakeWire in _BRepLib:
_BRepLib.BRepLib_MakeWire_swigregister(BRepLib_MakeWire)





