# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
BRepPrimAPI module, see official documentation at
https://www.opencascade.com/doc/occt-7.6.0/refman/html/package_brepprimapi.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _BRepPrimAPI
else:
    import _BRepPrimAPI

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BRepPrimAPI.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _BRepPrimAPI.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _BRepPrimAPI.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _BRepPrimAPI.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _BRepPrimAPI.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _BRepPrimAPI.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _BRepPrimAPI.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _BRepPrimAPI.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _BRepPrimAPI.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _BRepPrimAPI.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _BRepPrimAPI.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _BRepPrimAPI.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _BRepPrimAPI.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _BRepPrimAPI.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _BRepPrimAPI.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _BRepPrimAPI.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _BRepPrimAPI.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _BRepPrimAPI:
_BRepPrimAPI.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _BRepPrimAPI.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.BRepBuilderAPI
import OCC.Core.Geom
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.TopTools
import OCC.Core.BRepTools
import OCC.Core.Bnd
import OCC.Core.BVH
import OCC.Core.Geom2d
import OCC.Core.BRep
import OCC.Core.Poly
import OCC.Core.TShort
import OCC.Core.BRepPrim
import OCC.Core.BRepSweep
import OCC.Core.Sweep

from enum import IntEnum
from OCC.Core.Exception import *



class BRepPrimAPI_MakeBox(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Default constructor.

        Returns
        -------
        None
        Make a box with a corner at 0,0,0 and the other dx,dy,dz.

        Parameters
        ----------
        dx: float
        dy: float
        dz: float

        Returns
        -------
        None
        Make a box with a corner at p and size dx, dy, dz.

        Parameters
        ----------
        P: gp_Pnt
        dx: float
        dy: float
        dz: float

        Returns
        -------
        None
        Make a box with corners p1,p2.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None
        Make a box with ax2 (the left corner and the axis) and size dx, dy, dz.

        Parameters
        ----------
        Axes: gp_Ax2
        dx: float
        dy: float
        dz: float

        Returns
        -------
        None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeBox_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeBox(*args))

    def BackFace(self, *args) -> "TopoDS_Face const":
        r"""
        Returns xmin face.

        Returns
        -------
        TopoDS_Face

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_BackFace(self, *args)

    def BottomFace(self, *args) -> "TopoDS_Face const":
        r"""
        Returns zmin face.

        Returns
        -------
        TopoDS_Face

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_BottomFace(self, *args)

    def FrontFace(self, *args) -> "TopoDS_Face const":
        r"""
        Returns xmax face.

        Returns
        -------
        TopoDS_Face

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_FrontFace(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Init a box with a corner at 0,0,0 and the other thedx, thedy, thedz.

        Parameters
        ----------
        theDX: float
        theDY: float
        theDZ: float

        Returns
        -------
        None
        Init a box with a corner at thepnt and size thedx, thedy, thedz.

        Parameters
        ----------
        thePnt: gp_Pnt
        theDX: float
        theDY: float
        theDZ: float

        Returns
        -------
        None
        Init a box with corners thepnt1, thepnt2.

        Parameters
        ----------
        thePnt1: gp_Pnt
        thePnt2: gp_Pnt

        Returns
        -------
        None
        Init a box with ax2 (the left corner and the theaxes) and size thedx, thedy, thedz.

        Parameters
        ----------
        theAxes: gp_Ax2
        theDX: float
        theDY: float
        theDZ: float

        Returns
        -------
        None

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_Init(self, *args)

    def LeftFace(self, *args) -> "TopoDS_Face const":
        r"""
        Returns ymin face.

        Returns
        -------
        TopoDS_Face

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_LeftFace(self, *args)

    def RightFace(self, *args) -> "TopoDS_Face const":
        r"""
        Returns ymax face.

        Returns
        -------
        TopoDS_Face

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_RightFace(self, *args)

    def Shell(self, *args) -> "TopoDS_Shell const":
        r"""
        Returns the constructed box as a shell.

        Returns
        -------
        TopoDS_Shell

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_Shell(self, *args)

    def Solid(self, *args) -> "TopoDS_Solid const":
        r"""
        Returns the constructed box as a solid.

        Returns
        -------
        TopoDS_Solid

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_Solid(self, *args)

    def TopFace(self, *args) -> "TopoDS_Face const":
        r"""
        Returns zmax face.

        Returns
        -------
        TopoDS_Face

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_TopFace(self, *args)

    def Wedge(self, *args) -> "BRepPrim_Wedge &":
        r"""
        Returns the internal algorithm.

        Returns
        -------
        BRepPrim_Wedge

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_Wedge(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeBox

# Register BRepPrimAPI_MakeBox in _BRepPrimAPI:
_BRepPrimAPI.BRepPrimAPI_MakeBox_swigregister(BRepPrimAPI_MakeBox)

class BRepPrimAPI_MakeHalfSpace(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Make a halfspace defined with a face and a point.

        Parameters
        ----------
        Face: TopoDS_Face
        RefPnt: gp_Pnt

        Returns
        -------
        None
        Make a halfspace defined with a shell and a point.

        Parameters
        ----------
        Shell: TopoDS_Shell
        RefPnt: gp_Pnt

        Returns
        -------
        None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeHalfSpace_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeHalfSpace(*args))

    def Solid(self, *args) -> "TopoDS_Solid const":
        r"""
        Returns the constructed half-space as a solid.

        Returns
        -------
        TopoDS_Solid

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeHalfSpace_Solid(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeHalfSpace

# Register BRepPrimAPI_MakeHalfSpace in _BRepPrimAPI:
_BRepPrimAPI.BRepPrimAPI_MakeHalfSpace_swigregister(BRepPrimAPI_MakeHalfSpace)

class BRepPrimAPI_MakeOneAxis(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Face(self, *args) -> "TopoDS_Face const":
        r"""
        Returns the lateral face of the rotational primitive.

        Returns
        -------
        TopoDS_Face

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeOneAxis_Face(self, *args)

    def OneAxis(self, *args) -> "Standard_Address":
        r"""
        The inherited commands should provide the algorithm. returned as a pointer.

        Returns
        -------
        Standard_Address

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeOneAxis_OneAxis(self, *args)

    def Shell(self, *args) -> "TopoDS_Shell const":
        r"""
        Returns the constructed rotational primitive as a shell.

        Returns
        -------
        TopoDS_Shell

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeOneAxis_Shell(self, *args)

    def Solid(self, *args) -> "TopoDS_Solid const":
        r"""
        Returns the constructed rotational primitive as a solid.

        Returns
        -------
        TopoDS_Solid

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeOneAxis_Solid(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeOneAxis

# Register BRepPrimAPI_MakeOneAxis in _BRepPrimAPI:
_BRepPrimAPI.BRepPrimAPI_MakeOneAxis_swigregister(BRepPrimAPI_MakeOneAxis)

class BRepPrimAPI_MakeSweep(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def FirstShape(self, *args) -> "TopoDS_Shape":
        r"""
        Returns the topods shape of the bottom of the sweep.

        Returns
        -------
        TopoDS_Shape

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeSweep_FirstShape(self, *args)

    def LastShape(self, *args) -> "TopoDS_Shape":
        r"""
        Returns the topods shape of the top of the sweep.

        Returns
        -------
        TopoDS_Shape

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeSweep_LastShape(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeSweep

# Register BRepPrimAPI_MakeSweep in _BRepPrimAPI:
_BRepPrimAPI.BRepPrimAPI_MakeSweep_swigregister(BRepPrimAPI_MakeSweep)

class BRepPrimAPI_MakeWedge(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Make a step right angular wedge. (ltx >= 0).

        Parameters
        ----------
        dx: float
        dy: float
        dz: float
        ltx: float

        Returns
        -------
        None
        Make a step right angular wedge. (ltx >= 0).

        Parameters
        ----------
        Axes: gp_Ax2
        dx: float
        dy: float
        dz: float
        ltx: float

        Returns
        -------
        None
        Make a wedge. the face at dy is xmin,zmin xmax,zmax.

        Parameters
        ----------
        dx: float
        dy: float
        dz: float
        xmin: float
        zmin: float
        xmax: float
        zmax: float

        Returns
        -------
        None
        Make a wedge. the face at dy is xmin,zmin xmax,zmax.

        Parameters
        ----------
        Axes: gp_Ax2
        dx: float
        dy: float
        dz: float
        xmin: float
        zmin: float
        xmax: float
        zmax: float

        Returns
        -------
        None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeWedge_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeWedge(*args))

    def Shell(self, *args) -> "TopoDS_Shell const":
        r"""
        Returns the constructed box in the form of a shell.

        Returns
        -------
        TopoDS_Shell

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeWedge_Shell(self, *args)

    def Solid(self, *args) -> "TopoDS_Solid const":
        r"""
        Returns the constructed box in the form of a solid.

        Returns
        -------
        TopoDS_Solid

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeWedge_Solid(self, *args)

    def Wedge(self, *args) -> "BRepPrim_Wedge &":
        r"""
        Returns the internal algorithm.

        Returns
        -------
        BRepPrim_Wedge

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeWedge_Wedge(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeWedge

# Register BRepPrimAPI_MakeWedge in _BRepPrimAPI:
_BRepPrimAPI.BRepPrimAPI_MakeWedge_swigregister(BRepPrimAPI_MakeWedge)

class BRepPrimAPI_MakeCone(BRepPrimAPI_MakeOneAxis):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Make a cone. @param r1 [in] cone bottom radius, may be null (z = 0) @param r2 [in] cone top radius, may be null (z = h) @param h [in] cone height.

        Parameters
        ----------
        R1: float
        R2: float
        H: float

        Returns
        -------
        None
        Make a cone. @param r1 [in] cone bottom radius, may be null (z = 0) @param r2 [in] cone top radius, may be null (z = h) @param h [in] cone height @param angle [in] angle to create a part cone.

        Parameters
        ----------
        R1: float
        R2: float
        H: float
        angle: float

        Returns
        -------
        None
        Make a cone. @param axes [in] coordinate system for the construction of the cone @param r1 [in] cone bottom radius, may be null (z = 0) @param r2 [in] cone top radius, may be null (z = h) @param h [in] cone height.

        Parameters
        ----------
        Axes: gp_Ax2
        R1: float
        R2: float
        H: float

        Returns
        -------
        None
        Make a cone of height h radius r1 in the plane z = 0, r2 in the plane z = h. r1 and r2 may be null. take a section of <angle> constructs a cone, or a portion of a cone, of height h, and radius r1 in the plane z = 0 and r2 in the plane z = h. the result is a sharp cone if r1 or r2 is equal to 0. the cone is constructed about the 'z axis' of either: - the global coordinate system, or - the local coordinate system axes. it is limited in these coordinate systems as follows: - in the v parametric direction (the z coordinate), by the two parameter values 0 and h, - and in the u parametric direction (defined by the angle of rotation around the z axis), in the case of a portion of a cone, by the two parameter values 0 and angle. angle is given in radians. the resulting shape is composed of: - a lateral conical face - two planar faces in the planes z = 0 and z = h, or only one planar face in one of these two planes if a radius value is null (in the case of a complete cone, these faces are circles), and - and in the case of a portion of a cone, two planar faces to close the shape. (either two parallelograms or two triangles, in the planes u = 0 and u = angle). exceptions standard_domainerror if: - h is less than or equal to precision::confusion(), or - the half-angle at the apex of the cone, defined by r1, r2 and h, is less than precision::confusion()/h, or greater than (pi/2)-precision::confusion()/h.f.

        Parameters
        ----------
        Axes: gp_Ax2
        R1: float
        R2: float
        H: float
        angle: float

        Returns
        -------
        None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeCone_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeCone(*args))

    def Cone(self, *args) -> "BRepPrim_Cone &":
        r"""
        Returns the algorithm.

        Returns
        -------
        BRepPrim_Cone

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeCone_Cone(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeCone

# Register BRepPrimAPI_MakeCone in _BRepPrimAPI:
_BRepPrimAPI.BRepPrimAPI_MakeCone_swigregister(BRepPrimAPI_MakeCone)

class BRepPrimAPI_MakeCylinder(BRepPrimAPI_MakeOneAxis):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Make a cylinder. @param r [in] cylinder radius @param h [in] cylinder height.

        Parameters
        ----------
        R: float
        H: float

        Returns
        -------
        None
        Make a cylinder (part cylinder). @param r [in] cylinder radius @param h [in] cylinder height @param angle [in] defines the missing portion of the cylinder.

        Parameters
        ----------
        R: float
        H: float
        Angle: float

        Returns
        -------
        None
        Make a cylinder of radius r and length h. @param axes [in] coordinate system for the construction of the cylinder @param r [in] cylinder radius @param h [in] cylinder height.

        Parameters
        ----------
        Axes: gp_Ax2
        R: float
        H: float

        Returns
        -------
        None
        Make a cylinder of radius r and length h with angle h. constructs - a cylinder of radius r and height h, or - a portion of cylinder of radius r and height h, and of the angle angle defining the missing portion of the cylinder. the cylinder is constructed about the 'z axis' of either: - the global coordinate system, or - the local coordinate system axes. it is limited in this coordinate system as follows: - in the v parametric direction (the z axis), by the two parameter values 0 and h, - and in the u parametric direction (the rotation angle around the z axis), in the case of a portion of a cylinder, by the two parameter values 0 and angle. angle is given in radians. the resulting shape is composed of: - a lateral cylindrical face, - two planar faces in the planes z = 0 and z = h (in the case of a complete cylinder, these faces are circles), and - in case of a portion of a cylinder, two additional planar faces to close the shape.(two rectangles in the planes u = 0 and u = angle). exceptions standard_domainerror if: - r is less than or equal to precision::confusion(), or - h is less than or equal to precision::confusion().

        Parameters
        ----------
        Axes: gp_Ax2
        R: float
        H: float
        Angle: float

        Returns
        -------
        None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeCylinder_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeCylinder(*args))

    def Cylinder(self, *args) -> "BRepPrim_Cylinder &":
        r"""
        Returns the algorithm.

        Returns
        -------
        BRepPrim_Cylinder

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeCylinder_Cylinder(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeCylinder

# Register BRepPrimAPI_MakeCylinder in _BRepPrimAPI:
_BRepPrimAPI.BRepPrimAPI_MakeCylinder_swigregister(BRepPrimAPI_MakeCylinder)

class BRepPrimAPI_MakePrism(BRepPrimAPI_MakeSweep):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Builds the prism of base s and vector v. if c is true, s is copied. if canonize is true then generated surfaces are attempted to be canonized in simple types.

        Parameters
        ----------
        S: TopoDS_Shape
        V: gp_Vec
        Copy: bool,optional
        	default value is Standard_False
        Canonize: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        Builds a semi-infinite or an infinite prism of base s. if inf is true the prism is infinite, if inf is false the prism is semi-infinite (in the direction d). if c is true s is copied (for semi-infinite prisms). if canonize is true then generated surfaces are attempted to be canonized in simple types.

        Parameters
        ----------
        S: TopoDS_Shape
        D: gp_Dir
        Inf: bool,optional
        	default value is Standard_True
        Copy: bool,optional
        	default value is Standard_False
        Canonize: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        _BRepPrimAPI.BRepPrimAPI_MakePrism_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakePrism(*args))

    def FirstShape(self, *args) -> "TopoDS_Shape":
        r"""
        Returns the topods shape of the bottom of the prism.

        Returns
        -------
        TopoDS_Shape
        Returns the topods shape of the bottom of the prism. generated with theshape (subshape of the generating shape).

        Parameters
        ----------
        theShape: TopoDS_Shape

        Returns
        -------
        TopoDS_Shape

        """
        return _BRepPrimAPI.BRepPrimAPI_MakePrism_FirstShape(self, *args)

    def LastShape(self, *args) -> "TopoDS_Shape":
        r"""
        Returns the topods shape of the top of the prism. in the case of a finite prism, firstshape returns the basis of the prism, in other words, s if copy is false; otherwise, the copy of s belonging to the prism. lastshape returns the copy of s translated by v at the time of construction.

        Returns
        -------
        TopoDS_Shape
        Returns the topods shape of the top of the prism. generated with theshape (subshape of the generating shape).

        Parameters
        ----------
        theShape: TopoDS_Shape

        Returns
        -------
        TopoDS_Shape

        """
        return _BRepPrimAPI.BRepPrimAPI_MakePrism_LastShape(self, *args)

    def Prism(self, *args) -> "BRepSweep_Prism const &":
        r"""
        Returns the internal sweeping algorithm.

        Returns
        -------
        BRepSweep_Prism

        """
        return _BRepPrimAPI.BRepPrimAPI_MakePrism_Prism(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakePrism

# Register BRepPrimAPI_MakePrism in _BRepPrimAPI:
_BRepPrimAPI.BRepPrimAPI_MakePrism_swigregister(BRepPrimAPI_MakePrism)

class BRepPrimAPI_MakeRevol(BRepPrimAPI_MakeSweep):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Builds the revol of base s, axis a and angle d. if c is true, s is copied.

        Parameters
        ----------
        S: TopoDS_Shape
        A: gp_Ax1
        D: float
        Copy: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        Builds the revol of base s, axis a and angle 2*pi. if c is true, s is copied.

        Parameters
        ----------
        S: TopoDS_Shape
        A: gp_Ax1
        Copy: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeRevol_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeRevol(*args))

    def Degenerated(self, *args) -> "TopTools_ListOfShape const &":
        r"""
        Returns the list of degenerated edges.

        Returns
        -------
        TopTools_ListOfShape

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeRevol_Degenerated(self, *args)

    def FirstShape(self, *args) -> "TopoDS_Shape":
        r"""
        Returns the first shape of the revol (coinciding with the generating shape).

        Returns
        -------
        TopoDS_Shape
        Returns the topods shape of the beginning of the revolution, generated with theshape (subshape of the generating shape).

        Parameters
        ----------
        theShape: TopoDS_Shape

        Returns
        -------
        TopoDS_Shape

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeRevol_FirstShape(self, *args)

    def HasDegenerated(self, *args) -> "Standard_Boolean":
        r"""
        Check if there are degenerated edges in the result.

        Returns
        -------
        bool

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeRevol_HasDegenerated(self, *args)

    def LastShape(self, *args) -> "TopoDS_Shape":
        r"""
        Returns the topods shape of the end of the revol.

        Returns
        -------
        TopoDS_Shape
        Returns the topods shape of the end of the revolution, generated with theshape (subshape of the generating shape).

        Parameters
        ----------
        theShape: TopoDS_Shape

        Returns
        -------
        TopoDS_Shape

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeRevol_LastShape(self, *args)

    def Revol(self, *args) -> "BRepSweep_Revol const &":
        r"""
        Returns the internal sweeping algorithm.

        Returns
        -------
        BRepSweep_Revol

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeRevol_Revol(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeRevol

# Register BRepPrimAPI_MakeRevol in _BRepPrimAPI:
_BRepPrimAPI.BRepPrimAPI_MakeRevol_swigregister(BRepPrimAPI_MakeRevol)

class BRepPrimAPI_MakeRevolution(BRepPrimAPI_MakeOneAxis):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Make a revolution body by rotating a curve around z.

        Parameters
        ----------
        Meridian: Geom_Curve

        Returns
        -------
        None
        Make a revolution body by rotating a curve around z.

        Parameters
        ----------
        Meridian: Geom_Curve
        angle: float

        Returns
        -------
        None
        Make a revolution body by rotating a curve around z.

        Parameters
        ----------
        Meridian: Geom_Curve
        VMin: float
        VMax: float

        Returns
        -------
        None
        Make a revolution body by rotating a curve around z.

        Parameters
        ----------
        Meridian: Geom_Curve
        VMin: float
        VMax: float
        angle: float

        Returns
        -------
        None
        Make a revolution body by rotating a curve around z.

        Parameters
        ----------
        Axes: gp_Ax2
        Meridian: Geom_Curve

        Returns
        -------
        None
        Make a revolution body by rotating a curve around z.

        Parameters
        ----------
        Axes: gp_Ax2
        Meridian: Geom_Curve
        angle: float

        Returns
        -------
        None
        Make a revolution body by rotating a curve around z.

        Parameters
        ----------
        Axes: gp_Ax2
        Meridian: Geom_Curve
        VMin: float
        VMax: float

        Returns
        -------
        None
        Make a revolution body by rotating a curve around z. for all algorithms the resulting shape is composed of - a lateral revolved face, - two planar faces in planes parallel to the plane z = 0, and passing by the extremities of the revolved portion of meridian, if these points are not on the z axis (in case of a complete revolved shape, these faces are circles), - and in the case of a portion of a revolved shape, two planar faces to close the shape (in the planes u = 0 and u = angle).

        Parameters
        ----------
        Axes: gp_Ax2
        Meridian: Geom_Curve
        VMin: float
        VMax: float
        angle: float

        Returns
        -------
        None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeRevolution_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeRevolution(*args))

    def Revolution(self, *args) -> "BRepPrim_Revolution &":
        r"""
        Returns the algorithm.

        Returns
        -------
        BRepPrim_Revolution

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeRevolution_Revolution(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeRevolution

# Register BRepPrimAPI_MakeRevolution in _BRepPrimAPI:
_BRepPrimAPI.BRepPrimAPI_MakeRevolution_swigregister(BRepPrimAPI_MakeRevolution)

class BRepPrimAPI_MakeSphere(BRepPrimAPI_MakeOneAxis):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Make a sphere. @param r [in] sphere radius.

        Parameters
        ----------
        R: float

        Returns
        -------
        None
        Make a sphere (spherical wedge). @param r [in] sphere radius @param angle [in] angle between the radii lying within the bounding semidisks.

        Parameters
        ----------
        R: float
        angle: float

        Returns
        -------
        None
        Make a sphere (spherical segment). @param r [in] sphere radius @param angle1 [in] first angle defining a spherical segment @param angle2 [in] second angle defining a spherical segment.

        Parameters
        ----------
        R: float
        angle1: float
        angle2: float

        Returns
        -------
        None
        Make a sphere (spherical segment). @param r [in] sphere radius @param angle1 [in] first angle defining a spherical segment @param angle2 [in] second angle defining a spherical segment @param angle3 [in] angle between the radii lying within the bounding semidisks.

        Parameters
        ----------
        R: float
        angle1: float
        angle2: float
        angle3: float

        Returns
        -------
        None
        Make a sphere. @param center [in] sphere center coordinates @param r [in] sphere radius.

        Parameters
        ----------
        Center: gp_Pnt
        R: float

        Returns
        -------
        None
        Make a sphere (spherical wedge). @param center [in] sphere center coordinates @param r [in] sphere radius @param angle [in] angle between the radii lying within the bounding semidisks.

        Parameters
        ----------
        Center: gp_Pnt
        R: float
        angle: float

        Returns
        -------
        None
        Make a sphere (spherical segment). @param center [in] sphere center coordinates @param r [in] sphere radius @param angle1 [in] first angle defining a spherical segment @param angle2 [in] second angle defining a spherical segment.

        Parameters
        ----------
        Center: gp_Pnt
        R: float
        angle1: float
        angle2: float

        Returns
        -------
        None
        Make a sphere (spherical segment). @param center [in] sphere center coordinates @param r [in] sphere radius @param angle1 [in] first angle defining a spherical segment @param angle2 [in] second angle defining a spherical segment @param angle3 [in] angle between the radii lying within the bounding semidisks.

        Parameters
        ----------
        Center: gp_Pnt
        R: float
        angle1: float
        angle2: float
        angle3: float

        Returns
        -------
        None
        Make a sphere. @param axis [in] coordinate system for the construction of the sphere @param r [in] sphere radius.

        Parameters
        ----------
        Axis: gp_Ax2
        R: float

        Returns
        -------
        None
        Make a sphere (spherical wedge). @param axis [in] coordinate system for the construction of the sphere @param r [in] sphere radius @param angle [in] angle between the radii lying within the bounding semidisks.

        Parameters
        ----------
        Axis: gp_Ax2
        R: float
        angle: float

        Returns
        -------
        None
        Make a sphere (spherical segment). @param axis [in] coordinate system for the construction of the sphere @param r [in] sphere radius @param angle1 [in] first angle defining a spherical segment @param angle2 [in] second angle defining a spherical segment.

        Parameters
        ----------
        Axis: gp_Ax2
        R: float
        angle1: float
        angle2: float

        Returns
        -------
        None
        Make a sphere of radius r. for all algorithms the resulting shape is composed of - a lateral spherical face, - two planar faces parallel to the plane z = 0 if the sphere is truncated in the v parametric direction, or only one planar face if angle1 is equal to -p/2 or if angle2 is equal to p/2 (these faces are circles in case of a complete truncated sphere), - and in case of a portion of sphere, two planar faces to shut the shape.(in the planes u = 0 and u = angle).

        Parameters
        ----------
        Axis: gp_Ax2
        R: float
        angle1: float
        angle2: float
        angle3: float

        Returns
        -------
        None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeSphere_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeSphere(*args))

    def Sphere(self, *args) -> "BRepPrim_Sphere &":
        r"""
        Returns the algorithm.

        Returns
        -------
        BRepPrim_Sphere

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeSphere_Sphere(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeSphere

# Register BRepPrimAPI_MakeSphere in _BRepPrimAPI:
_BRepPrimAPI.BRepPrimAPI_MakeSphere_swigregister(BRepPrimAPI_MakeSphere)

class BRepPrimAPI_MakeTorus(BRepPrimAPI_MakeOneAxis):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Make a torus. @param r1 [in] distance from the center of the pipe to the center of the torus @param r2 [in] radius of the pipe.

        Parameters
        ----------
        R1: float
        R2: float

        Returns
        -------
        None
        Make a section of a torus. @param r1 [in] distance from the center of the pipe to the center of the torus @param r2 [in] radius of the pipe @param angle [in] angle to create a torus pipe segment.

        Parameters
        ----------
        R1: float
        R2: float
        angle: float

        Returns
        -------
        None
        Make a torus with angles on the small circle. @param r1 [in] distance from the center of the pipe to the center of the torus @param r2 [in] radius of the pipe @param angle1 [in] first angle to create a torus ring segment @param angle2 [in] second angle to create a torus ring segment.

        Parameters
        ----------
        R1: float
        R2: float
        angle1: float
        angle2: float

        Returns
        -------
        None
        Make a torus with angles on the small circle. @param r1 [in] distance from the center of the pipe to the center of the torus @param r2 [in] radius of the pipe @param angle1 [in] first angle to create a torus ring segment @param angle2 [in] second angle to create a torus ring segment @param angle [in] angle to create a torus pipe segment.

        Parameters
        ----------
        R1: float
        R2: float
        angle1: float
        angle2: float
        angle: float

        Returns
        -------
        None
        Make a torus. @param axes [in] coordinate system for the construction of the sphere @param r1 [in] distance from the center of the pipe to the center of the torus @param r2 [in] radius of the pipe.

        Parameters
        ----------
        Axes: gp_Ax2
        R1: float
        R2: float

        Returns
        -------
        None
        Make a section of a torus. @param axes [in] coordinate system for the construction of the sphere @param r1 [in] distance from the center of the pipe to the center of the torus @param r2 [in] radius of the pipe @param angle [in] angle to create a torus pipe segment.

        Parameters
        ----------
        Axes: gp_Ax2
        R1: float
        R2: float
        angle: float

        Returns
        -------
        None
        Make a torus. @param axes [in] coordinate system for the construction of the sphere @param r1 [in] distance from the center of the pipe to the center of the torus @param r2 [in] radius of the pipe @param angle1 [in] first angle to create a torus ring segment @param angle2 [in] second angle to create a torus ring segment.

        Parameters
        ----------
        Axes: gp_Ax2
        R1: float
        R2: float
        angle1: float
        angle2: float

        Returns
        -------
        None
        Make a section of a torus of radii r1 r2. for all algorithms the resulting shape is composed of - a lateral toroidal face, - two conical faces (defined by the equation v = angle1 and v = angle2) if the sphere is truncated in the v parametric direction (they may be cylindrical faces in some particular conditions), and in case of a portion of torus, two planar faces to close the shape.(in the planes u = 0 and u = angle). notes: - the u parameter corresponds to a rotation angle around the z axis. - the circle whose radius is equal to the minor radius, located in the plane defined by the x axis and the z axis, centered on the x axis, on its positive side, and positioned at a distance from the origin equal to the major radius, is the reference circle of the torus. the rotation around an axis parallel to the y axis and passing through the center of the reference circle gives the v parameter on the reference circle. the x axis gives the origin of the v parameter. near 0, as v increases, the z coordinate decreases.

        Parameters
        ----------
        Axes: gp_Ax2
        R1: float
        R2: float
        angle1: float
        angle2: float
        angle: float

        Returns
        -------
        None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeTorus_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeTorus(*args))

    def Torus(self, *args) -> "BRepPrim_Torus &":
        r"""
        Returns the algorithm.

        Returns
        -------
        BRepPrim_Torus

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeTorus_Torus(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeTorus

# Register BRepPrimAPI_MakeTorus in _BRepPrimAPI:
_BRepPrimAPI.BRepPrimAPI_MakeTorus_swigregister(BRepPrimAPI_MakeTorus)





