/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.ResourceHelper;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.Message;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractModuleDescriptorParser
implements ModuleDescriptorParser {
    @Override
    public ModuleDescriptor parseDescriptor(ParserSettings parserSettings, URL uRL, boolean bl) throws ParseException, IOException {
        return this.parseDescriptor(parserSettings, uRL, new URLResource(uRL), bl);
    }

    @Override
    public Artifact getMetadataArtifact(ModuleRevisionId moduleRevisionId, Resource resource) {
        return DefaultArtifact.newIvyArtifact(moduleRevisionId, new Date(resource.getLastModified()));
    }

    protected static abstract class AbstractParser
    extends DefaultHandler {
        private String defaultConf;
        private String defaultConfMapping;
        private DefaultDependencyDescriptor defaultConfMappingDescriptor;
        private Resource res;
        private List errors = new ArrayList();
        private DefaultModuleDescriptor md;
        private ModuleDescriptorParser parser;

        protected AbstractParser(ModuleDescriptorParser moduleDescriptorParser) {
            this.parser = moduleDescriptorParser;
        }

        public ModuleDescriptorParser getModuleDescriptorParser() {
            return this.parser;
        }

        protected void checkErrors() throws ParseException {
            if (!this.errors.isEmpty()) {
                throw new ParseException(this.errors.toString(), 0);
            }
        }

        public void setResource(Resource resource) {
            this.res = resource;
            this.md = new DefaultModuleDescriptor(this.parser, resource);
            this.md.setLastModified(ResourceHelper.getLastModifiedOrDefault(resource));
        }

        protected Resource getResource() {
            return this.res;
        }

        protected String getDefaultConfMapping() {
            return this.defaultConfMapping;
        }

        protected void setDefaultConfMapping(String string) {
            this.defaultConfMapping = string;
            this.getMd().setDefaultConfMapping(string);
        }

        protected void parseDepsConfs(String string, DefaultDependencyDescriptor defaultDependencyDescriptor) {
            this.parseDepsConfs(string, defaultDependencyDescriptor, this.defaultConfMapping != null);
        }

        protected void parseDepsConfs(String string, DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl) {
            this.parseDepsConfs(string, defaultDependencyDescriptor, bl, true);
        }

        protected void parseDepsConfs(String stringArray, DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl, boolean bl2) {
            if (stringArray == null) {
                return;
            }
            stringArray = stringArray.split(";");
            this.parseDepsConfs(stringArray, defaultDependencyDescriptor, bl, bl2);
        }

        protected void parseDepsConfs(String[] stringArray, DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl) {
            this.parseDepsConfs(stringArray, defaultDependencyDescriptor, bl, true);
        }

        protected void parseDepsConfs(String[] stringArray, DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl, boolean bl2) {
            AbstractParser abstractParser = this;
            abstractParser.replaceConfigurationWildcards(abstractParser.md);
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                int n;
                String[] stringArray2;
                String[] stringArray3 = stringArray[i].split("->");
                if (stringArray3.length == 1) {
                    stringArray2 = stringArray3[0].split(",");
                    if (!bl) {
                        for (int j = 0; j < stringArray2.length; ++j) {
                            defaultDependencyDescriptor.addDependencyConfiguration(stringArray2[j].trim(), stringArray2[j].trim());
                        }
                        continue;
                    }
                    for (int j = 0; j < stringArray2.length; ++j) {
                        String[] stringArray4 = this.getDefaultConfMappingDescriptor().getDependencyConfigurations(stringArray2[j]);
                        if (stringArray4.length > 0) {
                            for (n = 0; n < stringArray4.length; ++n) {
                                string = bl2 ? this.evaluateCondition(stringArray4[n].trim(), defaultDependencyDescriptor) : stringArray4[n].trim();
                                if (string == null) continue;
                                defaultDependencyDescriptor.addDependencyConfiguration(stringArray2[j].trim(), string);
                            }
                            continue;
                        }
                        defaultDependencyDescriptor.addDependencyConfiguration(stringArray2[j].trim(), stringArray2[j].trim());
                    }
                    continue;
                }
                if (stringArray3.length == 2) {
                    stringArray2 = stringArray3[0].split(",");
                    stringArray3 = stringArray3[1].split(",");
                    for (int j = 0; j < stringArray2.length; ++j) {
                        for (n = 0; n < stringArray3.length; ++n) {
                            string = bl2 ? this.evaluateCondition(stringArray3[n].trim(), defaultDependencyDescriptor) : stringArray3[n].trim();
                            if (string == null) continue;
                            defaultDependencyDescriptor.addDependencyConfiguration(stringArray2[j].trim(), string);
                        }
                    }
                    continue;
                }
                this.addError("invalid conf " + stringArray[i] + " for " + defaultDependencyDescriptor);
            }
            if (this.md.isMappingOverride()) {
                this.addExtendingConfigurations(stringArray, defaultDependencyDescriptor, bl);
            }
        }

        private String evaluateCondition(String string, DefaultDependencyDescriptor object) {
            if (string.charAt(0) != '[') {
                return string;
            }
            int n = string.indexOf(93);
            if (n == -1) {
                this.addError("invalid conf " + string + " for " + object);
                return null;
            }
            String string2 = string.substring(1, n);
            int n2 = string2.indexOf("!=");
            if (n2 == -1) {
                int n3 = string2.indexOf(61);
                if (n3 == -1) {
                    this.addError("invalid conf " + string + " for " + ((DefaultDependencyDescriptor)object).getDependencyRevisionId());
                    return null;
                }
                String string3 = string2.substring(0, n3).trim();
                string2 = string2.substring(n3 + 1).trim();
                if (string3.equals("org") || string3.equals("organization")) {
                    string3 = "organisation";
                }
                if (!string2.equals(object = ((DefaultDependencyDescriptor)object).getAttribute(string3))) {
                    return null;
                }
            } else {
                String string4 = string2.substring(0, n2).trim();
                String string5 = string2.substring(n2 + 2).trim();
                if (string4.equals("org") || string4.equals("organization")) {
                    string4 = "organisation";
                }
                if (string5.equals(string2 = ((DefaultDependencyDescriptor)object).getAttribute(string4))) {
                    return null;
                }
            }
            return string.substring(n + 1);
        }

        private void addExtendingConfigurations(String[] stringArray, DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addExtendingConfigurations(stringArray[i], defaultDependencyDescriptor, bl);
            }
        }

        private void addExtendingConfigurations(String string, DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl) {
            HashSet<String> hashSet = new HashSet<String>();
            Configuration[] configurationArray = this.md.getConfigurations();
            for (int i = 0; i < configurationArray.length; ++i) {
                String[] stringArray = configurationArray[i].getExtends();
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!string.equals(stringArray[j])) continue;
                    String string2 = configurationArray[i].getName();
                    hashSet.add(string2);
                    this.addExtendingConfigurations(string2, defaultDependencyDescriptor, bl);
                }
            }
            HashSet<String> hashSet2 = hashSet;
            String[] stringArray = hashSet2.toArray(new String[hashSet2.size()]);
            this.parseDepsConfs(stringArray, defaultDependencyDescriptor, bl);
        }

        protected DependencyDescriptor getDefaultConfMappingDescriptor() {
            if (this.defaultConfMappingDescriptor == null) {
                this.defaultConfMappingDescriptor = new DefaultDependencyDescriptor(ModuleRevisionId.newInstance("", "", ""), false);
                AbstractParser abstractParser = this;
                abstractParser.parseDepsConfs(abstractParser.defaultConfMapping, this.defaultConfMappingDescriptor, false, false);
            }
            return this.defaultConfMappingDescriptor;
        }

        protected void addError(String string) {
            if (this.res != null) {
                this.errors.add(string + " in " + this.res + "\n");
                return;
            }
            this.errors.add(string + "\n");
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            Message.warn("xml parsing: " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        @Override
        public void error(SAXParseException sAXParseException) {
            this.addError("xml parsing: " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.addError("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        private String getLocationString(SAXParseException sAXParseException) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = sAXParseException.getSystemId();
            if (string != null) {
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                stringBuffer.append(string);
            } else if (this.getResource() != null) {
                stringBuffer.append(this.getResource().toString());
            }
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getLineNumber());
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getColumnNumber());
            return stringBuffer.toString();
        }

        protected String getDefaultConf() {
            if (this.defaultConf != null) {
                return this.defaultConf;
            }
            if (this.defaultConfMapping != null) {
                return this.defaultConfMapping;
            }
            return "*->*";
        }

        protected void setDefaultConf(String string) {
            this.defaultConf = string;
            this.getMd().setDefaultConf(string);
        }

        public ModuleDescriptor getModuleDescriptor() throws ParseException {
            this.checkErrors();
            return this.md;
        }

        protected Date getDefaultPubDate() {
            return new Date(this.md.getLastModified());
        }

        private void replaceConfigurationWildcards(ModuleDescriptor moduleDescriptor) {
            Configuration[] configurationArray = moduleDescriptor.getConfigurations();
            for (int i = 0; i < configurationArray.length; ++i) {
                configurationArray[i].replaceWildcards(moduleDescriptor);
            }
        }

        protected void setMd(DefaultModuleDescriptor defaultModuleDescriptor) {
            this.md = defaultModuleDescriptor;
        }

        protected DefaultModuleDescriptor getMd() {
            return this.md;
        }
    }
}

