/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.parosproxy.paros.Constant;

public class Tech
implements Comparable<Tech> {
    public static final Tech Db = new Tech("Db", "technologies.db");
    public static final Tech MySQL = new Tech(Db, "MySQL");
    public static final Tech PostgreSQL = new Tech(Db, "PostgreSQL");
    public static final Tech MsSQL = new Tech(Db, "Microsoft SQL Server");
    public static final Tech Oracle = new Tech(Db, "Oracle");
    public static final Tech SQLite = new Tech(Db, "SQLite");
    public static final Tech Access = new Tech(Db, "Microsoft Access");
    public static final Tech Firebird = new Tech(Db, "Firebird");
    public static final Tech MaxDB = new Tech(Db, "SAP MaxDB");
    public static final Tech Sybase = new Tech(Db, "Sybase");
    public static final Tech Db2 = new Tech(Db, "IBM DB2");
    public static final Tech HypersonicSQL = new Tech(Db, "HypersonicSQL");
    public static final Tech MongoDB = new Tech(Db, "MongoDB");
    public static final Tech CouchDB = new Tech(Db, "CouchDB");
    public static final Tech Lang = new Tech("Language", "technologies.lang");
    public static final Tech ASP = new Tech(Lang, "ASP");
    public static final Tech C = new Tech(Lang, "C");
    public static final Tech JAVA = new Tech(Lang, "Java");
    public static final Tech SPRING = new Tech(JAVA, "Spring");
    public static final Tech JAVASCRIPT = new Tech(Lang, "JavaScript");
    public static final Tech JSP_SERVLET = new Tech(Lang, "JSP/Servlet");
    public static final Tech PHP = new Tech(Lang, "PHP");
    public static final Tech PYTHON = new Tech(Lang, "Python");
    public static final Tech RUBY = new Tech(Lang, "Ruby");
    public static final Tech XML = new Tech(Lang, "XML");
    public static final Tech OS = new Tech("OS", "technologies.os");
    public static final Tech Linux = new Tech(OS, "Linux");
    public static final Tech MacOS = new Tech(OS, "MacOS");
    public static final Tech Windows = new Tech(OS, "Windows");
    public static final Tech SCM = new Tech("SCM", "technologies.scm");
    public static final Tech Git = new Tech(SCM, "Git");
    public static final Tech SVN = new Tech(SCM, "SVN");
    public static final Tech WS = new Tech("WS", "technologies.ws");
    public static final Tech Apache = new Tech(WS, "Apache");
    public static final Tech IIS = new Tech(WS, "IIS");
    public static final Tech Tomcat = new Tech(WS, "Tomcat");
    private static final TreeSet<Tech> allTech = new TreeSet<Tech>(Arrays.asList(Db, MySQL, PostgreSQL, MsSQL, Oracle, SQLite, Access, Firebird, MaxDB, Sybase, Db2, HypersonicSQL, MongoDB, CouchDB, Lang, ASP, C, JAVA, SPRING, JAVASCRIPT, JSP_SERVLET, PHP, PYTHON, RUBY, XML, OS, Linux, MacOS, Windows, SCM, Git, SVN, WS, Apache, IIS, Tomcat));
    private static final TreeSet<Tech> topLevelTech = new TreeSet<Tech>(Arrays.asList(Db, Lang, OS, SCM, WS));
    @Deprecated
    public static final Tech[] builtInTech = allTech.toArray(new Tech[0]);
    @Deprecated
    public static final Tech[] builtInTopLevelTech = topLevelTech.toArray(new Tech[0]);
    private Tech parent = null;
    private String name = null;
    private String keyUiName;

    public Tech(String name) {
        this(name, null);
    }

    public Tech(String name, String keyUiName) {
        if (name.indexOf(".") > 0) {
            this.name = name.substring(name.lastIndexOf(".") + 1);
            this.parent = new Tech(name.substring(0, name.lastIndexOf(".")));
        } else {
            this.name = name;
        }
        this.keyUiName = keyUiName;
    }

    public Tech(Tech parent, String name) {
        this(parent, name, null);
    }

    public Tech(Tech parent, String name, String keyUiName) {
        this.parent = parent;
        this.name = name;
        this.keyUiName = keyUiName;
    }

    public String toString() {
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.toString() + "." + this.name;
    }

    public boolean equals(Object tech) {
        if (!(tech instanceof Tech)) {
            return false;
        }
        return this.toString().equals(tech.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean is(Tech other) {
        if (other == null) {
            return false;
        }
        Tech t = this;
        while (t != null) {
            if (other == t) {
                return true;
            }
            t = t.parent;
        }
        return false;
    }

    public Tech getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getUiName() {
        if (this.keyUiName == null) {
            return this.getName();
        }
        return Constant.messages.getString(this.keyUiName);
    }

    @Override
    public int compareTo(Tech o) {
        if (o == null) {
            return -1;
        }
        return this.toString().compareTo(o.toString());
    }

    public static Set<Tech> getAll() {
        return Collections.unmodifiableSet(allTech);
    }

    public static Set<Tech> getTopLevel() {
        return Collections.unmodifiableSet(topLevelTech);
    }

    public static void add(Tech tech) {
        if (tech != null) {
            if (tech.getParent() == null) {
                topLevelTech.add(tech);
            }
            allTech.add(tech);
        }
    }

    public static void remove(Tech tech) {
        if (tech != null) {
            if (tech.getParent() == null) {
                topLevelTech.remove(tech);
            }
            allTech.remove(tech);
        }
    }

    public static Tech get(String name) {
        if (name == null) {
            return null;
        }
        String trimmedTechName = name.trim();
        if (trimmedTechName.isEmpty()) {
            return null;
        }
        for (Tech tech : allTech) {
            if (!tech.toString().equalsIgnoreCase(trimmedTechName)) continue;
            return tech;
        }
        return null;
    }
}

