/* import.c generated by valac 0.56.3, the Vala compiler
 * generated from import.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include "config.h"
#include <stdio.h>
#include "folks/folks.h"
#include <gio/gio.h>
#include <gee.h>

#define FOLKS_IMPORT_TOOL_DEFAULT_SOURCE "pidgin"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FOLKS_TYPE_IMPORT_TOOL (folks_import_tool_get_type ())
#define FOLKS_IMPORT_TOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IMPORT_TOOL, FolksImportTool))
#define FOLKS_IMPORT_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_IMPORT_TOOL, FolksImportToolClass))
#define FOLKS_IS_IMPORT_TOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IMPORT_TOOL))
#define FOLKS_IS_IMPORT_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_IMPORT_TOOL))
#define FOLKS_IMPORT_TOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_IMPORT_TOOL, FolksImportToolClass))

typedef struct _FolksImportTool FolksImportTool;
typedef struct _FolksImportToolClass FolksImportToolClass;
typedef struct _FolksImportToolPrivate FolksImportToolPrivate;
enum  {
	FOLKS_IMPORT_TOOL_0_PROPERTY,
	FOLKS_IMPORT_TOOL_NUM_PROPERTIES
};
static GParamSpec* folks_import_tool_properties[FOLKS_IMPORT_TOOL_NUM_PROPERTIES];
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FOLKS_TYPE_IMPORTER (folks_importer_get_type ())
#define FOLKS_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IMPORTER, FolksImporter))
#define FOLKS_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_IMPORTER, FolksImporterClass))
#define FOLKS_IS_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IMPORTER))
#define FOLKS_IS_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_IMPORTER))
#define FOLKS_IMPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_IMPORTER, FolksImporterClass))

typedef struct _FolksImporter FolksImporter;
typedef struct _FolksImporterClass FolksImporterClass;

#define FOLKS_IMPORTERS_TYPE_PIDGIN (folks_importers_pidgin_get_type ())
#define FOLKS_IMPORTERS_PIDGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidgin))
#define FOLKS_IMPORTERS_PIDGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidginClass))
#define FOLKS_IMPORTERS_IS_PIDGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN))
#define FOLKS_IMPORTERS_IS_PIDGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_IMPORTERS_TYPE_PIDGIN))
#define FOLKS_IMPORTERS_PIDGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidginClass))

typedef struct _FolksImportersPidgin FolksImportersPidgin;
typedef struct _FolksImportersPidginClass FolksImportersPidginClass;

#define FOLKS_TYPE_IMPORT_ERROR (folks_import_error_get_type ())
typedef struct _FolksImportToolImportData FolksImportToolImportData;
typedef struct _FolksImporterPrivate FolksImporterPrivate;
enum  {
	FOLKS_IMPORTER_0_PROPERTY,
	FOLKS_IMPORTER_NUM_PROPERTIES
};
static GParamSpec* folks_importer_properties[FOLKS_IMPORTER_NUM_PROPERTIES];

struct _FolksImportTool {
	GObject parent_instance;
	FolksImportToolPrivate * priv;
};

struct _FolksImportToolClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* main_loop;
	gboolean success;
};

typedef enum  {
	FOLKS_IMPORT_ERROR_MALFORMED_INPUT
} FolksImportError;
#define FOLKS_IMPORT_ERROR folks_import_error_quark ()

struct _FolksImportToolImportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gboolean result;
	FolksBackendStore* backend_store;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* _tmp1_;
	GError* e1;
	FILE* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _tmp5_;
	const gchar* _tmp6_;
	FolksBackend* kf_backend;
	FolksBackendStore* _tmp7_;
	FolksBackend* _tmp8_;
	FolksBackend* _tmp9_;
	FILE* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	FolksBackend* _tmp13_;
	GError* e2;
	FILE* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	FolksPersonaStore* destination_store;
	GeeCollection* stores;
	FolksBackend* _tmp19_;
	GeeMap* _tmp20_;
	GeeMap* _tmp21_;
	GeeCollection* _tmp22_;
	GeeCollection* _tmp23_;
	GeeCollection* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	FILE* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GeeIterator* _persona_store_it;
	GeeCollection* _tmp30_;
	GeeIterator* _tmp31_;
	GeeIterator* _tmp32_;
	FolksPersonaStore* persona_store;
	GeeIterator* _tmp33_;
	gpointer _tmp34_;
	FolksPersonaStore* _tmp35_;
	FolksPersonaStore* _tmp36_;
	FolksPersonaStore* _tmp37_;
	GError* e3;
	FILE* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GError* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	FolksImporter* importer;
	FolksImportersPidgin* _tmp44_;
	FolksImporter* _tmp45_;
	FolksPersonaStore* _tmp46_;
	const gchar* _tmp47_;
	GError* e;
	FILE* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	GError* _tmp51_;
	const gchar* _tmp52_;
	FolksPersonaStore* _tmp53_;
	FILE* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	const gchar* _tmp57_;
	GError* _inner_error0_;
};

struct _FolksImporter {
	GObject parent_instance;
	FolksImporterPrivate * priv;
};

struct _FolksImporterClass {
	GObjectClass parent_class;
	void (*import) (FolksImporter* self, FolksPersonaStore* destination_store, const gchar* source_filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint (*import_finish) (FolksImporter* self, GAsyncResult* _res_, GError** error);
};

static gpointer folks_import_tool_parent_class = NULL;
static gchar* folks_import_tool_source;
static gchar* folks_import_tool_source_filename;
static gchar* folks_import_tool_source = NULL;
static gchar* folks_import_tool_source_filename = NULL;
static gpointer folks_importer_parent_class = NULL;

VALA_EXTERN GType folks_import_tool_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksImportTool, g_object_unref)
static gint folks_import_tool_main (gchar** args,
                             gint args_length1);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void folks_import_tool_import (GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
static gboolean folks_import_tool_import_finish (GAsyncResult* _res_);
static void __lambda4_ (Block1Data* _data1_,
                 GObject* o,
                 GAsyncResult* r);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void folks_import_tool_import_data_free (gpointer _data);
static gboolean folks_import_tool_import_co (FolksImportToolImportData* _data_);
static void folks_import_tool_import_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
VALA_EXTERN GType folks_importer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksImporter, g_object_unref)
VALA_EXTERN FolksImportersPidgin* folks_importers_pidgin_new (void);
VALA_EXTERN FolksImportersPidgin* folks_importers_pidgin_construct (GType object_type);
VALA_EXTERN GType folks_importers_pidgin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksImportersPidgin, g_object_unref)
VALA_EXTERN void folks_importer_import (FolksImporter* self,
                            FolksPersonaStore* destination_store,
                            const gchar* source_filename,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_);
VALA_EXTERN GQuark folks_import_error_quark (void);
GType folks_import_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint folks_importer_import_finish (FolksImporter* self,
                                    GAsyncResult* _res_,
                                    GError** error);
VALA_EXTERN FolksImportTool* folks_import_tool_new (void);
VALA_EXTERN FolksImportTool* folks_import_tool_construct (GType object_type);
static void folks_import_tool_finalize (GObject * obj);
static GType folks_import_tool_get_type_once (void);
VALA_EXTERN FolksImporter* folks_importer_construct (GType object_type);
static GType folks_importer_get_type_once (void);

static const GOptionEntry FOLKS_IMPORT_TOOL_options[3] = {{"source", 's', (gint) 0, G_OPTION_ARG_STRING, &folks_import_tool_source, N_ ("Source backend name (default: ‘pidgin’)"), "name"}, {"source-filename", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME, &folks_import_tool_source_filename, N_ ("Source filename (default: specific to source backend)"), NULL}, {NULL}};

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->main_loop);
		g_slice_free (Block1Data, _data1_);
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
__lambda4_ (Block1Data* _data1_,
            GObject* o,
            GAsyncResult* r)
{
	GMainLoop* _tmp0_;
	g_return_if_fail (r != NULL);
	_data1_->success = folks_import_tool_import_finish (r);
	_tmp0_ = _data1_->main_loop;
	g_main_loop_quit (_tmp0_);
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ (self, source_object, res);
	block1_data_unref (self);
}

static gint
folks_import_tool_main (gchar** args,
                        gint args_length1)
{
	Block1Data* _data1_;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	FolksIndividualAggregator* aggregator = NULL;
	FolksIndividualAggregator* _tmp16_;
	GMainLoop* _tmp17_;
	GMainLoop* _tmp18_;
	gint _tmp19_ = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new (_ ("— import meta-contact information to libfolks"));
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_add_main_entries (_tmp1_, FOLKS_IMPORT_TOOL_options, "folks");
	{
		GOptionContext* _tmp2_;
		_tmp2_ = context;
		g_option_context_parse (_tmp2_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp3_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (context);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = g_strconcat (_ ("Couldn’t parse command line options: %s"), "\n", NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp4_, _tmp6_, _tmp8_);
		_g_free0 (_tmp6_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp9_ = -1;
		_g_option_context_free0 (context);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp11_ = folks_import_tool_source;
	if (_tmp11_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = folks_import_tool_source;
		_tmp13_ = string_strip (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp10_ = g_strcmp0 (_tmp14_, "") == 0;
		_g_free0 (_tmp14_);
	}
	if (_tmp10_) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup (FOLKS_IMPORT_TOOL_DEFAULT_SOURCE);
		_g_free0 (folks_import_tool_source);
		folks_import_tool_source = _tmp15_;
	}
	_tmp16_ = folks_individual_aggregator_dup ();
	aggregator = _tmp16_;
	_g_object_unref0 (aggregator);
	aggregator = NULL;
	_tmp17_ = g_main_loop_new (NULL, FALSE);
	_data1_->main_loop = _tmp17_;
	_data1_->success = FALSE;
	folks_import_tool_import (___lambda4__gasync_ready_callback, block1_data_ref (_data1_));
	_tmp18_ = _data1_->main_loop;
	g_main_loop_run (_tmp18_);
	if (_data1_->success) {
		_tmp19_ = 0;
	} else {
		_tmp19_ = 1;
	}
	result = _tmp19_;
	_g_object_unref0 (aggregator);
	_g_option_context_free0 (context);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return folks_import_tool_main (argv, argc);
}

static void
folks_import_tool_import_data_free (gpointer _data)
{
	FolksImportToolImportData* _data_;
	_data_ = _data;
	g_slice_free (FolksImportToolImportData, _data_);
}

static void
folks_import_tool_import (GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	FolksImportToolImportData* _data_;
	_data_ = g_slice_new0 (FolksImportToolImportData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_import_tool_import_data_free);
	folks_import_tool_import_co (_data_);
}

static gboolean
folks_import_tool_import_finish (GAsyncResult* _res_)
{
	gboolean result;
	FolksImportToolImportData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
folks_import_tool_import_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	FolksImportToolImportData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_import_tool_import_co (_data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
folks_import_tool_import_co (FolksImportToolImportData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_backend_store_dup ();
	_data_->backend_store = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->backend_store;
		_data_->_state_ = 1;
		folks_backend_store_load_backends (_data_->_tmp1_, folks_import_tool_import_ready, _data_);
		return FALSE;
		_state_1:
		folks_backend_store_load_backends_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e1 = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = stderr;
		_data_->_tmp3_ = g_strconcat (_ ("Couldn’t load the backends: %s"), "\n", NULL);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = _data_->e1;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		fprintf (_data_->_tmp2_, _data_->_tmp4_, _data_->_tmp6_);
		_g_free0 (_data_->_tmp4_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->e1);
		_g_object_unref0 (_data_->backend_store);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->backend_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->backend_store;
	_data_->_tmp8_ = folks_backend_store_dup_backend_by_name (_data_->_tmp7_, "key-file");
	_data_->kf_backend = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->kf_backend;
	if (_data_->_tmp9_ == NULL) {
		_data_->_tmp10_ = stderr;
		_data_->_tmp11_ = g_strconcat (_ ("Couldn’t load the ‘%s’ backend."), "\n", NULL);
		_data_->_tmp12_ = _data_->_tmp11_;
		fprintf (_data_->_tmp10_, _data_->_tmp12_, "key-file");
		_g_free0 (_data_->_tmp12_);
		_data_->result = FALSE;
		_g_object_unref0 (_data_->kf_backend);
		_g_object_unref0 (_data_->backend_store);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp13_ = _data_->kf_backend;
		_data_->_state_ = 2;
		folks_backend_prepare (_data_->_tmp13_, folks_import_tool_import_ready, _data_);
		return FALSE;
		_state_2:
		folks_backend_prepare_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->e2 = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp14_ = stderr;
		_data_->_tmp15_ = g_strconcat (_ ("Couldn’t prepare the ‘%s’ backend: %s"), "\n", NULL);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = _data_->e2;
		_data_->_tmp18_ = _data_->_tmp17_->message;
		fprintf (_data_->_tmp14_, _data_->_tmp16_, "key-file", _data_->_tmp18_);
		_g_free0 (_data_->_tmp16_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->e2);
		_g_object_unref0 (_data_->kf_backend);
		_g_object_unref0 (_data_->backend_store);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->kf_backend);
		_g_object_unref0 (_data_->backend_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->destination_store = NULL;
	_data_->_tmp19_ = _data_->kf_backend;
	_data_->_tmp20_ = folks_backend_get_persona_stores (_data_->_tmp19_);
	_data_->_tmp21_ = _data_->_tmp20_;
	_data_->_tmp22_ = gee_map_get_values (_data_->_tmp21_);
	_data_->_tmp23_ = _data_->_tmp22_;
	_data_->stores = _data_->_tmp23_;
	_data_->_tmp24_ = _data_->stores;
	_data_->_tmp25_ = gee_collection_get_size (_data_->_tmp24_);
	_data_->_tmp26_ = _data_->_tmp25_;
	if (_data_->_tmp26_ == 0) {
		_data_->_tmp27_ = stderr;
		_data_->_tmp28_ = g_strconcat (_ ("Couldn’t load the ‘%s’ backend’s persona store."), "\n", NULL);
		_data_->_tmp29_ = _data_->_tmp28_;
		fprintf (_data_->_tmp27_, _data_->_tmp29_, "key-file");
		_g_free0 (_data_->_tmp29_);
		_data_->result = FALSE;
		_g_object_unref0 (_data_->stores);
		_g_object_unref0 (_data_->destination_store);
		_g_object_unref0 (_data_->kf_backend);
		_g_object_unref0 (_data_->backend_store);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		{
			_data_->_tmp30_ = _data_->stores;
			_data_->_tmp31_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp30_);
			_data_->_persona_store_it = _data_->_tmp31_;
			while (TRUE) {
				_data_->_tmp32_ = _data_->_persona_store_it;
				if (!gee_iterator_next (_data_->_tmp32_)) {
					break;
				}
				_data_->_tmp33_ = _data_->_persona_store_it;
				_data_->_tmp34_ = gee_iterator_get (_data_->_tmp33_);
				_data_->persona_store = (FolksPersonaStore*) _data_->_tmp34_;
				_data_->_tmp35_ = _data_->persona_store;
				_data_->_tmp36_ = _g_object_ref0 (_data_->_tmp35_);
				_g_object_unref0 (_data_->destination_store);
				_data_->destination_store = _data_->_tmp36_;
				_g_object_unref0 (_data_->persona_store);
				break;
			}
			_g_object_unref0 (_data_->_persona_store_it);
		}
		_data_->_tmp37_ = _data_->destination_store;
		_data_->_state_ = 3;
		folks_persona_store_prepare (_data_->_tmp37_, folks_import_tool_import_ready, _data_);
		return FALSE;
		_state_3:
		folks_persona_store_prepare_finish (_data_->_tmp37_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->e3 = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp38_ = stderr;
		_data_->_tmp39_ = g_strconcat (_ ("Couldn’t prepare the ‘%s’ backend’s persona store: %s"), "\n", NULL);
		_data_->_tmp40_ = _data_->_tmp39_;
		_data_->_tmp41_ = _data_->e3;
		_data_->_tmp42_ = _data_->_tmp41_->message;
		fprintf (_data_->_tmp38_, _data_->_tmp40_, _data_->_tmp42_);
		_g_free0 (_data_->_tmp40_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->e3);
		_g_object_unref0 (_data_->stores);
		_g_object_unref0 (_data_->destination_store);
		_g_object_unref0 (_data_->kf_backend);
		_g_object_unref0 (_data_->backend_store);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->stores);
		_g_object_unref0 (_data_->destination_store);
		_g_object_unref0 (_data_->kf_backend);
		_g_object_unref0 (_data_->backend_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp43_ = folks_import_tool_source;
	if (g_strcmp0 (_data_->_tmp43_, "pidgin") == 0) {
		_data_->_tmp44_ = folks_importers_pidgin_new ();
		_data_->importer = (FolksImporter*) _data_->_tmp44_;
		{
			_data_->_tmp45_ = _data_->importer;
			_data_->_tmp46_ = _data_->destination_store;
			_data_->_tmp47_ = folks_import_tool_source_filename;
			_data_->_state_ = 4;
			folks_importer_import (_data_->_tmp45_, _data_->_tmp46_, _data_->_tmp47_, folks_import_tool_import_ready, _data_);
			return FALSE;
			_state_4:
			folks_importer_import_finish (_data_->_tmp45_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == FOLKS_IMPORT_ERROR) {
					goto __catch3_folks_import_error;
				}
				_g_object_unref0 (_data_->importer);
				_g_object_unref0 (_data_->stores);
				_g_object_unref0 (_data_->destination_store);
				_g_object_unref0 (_data_->kf_backend);
				_g_object_unref0 (_data_->backend_store);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		goto __finally3;
		__catch3_folks_import_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp48_ = stderr;
			_data_->_tmp49_ = g_strconcat (_ ("Error importing contacts: %s"), "\n", NULL);
			_data_->_tmp50_ = _data_->_tmp49_;
			_data_->_tmp51_ = _data_->e;
			_data_->_tmp52_ = _data_->_tmp51_->message;
			fprintf (_data_->_tmp48_, _data_->_tmp50_, _data_->_tmp52_);
			_g_free0 (_data_->_tmp50_);
			_data_->result = FALSE;
			_g_error_free0 (_data_->e);
			_g_object_unref0 (_data_->importer);
			_g_object_unref0 (_data_->stores);
			_g_object_unref0 (_data_->destination_store);
			_g_object_unref0 (_data_->kf_backend);
			_g_object_unref0 (_data_->backend_store);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally3:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->importer);
			_g_object_unref0 (_data_->stores);
			_g_object_unref0 (_data_->destination_store);
			_g_object_unref0 (_data_->kf_backend);
			_g_object_unref0 (_data_->backend_store);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp53_ = _data_->destination_store;
		_data_->_state_ = 5;
		folks_persona_store_flush (_data_->_tmp53_, folks_import_tool_import_ready, _data_);
		return FALSE;
		_state_5:
		folks_persona_store_flush_finish (_data_->_tmp53_, _data_->_res_);
		_data_->result = TRUE;
		_g_object_unref0 (_data_->importer);
		_g_object_unref0 (_data_->stores);
		_g_object_unref0 (_data_->destination_store);
		_g_object_unref0 (_data_->kf_backend);
		_g_object_unref0 (_data_->backend_store);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp54_ = stderr;
		_data_->_tmp55_ = g_strconcat (_ ("Unrecognized source backend name ‘%s’. ‘%s’ is currently the only supp" \
"orted source backend."), "\n", NULL);
		_data_->_tmp56_ = _data_->_tmp55_;
		_data_->_tmp57_ = folks_import_tool_source;
		fprintf (_data_->_tmp54_, _data_->_tmp56_, _data_->_tmp57_, "pidgin");
		_g_free0 (_data_->_tmp56_);
		_data_->result = FALSE;
		_g_object_unref0 (_data_->stores);
		_g_object_unref0 (_data_->destination_store);
		_g_object_unref0 (_data_->kf_backend);
		_g_object_unref0 (_data_->backend_store);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

FolksImportTool*
folks_import_tool_construct (GType object_type)
{
	FolksImportTool * self = NULL;
	self = (FolksImportTool*) g_object_new (object_type, NULL);
	return self;
}

FolksImportTool*
folks_import_tool_new (void)
{
	return folks_import_tool_construct (FOLKS_TYPE_IMPORT_TOOL);
}

static void
folks_import_tool_class_init (FolksImportToolClass * klass,
                              gpointer klass_data)
{
	folks_import_tool_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = folks_import_tool_finalize;
}

static void
folks_import_tool_instance_init (FolksImportTool * self,
                                 gpointer klass)
{
}

static void
folks_import_tool_finalize (GObject * obj)
{
	FolksImportTool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_IMPORT_TOOL, FolksImportTool);
	G_OBJECT_CLASS (folks_import_tool_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
folks_import_tool_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksImportToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_import_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksImportTool), 0, (GInstanceInitFunc) folks_import_tool_instance_init, NULL };
	GType folks_import_tool_type_id;
	folks_import_tool_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksImportTool", &g_define_type_info, 0);
	return folks_import_tool_type_id;
}

GType
folks_import_tool_get_type (void)
{
	static volatile gsize folks_import_tool_type_id__once = 0;
	if (g_once_init_enter (&folks_import_tool_type_id__once)) {
		GType folks_import_tool_type_id;
		folks_import_tool_type_id = folks_import_tool_get_type_once ();
		g_once_init_leave (&folks_import_tool_type_id__once, folks_import_tool_type_id);
	}
	return folks_import_tool_type_id__once;
}

GQuark
folks_import_error_quark (void)
{
	return g_quark_from_static_string ("folks-import-error-quark");
}

 G_GNUC_NO_INLINE static GType
folks_import_error_get_type_once (void)
{
	static const GEnumValue values[] = {{FOLKS_IMPORT_ERROR_MALFORMED_INPUT, "FOLKS_IMPORT_ERROR_MALFORMED_INPUT", "malformed-input"}, {0, NULL, NULL}};
	GType folks_import_error_type_id;
	folks_import_error_type_id = g_enum_register_static ("FolksImportError", values);
	return folks_import_error_type_id;
}

GType
folks_import_error_get_type (void)
{
	static volatile gsize folks_import_error_type_id__once = 0;
	if (g_once_init_enter (&folks_import_error_type_id__once)) {
		GType folks_import_error_type_id;
		folks_import_error_type_id = folks_import_error_get_type_once ();
		g_once_init_leave (&folks_import_error_type_id__once, folks_import_error_type_id);
	}
	return folks_import_error_type_id__once;
}

void
folks_importer_import (FolksImporter* self,
                       FolksPersonaStore* destination_store,
                       const gchar* source_filename,
                       GAsyncReadyCallback _callback_,
                       gpointer _user_data_)
{
	FolksImporterClass* _klass_;
	_klass_ = FOLKS_IMPORTER_GET_CLASS (self);
	if (_klass_->import) {
		_klass_->import (self, destination_store, source_filename, _callback_, _user_data_);
	}
}

guint
folks_importer_import_finish (FolksImporter* self,
                              GAsyncResult* _res_,
                              GError** error)
{
	FolksImporterClass* _klass_;
	_klass_ = FOLKS_IMPORTER_GET_CLASS (self);
	if (_klass_->import_finish) {
		return _klass_->import_finish (self, _res_, error);
	}
	return 0U;
}

FolksImporter*
folks_importer_construct (GType object_type)
{
	FolksImporter * self = NULL;
	self = (FolksImporter*) g_object_new (object_type, NULL);
	return self;
}

static void
folks_importer_class_init (FolksImporterClass * klass,
                           gpointer klass_data)
{
	folks_importer_parent_class = g_type_class_peek_parent (klass);
}

static void
folks_importer_instance_init (FolksImporter * self,
                              gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
folks_importer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksImporterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_importer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksImporter), 0, (GInstanceInitFunc) folks_importer_instance_init, NULL };
	GType folks_importer_type_id;
	folks_importer_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksImporter", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return folks_importer_type_id;
}

GType
folks_importer_get_type (void)
{
	static volatile gsize folks_importer_type_id__once = 0;
	if (g_once_init_enter (&folks_importer_type_id__once)) {
		GType folks_importer_type_id;
		folks_importer_type_id = folks_importer_get_type_once ();
		g_once_init_leave (&folks_importer_type_id__once, folks_importer_type_id);
	}
	return folks_importer_type_id__once;
}

