/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.named.support;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.FileLockNamedLock$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.FileLockNamedLock$$Lambda$1;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.FileLockNamedLock$$Lambda$2;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.FileLockNamedLock$$Lambda$3;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.FileLockNamedLock$$Lambda$4;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.FileLockNamedLock$$Lambda$5;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.FileLockNamedLock$$Lambda$6;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.FileLockNamedLock$$Lambda$7;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.NamedLockFactorySupport;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.NamedLockSupport;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.Retry;

public final class FileLockNamedLock
extends NamedLockSupport {
    private final Map<Thread, Deque<Boolean>> threadSteps = new HashMap<Thread, Deque<Boolean>>();
    private final FileChannel fileChannel;
    private final AtomicReference<FileLock> fileLockRef;
    private final ReentrantLock criticalRegion;

    public FileLockNamedLock(String name, FileChannel fileChannel, NamedLockFactorySupport factory) {
        super(name, factory);
        this.fileChannel = fileChannel;
        this.fileLockRef = new AtomicReference<Object>(null);
        this.criticalRegion = new ReentrantLock();
    }

    @Override
    public boolean lockShared(long time, TimeUnit unit) throws InterruptedException {
        FileLockNamedLock fileLockNamedLock = this;
        return Retry.retry(time, unit, 100L, new FileLockNamedLock$$Lambda$0(fileLockNamedLock), null, false);
    }

    @Override
    public boolean lockExclusively(long time, TimeUnit unit) throws InterruptedException {
        FileLockNamedLock fileLockNamedLock = this;
        return Retry.retry(time, unit, 100L, new FileLockNamedLock$$Lambda$1(fileLockNamedLock), null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean doLockShared() {
        if (this.criticalRegion.tryLock()) {
            try {
                Deque<Boolean> steps = this.threadSteps.computeIfAbsent(Thread.currentThread(), FileLockNamedLock$$Lambda$2.INSTANCE);
                FileLock obtainedLock = this.fileLockRef.get();
                if (obtainedLock != null) {
                    if (obtainedLock.isShared()) {
                        this.logger.trace("{} lock (shared={})", (Object)this.name(), (Object)true);
                        steps.push(Boolean.TRUE);
                        Boolean bl = true;
                        return bl;
                    }
                    boolean weOwnExclusive = steps.contains(Boolean.FALSE);
                    if (weOwnExclusive) {
                        this.logger.trace("{} lock (shared={})", (Object)this.name(), (Object)true);
                        steps.push(Boolean.TRUE);
                        Boolean bl = true;
                        return bl;
                    }
                    Boolean bl = null;
                    return bl;
                }
                this.logger.trace("{} no obtained lock: obtain shared file lock", (Object)this.name());
                FileLock fileLock = this.obtainFileLock(true);
                if (fileLock != null) {
                    this.fileLockRef.set(fileLock);
                    steps.push(Boolean.TRUE);
                    Boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.criticalRegion.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean doLockExclusively() {
        if (this.criticalRegion.tryLock()) {
            try {
                Deque<Boolean> steps = this.threadSteps.computeIfAbsent(Thread.currentThread(), FileLockNamedLock$$Lambda$3.INSTANCE);
                FileLock obtainedLock = this.fileLockRef.get();
                if (obtainedLock != null) {
                    if (obtainedLock.isShared()) {
                        boolean weOwnShared = steps.contains(Boolean.TRUE);
                        if (weOwnShared) {
                            this.logger.trace("{} steps not empty, has not exclusive lock: lock-upgrade not supported", (Object)this.name());
                            Boolean bl = false;
                            return bl;
                        }
                        Boolean bl = null;
                        return bl;
                    }
                    boolean weOwnExclusive = steps.contains(Boolean.FALSE);
                    if (weOwnExclusive) {
                        this.logger.trace("{} lock (shared={})", (Object)this.name(), (Object)false);
                        steps.push(Boolean.FALSE);
                        Boolean bl = true;
                        return bl;
                    }
                    Boolean bl = null;
                    return bl;
                }
                this.logger.trace("{} no obtained lock: obtain exclusive file lock", (Object)this.name());
                FileLock fileLock = this.obtainFileLock(false);
                if (fileLock != null) {
                    this.fileLockRef.set(fileLock);
                    steps.push(Boolean.FALSE);
                    Boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.criticalRegion.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        block6: {
            this.criticalRegion.lock();
            try {
                Deque<Boolean> steps = this.threadSteps.computeIfAbsent(Thread.currentThread(), FileLockNamedLock$$Lambda$4.INSTANCE);
                if (steps.isEmpty()) {
                    throw new IllegalStateException("Wrong API usage: unlock without lock");
                }
                Boolean shared = steps.pop();
                this.logger.trace("{} unlock (shared = {})", (Object)this.name(), (Object)shared);
                if (!steps.isEmpty() || this.anyOtherThreadHasSteps()) break block6;
                try {
                    ((FileLock)this.fileLockRef.getAndSet(null)).release();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            finally {
                this.criticalRegion.unlock();
            }
        }
    }

    private boolean anyOtherThreadHasSteps() {
        return this.threadSteps.entrySet().stream().filter(FileLockNamedLock$$Lambda$5.INSTANCE).map(FileLockNamedLock$$Lambda$6.INSTANCE).anyMatch(FileLockNamedLock$$Lambda$7.INSTANCE);
    }

    private FileLock obtainFileLock(boolean shared) {
        FileLock result;
        try {
            result = this.fileChannel.tryLock(0L, 1L, shared);
        }
        catch (OverlappingFileLockException e) {
            this.logger.trace("File lock overlap on '{}'", (Object)this.name(), (Object)e);
            return null;
        }
        catch (IOException e) {
            this.logger.trace("Failure on acquire of file lock for '{}'", (Object)this.name(), (Object)e);
            throw new UncheckedIOException("Failed to acquire lock file channel for '" + this.name() + "'", e);
        }
        return result;
    }

    private static /* synthetic */ boolean lambda$anyOtherThreadHasSteps$4(Deque d) {
        return !d.isEmpty();
    }

    private static /* synthetic */ boolean lambda$anyOtherThreadHasSteps$3(Map.Entry e) {
        return !Thread.currentThread().equals(e.getKey());
    }

    private static /* synthetic */ Deque lambda$unlock$2(Thread k) {
        return new ArrayDeque();
    }

    private static /* synthetic */ Deque lambda$doLockExclusively$1(Thread k) {
        return new ArrayDeque();
    }

    private static /* synthetic */ Deque lambda$doLockShared$0(Thread k) {
        return new ArrayDeque();
    }

    static /* synthetic */ Boolean accessor$FileLockNamedLock$lambda0(FileLockNamedLock fileLockNamedLock) {
        return fileLockNamedLock.doLockShared();
    }

    static /* synthetic */ Boolean accessor$FileLockNamedLock$lambda1(FileLockNamedLock fileLockNamedLock) {
        return fileLockNamedLock.doLockExclusively();
    }

    static /* synthetic */ Deque accessor$FileLockNamedLock$lambda2(Thread thread) {
        return FileLockNamedLock.lambda$doLockShared$0(thread);
    }

    static /* synthetic */ Deque accessor$FileLockNamedLock$lambda3(Thread thread) {
        return FileLockNamedLock.lambda$doLockExclusively$1(thread);
    }

    static /* synthetic */ Deque accessor$FileLockNamedLock$lambda4(Thread thread) {
        return FileLockNamedLock.lambda$unlock$2(thread);
    }

    static /* synthetic */ boolean accessor$FileLockNamedLock$lambda5(Map.Entry entry) {
        return FileLockNamedLock.lambda$anyOtherThreadHasSteps$3(entry);
    }

    static /* synthetic */ boolean accessor$FileLockNamedLock$lambda7(Deque deque) {
        return FileLockNamedLock.lambda$anyOtherThreadHasSteps$4(deque);
    }
}

