/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColors;

class ExtremityDiamond
extends Extremity {
    private UPolygon polygon = new UPolygon();
    private final boolean fill;
    private final XPoint2D contact;
    private final UTranslate deltaForKal;

    @Override
    public XPoint2D somePoint() {
        return this.contact;
    }

    public ExtremityDiamond(XPoint2D p1, double angle, boolean fill) {
        this.fill = fill;
        this.contact = new XPoint2D(p1.getX(), p1.getY());
        angle = this.manageround(angle);
        this.polygon.addPoint(0.0, 0.0);
        int xWing = 6;
        int yAperture = 4;
        this.polygon.addPoint(-6.0, -4.0);
        this.polygon.addPoint(-12.0, 0.0);
        this.polygon.addPoint(-6.0, 4.0);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.rotate(angle + 1.5707963267948966);
        this.deltaForKal = new UTranslate(this.polygon.getPoint(2)).reverse();
        this.polygon = this.polygon.translate(p1.getX(), p1.getY());
    }

    @Override
    public UTranslate getDeltaForKal() {
        return this.deltaForKal;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = this.fill ? ug.apply(HColors.changeBack(ug)) : ug.apply(HColors.none().bg());
        ug.draw(this.polygon);
    }

    @Override
    public XPoint2D isTooSmallSoGiveThePointCloserToThisOne(XPoint2D pt) {
        XPoint2D result = null;
        for (XPoint2D p : this.polygon.getPoints()) {
            if (result != null && !(p.distance(pt) < result.distance(pt))) continue;
            result = p;
        }
        return result;
    }
}

