/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;
import net.sourceforge.plantuml.ugraphic.svg.DriverRectangleSvg;

public class DriverPathSvg
extends DriverShadowedG2d
implements UDriver<UPath, SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverPathSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UPath shape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        UClip clip = this.clipContainer.getClip();
        if (clip != null && !clip.isInside(x, y, shape)) {
            return;
        }
        if (shape.isOpenIconic()) {
            HColor color = param.getColor();
            svg.setFillColor(color.toSvg(mapper));
            svg.setStrokeColor("");
            svg.setStrokeWidth(0.0, "");
        } else {
            DriverRectangleSvg.applyFillColor(svg, mapper, param);
            DriverRectangleSvg.applyStrokeColor(svg, mapper, param);
            svg.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDasharraySvg());
        }
        svg.svgPath(x, y, shape, shape.getDeltaShadow());
    }
}

