/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.list;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionListener;

public abstract class MListButton {
    private String name;
    private Color rollOverColor;
    private ActionListener actionListener;
    private Rectangle bounds = new Rectangle();
    private Object rowObject;

    protected MListButton(String name, Color rollOverColor, ActionListener listener) {
        this.name = name;
        this.rollOverColor = rollOverColor;
        this.actionListener = listener;
        if (listener == null) {
            this.actionListener = e -> {};
        }
    }

    protected MListButton(String name, Color rollOverColor) {
        this(name, rollOverColor, null);
    }

    protected int getSizeMultiple() {
        return 2;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public String getName() {
        return this.name;
    }

    public Object getRowObject() {
        return this.rowObject;
    }

    public void setRowObject(Object rowObject) {
        this.rowObject = rowObject;
    }

    public Color getRollOverColor() {
        return this.rollOverColor;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    @Deprecated
    public void setBounds(Rectangle bounds) {
        this.bounds = new Rectangle(bounds);
    }

    public void setLocation(int x, int y) {
        this.bounds.x = x;
        this.bounds.y = y;
    }

    public void setSize(int size) {
        int normalisedSize;
        this.bounds.width = normalisedSize = Math.round((float)(size / this.getSizeMultiple()) * 1.0f) * this.getSizeMultiple();
        this.bounds.height = normalisedSize;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Color getBackground() {
        return Color.LIGHT_GRAY;
    }

    public abstract void paintButtonContent(Graphics2D var1);
}

