/* persona-store.c generated by valac 0.56.0, the Vala compiler
 * generated from persona-store.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include "folks/folks.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include "folks-internal.h"

enum  {
	FOLKS_PERSONA_STORE_0_PROPERTY,
	FOLKS_PERSONA_STORE_TYPE_ID_PROPERTY,
	FOLKS_PERSONA_STORE_DISPLAY_NAME_PROPERTY,
	FOLKS_PERSONA_STORE_ID_PROPERTY,
	FOLKS_PERSONA_STORE_PERSONAS_PROPERTY,
	FOLKS_PERSONA_STORE_CAN_ADD_PERSONAS_PROPERTY,
	FOLKS_PERSONA_STORE_CAN_ALIAS_PERSONAS_PROPERTY,
	FOLKS_PERSONA_STORE_CAN_GROUP_PERSONAS_PROPERTY,
	FOLKS_PERSONA_STORE_CAN_REMOVE_PERSONAS_PROPERTY,
	FOLKS_PERSONA_STORE_IS_PREPARED_PROPERTY,
	FOLKS_PERSONA_STORE_IS_QUIESCENT_PROPERTY,
	FOLKS_PERSONA_STORE_IS_WRITEABLE_PROPERTY,
	FOLKS_PERSONA_STORE_TRUST_LEVEL_PROPERTY,
	FOLKS_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES_PROPERTY,
	FOLKS_PERSONA_STORE_IS_PRIMARY_STORE_PROPERTY,
	FOLKS_PERSONA_STORE_IS_USER_SET_DEFAULT_PROPERTY,
	FOLKS_PERSONA_STORE_NUM_PROPERTIES
};
static GParamSpec* folks_persona_store_properties[FOLKS_PERSONA_STORE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksPersonaStoreFlushData FolksPersonaStoreFlushData;
enum  {
	FOLKS_PERSONA_STORE_PERSONAS_CHANGED_SIGNAL,
	FOLKS_PERSONA_STORE_REMOVED_SIGNAL,
	FOLKS_PERSONA_STORE_NUM_SIGNALS
};
static guint folks_persona_store_signals[FOLKS_PERSONA_STORE_NUM_SIGNALS] = {0};

/**
 * Errors from {@link PersonaStore}s.
 */
struct _FolksPersonaStorePrivate {
	gchar* _display_name;
	gchar* _id;
	gboolean _is_writeable;
	FolksPersonaStoreTrust _trust_level;
	gboolean _is_primary_store;
	gboolean _is_user_set_default;
};

struct _FolksPersonaStoreFlushData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksPersonaStore* self;
};

static gint FolksPersonaStore_private_offset;
static gpointer folks_persona_store_parent_class = NULL;

static void folks_persona_store_real_flush_data_free (gpointer _data);
static void folks_persona_store_real_flush (FolksPersonaStore* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static gboolean folks_persona_store_real_flush_co (FolksPersonaStoreFlushData* _data_);
VALA_EXTERN void folks_persona_store_set_is_primary_store (FolksPersonaStore* self,
                                               gboolean value);
VALA_EXTERN void folks_persona_store_set_is_user_set_default (FolksPersonaStore* self,
                                                  gboolean value);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM (GClosure * closure,
                                                                     GValue * return_value,
                                                                     guint n_param_values,
                                                                     const GValue * param_values,
                                                                     gpointer invocation_hint,
                                                                     gpointer marshal_data);
static GObject * folks_persona_store_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void folks_persona_store_finalize (GObject * obj);
static GType folks_persona_store_get_type_once (void);
static void _vala_folks_persona_store_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_folks_persona_store_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const gchar* FOLKS_PERSONA_STORE__PERSONA_DETAIL[25] = {"alias", "avatar", "birthday", "email-addresses", "full-name", "gender", "im-addresses", "is-favourite", "local-ids", "location", "nickname", "notes", "phone-numbers", "postal-addresses", "roles", "structured-name", "urls", "web-service-addresses", "groups", "im-interaction-count", "last-im-interaction-datetime", "call-interaction-count", "last-call-interaction-datetime", "anti-links", "extended-info"};

/**
 * Trust level for a {@link PersonaStore}'s {@link Persona}s for linking
 * purposes.
 *
 * Trust levels are set internally by the backends, and must not be modified by
 * clients.
 *
 * @since 0.1.13
 */
static GType
folks_persona_store_trust_get_type_once (void)
{
	static const GEnumValue values[] = {{FOLKS_PERSONA_STORE_TRUST_NONE, "FOLKS_PERSONA_STORE_TRUST_NONE", "none"}, {FOLKS_PERSONA_STORE_TRUST_PARTIAL, "FOLKS_PERSONA_STORE_TRUST_PARTIAL", "partial"}, {FOLKS_PERSONA_STORE_TRUST_FULL, "FOLKS_PERSONA_STORE_TRUST_FULL", "full"}, {0, NULL, NULL}};
	GType folks_persona_store_trust_type_id;
	folks_persona_store_trust_type_id = g_enum_register_static ("FolksPersonaStoreTrust", values);
	return folks_persona_store_trust_type_id;
}

GType
folks_persona_store_trust_get_type (void)
{
	static volatile gsize folks_persona_store_trust_type_id__once = 0;
	if (g_once_init_enter (&folks_persona_store_trust_type_id__once)) {
		GType folks_persona_store_trust_type_id;
		folks_persona_store_trust_type_id = folks_persona_store_trust_get_type_once ();
		g_once_init_leave (&folks_persona_store_trust_type_id__once, folks_persona_store_trust_type_id);
	}
	return folks_persona_store_trust_type_id__once;
}

GQuark
folks_persona_store_error_quark (void)
{
	return g_quark_from_static_string ("folks-persona-store-error-quark");
}

static GType
folks_persona_store_error_get_type_once (void)
{
	static const GEnumValue values[] = {{FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT, "FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT", "invalid-argument"}, {FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED, "FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED", "create-failed"}, {FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_USER, "FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_USER", "unsupported-on-user"}, {FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, "FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE", "store-offline"}, {FOLKS_PERSONA_STORE_ERROR_READ_ONLY, "FOLKS_PERSONA_STORE_ERROR_READ_ONLY", "read-only"}, {FOLKS_PERSONA_STORE_ERROR_PERMISSION_DENIED, "FOLKS_PERSONA_STORE_ERROR_PERMISSION_DENIED", "permission-denied"}, {FOLKS_PERSONA_STORE_ERROR_REMOVE_FAILED, "FOLKS_PERSONA_STORE_ERROR_REMOVE_FAILED", "remove-failed"}, {FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_NON_USER, "FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_NON_USER", "unsupported-on-non-user"}, {0, NULL, NULL}};
	GType folks_persona_store_error_type_id;
	folks_persona_store_error_type_id = g_enum_register_static ("FolksPersonaStoreError", values);
	return folks_persona_store_error_type_id;
}

GType
folks_persona_store_error_get_type (void)
{
	static volatile gsize folks_persona_store_error_type_id__once = 0;
	if (g_once_init_enter (&folks_persona_store_error_type_id__once)) {
		GType folks_persona_store_error_type_id;
		folks_persona_store_error_type_id = folks_persona_store_error_get_type_once ();
		g_once_init_leave (&folks_persona_store_error_type_id__once, folks_persona_store_error_type_id);
	}
	return folks_persona_store_error_type_id__once;
}

/**
 * Definition of the available fields to be looked up with
 * {@link PersonaStore.detail_key}.
 *
 * @since 0.5.0
 */
static GType
folks_persona_detail_get_type_once (void)
{
	static const GEnumValue values[] = {{FOLKS_PERSONA_DETAIL_INVALID, "FOLKS_PERSONA_DETAIL_INVALID", "invalid"}, {FOLKS_PERSONA_DETAIL_ALIAS, "FOLKS_PERSONA_DETAIL_ALIAS", "alias"}, {FOLKS_PERSONA_DETAIL_AVATAR, "FOLKS_PERSONA_DETAIL_AVATAR", "avatar"}, {FOLKS_PERSONA_DETAIL_BIRTHDAY, "FOLKS_PERSONA_DETAIL_BIRTHDAY", "birthday"}, {FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES, "FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES", "email-addresses"}, {FOLKS_PERSONA_DETAIL_FULL_NAME, "FOLKS_PERSONA_DETAIL_FULL_NAME", "full-name"}, {FOLKS_PERSONA_DETAIL_GENDER, "FOLKS_PERSONA_DETAIL_GENDER", "gender"}, {FOLKS_PERSONA_DETAIL_IM_ADDRESSES, "FOLKS_PERSONA_DETAIL_IM_ADDRESSES", "im-addresses"}, {FOLKS_PERSONA_DETAIL_IS_FAVOURITE, "FOLKS_PERSONA_DETAIL_IS_FAVOURITE", "is-favourite"}, {FOLKS_PERSONA_DETAIL_LOCAL_IDS, "FOLKS_PERSONA_DETAIL_LOCAL_IDS", "local-ids"}, {FOLKS_PERSONA_DETAIL_LOCATION, "FOLKS_PERSONA_DETAIL_LOCATION", "location"}, {FOLKS_PERSONA_DETAIL_NICKNAME, "FOLKS_PERSONA_DETAIL_NICKNAME", "nickname"}, {FOLKS_PERSONA_DETAIL_NOTES, "FOLKS_PERSONA_DETAIL_NOTES", "notes"}, {FOLKS_PERSONA_DETAIL_PHONE_NUMBERS, "FOLKS_PERSONA_DETAIL_PHONE_NUMBERS", "phone-numbers"}, {FOLKS_PERSONA_DETAIL_POSTAL_ADDRESSES, "FOLKS_PERSONA_DETAIL_POSTAL_ADDRESSES", "postal-addresses"}, {FOLKS_PERSONA_DETAIL_ROLES, "FOLKS_PERSONA_DETAIL_ROLES", "roles"}, {FOLKS_PERSONA_DETAIL_STRUCTURED_NAME, "FOLKS_PERSONA_DETAIL_STRUCTURED_NAME", "structured-name"}, {FOLKS_PERSONA_DETAIL_URLS, "FOLKS_PERSONA_DETAIL_URLS", "urls"}, {FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES, "FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES", "web-service-addresses"}, {FOLKS_PERSONA_DETAIL_GROUPS, "FOLKS_PERSONA_DETAIL_GROUPS", "groups"}, {FOLKS_PERSONA_DETAIL_IM_INTERACTION_COUNT, "FOLKS_PERSONA_DETAIL_IM_INTERACTION_COUNT", "im-interaction-count"}, {FOLKS_PERSONA_DETAIL_LAST_IM_INTERACTION_DATETIME, "FOLKS_PERSONA_DETAIL_LAST_IM_INTERACTION_DATETIME", "last-im-interaction-datetime"}, {FOLKS_PERSONA_DETAIL_CALL_INTERACTION_COUNT, "FOLKS_PERSONA_DETAIL_CALL_INTERACTION_COUNT", "call-interaction-count"}, {FOLKS_PERSONA_DETAIL_LAST_CALL_INTERACTION_DATETIME, "FOLKS_PERSONA_DETAIL_LAST_CALL_INTERACTION_DATETIME", "last-call-interaction-datetime"}, {FOLKS_PERSONA_DETAIL_ANTI_LINKS, "FOLKS_PERSONA_DETAIL_ANTI_LINKS", "anti-links"}, {FOLKS_PERSONA_DETAIL_EXTENDED_INFO, "FOLKS_PERSONA_DETAIL_EXTENDED_INFO", "extended-info"}, {0, NULL, NULL}};
	GType folks_persona_detail_type_id;
	folks_persona_detail_type_id = g_enum_register_static ("FolksPersonaDetail", values);
	return folks_persona_detail_type_id;
}

GType
folks_persona_detail_get_type (void)
{
	static volatile gsize folks_persona_detail_type_id__once = 0;
	if (g_once_init_enter (&folks_persona_detail_type_id__once)) {
		GType folks_persona_detail_type_id;
		folks_persona_detail_type_id = folks_persona_detail_get_type_once ();
		g_once_init_leave (&folks_persona_detail_type_id__once, folks_persona_detail_type_id);
	}
	return folks_persona_detail_type_id__once;
}

static inline gpointer
folks_persona_store_get_instance_private (FolksPersonaStore* self)
{
	return G_STRUCT_MEMBER_P (self, FolksPersonaStore_private_offset);
}

/**
   * Returns the key corresponding to @detail, for use in
   * the details param of {@link PersonaStore.add_persona_from_details}.
   *
   * @param detail the {@link PersonaDetail} to lookup
   * @return the corresponding property name, or ``null`` if ``detail`` is
   * invalid
   *
   * @since 0.5.0
   */
const gchar*
folks_persona_store_detail_key (FolksPersonaDetail detail)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* result;
	if (detail == FOLKS_PERSONA_DETAIL_INVALID) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = detail >= G_N_ELEMENTS (FOLKS_PERSONA_STORE__PERSONA_DETAIL);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = FOLKS_PERSONA_STORE__PERSONA_DETAIL[detail];
	result = _tmp1_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
_folks_persona_store_emit_personas_changed (FolksPersonaStore* self,
                                            GeeSet* added,
                                            GeeSet* removed,
                                            const gchar* message,
                                            FolksPersona* actor,
                                            FolksGroupDetailsChangeReason reason)
{
	GeeSet* _added = NULL;
	GeeSet* _tmp0_;
	GeeSet* _removed = NULL;
	GeeSet* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp11_;
	GeeSet* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GeeSet* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GeeSet* _tmp18_;
	GeeSet* _tmp19_;
	GeeSet* _tmp20_;
	GeeSet* _tmp21_;
	GeeSet* _tmp22_;
	GeeSet* _tmp23_;
	GeeSet* _tmp24_;
	GeeSet* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (added);
	_added = _tmp0_;
	_tmp1_ = _g_object_ref0 (removed);
	_removed = _tmp1_;
	if (added == NULL) {
		_tmp3_ = TRUE;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_SET, GeeSet));
		_tmp5_ = _tmp4_;
		_tmp3_ = _tmp5_ == 0;
	}
	if (_tmp3_) {
		gboolean _tmp6_ = FALSE;
		if (removed == NULL) {
			_tmp6_ = TRUE;
		} else {
			gint _tmp7_;
			gint _tmp8_;
			_tmp7_ = gee_collection_get_size ((GeeCollection*) G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_SET, GeeSet));
			_tmp8_ = _tmp7_;
			_tmp6_ = _tmp8_ == 0;
		}
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_g_object_unref0 (_removed);
		_g_object_unref0 (_added);
		return;
	} else {
		if (added == NULL) {
			GeeHashSet* _tmp9_;
			_tmp9_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
			_g_object_unref0 (_added);
			_added = (GeeSet*) _tmp9_;
		} else {
			if (removed == NULL) {
				GeeHashSet* _tmp10_;
				_tmp10_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
				_g_object_unref0 (_removed);
				_removed = (GeeSet*) _tmp10_;
			}
		}
	}
	_tmp11_ = self->priv->_id;
	_tmp12_ = _added;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _removed;
	_tmp16_ = gee_collection_get_size ((GeeCollection*) _tmp15_);
	_tmp17_ = _tmp16_;
	folks_internal_profiling_point ("emitting PersonaStore::personas-changed " "(ID: %s, count: %u)", _tmp11_, _tmp14_ + _tmp17_);
	_tmp18_ = _added;
	_tmp19_ = gee_set_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_SET, GeeSet));
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp22_ = _removed;
	_tmp23_ = gee_set_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_SET, GeeSet));
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_;
	g_signal_emit (self, folks_persona_store_signals[FOLKS_PERSONA_STORE_PERSONAS_CHANGED_SIGNAL], 0, _tmp21_, _tmp25_, message, actor, reason);
	_g_object_unref0 (_tmp25_);
	_g_object_unref0 (_tmp21_);
	_g_object_unref0 (_removed);
	_g_object_unref0 (_added);
}

void
folks_persona_store_prepare (FolksPersonaStore* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	FolksPersonaStoreClass* _klass_;
	_klass_ = FOLKS_PERSONA_STORE_GET_CLASS (self);
	if (_klass_->prepare) {
		_klass_->prepare (self, _callback_, _user_data_);
	}
}

void
folks_persona_store_prepare_finish (FolksPersonaStore* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	FolksPersonaStoreClass* _klass_;
	_klass_ = FOLKS_PERSONA_STORE_GET_CLASS (self);
	if (_klass_->prepare_finish) {
		_klass_->prepare_finish (self, _res_, error);
	}
}

static void
folks_persona_store_real_flush_data_free (gpointer _data)
{
	FolksPersonaStoreFlushData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksPersonaStoreFlushData, _data_);
}

static void
folks_persona_store_real_flush (FolksPersonaStore* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	FolksPersonaStoreFlushData* _data_;
	FolksPersonaStore* _tmp0_;
	_data_ = g_slice_new0 (FolksPersonaStoreFlushData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_persona_store_real_flush_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_persona_store_real_flush_co (_data_);
}

static void
folks_persona_store_real_flush_finish (FolksPersonaStore* self,
                                       GAsyncResult* _res_)
{
	FolksPersonaStoreFlushData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
   * Flush any pending changes to the PersonaStore's backing store.
   *
   * PersonaStores may (transparently) implement caching or I/O queueing which
   * means that changes to their {@link Persona}s may not be immediately written
   * to the PersonaStore's backing store. Calling this function will force all
   * pending changes to be flushed to the backing store.
   *
   * This must not be called before {@link PersonaStore.prepare}.
   *
   * @since 0.1.17
   */
static gboolean
folks_persona_store_real_flush_co (FolksPersonaStoreFlushData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
folks_persona_store_flush (FolksPersonaStore* self,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	FolksPersonaStoreClass* _klass_;
	_klass_ = FOLKS_PERSONA_STORE_GET_CLASS (self);
	if (_klass_->flush) {
		_klass_->flush (self, _callback_, _user_data_);
	}
}

void
folks_persona_store_flush_finish (FolksPersonaStore* self,
                                  GAsyncResult* _res_)
{
	FolksPersonaStoreClass* _klass_;
	_klass_ = FOLKS_PERSONA_STORE_GET_CLASS (self);
	if (_klass_->flush_finish) {
		_klass_->flush_finish (self, _res_);
	}
}

void
folks_persona_store_add_persona_from_details (FolksPersonaStore* self,
                                              GHashTable* details,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	FolksPersonaStoreClass* _klass_;
	_klass_ = FOLKS_PERSONA_STORE_GET_CLASS (self);
	if (_klass_->add_persona_from_details) {
		_klass_->add_persona_from_details (self, details, _callback_, _user_data_);
	}
}

FolksPersona*
folks_persona_store_add_persona_from_details_finish (FolksPersonaStore* self,
                                                     GAsyncResult* _res_,
                                                     GError** error)
{
	FolksPersonaStoreClass* _klass_;
	_klass_ = FOLKS_PERSONA_STORE_GET_CLASS (self);
	if (_klass_->add_persona_from_details_finish) {
		return _klass_->add_persona_from_details_finish (self, _res_, error);
	}
	return NULL;
}

void
folks_persona_store_remove_persona (FolksPersonaStore* self,
                                    FolksPersona* persona,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	FolksPersonaStoreClass* _klass_;
	_klass_ = FOLKS_PERSONA_STORE_GET_CLASS (self);
	if (_klass_->remove_persona) {
		_klass_->remove_persona (self, persona, _callback_, _user_data_);
	}
}

void
folks_persona_store_remove_persona_finish (FolksPersonaStore* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	FolksPersonaStoreClass* _klass_;
	_klass_ = FOLKS_PERSONA_STORE_GET_CLASS (self);
	if (_klass_->remove_persona_finish) {
		_klass_->remove_persona_finish (self, _res_, error);
	}
}

FolksPersonaStore*
folks_persona_store_construct (GType object_type)
{
	FolksPersonaStore * self = NULL;
	self = (FolksPersonaStore*) g_object_new (object_type, NULL);
	return self;
}

const gchar*
folks_persona_store_get_type_id (FolksPersonaStore* self)
{
	FolksPersonaStoreClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_PERSONA_STORE_GET_CLASS (self);
	if (_klass_->get_type_id) {
		return _klass_->get_type_id (self);
	}
	return NULL;
}

const gchar*
folks_persona_store_get_display_name (FolksPersonaStore* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}

static void
folks_persona_store_set_display_name (FolksPersonaStore* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = folks_persona_store_get_display_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_display_name);
		self->priv->_display_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, folks_persona_store_properties[FOLKS_PERSONA_STORE_DISPLAY_NAME_PROPERTY]);
	}
}

const gchar*
folks_persona_store_get_id (FolksPersonaStore* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
folks_persona_store_set_id (FolksPersonaStore* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = folks_persona_store_get_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, folks_persona_store_properties[FOLKS_PERSONA_STORE_ID_PROPERTY]);
	}
}

GeeMap*
folks_persona_store_get_personas (FolksPersonaStore* self)
{
	FolksPersonaStoreClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_PERSONA_STORE_GET_CLASS (self);
	if (_klass_->get_personas) {
		return _klass_->get_personas (self);
	}
	return NULL;
}

FolksMaybeBool
folks_persona_store_get_can_add_personas (FolksPersonaStore* self)
{
	FolksPersonaStoreClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = FOLKS_PERSONA_STORE_GET_CLASS (self);
	if (_klass_->get_can_add_personas) {
		return _klass_->get_can_add_personas (self);
	}
	return 0;
}

FolksMaybeBool
folks_persona_store_get_can_alias_personas (FolksPersonaStore* self)
{
	FolksPersonaStoreClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = FOLKS_PERSONA_STORE_GET_CLASS (self);
	if (_klass_->get_can_alias_personas) {
		return _klass_->get_can_alias_personas (self);
	}
	return 0;
}

FolksMaybeBool
folks_persona_store_get_can_group_personas (FolksPersonaStore* self)
{
	FolksPersonaStoreClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = FOLKS_PERSONA_STORE_GET_CLASS (self);
	if (_klass_->get_can_group_personas) {
		return _klass_->get_can_group_personas (self);
	}
	return 0;
}

FolksMaybeBool
folks_persona_store_get_can_remove_personas (FolksPersonaStore* self)
{
	FolksPersonaStoreClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = FOLKS_PERSONA_STORE_GET_CLASS (self);
	if (_klass_->get_can_remove_personas) {
		return _klass_->get_can_remove_personas (self);
	}
	return 0;
}

gboolean
folks_persona_store_get_is_prepared (FolksPersonaStore* self)
{
	FolksPersonaStoreClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FOLKS_PERSONA_STORE_GET_CLASS (self);
	if (_klass_->get_is_prepared) {
		return _klass_->get_is_prepared (self);
	}
	return FALSE;
}

gboolean
folks_persona_store_get_is_quiescent (FolksPersonaStore* self)
{
	FolksPersonaStoreClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FOLKS_PERSONA_STORE_GET_CLASS (self);
	if (_klass_->get_is_quiescent) {
		return _klass_->get_is_quiescent (self);
	}
	return FALSE;
}

gboolean
folks_persona_store_get_is_writeable (FolksPersonaStore* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_writeable;
	return result;
}

void
folks_persona_store_set_is_writeable (FolksPersonaStore* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = folks_persona_store_get_is_writeable (self);
	if (old_value != value) {
		self->priv->_is_writeable = value;
		g_object_notify_by_pspec ((GObject *) self, folks_persona_store_properties[FOLKS_PERSONA_STORE_IS_WRITEABLE_PROPERTY]);
	}
}

FolksPersonaStoreTrust
folks_persona_store_get_trust_level (FolksPersonaStore* self)
{
	FolksPersonaStoreTrust result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_trust_level;
	return result;
}

void
folks_persona_store_set_trust_level (FolksPersonaStore* self,
                                     FolksPersonaStoreTrust value)
{
	FolksPersonaStoreTrust _tmp0_;
	FolksPersonaStoreTrust _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_persona_store_get_trust_level (self);
	_tmp1_ = _tmp0_;
	if (value > _tmp1_) {
		self->priv->_trust_level = value;
		g_object_notify ((GObject*) self, "trust-level");
	} else {
		g_debug ("persona-store.vala:657: Unable to lower Persona Store trust_level");
	}
	g_object_notify_by_pspec ((GObject *) self, folks_persona_store_properties[FOLKS_PERSONA_STORE_TRUST_LEVEL_PROPERTY]);
}

gchar**
folks_persona_store_get_always_writeable_properties (FolksPersonaStore* self,
                                                     gint* result_length1)
{
	FolksPersonaStoreClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_PERSONA_STORE_GET_CLASS (self);
	if (_klass_->get_always_writeable_properties) {
		return _klass_->get_always_writeable_properties (self, result_length1);
	}
	return NULL;
}

gboolean
folks_persona_store_get_is_primary_store (FolksPersonaStore* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_primary_store;
	return result;
}

void
folks_persona_store_set_is_primary_store (FolksPersonaStore* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = folks_persona_store_get_is_primary_store (self);
	if (old_value != value) {
		self->priv->_is_primary_store = value;
		g_object_notify_by_pspec ((GObject *) self, folks_persona_store_properties[FOLKS_PERSONA_STORE_IS_PRIMARY_STORE_PROPERTY]);
	}
}

gboolean
folks_persona_store_get_is_user_set_default (FolksPersonaStore* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_user_set_default;
	return result;
}

void
folks_persona_store_set_is_user_set_default (FolksPersonaStore* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = folks_persona_store_get_is_user_set_default (self);
	if (old_value != value) {
		self->priv->_is_user_set_default = value;
		g_object_notify_by_pspec ((GObject *) self, folks_persona_store_properties[FOLKS_PERSONA_STORE_IS_USER_SET_DEFAULT_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM (GClosure * closure,
                                                                GValue * return_value,
                                                                guint n_param_values,
                                                                const GValue * param_values,
                                                                gpointer invocation_hint,
                                                                gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM) (gpointer data1, gpointer arg_1, gpointer arg_2, const char* arg_3, gpointer arg_4, gint arg_5, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_string (param_values + 3), g_value_get_object (param_values + 4), g_value_get_enum (param_values + 5), data2);
}

static GObject *
folks_persona_store_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FolksPersonaStore * self;
	const gchar* _tmp0_;
	parent_class = G_OBJECT_CLASS (folks_persona_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore);
	_tmp0_ = self->priv->_id;
	g_debug ("persona-store.vala:337: Constructing PersonaStore ‘%s’ (%p)", _tmp0_, self);
	return obj;
}

static void
folks_persona_store_class_init (FolksPersonaStoreClass * klass,
                                gpointer klass_data)
{
	folks_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksPersonaStore_private_offset);
	((FolksPersonaStoreClass *) klass)->flush = (void (*) (FolksPersonaStore*, GAsyncReadyCallback, gpointer)) folks_persona_store_real_flush;
	((FolksPersonaStoreClass *) klass)->flush_finish = (void (*) (FolksPersonaStore*, GAsyncResult*)) folks_persona_store_real_flush_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_persona_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_persona_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_persona_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_persona_store_finalize;
	/**
	   * The type of PersonaStore this is.
	   *
	   * This is the same for all PersonaStores provided by a given {@link Backend}.
	   *
	   * This is guaranteed to always be available; even before
	   * {@link PersonaStore.prepare} is called. It is immutable over the life of
	   * the {@link PersonaStore}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_TYPE_ID_PROPERTY, folks_persona_store_properties[FOLKS_PERSONA_STORE_TYPE_ID_PROPERTY] = g_param_spec_string ("type-id", "type-id", "type-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * The human-readable, service-specific name used to represent the
	   * PersonaStore to the user.
	   *
	   * For example: ``foo@@xmpp.example.org``.
	   *
	   * This should be used whenever the user needs to be presented with a
	   * familiar, service-specific name. For instance, in a prompt for the user to
	   * select a specific IM account from which to initiate a chat.
	   *
	   * This is not guaranteed to be unique even within this PersonaStore's
	   * {@link Backend}. Its value may change throughout the life of the store.
	   *
	   * @since 0.1.13
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_DISPLAY_NAME_PROPERTY, folks_persona_store_properties[FOLKS_PERSONA_STORE_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The instance identifier for this PersonaStore.
	   *
	   * Since each {@link Backend} can provide multiple different PersonaStores
	   * for different accounts or servers (for example), they each need an ID
	   * which is unique within the backend.
	   *
	   * It is immutable over the life of the {@link PersonaStore}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_ID_PROPERTY, folks_persona_store_properties[FOLKS_PERSONA_STORE_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The {@link Persona}s exposed by this PersonaStore.
	   *
	   * @since 0.5.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_PERSONAS_PROPERTY, folks_persona_store_properties[FOLKS_PERSONA_STORE_PERSONAS_PROPERTY] = g_param_spec_object ("personas", "personas", "personas", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether this {@link PersonaStore} can add {@link Persona}s.
	   *
	   * This value may change throughout the life of the {@link PersonaStore}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_CAN_ADD_PERSONAS_PROPERTY, folks_persona_store_properties[FOLKS_PERSONA_STORE_CAN_ADD_PERSONAS_PROPERTY] = g_param_spec_enum ("can-add-personas", "can-add-personas", "can-add-personas", FOLKS_TYPE_MAYBE_BOOL, FOLKS_MAYBE_BOOL_UNSET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether this {@link PersonaStore} can set the alias of {@link Persona}s.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_CAN_ALIAS_PERSONAS_PROPERTY, folks_persona_store_properties[FOLKS_PERSONA_STORE_CAN_ALIAS_PERSONAS_PROPERTY] = g_param_spec_enum ("can-alias-personas", "can-alias-personas", "can-alias-personas", FOLKS_TYPE_MAYBE_BOOL, FOLKS_MAYBE_BOOL_UNSET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_DEPRECATED));
	/**
	   * Whether this {@link PersonaStore} can set the groups of {@link Persona}s.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_CAN_GROUP_PERSONAS_PROPERTY, folks_persona_store_properties[FOLKS_PERSONA_STORE_CAN_GROUP_PERSONAS_PROPERTY] = g_param_spec_enum ("can-group-personas", "can-group-personas", "can-group-personas", FOLKS_TYPE_MAYBE_BOOL, FOLKS_MAYBE_BOOL_UNSET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_DEPRECATED));
	/**
	   * Whether this {@link PersonaStore} can remove {@link Persona}s.
	   *
	   * This value may change throughout the life of the {@link PersonaStore}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_CAN_REMOVE_PERSONAS_PROPERTY, folks_persona_store_properties[FOLKS_PERSONA_STORE_CAN_REMOVE_PERSONAS_PROPERTY] = g_param_spec_enum ("can-remove-personas", "can-remove-personas", "can-remove-personas", FOLKS_TYPE_MAYBE_BOOL, FOLKS_MAYBE_BOOL_UNSET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether {@link PersonaStore.prepare} has successfully completed for this
	   * store.
	   *
	   * It’s guaranteed that this will only ever change from ``false`` to ``true``
	   * in the lifetime of the {@link PersonaStore}.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_IS_PREPARED_PROPERTY, folks_persona_store_properties[FOLKS_PERSONA_STORE_IS_PREPARED_PROPERTY] = g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether the store has reached a quiescent state. This will happen at some
	   * point after {@link PersonaStore.prepare} has successfully completed for the
	   * store. A store is in a quiescent state when all the {@link Persona}s that
	   * it originally knows about have been loaded.
	   *
	   * It's guaranteed that this property's value will only ever change after
	   * {@link IndividualAggregator.is_prepared} has changed to ``true``.
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_IS_QUIESCENT_PROPERTY, folks_persona_store_properties[FOLKS_PERSONA_STORE_IS_QUIESCENT_PROPERTY] = g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether the PersonaStore is writeable.
	   *
	   * Only if a PersonaStore is writeable will its {@link Persona}s be updated by
	   * changes to the {@link Individual}s containing them, and those changes then
	   * be written out to the relevant backing store.
	   *
	   * If this property is ``false``, it doesn't mean that {@link Persona}s in
	   * this persona store aren't writeable at all. If their properties are updated
	   * through the {@link Persona}, rather than through the {@link Individual}
	   * containing that persona, changes may be propagated to the backing store.
	   *
	   * PersonaStores must not set this property themselves; it will be set as
	   * appropriate by the {@link IndividualAggregator}.
	   *
	   * @since 0.1.13
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_IS_WRITEABLE_PROPERTY, folks_persona_store_properties[FOLKS_PERSONA_STORE_IS_WRITEABLE_PROPERTY] = g_param_spec_boolean ("is-writeable", "is-writeable", "is-writeable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_DEPRECATED));
	/**
	   * The trust level of the PersonaStore for linking.
	   *
	   * Each {@link PersonaStore} is assigned a trust level by the
	   * IndividualAggregator, designating whether to trust the properties of its
	   * {@link Persona}s for linking to produce {@link Individual}s.
	   *
	   * This value may change throughout the life of the {@link PersonaStore}.
	   *
	   * The trust level may be queried by clients, but must not be set by them. The
	   * setter for this property is for libfolks internal use only.
	   *
	   * @see PersonaStoreTrust
	   * @since 0.1.13
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_TRUST_LEVEL_PROPERTY, folks_persona_store_properties[FOLKS_PERSONA_STORE_TRUST_LEVEL_PROPERTY] = g_param_spec_enum ("trust-level", "trust-level", "trust-level", FOLKS_TYPE_PERSONA_STORE_TRUST, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The names of the properties of the {@link Persona}s in this store which are
	   * always writeable.
	   *
	   * If a property name is in this list, setting the property on a persona
	   * should result in the updated value being stored in the backend's permanent
	   * storage (unless it gets rejected due to being invalid, or a different error
	   * occurs).
	   *
	   * This property value is guaranteed to be constant for a given persona store,
	   * but may vary between persona stores in the same backend. It's guaranteed
	   * that this will always be a subset of the value of
	   * {@link Persona.writeable_properties} for the personas in this persona
	   * store.
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES_PROPERTY, folks_persona_store_properties[FOLKS_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES_PROPERTY] = g_param_spec_boxed ("always-writeable-properties", "always-writeable-properties", "always-writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether this {@link PersonaStore} is the primary store to be used for
	   * linking {@link Persona}s.
	   *
	   * @since 0.6.3
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_IS_PRIMARY_STORE_PROPERTY, folks_persona_store_properties[FOLKS_PERSONA_STORE_IS_PRIMARY_STORE_PROPERTY] = g_param_spec_boolean ("is-primary-store", "is-primary-store", "is-primary-store", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Whether this {@link PersonaStore} is marked as the default in its backend
	   * by the user.
	   *
	   * i.e. A {@link PersonaStore} for the EDS backend would set this to ``true``
	   * if it represents the user’s default address book.
	   *
	   * @since 0.6.3
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_IS_USER_SET_DEFAULT_PROPERTY, folks_persona_store_properties[FOLKS_PERSONA_STORE_IS_USER_SET_DEFAULT_PROPERTY] = g_param_spec_boolean ("is-user-set-default", "is-user-set-default", "is-user-set-default", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Emitted when one or more {@link Persona}s are added to or removed from
	   * the store.
	   *
	   * This will not be emitted until after {@link PersonaStore.prepare} has been
	   * called.
	   *
	   * @param added a set of {@link Persona}s which have been removed
	   * @param removed a set of {@link Persona}s which have been removed
	   * @param message a string message from the backend, if any
	   * @param actor the {@link Persona} who made the change, if known
	   * @param reason the reason for the change
	   *
	   * @since 0.5.1
	   */
	folks_persona_store_signals[FOLKS_PERSONA_STORE_PERSONAS_CHANGED_SIGNAL] = g_signal_new ("personas-changed", FOLKS_TYPE_PERSONA_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM, G_TYPE_NONE, 5, GEE_TYPE_SET, GEE_TYPE_SET, G_TYPE_STRING, FOLKS_TYPE_PERSONA, FOLKS_GROUP_DETAILS_TYPE_CHANGE_REASON);
	/**
	   * Emitted when the backing store for this PersonaStore has been removed.
	   *
	   * At this point, the PersonaStore and all its {@link Persona}s are invalid,
	   * so any client referencing it should unreference it.
	   *
	   * This will not be emitted until after {@link PersonaStore.prepare} has been
	   * called.
	   */
	folks_persona_store_signals[FOLKS_PERSONA_STORE_REMOVED_SIGNAL] = g_signal_new ("removed", FOLKS_TYPE_PERSONA_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
folks_persona_store_instance_init (FolksPersonaStore * self,
                                   gpointer klass)
{
	self->priv = folks_persona_store_get_instance_private (self);
	self->priv->_is_writeable = FALSE;
	self->priv->_trust_level = FOLKS_PERSONA_STORE_TRUST_NONE;
	self->priv->_is_primary_store = FALSE;
	self->priv->_is_user_set_default = FALSE;
}

static void
folks_persona_store_finalize (GObject * obj)
{
	FolksPersonaStore * self;
	const gchar* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore);
	_tmp0_ = self->priv->_id;
	g_debug ("persona-store.vala:342: Destroying PersonaStore ‘%s’ (%p)", _tmp0_, self);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_id);
	G_OBJECT_CLASS (folks_persona_store_parent_class)->finalize (obj);
}

/**
 * A store for {@link Persona}s.
 *
 * After creating a PersonaStore instance, you must connect to the
 * {@link PersonaStore.personas_changed} signal, //then// call
 * {@link PersonaStore.prepare}, otherwise a race condition may occur between
 * emission of {@link PersonaStore.personas_changed} and your code connecting to
 * it.
 */
static GType
folks_persona_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPersonaStore), 0, (GInstanceInitFunc) folks_persona_store_instance_init, NULL };
	GType folks_persona_store_type_id;
	folks_persona_store_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksPersonaStore", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	FolksPersonaStore_private_offset = g_type_add_instance_private (folks_persona_store_type_id, sizeof (FolksPersonaStorePrivate));
	return folks_persona_store_type_id;
}

GType
folks_persona_store_get_type (void)
{
	static volatile gsize folks_persona_store_type_id__once = 0;
	if (g_once_init_enter (&folks_persona_store_type_id__once)) {
		GType folks_persona_store_type_id;
		folks_persona_store_type_id = folks_persona_store_get_type_once ();
		g_once_init_leave (&folks_persona_store_type_id__once, folks_persona_store_type_id);
	}
	return folks_persona_store_type_id__once;
}

static void
_vala_folks_persona_store_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	FolksPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore);
	switch (property_id) {
		case FOLKS_PERSONA_STORE_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, folks_persona_store_get_display_name (self));
		break;
		case FOLKS_PERSONA_STORE_ID_PROPERTY:
		g_value_set_string (value, folks_persona_store_get_id (self));
		break;
		case FOLKS_PERSONA_STORE_IS_WRITEABLE_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		g_value_set_boolean (value, folks_persona_store_get_is_writeable (self));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		case FOLKS_PERSONA_STORE_TRUST_LEVEL_PROPERTY:
		g_value_set_enum (value, folks_persona_store_get_trust_level (self));
		break;
		case FOLKS_PERSONA_STORE_IS_PRIMARY_STORE_PROPERTY:
		g_value_set_boolean (value, folks_persona_store_get_is_primary_store (self));
		break;
		case FOLKS_PERSONA_STORE_IS_USER_SET_DEFAULT_PROPERTY:
		g_value_set_boolean (value, folks_persona_store_get_is_user_set_default (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_persona_store_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	FolksPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore);
	switch (property_id) {
		case FOLKS_PERSONA_STORE_DISPLAY_NAME_PROPERTY:
		folks_persona_store_set_display_name (self, g_value_get_string (value));
		break;
		case FOLKS_PERSONA_STORE_ID_PROPERTY:
		folks_persona_store_set_id (self, g_value_get_string (value));
		break;
		case FOLKS_PERSONA_STORE_IS_WRITEABLE_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		folks_persona_store_set_is_writeable (self, g_value_get_boolean (value));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		case FOLKS_PERSONA_STORE_TRUST_LEVEL_PROPERTY:
		folks_persona_store_set_trust_level (self, g_value_get_enum (value));
		break;
		case FOLKS_PERSONA_STORE_IS_PRIMARY_STORE_PROPERTY:
		folks_persona_store_set_is_primary_store (self, g_value_get_boolean (value));
		break;
		case FOLKS_PERSONA_STORE_IS_USER_SET_DEFAULT_PROPERTY:
		folks_persona_store_set_is_user_set_default (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

