/* url-details.c generated by valac 0.56.0, the Vala compiler
 * generated from url-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include "folks/folks.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

enum  {
	FOLKS_URL_FIELD_DETAILS_0_PROPERTY,
	FOLKS_URL_FIELD_DETAILS_NUM_PROPERTIES
};
static GParamSpec* folks_url_field_details_properties[FOLKS_URL_FIELD_DETAILS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksUrlDetailsChangeUrlsData FolksUrlDetailsChangeUrlsData;

struct _FolksUrlDetailsChangeUrlsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksUrlDetails* self;
	GeeSet* urls;
	GError* _tmp0_;
	GError* _inner_error0_;
};

static gpointer folks_url_field_details_parent_class = NULL;

static gboolean folks_url_field_details_real_equal (FolksAbstractFieldDetails* base,
                                             FolksAbstractFieldDetails* that);
static guint folks_url_field_details_real_hash (FolksAbstractFieldDetails* base);
static GType folks_url_field_details_get_type_once (void);
static void folks_url_details_real_change_urls_data_free (gpointer _data);
static void folks_url_details_real_change_urls (FolksUrlDetails* self,
                                         GeeSet* urls,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean folks_url_details_real_change_urls_co (FolksUrlDetailsChangeUrlsData* _data_);
static GType folks_url_details_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
   * Create a new UrlFieldDetails.
   *
   * @param value the value of the field, a non-empty URI
   * @param parameters initial parameters. See
   * {@link AbstractFieldDetails.parameters}. A ``null`` value is equivalent to
   * an empty map of parameters.
   *
   * @return a new UrlFieldDetails
   *
   * @since 0.6.0
   */
FolksUrlFieldDetails*
folks_url_field_details_construct (GType object_type,
                                   const gchar* value,
                                   GeeMultiMap* parameters)
{
	FolksUrlFieldDetails * self = NULL;
	g_return_val_if_fail (value != NULL, NULL);
	if (g_strcmp0 (value, "") == 0) {
		g_warning ("url-details.vala:91: Empty URI passed to UrlFieldDetails.");
	}
	self = (FolksUrlFieldDetails*) g_object_new (object_type, "t-type", G_TYPE_STRING, "t-dup-func", (GBoxedCopyFunc) g_strdup, "t-destroy-func", (GDestroyNotify) g_free, "value", value, "parameters", parameters, NULL);
	return self;
}

FolksUrlFieldDetails*
folks_url_field_details_new (const gchar* value,
                             GeeMultiMap* parameters)
{
	return folks_url_field_details_construct (FOLKS_TYPE_URL_FIELD_DETAILS, value, parameters);
}

/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static gboolean
folks_url_field_details_real_equal (FolksAbstractFieldDetails* base,
                                    FolksAbstractFieldDetails* that)
{
	FolksUrlFieldDetails * self;
	gboolean result;
	self = (FolksUrlFieldDetails*) base;
	g_return_val_if_fail (that != NULL, FALSE);
	result = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_url_field_details_parent_class)->equal (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails), that);
	return result;
}

/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static guint
folks_url_field_details_real_hash (FolksAbstractFieldDetails* base)
{
	FolksUrlFieldDetails * self;
	guint result;
	self = (FolksUrlFieldDetails*) base;
	result = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_url_field_details_parent_class)->hash (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails));
	return result;
}

static void
folks_url_field_details_class_init (FolksUrlFieldDetailsClass * klass,
                                    gpointer klass_data)
{
	folks_url_field_details_parent_class = g_type_class_peek_parent (klass);
	((FolksAbstractFieldDetailsClass *) klass)->equal = (gboolean (*) (FolksAbstractFieldDetails*, FolksAbstractFieldDetails*)) folks_url_field_details_real_equal;
	((FolksAbstractFieldDetailsClass *) klass)->hash = (guint (*) (FolksAbstractFieldDetails*)) folks_url_field_details_real_hash;
}

static void
folks_url_field_details_instance_init (FolksUrlFieldDetails * self,
                                       gpointer klass)
{
}

/**
 * Object representing a URL that can have some parameters associated with it.
 *
 * See {@link Folks.AbstractFieldDetails} for details on common parameter names
 * and values.
 *
 * @since 0.6.0
 */
static GType
folks_url_field_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksUrlFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_url_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksUrlFieldDetails), 0, (GInstanceInitFunc) folks_url_field_details_instance_init, NULL };
	GType folks_url_field_details_type_id;
	folks_url_field_details_type_id = g_type_register_static (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, "FolksUrlFieldDetails", &g_define_type_info, 0);
	return folks_url_field_details_type_id;
}

GType
folks_url_field_details_get_type (void)
{
	static volatile gsize folks_url_field_details_type_id__once = 0;
	if (g_once_init_enter (&folks_url_field_details_type_id__once)) {
		GType folks_url_field_details_type_id;
		folks_url_field_details_type_id = folks_url_field_details_get_type_once ();
		g_once_init_leave (&folks_url_field_details_type_id__once, folks_url_field_details_type_id);
	}
	return folks_url_field_details_type_id__once;
}

static void
folks_url_details_real_change_urls_data_free (gpointer _data)
{
	FolksUrlDetailsChangeUrlsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->urls);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksUrlDetailsChangeUrlsData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folks_url_details_real_change_urls (FolksUrlDetails* self,
                                    GeeSet* urls,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	FolksUrlDetailsChangeUrlsData* _data_;
	FolksUrlDetails* _tmp0_;
	GeeSet* _tmp1_;
	g_return_if_fail (urls != NULL);
	_data_ = g_slice_new0 (FolksUrlDetailsChangeUrlsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_url_details_real_change_urls_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (urls);
	_g_object_unref0 (_data_->urls);
	_data_->urls = _tmp1_;
	folks_url_details_real_change_urls_co (_data_);
}

static void
folks_url_details_real_change_urls_finish (FolksUrlDetails* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	FolksUrlDetailsChangeUrlsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Change the contact's URLs.
   *
   * It's preferred to call this rather than setting {@link UrlDetails.urls}
   * directly, as this method gives error notification and will only return once
   * the URLs have been written to the relevant backing store (or the
   * operation's failed).
   *
   * @param urls the set of URLs
   * @throws PropertyError if setting the URLs failed
   * @since 0.6.2
   */
static gboolean
folks_url_details_real_change_urls_co (FolksUrlDetailsChangeUrlsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _ ("URLs are not writeable on this contact."));
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
folks_url_details_change_urls (FolksUrlDetails* self,
                               GeeSet* urls,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	FolksUrlDetailsIface* _iface_;
	_iface_ = FOLKS_URL_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_urls) {
		_iface_->change_urls (self, urls, _callback_, _user_data_);
	}
}

void
folks_url_details_change_urls_finish (FolksUrlDetails* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	FolksUrlDetailsIface* _iface_;
	_iface_ = FOLKS_URL_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_urls_finish) {
		_iface_->change_urls_finish (self, _res_, error);
	}
}

GeeSet*
folks_url_details_get_urls (FolksUrlDetails* self)
{
	FolksUrlDetailsIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = FOLKS_URL_DETAILS_GET_INTERFACE (self);
	if (_iface_->get_urls) {
		return _iface_->get_urls (self);
	}
	return NULL;
}

void
folks_url_details_set_urls (FolksUrlDetails* self,
                            GeeSet* value)
{
	FolksUrlDetailsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = FOLKS_URL_DETAILS_GET_INTERFACE (self);
	if (_iface_->set_urls) {
		_iface_->set_urls (self, value);
	}
}

static void
folks_url_details_default_init (FolksUrlDetailsIface * iface,
                                gpointer iface_data)
{
	/**
	   * The websites of the contact.
	   *
	   * A list or websites associated to the contact.
	   *
	   * @since 0.5.1
	   */
	g_object_interface_install_property (iface, g_param_spec_object ("urls", "urls", "urls", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	iface->change_urls = folks_url_details_real_change_urls;
	iface->change_urls_finish = folks_url_details_real_change_urls_finish;
}

/**
 * Associates a list of URLs with a contact.
 *
 * @since 0.3.5
 */
static GType
folks_url_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksUrlDetailsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_url_details_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType folks_url_details_type_id;
	folks_url_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksUrlDetails", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (folks_url_details_type_id, G_TYPE_OBJECT);
	return folks_url_details_type_id;
}

GType
folks_url_details_get_type (void)
{
	static volatile gsize folks_url_details_type_id__once = 0;
	if (g_once_init_enter (&folks_url_details_type_id__once)) {
		GType folks_url_details_type_id;
		folks_url_details_type_id = folks_url_details_get_type_once ();
		g_once_init_leave (&folks_url_details_type_id__once, folks_url_details_type_id);
	}
	return folks_url_details_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

