/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.ExceptionUtils;

@Deprecated
public class JDBCStore
extends StoreBase {
    private String name = null;
    protected static final String storeName = "JDBCStore";
    protected static final String threadName = "JDBCStore";
    protected String connectionName = null;
    protected String connectionPassword = null;
    protected String connectionURL = null;
    private Connection dbConnection = null;
    protected Driver driver = null;
    protected String driverName = null;
    protected String dataSourceName = null;
    private boolean localDataSource = false;
    protected DataSource dataSource = null;
    protected String sessionTable = "tomcat$sessions";
    protected String sessionAppCol = "app";
    protected String sessionIdCol = "id";
    protected String sessionDataCol = "data";
    protected String sessionValidCol = "valid";
    protected String sessionMaxInactiveCol = "maxinactive";
    protected String sessionLastAccessedCol = "lastaccess";
    protected PreparedStatement preparedSizeSql = null;
    protected PreparedStatement preparedSaveSql = null;
    protected PreparedStatement preparedClearSql = null;
    protected PreparedStatement preparedRemoveSql = null;
    protected PreparedStatement preparedLoadSql = null;

    public String getName() {
        if (this.name == null) {
            Context context = this.manager.getContext();
            String string = context.getName();
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            String string2 = "";
            String string3 = "";
            if (context.getParent() != null) {
                Container container = context.getParent();
                string2 = container.getName();
                if (container.getParent() != null) {
                    string3 = container.getParent().getName();
                }
            }
            this.name = "/" + string3 + "/" + string2 + string;
        }
        return this.name;
    }

    public String getThreadName() {
        return "JDBCStore";
    }

    @Override
    public String getStoreName() {
        return "JDBCStore";
    }

    public void setDriverName(String string) {
        String string2 = this.driverName;
        this.driverName = string;
        this.support.firePropertyChange("driverName", string2, this.driverName);
        this.driverName = string;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String string) {
        this.connectionName = string;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String string) {
        this.connectionPassword = string;
    }

    public void setConnectionURL(String string) {
        String string2 = this.connectionURL;
        this.connectionURL = string;
        this.support.firePropertyChange("connectionURL", string2, this.connectionURL);
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setSessionTable(String string) {
        String string2 = this.sessionTable;
        this.sessionTable = string;
        this.support.firePropertyChange("sessionTable", string2, this.sessionTable);
    }

    public String getSessionTable() {
        return this.sessionTable;
    }

    public void setSessionAppCol(String string) {
        String string2 = this.sessionAppCol;
        this.sessionAppCol = string;
        this.support.firePropertyChange("sessionAppCol", string2, this.sessionAppCol);
    }

    public String getSessionAppCol() {
        return this.sessionAppCol;
    }

    public void setSessionIdCol(String string) {
        String string2 = this.sessionIdCol;
        this.sessionIdCol = string;
        this.support.firePropertyChange("sessionIdCol", string2, this.sessionIdCol);
    }

    public String getSessionIdCol() {
        return this.sessionIdCol;
    }

    public void setSessionDataCol(String string) {
        String string2 = this.sessionDataCol;
        this.sessionDataCol = string;
        this.support.firePropertyChange("sessionDataCol", string2, this.sessionDataCol);
    }

    public String getSessionDataCol() {
        return this.sessionDataCol;
    }

    public void setSessionValidCol(String string) {
        String string2 = this.sessionValidCol;
        this.sessionValidCol = string;
        this.support.firePropertyChange("sessionValidCol", string2, this.sessionValidCol);
    }

    public String getSessionValidCol() {
        return this.sessionValidCol;
    }

    public void setSessionMaxInactiveCol(String string) {
        String string2 = this.sessionMaxInactiveCol;
        this.sessionMaxInactiveCol = string;
        this.support.firePropertyChange("sessionMaxInactiveCol", string2, this.sessionMaxInactiveCol);
    }

    public String getSessionMaxInactiveCol() {
        return this.sessionMaxInactiveCol;
    }

    public void setSessionLastAccessedCol(String string) {
        String string2 = this.sessionLastAccessedCol;
        this.sessionLastAccessedCol = string;
        this.support.firePropertyChange("sessionLastAccessedCol", string2, this.sessionLastAccessedCol);
    }

    public String getSessionLastAccessedCol() {
        return this.sessionLastAccessedCol;
    }

    public void setDataSourceName(String string) {
        if (string == null || string.trim().isEmpty()) {
            this.manager.getContext().getLogger().warn((Object)sm.getString(this.getStoreName() + ".missingDataSourceName"));
            return;
        }
        this.dataSourceName = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public boolean getLocalDataSource() {
        return this.localDataSource;
    }

    public void setLocalDataSource(boolean bl) {
        this.localDataSource = bl;
    }

    @Override
    public String[] expiredKeys() throws IOException {
        return this.keys(true);
    }

    @Override
    public String[] keys() throws IOException {
        return this.keys(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] keys(boolean bl) throws IOException {
        String[] stringArray = null;
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            for (int i = 2; i > 0; --i) {
                Connection connection = this.getConnection();
                if (connection == null) {
                    return new String[0];
                }
                try {
                    String string = "SELECT " + this.sessionIdCol + " FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
                    if (bl) {
                        string = string + " AND (" + this.sessionLastAccessedCol + " + " + this.sessionMaxInactiveCol + " * 1000 < ?)";
                    }
                    try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
                        preparedStatement.setString(1, this.getName());
                        if (bl) {
                            preparedStatement.setLong(2, System.currentTimeMillis());
                        }
                        try (ResultSet resultSet = preparedStatement.executeQuery();){
                            ArrayList<String> arrayList = new ArrayList<String>();
                            if (resultSet != null) {
                                while (resultSet.next()) {
                                    arrayList.add(resultSet.getString(1));
                                }
                            }
                            stringArray = arrayList.toArray(new String[0]);
                            i = 0;
                            continue;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    this.manager.getContext().getLogger().error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                    stringArray = new String[]{};
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                finally {
                    this.release(connection);
                }
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() throws IOException {
        int n = 0;
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            for (int i = 2; i > 0; --i) {
                Connection connection = this.getConnection();
                if (connection == null) {
                    return n;
                }
                try {
                    Object object;
                    if (this.preparedSizeSql == null) {
                        object = "SELECT COUNT(" + this.sessionIdCol + ") FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
                        this.preparedSizeSql = connection.prepareStatement((String)object);
                    }
                    this.preparedSizeSql.setString(1, this.getName());
                    object = this.preparedSizeSql.executeQuery();
                    Throwable throwable = null;
                    try {
                        if (object.next()) {
                            n = object.getInt(1);
                        }
                        i = 0;
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    object.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                object.close();
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    this.manager.getContext().getLogger().error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                finally {
                    this.release(connection);
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session load(String string) throws ClassNotFoundException, IOException {
        StandardSession standardSession = null;
        Context context = this.getManager().getContext();
        Log log = context.getLogger();
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            for (int i = 2; i > 0; --i) {
                Connection connection = this.getConnection();
                if (connection == null) {
                    return null;
                }
                ClassLoader classLoader = context.bind(Globals.IS_SECURITY_ENABLED, null);
                try {
                    Object object;
                    if (this.preparedLoadSql == null) {
                        object = "SELECT " + this.sessionIdCol + ", " + this.sessionDataCol + " FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ? AND " + this.sessionAppCol + " = ?";
                        this.preparedLoadSql = connection.prepareStatement((String)object);
                    }
                    this.preparedLoadSql.setString(1, string);
                    this.preparedLoadSql.setString(2, this.getName());
                    object = this.preparedLoadSql.executeQuery();
                    Throwable throwable = null;
                    try {
                        if (object.next()) {
                            try (ObjectInputStream objectInputStream = this.getObjectInputStream(object.getBinaryStream(2));){
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)sm.getString(this.getStoreName() + ".loading", new Object[]{string, this.sessionTable}));
                                }
                                standardSession = (StandardSession)this.manager.createEmptySession();
                                standardSession.readObjectData(objectInputStream);
                                standardSession.setManager(this.manager);
                            }
                        } else if (context.getLogger().isDebugEnabled()) {
                            log.debug((Object)(this.getStoreName() + ": No persisted data object found"));
                        }
                        i = 0;
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    object.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                object.close();
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    log.error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                finally {
                    context.unbind(Globals.IS_SECURITY_ENABLED, classLoader);
                    this.release(connection);
                }
            }
        }
        return standardSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String string) throws IOException {
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            for (int i = 2; i > 0; --i) {
                Connection connection = this.getConnection();
                if (connection == null) {
                    return;
                }
                try {
                    this.remove(string, connection);
                    i = 0;
                    continue;
                }
                catch (SQLException sQLException) {
                    this.manager.getContext().getLogger().error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                finally {
                    this.release(connection);
                }
            }
        }
        if (this.manager.getContext().getLogger().isDebugEnabled()) {
            this.manager.getContext().getLogger().debug((Object)sm.getString(this.getStoreName() + ".removing", new Object[]{string, this.sessionTable}));
        }
    }

    private void remove(String string, Connection connection) throws SQLException {
        if (this.preparedRemoveSql == null) {
            String string2 = "DELETE FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ?  AND " + this.sessionAppCol + " = ?";
            this.preparedRemoveSql = connection.prepareStatement(string2);
        }
        this.preparedRemoveSql.setString(1, string);
        this.preparedRemoveSql.setString(2, this.getName());
        this.preparedRemoveSql.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            for (int i = 2; i > 0; --i) {
                Connection connection = this.getConnection();
                if (connection == null) {
                    return;
                }
                try {
                    if (this.preparedClearSql == null) {
                        String string = "DELETE FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
                        this.preparedClearSql = connection.prepareStatement(string);
                    }
                    this.preparedClearSql.setString(1, this.getName());
                    this.preparedClearSql.execute();
                    i = 0;
                    continue;
                }
                catch (SQLException sQLException) {
                    this.manager.getContext().getLogger().error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                finally {
                    this.release(connection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Session session) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            for (int i = 2; i > 0; --i) {
                Connection connection = this.getConnection();
                if (connection == null) {
                    return;
                }
                try {
                    this.remove(session.getIdInternal(), connection);
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    try (Object object = new ObjectOutputStream(new BufferedOutputStream(byteArrayOutputStream));){
                        ((StandardSession)session).writeObjectData((ObjectOutputStream)object);
                    }
                    object = byteArrayOutputStream.toByteArray();
                    int n = ((Object)object).length;
                    try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object, 0, n);
                         BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream, n);){
                        if (this.preparedSaveSql == null) {
                            String string = "INSERT INTO " + this.sessionTable + " (" + this.sessionIdCol + ", " + this.sessionAppCol + ", " + this.sessionDataCol + ", " + this.sessionValidCol + ", " + this.sessionMaxInactiveCol + ", " + this.sessionLastAccessedCol + ") VALUES (?, ?, ?, ?, ?, ?)";
                            this.preparedSaveSql = connection.prepareStatement(string);
                        }
                        this.preparedSaveSql.setString(1, session.getIdInternal());
                        this.preparedSaveSql.setString(2, this.getName());
                        this.preparedSaveSql.setBinaryStream(3, (InputStream)bufferedInputStream, n);
                        this.preparedSaveSql.setString(4, session.isValid() ? "1" : "0");
                        this.preparedSaveSql.setInt(5, session.getMaxInactiveInterval());
                        this.preparedSaveSql.setLong(6, session.getLastAccessedTime());
                        this.preparedSaveSql.execute();
                        i = 0;
                        continue;
                    }
                }
                catch (SQLException sQLException) {
                    this.manager.getContext().getLogger().error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                finally {
                    this.release(connection);
                }
            }
        }
        if (this.manager.getContext().getLogger().isDebugEnabled()) {
            this.manager.getContext().getLogger().debug((Object)sm.getString(this.getStoreName() + ".saving", new Object[]{session.getIdInternal(), this.sessionTable}));
        }
    }

    protected Connection getConnection() {
        Connection connection = null;
        try {
            connection = this.open();
            if (connection == null || connection.isClosed()) {
                this.manager.getContext().getLogger().info((Object)sm.getString(this.getStoreName() + ".checkConnectionDBClosed"));
                connection = this.open();
                if (connection == null || connection.isClosed()) {
                    this.manager.getContext().getLogger().info((Object)sm.getString(this.getStoreName() + ".checkConnectionDBReOpenFail"));
                }
            }
        }
        catch (SQLException sQLException) {
            this.manager.getContext().getLogger().error((Object)sm.getString(this.getStoreName() + ".checkConnectionSQLException", new Object[]{sQLException.toString()}));
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection open() throws SQLException {
        Class<?> clazz;
        if (this.dbConnection != null) {
            return this.dbConnection;
        }
        if (this.dataSourceName != null && this.dataSource == null) {
            clazz = this.getManager().getContext();
            ClassLoader classLoader = null;
            if (this.localDataSource) {
                classLoader = clazz.bind(Globals.IS_SECURITY_ENABLED, null);
            }
            try {
                InitialContext initialContext = new InitialContext();
                javax.naming.Context context = (javax.naming.Context)initialContext.lookup("java:comp/env");
                this.dataSource = (DataSource)context.lookup(this.dataSourceName);
            }
            catch (NamingException namingException) {
                clazz.getLogger().error((Object)sm.getString(this.getStoreName() + ".wrongDataSource", new Object[]{this.dataSourceName}), (Throwable)namingException);
            }
            finally {
                if (this.localDataSource) {
                    clazz.unbind(Globals.IS_SECURITY_ENABLED, classLoader);
                }
            }
        }
        if (this.dataSource != null) {
            return this.dataSource.getConnection();
        }
        if (this.driver == null) {
            try {
                clazz = Class.forName(this.driverName);
                this.driver = (Driver)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                this.manager.getContext().getLogger().error((Object)sm.getString(this.getStoreName() + ".checkConnectionClassNotFoundException", new Object[]{reflectiveOperationException.toString()}));
                throw new SQLException(reflectiveOperationException);
            }
        }
        clazz = new Properties();
        if (this.connectionName != null) {
            ((Properties)((Object)clazz)).put("user", this.connectionName);
        }
        if (this.connectionPassword != null) {
            ((Properties)((Object)clazz)).put("password", this.connectionPassword);
        }
        this.dbConnection = this.driver.connect(this.connectionURL, (Properties)((Object)clazz));
        if (this.dbConnection == null) {
            throw new SQLException(sm.getString(this.getStoreName() + ".connectError", new Object[]{this.connectionURL}));
        }
        this.dbConnection.setAutoCommit(true);
        return this.dbConnection;
    }

    protected void close(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            this.preparedSizeSql.close();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        this.preparedSizeSql = null;
        try {
            this.preparedSaveSql.close();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        this.preparedSaveSql = null;
        try {
            this.preparedClearSql.close();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        try {
            this.preparedRemoveSql.close();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        this.preparedRemoveSql = null;
        try {
            this.preparedLoadSql.close();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        this.preparedLoadSql = null;
        try {
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            this.manager.getContext().getLogger().error((Object)sm.getString(this.getStoreName() + ".commitSQLException"), (Throwable)sQLException);
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            this.manager.getContext().getLogger().error((Object)sm.getString(this.getStoreName() + ".close", new Object[]{sQLException.toString()}));
        }
        finally {
            this.dbConnection = null;
        }
    }

    protected void release(Connection connection) {
        if (this.dataSource != null) {
            this.close(connection);
        }
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        if (this.dataSourceName == null) {
            this.dbConnection = this.getConnection();
        }
        super.startInternal();
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        if (this.dbConnection != null) {
            try {
                this.dbConnection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.close(this.dbConnection);
        }
    }
}

