/* tracker-backend.c generated by valac 0.56.3, the Vala compiler
 * generated from tracker-backend.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "libtracker-common/tracker-domain-ontology.h"
#include <gio/gio.h>
#include "libtracker-sparql/tracker-generated-no-checks.h"
#include <glib-object.h>
#include "libtracker-sparql/tracker-namespace-manager.h"
#include "libtracker-direct/tracker-direct.h"
#include "libtracker-data/tracker-db-interface.h"
#include "tracker-bus.h"
#include "tracker-sparql-2.0.h"
#include "tracker-remote.h"

#define TRACKER_SPARQL_TYPE_BACKEND (tracker_sparql_backend_get_type ())
#define TRACKER_SPARQL_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackend))
#define TRACKER_SPARQL_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendClass))
#define TRACKER_SPARQL_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_BACKEND))
#define TRACKER_SPARQL_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_BACKEND))
#define TRACKER_SPARQL_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendClass))

typedef struct _TrackerSparqlBackend TrackerSparqlBackend;
typedef struct _TrackerSparqlBackendClass TrackerSparqlBackendClass;
typedef struct _TrackerSparqlBackendPrivate TrackerSparqlBackendPrivate;
enum  {
	TRACKER_SPARQL_BACKEND_0_PROPERTY,
	TRACKER_SPARQL_BACKEND_NUM_PROPERTIES
};
static GParamSpec* tracker_sparql_backend_properties[TRACKER_SPARQL_BACKEND_NUM_PROPERTIES];
typedef enum  {
	TRACKER_SPARQL_BACKEND_BACKEND_AUTO,
	TRACKER_SPARQL_BACKEND_BACKEND_DIRECT,
	TRACKER_SPARQL_BACKEND_BACKEND_BUS
} TrackerSparqlBackendBackend;

#define TRACKER_SPARQL_BACKEND_TYPE_BACKEND (tracker_sparql_backend_backend_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _tracker_domain_ontology_unref0(var) ((var == NULL) ? NULL : (var = (tracker_domain_ontology_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerSparqlBackendQueryAsyncData TrackerSparqlBackendQueryAsyncData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerSparqlBackendUpdateAsyncData TrackerSparqlBackendUpdateAsyncData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _TrackerSparqlBackendUpdateArrayAsyncData TrackerSparqlBackendUpdateArrayAsyncData;
typedef struct _TrackerSparqlBackendUpdateBlankAsyncData TrackerSparqlBackendUpdateBlankAsyncData;
typedef struct _TrackerSparqlBackendLoadAsyncData TrackerSparqlBackendLoadAsyncData;
typedef struct _TrackerSparqlBackendStatisticsAsyncData TrackerSparqlBackendStatisticsAsyncData;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
typedef struct _TrackerSparqlBackendGetInternalAsyncData TrackerSparqlBackendGetInternalAsyncData;
typedef struct _TrackerSparqlConnectionGetAsyncData TrackerSparqlConnectionGetAsyncData;
typedef struct _TrackerSparqlConnectionLocalNewAsyncData TrackerSparqlConnectionLocalNewAsyncData;

struct _TrackerSparqlBackend {
	TrackerSparqlConnection parent_instance;
	TrackerSparqlBackendPrivate * priv;
};

struct _TrackerSparqlBackendClass {
	TrackerSparqlConnectionClass parent_class;
};

struct _TrackerSparqlBackendPrivate {
	gboolean initialized;
	TrackerSparqlConnection* direct;
	TrackerSparqlConnection* bus;
};

struct _TrackerSparqlBackendQueryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlCursor* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	TrackerSparqlCursor* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	TrackerSparqlCursor* _tmp5_;
	TrackerSparqlConnection* _tmp6_;
	TrackerSparqlCursor* _tmp7_;
	TrackerSparqlCursor* _tmp8_;
	GError* _inner_error0_;
};

struct _TrackerSparqlBackendUpdateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	TrackerSparqlConnection* _tmp0_;
	GError* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GError* _inner_error0_;
};

struct _TrackerSparqlBackendUpdateArrayAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	gchar** sparql;
	gint sparql_length1;
	gint priority;
	GCancellable* cancellable;
	GPtrArray* result;
	TrackerSparqlConnection* _tmp0_;
	GError* _tmp1_;
	GPtrArray* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	GPtrArray* _tmp4_;
	GPtrArray* _tmp5_;
	GError* _inner_error0_;
};

struct _TrackerSparqlBackendUpdateBlankAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
	TrackerSparqlConnection* _tmp0_;
	GError* _tmp1_;
	GVariant* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GError* _inner_error0_;
};

struct _TrackerSparqlBackendLoadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	GFile* file;
	GCancellable* cancellable;
	gchar* uri;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GError* _tmp3_;
	TrackerSparqlConnection* _tmp4_;
	GError* _inner_error0_;
};

struct _TrackerSparqlBackendStatisticsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlConnection* _tmp0_;
	GError* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	TrackerSparqlCursor* _tmp5_;
	GError* _inner_error0_;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	GAsyncResult* async_result;
};

struct _Block2Data {
	int _ref_count_;
	GError* sparql_error;
	GError* io_error;
	GError* dbus_error;
	GError* spawn_error;
	TrackerSparqlConnection* _result_;
	GMainContext* context;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _TrackerSparqlBackendGetInternalAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	Block2Data* _data2_;
	TrackerSparqlConnection* _result_;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GMainContext* _tmp3_;
	GMainContext* _tmp4_;
	GError* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	TrackerSparqlConnection* _tmp17_;
	TrackerSparqlConnection* _tmp18_;
	GError* _inner_error0_;
};

struct _TrackerSparqlConnectionGetAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GError* _inner_error0_;
};

struct _TrackerSparqlConnectionLocalNewAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlConnectionFlags flags;
	GFile* store;
	GFile* journal;
	GFile* ontology;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	TrackerDirectConnection* conn;
	TrackerDirectConnection* _tmp0_;
	GError* _inner_error0_;
};

VALA_EXTERN gchar* domain_name;
gchar* domain_name = NULL;
VALA_EXTERN TrackerDomainOntology* domain_ontology;
TrackerDomainOntology* domain_ontology = NULL;
VALA_EXTERN GDBusConnection* global_dbus_connection;
GDBusConnection* global_dbus_connection = NULL;
static gint TrackerSparqlBackend_private_offset;
static gpointer tracker_sparql_backend_parent_class = NULL;
static TrackerSparqlConnection* tracker_sparql_backend_singleton;
static TrackerSparqlConnection* tracker_sparql_backend_singleton = NULL;
static GMutex tracker_sparql_backend_door;
static GMutex tracker_sparql_backend_door = {0};

VALA_EXTERN GType tracker_sparql_backend_get_type (void) G_GNUC_CONST ;
static GType tracker_sparql_backend_backend_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN TrackerSparqlBackend* tracker_sparql_backend_new (GError** error);
VALA_EXTERN TrackerSparqlBackend* tracker_sparql_backend_construct (GType object_type,
                                                        GError** error);
static void tracker_sparql_backend_load_plugins (TrackerSparqlBackend* self,
                                          GError** error);
static void tracker_sparql_backend_real_dispose (GObject* base);
static TrackerSparqlCursor* tracker_sparql_backend_real_query (TrackerSparqlConnection* base,
                                                        const gchar* sparql,
                                                        GCancellable* cancellable,
                                                        GError** error);
static void tracker_sparql_backend_real_query_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_query_async (TrackerSparqlConnection* base,
                                              const gchar* sparql,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean tracker_sparql_backend_real_query_async_co (TrackerSparqlBackendQueryAsyncData* _data_);
static void tracker_sparql_backend_query_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static TrackerSparqlStatement* tracker_sparql_backend_real_query_statement (TrackerSparqlConnection* base,
                                                                     const gchar* sparql,
                                                                     GCancellable* cancellable,
                                                                     GError** error);
static void tracker_sparql_backend_real_update (TrackerSparqlConnection* base,
                                         const gchar* sparql,
                                         gint priority,
                                         GCancellable* cancellable,
                                         GError** error);
static GVariant* tracker_sparql_backend_real_update_blank (TrackerSparqlConnection* base,
                                                    const gchar* sparql,
                                                    gint priority,
                                                    GCancellable* cancellable,
                                                    GError** error);
static void tracker_sparql_backend_real_update_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_async (TrackerSparqlConnection* base,
                                               const gchar* sparql,
                                               gint priority,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_async_co (TrackerSparqlBackendUpdateAsyncData* _data_);
static void tracker_sparql_backend_update_async_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void tracker_sparql_backend_real_update_array_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_array_async (TrackerSparqlConnection* base,
                                                     gchar** sparql,
                                                     gint sparql_length1,
                                                     gint priority,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_array_async_co (TrackerSparqlBackendUpdateArrayAsyncData* _data_);
static void tracker_sparql_backend_update_array_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void tracker_sparql_backend_real_update_blank_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_blank_async (TrackerSparqlConnection* base,
                                                     const gchar* sparql,
                                                     gint priority,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_blank_async_co (TrackerSparqlBackendUpdateBlankAsyncData* _data_);
static void tracker_sparql_backend_update_blank_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void tracker_sparql_backend_real_load (TrackerSparqlConnection* base,
                                       GFile* file,
                                       GCancellable* cancellable,
                                       GError** error);
static void tracker_sparql_backend_real_load_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_load_async (TrackerSparqlConnection* base,
                                             GFile* file,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean tracker_sparql_backend_real_load_async_co (TrackerSparqlBackendLoadAsyncData* _data_);
static void tracker_sparql_backend_load_async_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static TrackerSparqlCursor* tracker_sparql_backend_real_statistics (TrackerSparqlConnection* base,
                                                             GCancellable* cancellable,
                                                             GError** error);
static void tracker_sparql_backend_real_statistics_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_statistics_async (TrackerSparqlConnection* base,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gboolean tracker_sparql_backend_real_statistics_async_co (TrackerSparqlBackendStatisticsAsyncData* _data_);
static void tracker_sparql_backend_statistics_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static TrackerNamespaceManager* tracker_sparql_backend_real_get_namespace_manager (TrackerSparqlConnection* base);
static TrackerSparqlConnection* tracker_sparql_backend_create_readonly_direct (TrackerSparqlBackend* self,
                                                                        GError** error);
static TrackerSparqlConnection* tracker_sparql_backend_get (GCancellable* cancellable,
                                                     GError** error);
VALA_EXTERN TrackerSparqlConnection* tracker_sparql_backend_get_internal (GCancellable* cancellable,
                                                              GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN void tracker_sparql_backend_get_internal_async (GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN TrackerSparqlConnection* tracker_sparql_backend_get_internal_finish (GAsyncResult* _res_,
                                                                     GError** error);
static void __lambda6_ (Block1Data* _data1_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda6__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void tracker_sparql_backend_get_internal_async_data_free (gpointer _data);
static gboolean tracker_sparql_backend_get_internal_async_co (TrackerSparqlBackendGetInternalAsyncData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda4_ (Block2Data* _data2_,
                     GIOSchedulerJob* job);
static gboolean __lambda5_ (Block2Data* _data2_);
static gboolean ___lambda5__gsource_func (gpointer self);
static gboolean ___lambda4__gio_scheduler_job_func (GIOSchedulerJob* job,
                                             GCancellable* cancellable,
                                             gpointer self);
static void tracker_sparql_backend_finalize (GObject * obj);
static GType tracker_sparql_backend_get_type_once (void);
static void tracker_sparql_connection_get_async_data_free (gpointer _data);
static gboolean tracker_sparql_connection_get_async_co (TrackerSparqlConnectionGetAsyncData* _data_);
static void tracker_sparql_connection_get_async_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void tracker_sparql_connection_local_new_async_data_free (gpointer _data);
static gboolean tracker_sparql_connection_local_new_async_co (TrackerSparqlConnectionLocalNewAsyncData* _data_);

static inline gpointer
tracker_sparql_backend_get_instance_private (TrackerSparqlBackend* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerSparqlBackend_private_offset);
}

static GType
tracker_sparql_backend_backend_get_type_once (void)
{
	static const GEnumValue values[] = {{TRACKER_SPARQL_BACKEND_BACKEND_AUTO, "TRACKER_SPARQL_BACKEND_BACKEND_AUTO", "auto"}, {TRACKER_SPARQL_BACKEND_BACKEND_DIRECT, "TRACKER_SPARQL_BACKEND_BACKEND_DIRECT", "direct"}, {TRACKER_SPARQL_BACKEND_BACKEND_BUS, "TRACKER_SPARQL_BACKEND_BACKEND_BUS", "bus"}, {0, NULL, NULL}};
	GType tracker_sparql_backend_backend_type_id;
	tracker_sparql_backend_backend_type_id = g_enum_register_static ("TrackerSparqlBackendBackend", values);
	return tracker_sparql_backend_backend_type_id;
}

static GType
tracker_sparql_backend_backend_get_type (void)
{
	static volatile gsize tracker_sparql_backend_backend_type_id__once = 0;
	if (g_once_init_enter (&tracker_sparql_backend_backend_type_id__once)) {
		GType tracker_sparql_backend_backend_type_id;
		tracker_sparql_backend_backend_type_id = tracker_sparql_backend_backend_get_type_once ();
		g_once_init_leave (&tracker_sparql_backend_backend_type_id__once, tracker_sparql_backend_backend_type_id);
	}
	return tracker_sparql_backend_backend_type_id__once;
}

TrackerSparqlBackend*
tracker_sparql_backend_construct (GType object_type,
                                  GError** error)
{
	TrackerSparqlBackend * self = NULL;
	GError* _inner_error0_ = NULL;
	self = (TrackerSparqlBackend*) tracker_sparql_connection_construct (object_type);
	{
		TrackerDomainOntology* _tmp0_ = NULL;
		const gchar* _tmp1_;
		TrackerDomainOntology* _tmp2_;
		TrackerDomainOntology* _tmp3_;
		_tmp1_ = domain_name;
		_tmp2_ = tracker_domain_ontology_new (_tmp1_, NULL, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_tracker_domain_ontology_unref0 (domain_ontology);
		domain_ontology = _tmp3_;
		tracker_sparql_backend_load_plugins (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_tracker_domain_ontology_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tracker_domain_ontology_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = g_strconcat ("Failed to load SPARQL backend: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_inner_error0_ = _tmp9_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((((_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) || (_inner_error0_->domain == G_DBUS_ERROR)) || (_inner_error0_->domain == G_SPAWN_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	self->priv->initialized = TRUE;
	return self;
}

TrackerSparqlBackend*
tracker_sparql_backend_new (GError** error)
{
	return tracker_sparql_backend_construct (TRACKER_SPARQL_TYPE_BACKEND, error);
}

static void
tracker_sparql_backend_real_dispose (GObject* base)
{
	TrackerSparqlBackend * self;
	GError* _inner_error0_ = NULL;
	self = (TrackerSparqlBackend*) base;
	if (self->priv->initialized) {
		g_mutex_lock (&tracker_sparql_backend_door);
		{
			TrackerSparqlConnection* _tmp0_;
			_tmp0_ = tracker_sparql_backend_singleton;
			if (_tmp0_ == G_TYPE_CHECK_INSTANCE_CAST (self, TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection)) {
				tracker_sparql_backend_singleton = NULL;
			}
		}
		__finally0:
		{
			g_mutex_unlock (&tracker_sparql_backend_door);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	G_OBJECT_CLASS (tracker_sparql_backend_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection));
}

static TrackerSparqlCursor*
tracker_sparql_backend_real_query (TrackerSparqlConnection* base,
                                   const gchar* sparql,
                                   GCancellable* cancellable,
                                   GError** error)
{
	TrackerSparqlBackend * self;
	TrackerSparqlConnection* _tmp0_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlCursor* result;
	self = (TrackerSparqlBackend*) base;
	g_return_val_if_fail (sparql != NULL, NULL);
	g_debug ("%s(): '%s'", "Tracker.Sparql.Backend.query", sparql);
	_tmp0_ = self->priv->direct;
	if (_tmp0_ != NULL) {
		TrackerSparqlCursor* _tmp1_ = NULL;
		TrackerSparqlConnection* _tmp2_;
		TrackerSparqlCursor* _tmp3_;
		TrackerSparqlCursor* _tmp4_;
		_tmp2_ = self->priv->direct;
		_tmp3_ = tracker_sparql_connection_query (_tmp2_, sparql, cancellable, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		result = _tmp4_;
		_g_object_unref0 (_tmp1_);
		return result;
	} else {
		TrackerSparqlCursor* _tmp5_ = NULL;
		TrackerSparqlConnection* _tmp6_;
		TrackerSparqlCursor* _tmp7_;
		TrackerSparqlCursor* _tmp8_;
		_tmp6_ = self->priv->bus;
		_tmp7_ = tracker_sparql_connection_query (_tmp6_, sparql, cancellable, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp8_;
		_g_object_unref0 (_tmp5_);
		return result;
	}
}

static void
tracker_sparql_backend_real_query_async_data_free (gpointer _data)
{
	TrackerSparqlBackendQueryAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sparql);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerSparqlBackendQueryAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
tracker_sparql_backend_real_query_async (TrackerSparqlConnection* base,
                                         const gchar* sparql,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	TrackerSparqlBackend * self;
	TrackerSparqlBackendQueryAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (sparql != NULL);
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendQueryAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_query_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sparql);
	_g_free0 (_data_->sparql);
	_data_->sparql = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	tracker_sparql_backend_real_query_async_co (_data_);
}

static TrackerSparqlCursor*
tracker_sparql_backend_query_finish (TrackerSparqlConnection* base,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	TrackerSparqlCursor* result;
	TrackerSparqlBackendQueryAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
tracker_sparql_backend_query_async_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	TrackerSparqlBackendQueryAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_sparql_backend_real_query_async_co (_data_);
}

static gboolean
tracker_sparql_backend_real_query_async_co (TrackerSparqlBackendQueryAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("%s(): '%s'", "Tracker.Sparql.Backend.query_async", _data_->sparql);
	_data_->_tmp0_ = _data_->self->priv->direct;
	if (_data_->_tmp0_ != NULL) {
		_data_->_tmp2_ = _data_->self->priv->direct;
		_data_->_state_ = 1;
		tracker_sparql_connection_query_async (_data_->_tmp2_, _data_->sparql, _data_->cancellable, tracker_sparql_backend_query_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = tracker_sparql_connection_query_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp4_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_data_->result = _data_->_tmp4_;
		_g_object_unref0 (_data_->_tmp1_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp6_ = _data_->self->priv->bus;
		_data_->_state_ = 2;
		tracker_sparql_connection_query_async (_data_->_tmp6_, _data_->sparql, _data_->cancellable, tracker_sparql_backend_query_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp7_ = tracker_sparql_connection_query_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp5_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp8_ = _data_->_tmp5_;
		_data_->_tmp5_ = NULL;
		_data_->result = _data_->_tmp8_;
		_g_object_unref0 (_data_->_tmp5_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static TrackerSparqlStatement*
tracker_sparql_backend_real_query_statement (TrackerSparqlConnection* base,
                                             const gchar* sparql,
                                             GCancellable* cancellable,
                                             GError** error)
{
	TrackerSparqlBackend * self;
	TrackerSparqlConnection* _tmp0_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlStatement* result;
	self = (TrackerSparqlBackend*) base;
	g_return_val_if_fail (sparql != NULL, NULL);
	g_debug ("%s(): '%s'", "Tracker.Sparql.Backend.query_statement", sparql);
	_tmp0_ = self->priv->direct;
	if (_tmp0_ != NULL) {
		TrackerSparqlStatement* _tmp1_ = NULL;
		TrackerSparqlConnection* _tmp2_;
		TrackerSparqlStatement* _tmp3_;
		TrackerSparqlStatement* _tmp4_;
		_tmp2_ = self->priv->direct;
		_tmp3_ = tracker_sparql_connection_query_statement (_tmp2_, sparql, cancellable, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		result = _tmp4_;
		_g_object_unref0 (_tmp1_);
		return result;
	} else {
		g_warning ("Interface 'query_statement' not implemented on dbus interface");
		result = NULL;
		return result;
	}
}

static void
tracker_sparql_backend_real_update (TrackerSparqlConnection* base,
                                    const gchar* sparql,
                                    gint priority,
                                    GCancellable* cancellable,
                                    GError** error)
{
	TrackerSparqlBackend * self;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlConnection* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_if_fail (sparql != NULL);
	g_debug ("%s(priority:%d): '%s'", "Tracker.Sparql.Backend.update", priority, sparql);
	_tmp0_ = self->priv->bus;
	if (_tmp0_ == NULL) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
		_inner_error0_ = _tmp1_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = self->priv->bus;
	tracker_sparql_connection_update (_tmp2_, sparql, priority, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static GVariant*
tracker_sparql_backend_real_update_blank (TrackerSparqlConnection* base,
                                          const gchar* sparql,
                                          gint priority,
                                          GCancellable* cancellable,
                                          GError** error)
{
	TrackerSparqlBackend * self;
	TrackerSparqlConnection* _tmp0_;
	GVariant* _tmp2_ = NULL;
	TrackerSparqlConnection* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GError* _inner_error0_ = NULL;
	GVariant* result;
	self = (TrackerSparqlBackend*) base;
	g_return_val_if_fail (sparql != NULL, NULL);
	g_debug ("%s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_blank", priority, sparql);
	_tmp0_ = self->priv->bus;
	if (_tmp0_ == NULL) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
		_inner_error0_ = _tmp1_;
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = self->priv->bus;
	_tmp4_ = tracker_sparql_connection_update_blank (_tmp3_, sparql, priority, cancellable, &_inner_error0_);
	_tmp2_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp5_ = _tmp2_;
	_tmp2_ = NULL;
	result = _tmp5_;
	_g_variant_unref0 (_tmp2_);
	return result;
}

static void
tracker_sparql_backend_real_update_async_data_free (gpointer _data)
{
	TrackerSparqlBackendUpdateAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sparql);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerSparqlBackendUpdateAsyncData, _data_);
}

static void
tracker_sparql_backend_real_update_async (TrackerSparqlConnection* base,
                                          const gchar* sparql,
                                          gint priority,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (sparql != NULL);
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_update_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sparql);
	_g_free0 (_data_->sparql);
	_data_->sparql = _tmp1_;
	_data_->priority = priority;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	tracker_sparql_backend_real_update_async_co (_data_);
}

static void
tracker_sparql_backend_update_finish (TrackerSparqlConnection* base,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	TrackerSparqlBackendUpdateAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
tracker_sparql_backend_update_async_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	TrackerSparqlBackendUpdateAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_sparql_backend_real_update_async_co (_data_);
}

static gboolean
tracker_sparql_backend_real_update_async_co (TrackerSparqlBackendUpdateAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("%s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_async", _data_->priority, _data_->sparql);
	_data_->_tmp0_ = _data_->self->priv->bus;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
		_data_->_inner_error0_ = _data_->_tmp1_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->bus;
	_data_->_state_ = 1;
	tracker_sparql_connection_update_async (_data_->_tmp2_, _data_->sparql, _data_->priority, _data_->cancellable, tracker_sparql_backend_update_async_ready, _data_);
	return FALSE;
	_state_1:
	tracker_sparql_connection_update_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
tracker_sparql_backend_real_update_array_async_data_free (gpointer _data)
{
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_ptr_array_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerSparqlBackendUpdateArrayAsyncData, _data_);
}

static void
tracker_sparql_backend_real_update_array_async (TrackerSparqlConnection* base,
                                                gchar** sparql,
                                                gint sparql_length1,
                                                gint priority,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	GCancellable* _tmp1_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateArrayAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_update_array_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->sparql = sparql;
	_data_->sparql_length1 = sparql_length1;
	_data_->priority = priority;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	tracker_sparql_backend_real_update_array_async_co (_data_);
}

static GPtrArray*
tracker_sparql_backend_update_array_finish (TrackerSparqlConnection* base,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	GPtrArray* result;
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
tracker_sparql_backend_update_array_async_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_sparql_backend_real_update_array_async_co (_data_);
}

static gboolean
tracker_sparql_backend_real_update_array_async_co (TrackerSparqlBackendUpdateArrayAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->bus;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
		_data_->_inner_error0_ = _data_->_tmp1_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->bus;
	_data_->_state_ = 1;
	tracker_sparql_connection_update_array_async (_data_->_tmp3_, _data_->sparql, (gint) _data_->sparql_length1, _data_->priority, _data_->cancellable, tracker_sparql_backend_update_array_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = tracker_sparql_connection_update_array_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp2_ = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->_tmp2_;
	_data_->_tmp2_ = NULL;
	_data_->result = _data_->_tmp5_;
	_g_ptr_array_unref0 (_data_->_tmp2_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
tracker_sparql_backend_real_update_blank_async_data_free (gpointer _data)
{
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sparql);
	_g_object_unref0 (_data_->cancellable);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerSparqlBackendUpdateBlankAsyncData, _data_);
}

static void
tracker_sparql_backend_real_update_blank_async (TrackerSparqlConnection* base,
                                                const gchar* sparql,
                                                gint priority,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (sparql != NULL);
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateBlankAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_update_blank_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sparql);
	_g_free0 (_data_->sparql);
	_data_->sparql = _tmp1_;
	_data_->priority = priority;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	tracker_sparql_backend_real_update_blank_async_co (_data_);
}

static GVariant*
tracker_sparql_backend_update_blank_finish (TrackerSparqlConnection* base,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	GVariant* result;
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
tracker_sparql_backend_update_blank_async_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_sparql_backend_real_update_blank_async_co (_data_);
}

static gboolean
tracker_sparql_backend_real_update_blank_async_co (TrackerSparqlBackendUpdateBlankAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("%s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_blank_async", _data_->priority, _data_->sparql);
	_data_->_tmp0_ = _data_->self->priv->bus;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
		_data_->_inner_error0_ = _data_->_tmp1_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->bus;
	_data_->_state_ = 1;
	tracker_sparql_connection_update_blank_async (_data_->_tmp3_, _data_->sparql, _data_->priority, _data_->cancellable, tracker_sparql_backend_update_blank_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = tracker_sparql_connection_update_blank_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp2_ = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->_tmp2_;
	_data_->_tmp2_ = NULL;
	_data_->result = _data_->_tmp5_;
	_g_variant_unref0 (_data_->_tmp2_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
tracker_sparql_backend_real_load (TrackerSparqlConnection* base,
                                  GFile* file,
                                  GCancellable* cancellable,
                                  GError** error)
{
	TrackerSparqlBackend * self;
	gchar* uri = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	TrackerSparqlConnection* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_uri (file);
	uri = _tmp0_;
	_tmp1_ = uri;
	g_debug ("%s(): '%s'", "Tracker.Sparql.Backend.load", _tmp1_);
	_tmp2_ = self->priv->bus;
	if (_tmp2_ == NULL) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
		_inner_error0_ = _tmp3_;
		if (((_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) || (_inner_error0_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (uri);
			return;
		} else {
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp4_ = self->priv->bus;
	tracker_sparql_connection_load (_tmp4_, file, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (((_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) || (_inner_error0_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (uri);
			return;
		} else {
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_free0 (uri);
}

static void
tracker_sparql_backend_real_load_async_data_free (gpointer _data)
{
	TrackerSparqlBackendLoadAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerSparqlBackendLoadAsyncData, _data_);
}

static void
tracker_sparql_backend_real_load_async (TrackerSparqlConnection* base,
                                        GFile* file,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	TrackerSparqlBackend * self;
	TrackerSparqlBackendLoadAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (file != NULL);
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendLoadAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_load_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	tracker_sparql_backend_real_load_async_co (_data_);
}

static void
tracker_sparql_backend_load_finish (TrackerSparqlConnection* base,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	TrackerSparqlBackendLoadAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
tracker_sparql_backend_load_async_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	TrackerSparqlBackendLoadAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_sparql_backend_real_load_async_co (_data_);
}

static gboolean
tracker_sparql_backend_real_load_async_co (TrackerSparqlBackendLoadAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_get_uri (_data_->file);
	_data_->uri = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->uri;
	g_debug ("%s(): '%s'", "Tracker.Sparql.Backend.load_async", _data_->_tmp1_);
	_data_->_tmp2_ = _data_->self->priv->bus;
	if (_data_->_tmp2_ == NULL) {
		_data_->_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
		_data_->_inner_error0_ = _data_->_tmp3_;
		if (((_data_->_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->uri);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp4_ = _data_->self->priv->bus;
	_data_->_state_ = 1;
	tracker_sparql_connection_load_async (_data_->_tmp4_, _data_->file, _data_->cancellable, tracker_sparql_backend_load_async_ready, _data_);
	return FALSE;
	_state_1:
	tracker_sparql_connection_load_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (((_data_->_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->uri);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_free0 (_data_->uri);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static TrackerSparqlCursor*
tracker_sparql_backend_real_statistics (TrackerSparqlConnection* base,
                                        GCancellable* cancellable,
                                        GError** error)
{
	TrackerSparqlBackend * self;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlCursor* _tmp2_ = NULL;
	TrackerSparqlConnection* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	TrackerSparqlCursor* _tmp5_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlCursor* result;
	self = (TrackerSparqlBackend*) base;
	g_debug ("%s()", "Tracker.Sparql.Backend.statistics");
	_tmp0_ = self->priv->bus;
	if (_tmp0_ == NULL) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Statistics support not available for direct-only connection");
		_inner_error0_ = _tmp1_;
		if (((_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) || (_inner_error0_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = self->priv->bus;
	_tmp4_ = tracker_sparql_connection_statistics (_tmp3_, cancellable, &_inner_error0_);
	_tmp2_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (((_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) || (_inner_error0_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = _tmp2_;
	_tmp2_ = NULL;
	result = _tmp5_;
	_g_object_unref0 (_tmp2_);
	return result;
}

static void
tracker_sparql_backend_real_statistics_async_data_free (gpointer _data)
{
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerSparqlBackendStatisticsAsyncData, _data_);
}

static void
tracker_sparql_backend_real_statistics_async (TrackerSparqlConnection* base,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	TrackerSparqlBackend * self;
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	GCancellable* _tmp1_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendStatisticsAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_statistics_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	tracker_sparql_backend_real_statistics_async_co (_data_);
}

static TrackerSparqlCursor*
tracker_sparql_backend_statistics_finish (TrackerSparqlConnection* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	TrackerSparqlCursor* result;
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
tracker_sparql_backend_statistics_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_sparql_backend_real_statistics_async_co (_data_);
}

static gboolean
tracker_sparql_backend_real_statistics_async_co (TrackerSparqlBackendStatisticsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("%s()", "Tracker.Sparql.Backend.statistics_async");
	_data_->_tmp0_ = _data_->self->priv->bus;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Statistics support not available for direct-only connection");
		_data_->_inner_error0_ = _data_->_tmp1_;
		if (((_data_->_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp3_ = _data_->self->priv->bus;
	_data_->_state_ = 1;
	tracker_sparql_connection_statistics_async (_data_->_tmp3_, _data_->cancellable, tracker_sparql_backend_statistics_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = tracker_sparql_connection_statistics_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp2_ = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (((_data_->_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp5_ = _data_->_tmp2_;
	_data_->_tmp2_ = NULL;
	_data_->result = _data_->_tmp5_;
	_g_object_unref0 (_data_->_tmp2_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static TrackerNamespaceManager*
tracker_sparql_backend_real_get_namespace_manager (TrackerSparqlConnection* base)
{
	TrackerSparqlBackend * self;
	TrackerSparqlConnection* _tmp0_;
	TrackerNamespaceManager* result;
	self = (TrackerSparqlBackend*) base;
	_tmp0_ = self->priv->direct;
	if (_tmp0_ != NULL) {
		TrackerSparqlConnection* _tmp1_;
		TrackerNamespaceManager* _tmp2_;
		_tmp1_ = self->priv->direct;
		_tmp2_ = tracker_sparql_connection_get_namespace_manager (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		TrackerNamespaceManager* _tmp3_;
		_tmp3_ = tracker_namespace_manager_get_default ();
		result = _tmp3_;
		return result;
	}
}

static TrackerSparqlConnection*
tracker_sparql_backend_create_readonly_direct (TrackerSparqlBackend* self,
                                               GError** error)
{
	TrackerDirectConnection* conn = NULL;
	TrackerDomainOntology* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	TrackerDomainOntology* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	TrackerDomainOntology* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	TrackerDirectConnection* _tmp9_;
	TrackerDirectConnection* _tmp10_;
	TrackerDirectConnection* _tmp11_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlConnection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = domain_ontology;
	_tmp1_ = tracker_domain_ontology_get_cache (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = domain_ontology;
	_tmp4_ = tracker_domain_ontology_get_journal (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = domain_ontology;
	_tmp7_ = tracker_domain_ontology_get_ontology (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = tracker_direct_connection_new (TRACKER_SPARQL_CONNECTION_FLAGS_READONLY, _tmp2_, _tmp5_, _tmp8_, &_inner_error0_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp2_);
	conn = _tmp10_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp11_ = conn;
	g_initable_init ((GInitable*) _tmp11_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (conn);
		return NULL;
	}
	result = (TrackerSparqlConnection*) conn;
	return result;
}

static void
tracker_sparql_backend_load_plugins (TrackerSparqlBackend* self,
                                     GError** error)
{
	gchar* env_backend = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	TrackerSparqlBackendBackend backend = 0;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_getenv ("TRACKER_SPARQL_BACKEND");
	_tmp1_ = g_strdup (_tmp0_);
	env_backend = _tmp1_;
	backend = TRACKER_SPARQL_BACKEND_BACKEND_AUTO;
	_tmp2_ = env_backend;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = env_backend;
		if (g_ascii_strcasecmp (_tmp3_, "direct") == 0) {
			backend = TRACKER_SPARQL_BACKEND_BACKEND_DIRECT;
			g_debug ("Using backend = 'DIRECT'");
		} else {
			const gchar* _tmp4_;
			_tmp4_ = env_backend;
			if (g_ascii_strcasecmp (_tmp4_, "bus") == 0) {
				backend = TRACKER_SPARQL_BACKEND_BACKEND_BUS;
				g_debug ("Using backend = 'BUS'");
			} else {
				const gchar* _tmp5_;
				_tmp5_ = env_backend;
				g_warning ("Environment variable TRACKER_SPARQL_BACKEND set to unknown value '%s'", _tmp5_);
			}
		}
	}
	if (backend == TRACKER_SPARQL_BACKEND_BACKEND_AUTO) {
		g_debug ("Using backend = 'AUTO'");
	}
	switch (backend) {
		case TRACKER_SPARQL_BACKEND_BACKEND_AUTO:
		{
			gboolean direct_failed = FALSE;
			TrackerBusConnection* _tmp9_ = NULL;
			TrackerDomainOntology* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GDBusConnection* _tmp13_;
			TrackerBusConnection* _tmp14_;
			TrackerBusConnection* _tmp15_;
			TrackerBusConnection* _tmp16_;
			direct_failed = FALSE;
			{
				TrackerSparqlConnection* _tmp6_ = NULL;
				TrackerSparqlConnection* _tmp7_;
				TrackerSparqlConnection* _tmp8_;
				_tmp7_ = tracker_sparql_backend_create_readonly_direct (self, &_inner_error0_);
				_tmp6_ = _tmp7_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == TRACKER_DB_INTERFACE_ERROR) {
						goto __catch0_tracker_db_interface_error;
					}
					goto __finally0;
				}
				_tmp8_ = _tmp6_;
				_tmp6_ = NULL;
				_g_object_unref0 (self->priv->direct);
				self->priv->direct = _tmp8_;
				_g_object_unref0 (_tmp6_);
			}
			goto __finally0;
			__catch0_tracker_db_interface_error:
			{
				g_clear_error (&_inner_error0_);
				direct_failed = TRUE;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (env_backend);
				return;
			}
			_tmp10_ = domain_ontology;
			_tmp11_ = tracker_domain_ontology_get_domain (_tmp10_, "Tracker1");
			_tmp12_ = _tmp11_;
			_tmp13_ = global_dbus_connection;
			_tmp14_ = tracker_bus_connection_new (_tmp12_, _tmp13_, direct_failed, &_inner_error0_);
			_tmp15_ = _tmp14_;
			_g_free0 (_tmp12_);
			_tmp9_ = _tmp15_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (env_backend);
				return;
			}
			_tmp16_ = _tmp9_;
			_tmp9_ = NULL;
			_g_object_unref0 (self->priv->bus);
			self->priv->bus = (TrackerSparqlConnection*) _tmp16_;
			if (direct_failed) {
				{
					TrackerSparqlConnection* _tmp17_ = NULL;
					TrackerSparqlConnection* _tmp18_;
					TrackerSparqlConnection* _tmp19_;
					_tmp18_ = tracker_sparql_backend_create_readonly_direct (self, &_inner_error0_);
					_tmp17_ = _tmp18_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == TRACKER_DB_INTERFACE_ERROR) {
							goto __catch1_tracker_db_interface_error;
						}
						goto __finally1;
					}
					_tmp19_ = _tmp17_;
					_tmp17_ = NULL;
					_g_object_unref0 (self->priv->direct);
					self->priv->direct = _tmp19_;
					_g_object_unref0 (_tmp17_);
				}
				goto __finally1;
				__catch1_tracker_db_interface_error:
				{
					GError* e = NULL;
					GError* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp20_ = e;
					_tmp21_ = _tmp20_->message;
					_tmp22_ = g_strconcat ("Falling back to bus backend, the direct backend failed to initialize: ", _tmp21_, NULL);
					_tmp23_ = _tmp22_;
					g_warning ("%s", _tmp23_);
					_g_free0 (_tmp23_);
					_g_error_free0 (e);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (_tmp9_);
					_g_free0 (env_backend);
					return;
				}
			}
			_g_object_unref0 (_tmp9_);
			break;
		}
		case TRACKER_SPARQL_BACKEND_BACKEND_DIRECT:
		{
			TrackerSparqlConnection* _tmp24_ = NULL;
			TrackerSparqlConnection* _tmp25_;
			TrackerSparqlConnection* _tmp26_;
			_tmp25_ = tracker_sparql_backend_create_readonly_direct (self, &_inner_error0_);
			_tmp24_ = _tmp25_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (env_backend);
				return;
			}
			_tmp26_ = _tmp24_;
			_tmp24_ = NULL;
			_g_object_unref0 (self->priv->direct);
			self->priv->direct = _tmp26_;
			_g_object_unref0 (_tmp24_);
			break;
		}
		case TRACKER_SPARQL_BACKEND_BACKEND_BUS:
		{
			TrackerBusConnection* _tmp27_ = NULL;
			TrackerDomainOntology* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			GDBusConnection* _tmp31_;
			TrackerBusConnection* _tmp32_;
			TrackerBusConnection* _tmp33_;
			TrackerBusConnection* _tmp34_;
			_tmp28_ = domain_ontology;
			_tmp29_ = tracker_domain_ontology_get_domain (_tmp28_, "Tracker1");
			_tmp30_ = _tmp29_;
			_tmp31_ = global_dbus_connection;
			_tmp32_ = tracker_bus_connection_new (_tmp30_, _tmp31_, FALSE, &_inner_error0_);
			_tmp33_ = _tmp32_;
			_g_free0 (_tmp30_);
			_tmp27_ = _tmp33_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (env_backend);
				return;
			}
			_tmp34_ = _tmp27_;
			_tmp27_ = NULL;
			_g_object_unref0 (self->priv->bus);
			self->priv->bus = (TrackerSparqlConnection*) _tmp34_;
			_g_object_unref0 (_tmp27_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_g_free0 (env_backend);
}

static TrackerSparqlConnection*
tracker_sparql_backend_get (GCancellable* cancellable,
                            GError** error)
{
	GError* _inner_error0_ = NULL;
	TrackerSparqlConnection* result;
	g_mutex_lock (&tracker_sparql_backend_door);
	{
		TrackerSparqlConnection* _result_ = NULL;
		TrackerSparqlConnection* _tmp0_;
		TrackerSparqlConnection* _tmp1_;
		TrackerSparqlConnection* _tmp2_;
		_tmp0_ = tracker_sparql_backend_singleton;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_result_ = _tmp1_;
		_tmp2_ = _result_;
		if (_tmp2_ == NULL) {
			TrackerSparqlBackend* _tmp3_ = NULL;
			TrackerSparqlBackend* _tmp4_;
			TrackerSparqlBackend* _tmp5_;
			gboolean _tmp6_ = FALSE;
			TrackerSparqlConnection* _tmp8_;
			_tmp4_ = tracker_sparql_backend_new (&_inner_error0_);
			_tmp3_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_result_);
				goto __finally0;
			}
			_tmp5_ = _tmp3_;
			_tmp3_ = NULL;
			_g_object_unref0 (_result_);
			_result_ = (TrackerSparqlConnection*) _tmp5_;
			if (cancellable != NULL) {
				_tmp6_ = g_cancellable_is_cancelled (cancellable);
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				GError* _tmp7_;
				_tmp7_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
				_inner_error0_ = _tmp7_;
				_g_object_unref0 (_tmp3_);
				_g_object_unref0 (_result_);
				goto __finally0;
			}
			_tmp8_ = _result_;
			tracker_sparql_backend_singleton = _tmp8_;
			_g_object_unref0 (_tmp3_);
		}
		result = _result_;
		{
			GError* _inner_error0_ = NULL;
			g_mutex_unlock (&tracker_sparql_backend_door);
		}
		return result;
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		g_mutex_unlock (&tracker_sparql_backend_door);
	}
	if ((((_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) || (_inner_error0_->domain == G_DBUS_ERROR)) || (_inner_error0_->domain == G_SPAWN_ERROR)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->async_result);
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda6_ (Block1Data* _data1_,
            GObject* obj,
            GAsyncResult* res)
{
	GAsyncResult* _tmp0_;
	GMainLoop* _tmp1_;
	g_return_if_fail (res != NULL);
	_tmp0_ = _g_object_ref0 (res);
	_g_object_unref0 (_data1_->async_result);
	_data1_->async_result = _tmp0_;
	_tmp1_ = _data1_->loop;
	g_main_loop_quit (_tmp1_);
}

static void
___lambda6__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda6_ (self, source_object, res);
	block1_data_unref (self);
}

TrackerSparqlConnection*
tracker_sparql_backend_get_internal (GCancellable* cancellable,
                                     GError** error)
{
	Block1Data* _data1_;
	GMainContext* _tmp0_;
	GMainContext* context = NULL;
	GMainContext* _tmp4_;
	GMainContext* _tmp5_;
	GMainLoop* _tmp6_;
	GMainContext* _tmp7_;
	GMainLoop* _tmp8_;
	GMainContext* _tmp9_;
	TrackerSparqlConnection* _tmp10_ = NULL;
	GAsyncResult* _tmp11_;
	TrackerSparqlConnection* _tmp12_;
	TrackerSparqlConnection* _tmp13_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlConnection* result;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = g_main_context_get_thread_default ();
	if (_tmp0_ == NULL) {
		TrackerSparqlConnection* _tmp1_ = NULL;
		TrackerSparqlConnection* _tmp2_;
		TrackerSparqlConnection* _tmp3_;
		_tmp2_ = tracker_sparql_backend_get (cancellable, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if ((((_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) || (_inner_error0_->domain == G_DBUS_ERROR)) || (_inner_error0_->domain == G_SPAWN_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				block1_data_unref (_data1_);
				_data1_ = NULL;
				return NULL;
			} else {
				block1_data_unref (_data1_);
				_data1_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		result = _tmp3_;
		_g_object_unref0 (_tmp1_);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	_tmp4_ = g_main_context_new ();
	context = _tmp4_;
	_tmp5_ = context;
	_tmp6_ = g_main_loop_new (_tmp5_, FALSE);
	_data1_->loop = _tmp6_;
	_data1_->async_result = NULL;
	_tmp7_ = context;
	g_main_context_push_thread_default (_tmp7_);
	tracker_sparql_backend_get_internal_async (cancellable, ___lambda6__gasync_ready_callback, block1_data_ref (_data1_));
	_tmp8_ = _data1_->loop;
	g_main_loop_run (_tmp8_);
	_tmp9_ = context;
	g_main_context_pop_thread_default (_tmp9_);
	_tmp11_ = _data1_->async_result;
	_tmp12_ = tracker_sparql_backend_get_internal_finish (_tmp11_, &_inner_error0_);
	_tmp10_ = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((((_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) || (_inner_error0_->domain == G_DBUS_ERROR)) || (_inner_error0_->domain == G_SPAWN_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_main_context_unref0 (context);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return NULL;
		} else {
			_g_main_context_unref0 (context);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp13_ = _tmp10_;
	_tmp10_ = NULL;
	result = _tmp13_;
	_g_object_unref0 (_tmp10_);
	_g_main_context_unref0 (context);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
tracker_sparql_backend_get_internal_async_data_free (gpointer _data)
{
	TrackerSparqlBackendGetInternalAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	g_slice_free (TrackerSparqlBackendGetInternalAsyncData, _data_);
}

void
tracker_sparql_backend_get_internal_async (GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	TrackerSparqlBackendGetInternalAsyncData* _data_;
	GCancellable* _tmp0_;
	_data_ = g_slice_new0 (TrackerSparqlBackendGetInternalAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_get_internal_async_data_free);
	_tmp0_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp0_;
	tracker_sparql_backend_get_internal_async_co (_data_);
}

TrackerSparqlConnection*
tracker_sparql_backend_get_internal_finish (GAsyncResult* _res_,
                                            GError** error)
{
	TrackerSparqlConnection* result;
	TrackerSparqlBackendGetInternalAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_main_context_unref0 (_data2_->context);
		_g_object_unref0 (_data2_->_result_);
		_g_error_free0 (_data2_->spawn_error);
		_g_error_free0 (_data2_->dbus_error);
		_g_error_free0 (_data2_->io_error);
		_g_error_free0 (_data2_->sparql_error);
		_g_object_unref0 (_data2_->cancellable);
		g_slice_free (Block2Data, _data2_);
	}
}

static gpointer
_g_main_context_ref0 (gpointer self)
{
	return self ? g_main_context_ref (self) : NULL;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
__lambda5_ (Block2Data* _data2_)
{
	gboolean result;
	tracker_sparql_backend_get_internal_async_co (_data2_->_async_data_);
	result = FALSE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ (self);
	return result;
}

static gboolean
__lambda4_ (Block2Data* _data2_,
            GIOSchedulerJob* job)
{
	GSource* source = NULL;
	GSource* _tmp13_;
	GMainContext* _tmp14_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (job != NULL, FALSE);
	{
		TrackerSparqlConnection* _tmp0_ = NULL;
		TrackerSparqlConnection* _tmp1_;
		TrackerSparqlConnection* _tmp3_;
		_tmp1_ = tracker_sparql_backend_get (_data2_->cancellable, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch0_tracker_sparql_error;
			}
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (_data2_->_result_);
		_data2_->_result_ = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e_io = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
		e_io = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e_io;
		_tmp5_ = _g_error_copy0 (_tmp4_);
		_g_error_free0 (_data2_->io_error);
		_data2_->io_error = _tmp5_;
		_g_error_free0 (e_io);
	}
	goto __finally0;
	__catch0_tracker_sparql_error:
	{
		GError* e_spql = NULL;
		GError* _tmp6_;
		GError* _tmp7_;
		e_spql = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e_spql;
		_tmp7_ = _g_error_copy0 (_tmp6_);
		_g_error_free0 (_data2_->sparql_error);
		_data2_->sparql_error = _tmp7_;
		_g_error_free0 (e_spql);
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e_dbus = NULL;
		GError* _tmp8_;
		GError* _tmp9_;
		e_dbus = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e_dbus;
		_tmp9_ = _g_error_copy0 (_tmp8_);
		_g_error_free0 (_data2_->dbus_error);
		_data2_->dbus_error = _tmp9_;
		_g_error_free0 (e_dbus);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e_spawn = NULL;
		GError* _tmp10_;
		GError* _tmp11_;
		e_spawn = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e_spawn;
		_tmp11_ = _g_error_copy0 (_tmp10_);
		_g_error_free0 (_data2_->spawn_error);
		_data2_->spawn_error = _tmp11_;
		_g_error_free0 (e_spawn);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp12_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp12_;
	}
	_tmp13_ = g_idle_source_new ();
	source = _tmp13_;
	g_source_set_callback (source, ___lambda5__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	_tmp14_ = _data2_->context;
	g_source_attach (source, _tmp14_);
	result = FALSE;
	_g_source_unref0 (source);
	return result;
}

static gboolean
___lambda4__gio_scheduler_job_func (GIOSchedulerJob* job,
                                    GCancellable* cancellable,
                                    gpointer self)
{
	gboolean result;
	result = __lambda4_ (self, job);
	return result;
}

static gboolean
tracker_sparql_backend_get_internal_async_co (TrackerSparqlBackendGetInternalAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_g_object_unref0 (_data_->_data2_->cancellable);
	_data_->_data2_->cancellable = _data_->cancellable;
	_data_->_data2_->_async_data_ = _data_;
	if (g_mutex_trylock (&tracker_sparql_backend_door)) {
		_data_->_tmp0_ = tracker_sparql_backend_singleton;
		_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
		_data_->_result_ = _data_->_tmp1_;
		g_mutex_unlock (&tracker_sparql_backend_door);
		_data_->_tmp2_ = _data_->_result_;
		if (_data_->_tmp2_ != NULL) {
			_data_->result = _data_->_result_;
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->_result_);
	}
	_data_->_data2_->sparql_error = NULL;
	_data_->_data2_->io_error = NULL;
	_data_->_data2_->dbus_error = NULL;
	_data_->_data2_->spawn_error = NULL;
	_data_->_data2_->_result_ = NULL;
	_data_->_tmp3_ = g_main_context_get_thread_default ();
	_data_->_tmp4_ = _g_main_context_ref0 (_data_->_tmp3_);
	_data_->_data2_->context = _data_->_tmp4_;
	g_io_scheduler_push_job (___lambda4__gio_scheduler_job_func, block2_data_ref (_data_->_data2_), block2_data_unref, G_PRIORITY_DEFAULT, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp5_ = _data_->_data2_->sparql_error;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = _data_->_data2_->sparql_error;
		_data_->_tmp7_ = _g_error_copy0 (_data_->_tmp6_);
		_data_->_inner_error0_ = _data_->_tmp7_;
		if ((((_data_->_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) || (_data_->_inner_error0_->domain == G_SPAWN_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->_tmp8_ = _data_->_data2_->io_error;
		if (_data_->_tmp8_ != NULL) {
			_data_->_tmp9_ = _data_->_data2_->io_error;
			_data_->_tmp10_ = _g_error_copy0 (_data_->_tmp9_);
			_data_->_inner_error0_ = _data_->_tmp10_;
			if ((((_data_->_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) || (_data_->_inner_error0_->domain == G_SPAWN_ERROR)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				block2_data_unref (_data_->_data2_);
				_data_->_data2_ = NULL;
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				block2_data_unref (_data_->_data2_);
				_data_->_data2_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		} else {
			_data_->_tmp11_ = _data_->_data2_->dbus_error;
			if (_data_->_tmp11_ != NULL) {
				_data_->_tmp12_ = _data_->_data2_->dbus_error;
				_data_->_tmp13_ = _g_error_copy0 (_data_->_tmp12_);
				_data_->_inner_error0_ = _data_->_tmp13_;
				if ((((_data_->_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) || (_data_->_inner_error0_->domain == G_SPAWN_ERROR)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					block2_data_unref (_data_->_data2_);
					_data_->_data2_ = NULL;
					g_object_unref (_data_->_async_result);
					return FALSE;
				} else {
					block2_data_unref (_data_->_data2_);
					_data_->_data2_ = NULL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			} else {
				_data_->_tmp14_ = _data_->_data2_->spawn_error;
				if (_data_->_tmp14_ != NULL) {
					_data_->_tmp15_ = _data_->_data2_->spawn_error;
					_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
					_data_->_inner_error0_ = _data_->_tmp16_;
					if ((((_data_->_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) || (_data_->_inner_error0_->domain == G_SPAWN_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						block2_data_unref (_data_->_data2_);
						_data_->_data2_ = NULL;
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						block2_data_unref (_data_->_data2_);
						_data_->_data2_ = NULL;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				} else {
					_data_->_tmp17_ = _data_->_data2_->_result_;
					_data_->_tmp18_ = _g_object_ref0 (_data_->_tmp17_);
					_data_->result = _data_->_tmp18_;
					block2_data_unref (_data_->_data2_);
					_data_->_data2_ = NULL;
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
		}
	}
}

static void
tracker_sparql_backend_class_init (TrackerSparqlBackendClass * klass,
                                   gpointer klass_data)
{
	tracker_sparql_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TrackerSparqlBackend_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) tracker_sparql_backend_real_dispose;
	((TrackerSparqlConnectionClass *) klass)->query = (TrackerSparqlCursor* (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GError**)) tracker_sparql_backend_real_query;
	((TrackerSparqlConnectionClass *) klass)->query_async = (void (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_query_async;
	((TrackerSparqlConnectionClass *) klass)->query_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_sparql_backend_query_finish;
	((TrackerSparqlConnectionClass *) klass)->query_statement = (TrackerSparqlStatement* (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GError**)) tracker_sparql_backend_real_query_statement;
	((TrackerSparqlConnectionClass *) klass)->update = (void (*) (TrackerSparqlConnection*, const gchar*, gint, GCancellable*, GError**)) tracker_sparql_backend_real_update;
	((TrackerSparqlConnectionClass *) klass)->update_blank = (GVariant* (*) (TrackerSparqlConnection*, const gchar*, gint, GCancellable*, GError**)) tracker_sparql_backend_real_update_blank;
	((TrackerSparqlConnectionClass *) klass)->update_async = (void (*) (TrackerSparqlConnection*, const gchar*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_update_async;
	((TrackerSparqlConnectionClass *) klass)->update_finish = (void (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_sparql_backend_update_finish;
	((TrackerSparqlConnectionClass *) klass)->update_array_async = (void (*) (TrackerSparqlConnection*, gchar**, gint, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_update_array_async;
	((TrackerSparqlConnectionClass *) klass)->update_array_finish = (GPtrArray* (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_sparql_backend_update_array_finish;
	((TrackerSparqlConnectionClass *) klass)->update_blank_async = (void (*) (TrackerSparqlConnection*, const gchar*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_update_blank_async;
	((TrackerSparqlConnectionClass *) klass)->update_blank_finish = (GVariant* (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_sparql_backend_update_blank_finish;
	((TrackerSparqlConnectionClass *) klass)->load = (void (*) (TrackerSparqlConnection*, GFile*, GCancellable*, GError**)) tracker_sparql_backend_real_load;
	((TrackerSparqlConnectionClass *) klass)->load_async = (void (*) (TrackerSparqlConnection*, GFile*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_load_async;
	((TrackerSparqlConnectionClass *) klass)->load_finish = (void (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_sparql_backend_load_finish;
	((TrackerSparqlConnectionClass *) klass)->statistics = (TrackerSparqlCursor* (*) (TrackerSparqlConnection*, GCancellable*, GError**)) tracker_sparql_backend_real_statistics;
	((TrackerSparqlConnectionClass *) klass)->statistics_async = (void (*) (TrackerSparqlConnection*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_statistics_async;
	((TrackerSparqlConnectionClass *) klass)->statistics_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_sparql_backend_statistics_finish;
	((TrackerSparqlConnectionClass *) klass)->get_namespace_manager = (TrackerNamespaceManager* (*) (TrackerSparqlConnection*)) tracker_sparql_backend_real_get_namespace_manager;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_backend_finalize;
}

static void
tracker_sparql_backend_instance_init (TrackerSparqlBackend * self,
                                      gpointer klass)
{
	self->priv = tracker_sparql_backend_get_instance_private (self);
	self->priv->direct = NULL;
	self->priv->bus = NULL;
}

static void
tracker_sparql_backend_finalize (GObject * obj)
{
	TrackerSparqlBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackend);
	_g_object_unref0 (self->priv->direct);
	_g_object_unref0 (self->priv->bus);
	G_OBJECT_CLASS (tracker_sparql_backend_parent_class)->finalize (obj);
}

static GType
tracker_sparql_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlBackend), 0, (GInstanceInitFunc) tracker_sparql_backend_instance_init, NULL };
	GType tracker_sparql_backend_type_id;
	tracker_sparql_backend_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerSparqlBackend", &g_define_type_info, 0);
	TrackerSparqlBackend_private_offset = g_type_add_instance_private (tracker_sparql_backend_type_id, sizeof (TrackerSparqlBackendPrivate));
	return tracker_sparql_backend_type_id;
}

GType
tracker_sparql_backend_get_type (void)
{
	static volatile gsize tracker_sparql_backend_type_id__once = 0;
	if (g_once_init_enter (&tracker_sparql_backend_type_id__once)) {
		GType tracker_sparql_backend_type_id;
		tracker_sparql_backend_type_id = tracker_sparql_backend_get_type_once ();
		g_once_init_leave (&tracker_sparql_backend_type_id__once, tracker_sparql_backend_type_id);
	}
	return tracker_sparql_backend_type_id__once;
}

static void
tracker_sparql_connection_get_async_data_free (gpointer _data)
{
	TrackerSparqlConnectionGetAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (TrackerSparqlConnectionGetAsyncData, _data_);
}

void
tracker_sparql_connection_get_async (GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	TrackerSparqlConnectionGetAsyncData* _data_;
	GCancellable* _tmp0_;
	_data_ = g_slice_new0 (TrackerSparqlConnectionGetAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_get_async_data_free);
	_tmp0_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp0_;
	tracker_sparql_connection_get_async_co (_data_);
}

TrackerSparqlConnection*
tracker_sparql_connection_get_finish (GAsyncResult* _res_,
                                      GError** error)
{
	TrackerSparqlConnection* result;
	TrackerSparqlConnectionGetAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
tracker_sparql_connection_get_async_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	TrackerSparqlConnectionGetAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_sparql_connection_get_async_co (_data_);
}

static gboolean
tracker_sparql_connection_get_async_co (TrackerSparqlConnectionGetAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	tracker_sparql_backend_get_internal_async (_data_->cancellable, tracker_sparql_connection_get_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = tracker_sparql_backend_get_internal_finish (_data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((((_data_->_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) || (_data_->_inner_error0_->domain == G_SPAWN_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp2_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp2_;
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

TrackerSparqlConnection*
tracker_sparql_connection_get (GCancellable* cancellable,
                               GError** error)
{
	TrackerSparqlConnection* _tmp0_ = NULL;
	TrackerSparqlConnection* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlConnection* result;
	_tmp1_ = tracker_sparql_backend_get_internal (cancellable, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((((_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) || (_inner_error0_->domain == G_DBUS_ERROR)) || (_inner_error0_->domain == G_SPAWN_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

TrackerSparqlConnection*
tracker_sparql_connection_remote_new (const gchar* url_base)
{
	TrackerRemoteConnection* _tmp0_;
	TrackerSparqlConnection* result;
	g_return_val_if_fail (url_base != NULL, NULL);
	_tmp0_ = tracker_remote_connection_new (url_base);
	result = (TrackerSparqlConnection*) _tmp0_;
	return result;
}

TrackerSparqlConnection*
tracker_sparql_connection_local_new (TrackerSparqlConnectionFlags flags,
                                     GFile* store,
                                     GFile* journal,
                                     GFile* ontology,
                                     GCancellable* cancellable,
                                     GError** error)
{
	TrackerDirectConnection* conn = NULL;
	TrackerDirectConnection* _tmp0_;
	TrackerDirectConnection* _tmp1_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlConnection* result;
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = tracker_direct_connection_new (flags, store, journal, ontology, &_inner_error0_);
	conn = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = conn;
	g_initable_init ((GInitable*) _tmp1_, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (conn);
		return NULL;
	}
	result = (TrackerSparqlConnection*) conn;
	return result;
}

static void
tracker_sparql_connection_local_new_async_data_free (gpointer _data)
{
	TrackerSparqlConnectionLocalNewAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->store);
	_g_object_unref0 (_data_->journal);
	_g_object_unref0 (_data_->ontology);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (TrackerSparqlConnectionLocalNewAsyncData, _data_);
}

void
tracker_sparql_connection_local_new_async (TrackerSparqlConnectionFlags flags,
                                           GFile* store,
                                           GFile* journal,
                                           GFile* ontology,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	TrackerSparqlConnectionLocalNewAsyncData* _data_;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (store != NULL);
	_data_ = g_slice_new0 (TrackerSparqlConnectionLocalNewAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_local_new_async_data_free);
	_data_->flags = flags;
	_tmp0_ = _g_object_ref0 (store);
	_g_object_unref0 (_data_->store);
	_data_->store = _tmp0_;
	_tmp1_ = _g_object_ref0 (journal);
	_g_object_unref0 (_data_->journal);
	_data_->journal = _tmp1_;
	_tmp2_ = _g_object_ref0 (ontology);
	_g_object_unref0 (_data_->ontology);
	_data_->ontology = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	tracker_sparql_connection_local_new_async_co (_data_);
}

TrackerSparqlConnection*
tracker_sparql_connection_local_new_finish (GAsyncResult* _res_,
                                            GError** error)
{
	TrackerSparqlConnection* result;
	TrackerSparqlConnectionLocalNewAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
tracker_sparql_connection_local_new_async_co (TrackerSparqlConnectionLocalNewAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = tracker_direct_connection_new (_data_->flags, _data_->store, _data_->journal, _data_->ontology, &_data_->_inner_error0_);
	_data_->conn = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_async_initable_init_async ((GAsyncInitable*) _data_->conn, G_PRIORITY_DEFAULT, _data_->cancellable, NULL, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->result = (TrackerSparqlConnection*) _data_->conn;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
tracker_sparql_connection_set_domain (const gchar* domain)
{
	const gchar* _tmp0_;
	_tmp0_ = domain_name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (domain);
		_g_free0 (domain_name);
		domain_name = _tmp1_;
	}
}

gchar*
tracker_sparql_connection_get_domain (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = domain_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
tracker_sparql_connection_set_dbus_connection (GDBusConnection* dbus_connection)
{
	GDBusConnection* _tmp0_;
	g_return_if_fail (dbus_connection != NULL);
	_tmp0_ = _g_object_ref0 (dbus_connection);
	_g_object_unref0 (global_dbus_connection);
	global_dbus_connection = _tmp0_;
}

GDBusConnection*
tracker_sparql_connection_get_dbus_connection (void)
{
	GDBusConnection* _tmp0_;
	GDBusConnection* _tmp1_;
	GDBusConnection* result;
	_tmp0_ = global_dbus_connection;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

