/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.rules.spelling.symspell.implementation.EditDistance;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tools.StringTools;

public abstract class AbstractFindSuggestionsFilter
extends RuleFilter {
    protected final int MAX_SUGGESTIONS = 10;

    protected abstract Tagger getTagger();

    protected abstract List<String> getSpellingSuggestions(AnalyzedTokenReadings var1) throws IOException;

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        String mode;
        ArrayList<String> replacements = new ArrayList<String>();
        ArrayList<String> replacements2 = new ArrayList<String>();
        String wordFrom = this.getRequired("wordFrom", arguments);
        String desiredPostag = this.getRequired("desiredPostag", arguments);
        String priorityPostag = this.getOptional("priorityPostag", arguments);
        String removeSuggestionsRegexp = this.getOptional("removeSuggestionsRegexp", arguments);
        String suppressMatch = this.getOptional("suppressMatch", arguments);
        boolean bSuppressMatch = false;
        if (suppressMatch != null && suppressMatch.equalsIgnoreCase("true")) {
            bSuppressMatch = true;
        }
        boolean diacriticsMode = (mode = this.getOptional("Mode", arguments)) != null && mode.equals("diacritics");
        boolean generateSuggestions = true;
        Pattern regexpPattern = null;
        Synthesizer synth = this.getSynthesizer();
        ArrayList<String> usedLemmas = new ArrayList<String>();
        StringComparator stringComparator = new StringComparator("");
        if (wordFrom != null && desiredPostag != null) {
            int posWord;
            if (wordFrom.equals("marker")) {
                for (posWord = 0; posWord < patternTokens.length && (patternTokens[posWord].getStartPos() < match.getFromPos() || patternTokens[posWord].isSentenceStart()); ++posWord) {
                }
                ++posWord;
            } else {
                posWord = Integer.parseInt(wordFrom);
            }
            if (posWord < 1 || posWord > patternTokens.length) {
                throw new IllegalArgumentException("FindSuggestionsFilter: Index out of bounds in " + match.getRule().getFullId() + ", wordFrom: " + posWord);
            }
            AnalyzedTokenReadings atrWord = patternTokens[posWord - 1];
            stringComparator = new StringComparator(atrWord.getToken());
            boolean isWordCapitalized = StringTools.isCapitalizedWord(atrWord.getToken());
            boolean isWordAllupper = StringTools.isAllUppercase(atrWord.getToken());
            List<String> originalWord = Collections.singletonList(atrWord.getToken());
            List<AnalyzedTokenReadings> aOriginalWord = this.getTagger().tag(originalWord);
            for (AnalyzedTokenReadings analyzedTokenReadings : aOriginalWord) {
                if (!analyzedTokenReadings.matchesPosTagRegex(desiredPostag) || !diacriticsMode) continue;
                return null;
            }
            if (generateSuggestions) {
                List<String> suggestions;
                if (removeSuggestionsRegexp != null) {
                    regexpPattern = Pattern.compile(removeSuggestionsRegexp, 64);
                }
                if ((suggestions = this.getSpellingSuggestions(atrWord)).size() > 0) {
                    block2: for (String suggestion : suggestions) {
                        List<AnalyzedTokenReadings> analyzedSuggestions = this.getTagger().tag(Collections.singletonList(this.cleanSuggestion(suggestion)));
                        for (AnalyzedTokenReadings analyzedSuggestion : analyzedSuggestions) {
                            if (this.isSuggestionException(analyzedSuggestion)) continue;
                            if (replacements.size() >= 20) continue block2;
                            boolean used = false;
                            if (!(suggestion.equals(atrWord.getToken()) || !analyzedSuggestion.matchesPosTagRegex(desiredPostag) || replacements.contains(suggestion) || replacements.contains(suggestion.toLowerCase()) || diacriticsMode && !this.equalWithoutDiacritics(suggestion, atrWord.getToken()) || regexpPattern != null && regexpPattern.matcher(suggestion).matches())) {
                                String replacement = suggestion;
                                if (isWordAllupper) {
                                    replacement = replacement.toUpperCase();
                                }
                                if (isWordCapitalized) {
                                    replacement = StringTools.uppercaseFirstChar(replacement);
                                }
                                if (priorityPostag != null && analyzedSuggestion.matchesPosTagRegex(priorityPostag)) {
                                    replacements.add(0, replacement);
                                    used = true;
                                } else {
                                    replacements.add(replacement);
                                    used = true;
                                }
                            }
                            if (used || synth == null) continue;
                            ArrayList<String> synthesizedSuggestions = new ArrayList<String>();
                            for (AnalyzedToken at : analyzedSuggestion) {
                                if (usedLemmas.contains(at.getLemma())) continue;
                                String[] synthesizedArray = synth.synthesize(at, desiredPostag, true);
                                usedLemmas.add(at.getLemma());
                                for (String synthesizedSuggestion : synthesizedArray) {
                                    if (synthesizedSuggestions.contains(synthesizedSuggestion)) continue;
                                    synthesizedSuggestions.add(synthesizedSuggestion);
                                }
                                for (String replacement : synthesizedSuggestions) {
                                    if (isWordAllupper) {
                                        replacement = replacement.toUpperCase();
                                    }
                                    if (isWordCapitalized) {
                                        replacement = StringTools.uppercaseFirstChar(replacement);
                                    }
                                    replacements2.add(replacement);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (diacriticsMode && replacements.size() == 0) {
            return null;
        }
        if (replacements.size() + replacements2.size() == 0 && bSuppressMatch) {
            return null;
        }
        String message = match.getMessage();
        RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), message, match.getShortMessage());
        ruleMatch.setType(match.getType());
        ArrayList<String> definitiveReplacements = new ArrayList<String>();
        boolean replacementsUsed = false;
        if (generateSuggestions) {
            block7: for (String s : match.getSuggestedReplacements()) {
                if (s.contains("{suggestion}") || s.contains("{Suggestion}")) {
                    replacementsUsed = true;
                    for (String string : replacements) {
                        if (definitiveReplacements.size() >= 10) continue block7;
                        if (s.contains("{suggestion}")) {
                            if (definitiveReplacements.contains(string)) continue;
                            definitiveReplacements.add(s.replace("{suggestion}", string));
                            continue;
                        }
                        if (definitiveReplacements.contains(StringTools.uppercaseFirstChar(string))) continue;
                        definitiveReplacements.add(s.replace("{Suggestion}", StringTools.uppercaseFirstChar(string)));
                    }
                    continue;
                }
                definitiveReplacements.add(s);
            }
            if (!replacementsUsed) {
                if (replacements.size() == 0) {
                    Collections.sort(replacements2, stringComparator);
                    for (String replacement : replacements2) {
                        if (replacements.contains(replacement) || definitiveReplacements.contains(replacement)) continue;
                        replacements.add(replacement);
                    }
                }
                for (String replacement : replacements) {
                    if (definitiveReplacements.size() >= 10) break;
                    if (definitiveReplacements.contains(replacement)) continue;
                    definitiveReplacements.add(replacement);
                }
            }
        }
        if (!definitiveReplacements.isEmpty()) {
            ruleMatch.setSuggestedReplacements(definitiveReplacements);
        }
        return ruleMatch;
    }

    protected boolean isSuggestionException(AnalyzedTokenReadings analyzedSuggestion) {
        return false;
    }

    private boolean equalWithoutDiacritics(String s, String t) {
        return StringTools.removeDiacritics(s).equalsIgnoreCase(StringTools.removeDiacritics(t));
    }

    protected String cleanSuggestion(String s) {
        return s;
    }

    protected Synthesizer getSynthesizer() {
        return null;
    }

    public class StringComparator
    implements Comparator<String> {
        EditDistance levenstheinDistance;
        int maxDistance = 4;

        StringComparator(String word) {
            this.levenstheinDistance = new EditDistance(word, EditDistance.DistanceAlgorithm.Damerau);
        }

        @Override
        public int compare(String o1, String o2) {
            int d1 = this.levenstheinDistance.compare(o1, this.maxDistance);
            int d2 = this.levenstheinDistance.compare(o2, this.maxDistance);
            if (d1 < 0) {
                d1 = 2 * this.maxDistance;
            }
            if (d2 < 0) {
                d2 = 2 * this.maxDistance;
            }
            return d1 - d2;
        }
    }
}

