/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.activitydiagram.ConditionalContext;
import net.sourceforge.plantuml.baraye.CucaDiagram;
import net.sourceforge.plantuml.baraye.IEntity;
import net.sourceforge.plantuml.baraye.IGroup;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.NamespaceStrategy;
import net.sourceforge.plantuml.graphic.USymbol;

public class ActivityDiagram
extends CucaDiagram {
    private IEntity lastEntityConsulted;
    private IEntity lastEntityBrancheConsulted;
    private ConditionalContext currentContext;

    public ActivityDiagram(UmlSource source, Map<String, String> skinParam) {
        super(source, UmlDiagramType.ACTIVITY, skinParam);
        this.setNamespaceSeparator(null);
    }

    @Override
    public ILeaf getOrCreateLeaf(Ident ident, Code code, LeafType type, USymbol symbol) {
        return this.getOrCreateLeafDefault(Objects.requireNonNull(ident), code, type, symbol);
    }

    private String getAutoBranch() {
        return "#" + this.getUniqueSequence();
    }

    public IEntity getOrCreate(Ident idNewLong, Code code, Display display, LeafType type) {
        ILeaf result;
        boolean leafExist;
        boolean bl = leafExist = this.V1972() ? this.leafExistSmart(idNewLong) : this.leafExist(code);
        if (leafExist) {
            result = this.getOrCreateLeafDefault(idNewLong, code, type, null);
            if (result.getLeafType() != type) {
                return null;
            }
        } else {
            result = this.createLeaf(idNewLong, code, display, type, null);
        }
        this.updateLasts(result);
        return result;
    }

    @Override
    public ILeaf getLeafVerySmart(Ident ident) {
        ILeaf result = super.getLeafVerySmart(ident);
        this.updateLasts(result);
        return result;
    }

    public void startIf(String optionalCodeString) {
        String idShort = optionalCodeString == null ? this.getAutoBranch() : optionalCodeString;
        Ident idNewLong = this.buildLeafIdent(idShort);
        Ident code = this.V1972() ? idNewLong : this.buildCode(idShort);
        ILeaf br = this.createLeaf(idNewLong, code, Display.create(""), LeafType.BRANCH, null);
        this.currentContext = new ConditionalContext(this.currentContext, br, Direction.DOWN);
    }

    public void endif() {
        this.currentContext = this.currentContext.getParent();
    }

    public ILeaf getStart() {
        Ident ident = this.buildLeafIdent("start");
        Ident code = this.V1972() ? ident : this.buildCode("start");
        return (ILeaf)this.getOrCreate(ident, code, Display.getWithNewlines("start"), LeafType.CIRCLE_START);
    }

    public ILeaf getEnd(String suppId) {
        String tmp = suppId == null ? "end" : "end$" + suppId;
        Ident ident = this.buildLeafIdent(tmp);
        Ident code = this.V1972() ? ident : this.buildCode(tmp);
        return (ILeaf)this.getOrCreate(ident, code, Display.getWithNewlines("end"), LeafType.CIRCLE_END);
    }

    private void updateLasts(IEntity result) {
        if (result == null || result.getLeafType() == LeafType.NOTE) {
            return;
        }
        this.lastEntityConsulted = result;
        if (result.getLeafType() == LeafType.BRANCH) {
            this.lastEntityBrancheConsulted = result;
        }
    }

    @Override
    public ILeaf createLeaf(Ident idNewLong, Code code, Display display, LeafType type, USymbol symbol) {
        ILeaf result = super.createLeaf(Objects.requireNonNull(idNewLong), code, display, type, symbol);
        this.updateLasts(result);
        return result;
    }

    public IEntity createNote(Ident idNewLong, Code code, Display display) {
        return super.createLeaf(Objects.requireNonNull(idNewLong), code, display, LeafType.NOTE, null);
    }

    @Override
    protected final List<String> getDotStrings() {
        return Arrays.asList("nodesep=.20;", "ranksep=0.4;", "edge [fontsize=11,labelfontsize=11];", "node [fontsize=11];");
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(" + this.getLeafssize() + " activities)");
    }

    public IEntity getLastEntityConsulted() {
        return this.lastEntityConsulted;
    }

    @Deprecated
    public IEntity getLastEntityBrancheConsulted() {
        return this.lastEntityBrancheConsulted;
    }

    public final ConditionalContext getCurrentContext() {
        return this.currentContext;
    }

    public final void setLastEntityConsulted(IEntity lastEntityConsulted) {
        this.lastEntityConsulted = lastEntityConsulted;
    }

    public IEntity createInnerActivity() {
        String idShort = "##" + this.getUniqueSequence();
        Ident idNewLong = this.buildLeafIdent(idShort);
        Ident code = this.V1972() ? idNewLong : this.buildCode(idShort);
        this.gotoGroup(idNewLong, code, Display.getWithNewlines(code), GroupType.INNER_ACTIVITY, this.getCurrentGroup(), NamespaceStrategy.SINGLE);
        IGroup g = this.getCurrentGroup();
        this.lastEntityConsulted = null;
        this.lastEntityBrancheConsulted = null;
        return g;
    }

    public void concurrentActivity(String name) {
        if (this.getCurrentGroup().getGroupType() == GroupType.CONCURRENT_ACTIVITY) {
            this.endGroup();
        }
        String idShort = "##" + this.getUniqueSequence();
        Code code = this.buildCode(idShort);
        if (this.getCurrentGroup().getGroupType() != GroupType.INNER_ACTIVITY) {
            throw new IllegalStateException("type=" + (Object)((Object)this.getCurrentGroup().getGroupType()));
        }
        Ident idNewLong = this.buildLeafIdent(idShort);
        this.gotoGroup(idNewLong, code, Display.getWithNewlines("code"), GroupType.CONCURRENT_ACTIVITY, this.getCurrentGroup(), NamespaceStrategy.SINGLE);
        this.lastEntityConsulted = null;
        this.lastEntityBrancheConsulted = null;
    }
}

