/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Hexagon;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondWIP;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

class FtileIfAndStop
extends AbstractFtile {
    private final Ftile tile1;
    private final Ftile diamond1;
    private final Ftile stop2;
    private final Rainbow arrowColor;

    private FtileIfAndStop(Ftile diamond1, Ftile tile1, Rainbow arrowColor, Ftile stopFtile) {
        super(tile1.skinParam());
        this.diamond1 = diamond1;
        this.tile1 = tile1;
        this.stop2 = stopFtile;
        this.arrowColor = arrowColor;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        if (this.getSwimlaneIn() != null) {
            result.add(this.getSwimlaneIn());
        }
        result.addAll(this.tile1.getSwimlanes());
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.diamond1.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    static Ftile create(Swimlane swimlane, HColor borderColor, HColor backColor, Rainbow arrowColor, FtileFactory ftileFactory, ConditionStyle conditionStyle, Branch nonStop, ISkinParam skinParam, StringBounder stringBounder, Display labelTest) {
        FtileDiamondWIP diamond1;
        Ftile tileNonStop = nonStop.getFtile();
        Ftile stopFtile = ftileFactory.stop(swimlane);
        Style style = StyleSignatureBasic.activityDiamond().getMergedStyle(skinParam.getCurrentStyleBuilder());
        UStroke thickness = tileNonStop.getThickness(style);
        FontConfiguration fcTest = FontConfiguration.create(skinParam, style);
        Sheet sheet = skinParam.sheet(fcTest, skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), CreoleMode.FULL).createSheet(labelTest);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, skinParam.getPadding());
        SheetBlock2 tbTest = new SheetBlock2(sheetBlock1, Hexagon.asStencil(sheetBlock1), thickness);
        if (conditionStyle == ConditionStyle.INSIDE_HEXAGON) {
            diamond1 = new FtileDiamondInside(tbTest, tileNonStop.skinParam(), backColor, borderColor, swimlane);
        } else if (conditionStyle == ConditionStyle.EMPTY_DIAMOND) {
            diamond1 = new FtileDiamond(tileNonStop.skinParam(), backColor, borderColor, swimlane).withNorth(tbTest);
        } else {
            throw new IllegalStateException();
        }
        FtileIfAndStop result = new FtileIfAndStop(diamond1, tileNonStop, arrowColor, stopFtile);
        ArrayList<Connection> conns = new ArrayList<Connection>();
        FtileIfAndStop ftileIfAndStop = result;
        Objects.requireNonNull(ftileIfAndStop);
        conns.add(ftileIfAndStop.new ConnectionHorizontal(arrowColor));
        return FtileUtils.addConnection((Ftile)result, conns);
    }

    private UTranslate getTranslate1(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimension(stringBounder);
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry dim1 = this.tile1.calculateDimension(stringBounder);
        double x1 = this.calculateDimension(stringBounder).getLeft() - dim1.getLeft();
        double y1 = dimDiamond1.getHeight() + (double)this.getSuppHeight();
        return new UTranslate(x1, y1);
    }

    private int getSuppHeight() {
        return 30;
    }

    private UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        double y1 = 0.0;
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        double x1 = this.calculateDimension(stringBounder).getLeft() - ((XDimension2D)dimDiamond1).getWidth() / 2.0;
        return new UTranslate(x1, 0.0);
    }

    private UTranslate getTranslateStop(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry dimStop = this.stop2.calculateDimension(stringBounder);
        double y1 = (((XDimension2D)dimDiamond1).getHeight() - ((XDimension2D)dimStop).getHeight()) / 2.0;
        double x1 = this.calculateDimension(stringBounder).getLeft() + ((XDimension2D)dimDiamond1).getWidth() / 2.0 + this.getDiamondStopDistance();
        return new UTranslate(x1, y1);
    }

    private double getDiamondStopDistance() {
        return 40.0;
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.diamond1) {
            return this.getTranslateDiamond1(stringBounder);
        }
        if (child == this.tile1) {
            return this.getTranslate1(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ug.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
        ug.apply(this.getTranslate1(stringBounder)).draw(this.tile1);
        ug.apply(this.getTranslateStop(stringBounder)).draw(this.stop2);
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        FtileGeometry dimStop2 = this.stop2.calculateDimension(stringBounder);
        FtileGeometry dim1 = this.tile1.calculateDimension(stringBounder).addDim(0.0, this.getDiamondStopDistance() + ((XDimension2D)dimStop2).getWidth());
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        return dimDiamond1.appendBottom(dim1).addDim(0.0, this.getSuppHeight());
    }

    class ConnectionHorizontal
    extends AbstractConnection {
        private final Rainbow color;

        public ConnectionHorizontal(Rainbow color) {
            super(FtileIfAndStop.this.diamond1, FtileIfAndStop.this.stop2);
            this.color = color;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            XPoint2D p2 = this.getP2(stringBounder);
            Snake snake = Snake.create(FtileIfAndStop.this.skinParam(), this.color, FtileIfAndStop.this.skinParam().arrows().asToRight());
            snake.addPoint(p1);
            snake.addPoint(p2);
            ug.draw(snake);
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            FtileGeometry dimDiamond1 = this.getFtile1().calculateDimension(stringBounder);
            XPoint2D p = new XPoint2D(((XDimension2D)dimDiamond1).getWidth(), ((XDimension2D)dimDiamond1).getHeight() / 2.0);
            return FtileIfAndStop.this.getTranslateDiamond1(stringBounder).getTranslated(p);
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            FtileGeometry dimStop = this.getFtile2().calculateDimension(stringBounder);
            XPoint2D p = new XPoint2D(0.0, ((XDimension2D)dimStop).getHeight() / 2.0);
            return FtileIfAndStop.this.getTranslateStop(stringBounder).getTranslated(p);
        }
    }
}

