/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtile;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class GtileCircleSpot
extends AbstractGtile {
    private static final int SIZE = 20;
    private final String spot;
    private final FontConfiguration fc;
    private final HColor backColor;
    private double shadowing;

    private StyleSignatureBasic getDefaultStyleDefinitionCircle() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.circle);
    }

    public GtileCircleSpot(StringBounder stringBounder, ISkinParam skinParam, HColor backColor, Swimlane swimlane, String spot, UFont font) {
        super(stringBounder, skinParam, swimlane);
        this.spot = spot;
        this.backColor = backColor;
        this.fc = FontConfiguration.create(skinParam, FontParam.ACTIVITY, null);
        Style style = this.getDefaultStyleDefinitionCircle().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
        this.shadowing = style.value(PName.Shadowing).asDouble();
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        HColor borderColor = SkinParamUtils.getColor(this.skinParam(), null, ColorParam.activityBorder);
        HColor backColor = this.backColor == null ? SkinParamUtils.getColor(this.skinParam(), null, ColorParam.activityBackground) : this.backColor;
        UEllipse circle = new UEllipse(20.0, 20.0);
        circle.setDeltaShadow(this.shadowing);
        ug.apply(borderColor).apply(backColor.bg()).apply(this.getThickness()).draw(circle);
        ug.apply(this.fc.getColor()).apply(new UTranslate(10.0, 10.0)).draw(new UCenteredCharacter(this.spot.charAt(0), this.fc.getFont()));
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(20.0, 20.0);
    }
}

