/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.baraye.EntityImp;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplayPositioned;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.DecorateEntityImage;

public final class ClusterHeader {
    private int titleAndAttributeWidth = 0;
    private int titleAndAttributeHeight = 0;
    private final TextBlock title;
    private final TextBlock stereo;

    public ClusterHeader(EntityImp g, ISkinParam skinParam, PortionShower portionShower, StringBounder stringBounder) {
        this.title = this.getTitleBlock(g, skinParam);
        this.stereo = this.getStereoBlock(g, skinParam, portionShower);
        TextBlock stereoAndTitle = TextBlockUtils.mergeTB(this.stereo, this.title, HorizontalAlignment.CENTER);
        XDimension2D dimLabel = stereoAndTitle.calculateDimension(stringBounder);
        if (dimLabel.getWidth() > 0.0) {
            XDimension2D dimAttribute = g.getStateHeader(skinParam).calculateDimension(stringBounder);
            double attributeHeight = dimAttribute.getHeight();
            double attributeWidth = dimAttribute.getWidth();
            double marginForFields = attributeHeight > 0.0 ? 5.0 : 0.0;
            USymbol uSymbol = g.getUSymbol();
            int suppHeightBecauseOfShape = uSymbol == null ? 0 : uSymbol.suppHeightBecauseOfShape();
            int suppWidthBecauseOfShape = uSymbol == null ? 0 : uSymbol.suppWidthBecauseOfShape();
            this.titleAndAttributeWidth = (int)Math.max(dimLabel.getWidth(), attributeWidth) + suppWidthBecauseOfShape;
            this.titleAndAttributeHeight = (int)(dimLabel.getHeight() + attributeHeight + marginForFields + (double)suppHeightBecauseOfShape);
        }
    }

    public final int getTitleAndAttributeWidth() {
        return this.titleAndAttributeWidth;
    }

    public final int getTitleAndAttributeHeight() {
        return this.titleAndAttributeHeight;
    }

    public final TextBlock getTitle() {
        return this.title;
    }

    public final TextBlock getStereo() {
        return this.stereo;
    }

    private TextBlock getTitleBlock(EntityImp g, ISkinParam skinParam) {
        Display label = g.getDisplay();
        if (label == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        SName sname = skinParam.getUmlDiagramType().getStyleName();
        USymbol uSymbol = g.getUSymbol();
        StyleSignatureBasic signature = g.getGroupType() == GroupType.STATE ? StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state, SName.composite, SName.title) : (uSymbol != null ? StyleSignatureBasic.of(SName.root, SName.element, sname, uSymbol.getSName(), SName.composite, SName.title) : StyleSignatureBasic.of(SName.root, SName.element, sname, SName.composite, SName.title));
        Style style = signature.withTOBECHANGED(g.getStereotype()).with(g.getStereostyles()).getMergedStyle(skinParam.getCurrentStyleBuilder());
        FontConfiguration fontConfiguration = style.getFontConfiguration(skinParam.getIHtmlColorSet(), g.getColors());
        HorizontalAlignment alignment = HorizontalAlignment.CENTER;
        return label.create(fontConfiguration, alignment, skinParam);
    }

    private TextBlock getStereoBlock(EntityImp g, ISkinParam skinParam, PortionShower portionShower) {
        TextBlock stereo = this.getStereoBlockWithoutLegend(g, portionShower, skinParam);
        DisplayPositioned legend = g.getLegend();
        if (legend == null || legend.isNull()) {
            return stereo;
        }
        TextBlock legendBlock = EntityImageLegend.create(legend.getDisplay(), skinParam);
        return DecorateEntityImage.add(legendBlock, stereo, legend.getHorizontalAlignment(), legend.getVerticalAlignment());
    }

    private TextBlock getStereoBlockWithoutLegend(EntityImp g, PortionShower portionShower, ISkinParam skinParam) {
        Stereotype stereotype = g.getStereotype();
        if (stereotype == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        TextBlock tmp = stereotype.getSprite(skinParam);
        if (tmp != null) {
            return tmp;
        }
        List<String> stereos = stereotype.getLabels(skinParam.guillemet());
        if (stereos == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        boolean show = portionShower.showPortion(EntityPortion.STEREOTYPE, g);
        if (!show) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        Style style = Cluster.getDefaultStyleDefinition(skinParam.getUmlDiagramType().getStyleName(), g.getUSymbol()).forStereotypeItself(g.getStereotype()).getMergedStyle(skinParam.getCurrentStyleBuilder());
        FontConfiguration fontConfiguration = style.getFontConfiguration(skinParam.getIHtmlColorSet());
        return Display.create(stereos).create(fontConfiguration, HorizontalAlignment.CENTER, skinParam);
    }
}

