from _typeshed import Incomplete
from ssl import SSLObject, SSLSocket
from typing_extensions import Literal

from cryptography.x509.base import Certificate
from OpenSSL.SSL import Connection

def ocsp_staple_verifier(con: Connection, ocsp_bytes: bytes, expected: bytes | None = ...) -> Literal[True]: ...

class OCSPVerifier:
    SOCK: SSLObject | SSLSocket
    HOST: str
    PORT: int
    CA_CERTS: str | None
    def __init__(self, sock: SSLObject | SSLSocket, host: str, port: int, ca_certs: str | None = ...) -> None: ...
    # cryptography.x509.general_name.GeneralName.value is typed as Any
    def components_from_socket(self) -> tuple[Certificate, Incomplete | None, Incomplete]: ...
    def components_from_direct_connection(self) -> tuple[Certificate, Incomplete | None, Incomplete]: ...
    def build_certificate_url(self, server: str, cert: Certificate, issuer_cert: Certificate) -> str: ...
    def check_certificate(self, server: str, cert: Certificate, issuer_url: str | bytes) -> Literal[True]: ...
    def is_valid(self) -> Literal[True]: ...
