/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.picnic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.bouncycastle.pqc.crypto.picnic.KMatrices;
import org.bouncycastle.pqc.crypto.picnic.KMatricesWithPointer;
import org.bouncycastle.pqc.crypto.picnic.PicnicEngine;
import org.bouncycastle.util.Exceptions;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.encoders.Hex;

class LowmcConstants {
    private static final int[] linearMatrices_L1;
    private static final int[] roundConstants_L1;
    private static final int[] keyMatrices_L1;
    private static final KMatrices LMatrix_L1;
    private static final KMatrices KMatrix_L1;
    private static final KMatrices RConstants_L1;
    private static final int[] linearMatrices_L1_full;
    private static final int[] keyMatrices_L1_full;
    private static final int[] keyMatrices_L1_inv;
    private static final int[] linearMatrices_L1_inv;
    private static final int[] roundConstants_L1_full;
    private static final KMatrices LMatrix_L1_full;
    private static final KMatrices LMatrix_L1_inv;
    private static final KMatrices KMatrix_L1_full;
    private static final KMatrices KMatrix_L1_inv;
    private static final KMatrices RConstants_L1_full;
    private static final int[] linearMatrices_L3;
    private static final int[] roundConstants_L3;
    private static final int[] keyMatrices_L3;
    private static final KMatrices LMatrix_L3;
    private static final KMatrices KMatrix_L3;
    private static final KMatrices RConstants_L3;
    private static final int[] linearMatrices_L3_full;
    private static final int[] linearMatrices_L3_inv;
    private static final int[] roundConstants_L3_full;
    private static final int[] keyMatrices_L3_full;
    private static final int[] keyMatrices_L3_inv;
    private static final KMatrices LMatrix_L3_full;
    private static final KMatrices LMatrix_L3_inv;
    private static final KMatrices KMatrix_L3_full;
    private static final KMatrices KMatrix_L3_inv;
    private static final KMatrices RConstants_L3_full;
    private static final int[] linearMatrices_L5;
    private static final int[] roundConstants_L5;
    private static final int[] keyMatrices_L5;
    private static final KMatrices LMatrix_L5;
    private static final KMatrices KMatrix_L5;
    private static final KMatrices RConstants_L5;
    private static final int[] linearMatrices_L5_full;
    private static final int[] linearMatrices_L5_inv;
    private static final int[] roundConstants_L5_full;
    private static final int[] keyMatrices_L5_full;
    private static final int[] keyMatrices_L5_inv;
    private static final KMatrices LMatrix_L5_full;
    private static final KMatrices LMatrix_L5_inv;
    private static final KMatrices KMatrix_L5_full;
    private static final KMatrices KMatrix_L5_inv;
    private static final KMatrices RConstants_L5_full;

    LowmcConstants() {
    }

    private static int[] ReadFromProperty(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string);
        byte[] byArray = Hex.decode(LowmcConstants.removeCommas(string2));
        int[] nArray = new int[n];
        for (int i = 0; i < byArray.length / 4; ++i) {
            nArray[i] = Pack.littleEndianToInt(byArray, i * 4);
        }
        return nArray;
    }

    private static byte[] removeCommas(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i != string.length(); ++i) {
            if (string.charAt(i) == ',') continue;
            byteArrayOutputStream.write(string.charAt(i));
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static KMatricesWithPointer GET_MAT(KMatrices kMatrices, int n) {
        KMatricesWithPointer kMatricesWithPointer = new KMatricesWithPointer(kMatrices);
        kMatricesWithPointer.setMatrixPointer(n * kMatricesWithPointer.getSize());
        return kMatricesWithPointer;
    }

    static KMatricesWithPointer LMatrix(PicnicEngine picnicEngine, int n) {
        if (picnicEngine.stateSizeBits == 128) {
            return LowmcConstants.GET_MAT(LMatrix_L1, n);
        }
        if (picnicEngine.stateSizeBits == 129) {
            return LowmcConstants.GET_MAT(LMatrix_L1_full, n);
        }
        if (picnicEngine.stateSizeBits == 192) {
            if (picnicEngine.numRounds == 4) {
                return LowmcConstants.GET_MAT(LMatrix_L3_full, n);
            }
            return LowmcConstants.GET_MAT(LMatrix_L3, n);
        }
        if (picnicEngine.stateSizeBits == 255) {
            return LowmcConstants.GET_MAT(LMatrix_L5_full, n);
        }
        if (picnicEngine.stateSizeBits == 256) {
            return LowmcConstants.GET_MAT(LMatrix_L5, n);
        }
        return null;
    }

    static KMatricesWithPointer LMatrixInv(PicnicEngine picnicEngine, int n) {
        if (picnicEngine.stateSizeBits == 129) {
            return LowmcConstants.GET_MAT(LMatrix_L1_inv, n);
        }
        if (picnicEngine.stateSizeBits == 192 && picnicEngine.numRounds == 4) {
            return LowmcConstants.GET_MAT(LMatrix_L3_inv, n);
        }
        if (picnicEngine.stateSizeBits == 255) {
            return LowmcConstants.GET_MAT(LMatrix_L5_inv, n);
        }
        return null;
    }

    static KMatricesWithPointer KMatrix(PicnicEngine picnicEngine, int n) {
        if (picnicEngine.stateSizeBits == 128) {
            return LowmcConstants.GET_MAT(KMatrix_L1, n);
        }
        if (picnicEngine.stateSizeBits == 129) {
            return LowmcConstants.GET_MAT(KMatrix_L1_full, n);
        }
        if (picnicEngine.stateSizeBits == 192) {
            if (picnicEngine.numRounds == 4) {
                return LowmcConstants.GET_MAT(KMatrix_L3_full, n);
            }
            return LowmcConstants.GET_MAT(KMatrix_L3, n);
        }
        if (picnicEngine.stateSizeBits == 255) {
            return LowmcConstants.GET_MAT(KMatrix_L5_full, n);
        }
        if (picnicEngine.stateSizeBits == 256) {
            return LowmcConstants.GET_MAT(KMatrix_L5, n);
        }
        return null;
    }

    static KMatricesWithPointer KMatrixInv(PicnicEngine picnicEngine) {
        int n = 0;
        if (picnicEngine.stateSizeBits == 129) {
            return LowmcConstants.GET_MAT(KMatrix_L1_inv, n);
        }
        if (picnicEngine.stateSizeBits == 192 && picnicEngine.numRounds == 4) {
            return LowmcConstants.GET_MAT(KMatrix_L3_inv, n);
        }
        if (picnicEngine.stateSizeBits == 255) {
            return LowmcConstants.GET_MAT(KMatrix_L5_inv, n);
        }
        return null;
    }

    static KMatricesWithPointer RConstant(PicnicEngine picnicEngine, int n) {
        if (picnicEngine.stateSizeBits == 128) {
            return LowmcConstants.GET_MAT(RConstants_L1, n);
        }
        if (picnicEngine.stateSizeBits == 129) {
            return LowmcConstants.GET_MAT(RConstants_L1_full, n);
        }
        if (picnicEngine.stateSizeBits == 192) {
            if (picnicEngine.numRounds == 4) {
                return LowmcConstants.GET_MAT(RConstants_L3_full, n);
            }
            return LowmcConstants.GET_MAT(RConstants_L3, n);
        }
        if (picnicEngine.stateSizeBits == 255) {
            return LowmcConstants.GET_MAT(RConstants_L5_full, n);
        }
        if (picnicEngine.stateSizeBits == 256) {
            return LowmcConstants.GET_MAT(RConstants_L5, n);
        }
        return null;
    }

    static {
        InputStream inputStream = LowmcConstants.class.getResourceAsStream("lowmc.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            throw Exceptions.illegalStateException("unable to load Picnic properties: " + iOException.getMessage(), iOException);
        }
        linearMatrices_L1 = LowmcConstants.ReadFromProperty(properties, "linearMatrices_L1", 40960);
        roundConstants_L1 = LowmcConstants.ReadFromProperty(properties, "roundConstants_L1", 320);
        keyMatrices_L1 = LowmcConstants.ReadFromProperty(properties, "keyMatrices_L1", 43008);
        LMatrix_L1 = new KMatrices(20, 128, 4, linearMatrices_L1);
        KMatrix_L1 = new KMatrices(21, 128, 4, keyMatrices_L1);
        RConstants_L1 = new KMatrices(0, 1, 4, roundConstants_L1);
        linearMatrices_L1_full = LowmcConstants.ReadFromProperty(properties, "linearMatrices_L1_full", 12800);
        keyMatrices_L1_full = LowmcConstants.ReadFromProperty(properties, "keyMatrices_L1_full", 12900);
        keyMatrices_L1_inv = LowmcConstants.ReadFromProperty(properties, "keyMatrices_L1_inv", 2850);
        linearMatrices_L1_inv = LowmcConstants.ReadFromProperty(properties, "linearMatrices_L1_inv", 12800);
        roundConstants_L1_full = LowmcConstants.ReadFromProperty(properties, "roundConstants_L1_full", 80);
        LMatrix_L1_full = new KMatrices(4, 129, 5, linearMatrices_L1_full);
        LMatrix_L1_inv = new KMatrices(4, 129, 5, linearMatrices_L1_inv);
        KMatrix_L1_full = new KMatrices(5, 129, 5, keyMatrices_L1_full);
        KMatrix_L1_inv = new KMatrices(1, 129, 5, keyMatrices_L1_inv);
        RConstants_L1_full = new KMatrices(4, 1, 5, roundConstants_L1_full);
        linearMatrices_L3 = LowmcConstants.ReadFromProperty(properties, "linearMatrices_L3", 138240);
        roundConstants_L3 = LowmcConstants.ReadFromProperty(properties, "roundConstants_L3", 720);
        keyMatrices_L3 = LowmcConstants.ReadFromProperty(properties, "keyMatrices_L3", 142848);
        LMatrix_L3 = new KMatrices(30, 192, 6, linearMatrices_L3);
        KMatrix_L3 = new KMatrices(31, 192, 6, keyMatrices_L3);
        RConstants_L3 = new KMatrices(30, 1, 6, roundConstants_L3);
        linearMatrices_L3_full = LowmcConstants.ReadFromProperty(properties, "linearMatrices_L3_full", 18432);
        linearMatrices_L3_inv = LowmcConstants.ReadFromProperty(properties, "linearMatrices_L3_inv", 18432);
        roundConstants_L3_full = LowmcConstants.ReadFromProperty(properties, "roundConstants_L3_full", 96);
        keyMatrices_L3_full = LowmcConstants.ReadFromProperty(properties, "keyMatrices_L3_full", 23040);
        keyMatrices_L3_inv = LowmcConstants.ReadFromProperty(properties, "keyMatrices_L3_inv", 4608);
        LMatrix_L3_full = new KMatrices(4, 192, 6, linearMatrices_L3_full);
        LMatrix_L3_inv = new KMatrices(4, 192, 6, linearMatrices_L3_inv);
        KMatrix_L3_full = new KMatrices(5, 192, 6, keyMatrices_L3_full);
        KMatrix_L3_inv = new KMatrices(1, 192, 6, keyMatrices_L3_inv);
        RConstants_L3_full = new KMatrices(4, 1, 6, roundConstants_L3_full);
        linearMatrices_L5 = LowmcConstants.ReadFromProperty(properties, "linearMatrices_L5", 311296);
        roundConstants_L5 = LowmcConstants.ReadFromProperty(properties, "roundConstants_L5", 1216);
        keyMatrices_L5 = LowmcConstants.ReadFromProperty(properties, "keyMatrices_L5", 319488);
        LMatrix_L5 = new KMatrices(38, 256, 8, linearMatrices_L5);
        KMatrix_L5 = new KMatrices(39, 256, 8, keyMatrices_L5);
        RConstants_L5 = new KMatrices(38, 1, 8, roundConstants_L5);
        linearMatrices_L5_full = LowmcConstants.ReadFromProperty(properties, "linearMatrices_L5_full", 32768);
        linearMatrices_L5_inv = LowmcConstants.ReadFromProperty(properties, "linearMatrices_L5_inv", 32768);
        roundConstants_L5_full = LowmcConstants.ReadFromProperty(properties, "roundConstants_L5_full", 128);
        keyMatrices_L5_full = LowmcConstants.ReadFromProperty(properties, "keyMatrices_L5_full", 40960);
        keyMatrices_L5_inv = LowmcConstants.ReadFromProperty(properties, "keyMatrices_L5_inv", 8160);
        LMatrix_L5_full = new KMatrices(4, 255, 8, linearMatrices_L5_full);
        LMatrix_L5_inv = new KMatrices(4, 255, 8, linearMatrices_L5_inv);
        KMatrix_L5_full = new KMatrices(5, 255, 8, keyMatrices_L5_full);
        KMatrix_L5_inv = new KMatrices(1, 255, 8, keyMatrices_L5_inv);
        RConstants_L5_full = new KMatrices(4, 1, 8, roundConstants_L5_full);
    }
}

