/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.transport;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.BaseNodeRequest;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.search.asynchronous.request.AsynchronousSearchStatsRequest;
import org.opensearch.search.asynchronous.response.AsynchronousSearchStatsResponse;
import org.opensearch.search.asynchronous.service.AsynchronousSearchService;
import org.opensearch.search.asynchronous.stats.AsynchronousSearchStats;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportAsynchronousSearchStatsAction
extends TransportNodesAction<AsynchronousSearchStatsRequest, AsynchronousSearchStatsResponse, AsynchronousSearchStatsNodeRequest, AsynchronousSearchStats> {
    private final AsynchronousSearchService asynchronousSearchService;

    @Inject
    public TransportAsynchronousSearchStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, AsynchronousSearchService asynchronousSearchService) {
        super("cluster:admin/opendistro/asynchronous_search/stats", threadPool, clusterService, transportService, actionFilters, AsynchronousSearchStatsRequest::new, AsynchronousSearchStatsNodeRequest::new, "management", AsynchronousSearchStats.class);
        this.asynchronousSearchService = asynchronousSearchService;
    }

    protected AsynchronousSearchStatsResponse newResponse(AsynchronousSearchStatsRequest request, List<AsynchronousSearchStats> responses, List<FailedNodeException> failures) {
        return new AsynchronousSearchStatsResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected AsynchronousSearchStatsNodeRequest newNodeRequest(AsynchronousSearchStatsRequest request) {
        return new AsynchronousSearchStatsNodeRequest(request);
    }

    protected AsynchronousSearchStats newNodeResponse(StreamInput in) throws IOException {
        return new AsynchronousSearchStats(in);
    }

    protected AsynchronousSearchStats nodeOperation(AsynchronousSearchStatsNodeRequest asynchronousSearchStatsNodeRequest) {
        return this.asynchronousSearchService.stats();
    }

    public static class AsynchronousSearchStatsNodeRequest
    extends BaseNodeRequest {
        AsynchronousSearchStatsRequest request;

        public AsynchronousSearchStatsNodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new AsynchronousSearchStatsRequest(in);
        }

        AsynchronousSearchStatsNodeRequest(AsynchronousSearchStatsRequest request) {
            this.request = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

