/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.task.autofollow;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.tasks.Task;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010#\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 .2\u00020\u0001:\u0001.B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010$\u001a\u00020\u0003H\u0016J\u001a\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u001a\u0010\u001b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u001a\u0010!\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\f\"\u0004\b#\u0010\u000e\u00a8\u0006/"}, d2={"Lorg/opensearch/replication/task/autofollow/AutoFollowStat;", "Lorg/opensearch/tasks/Task$Status;", "name", "", "pattern", "(Ljava/lang/String;Ljava/lang/String;)V", "inp", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "failCount", "", "getFailCount", "()J", "setFailCount", "(J)V", "failCounterForRun", "getFailCounterForRun", "setFailCounterForRun", "failedIndices", "", "getFailedIndices", "()Ljava/util/Set;", "setFailedIndices", "(Ljava/util/Set;)V", "failedLeaderCall", "getFailedLeaderCall", "setFailedLeaderCall", "lastExecutionTime", "getLastExecutionTime", "setLastExecutionTime", "getName", "()Ljava/lang/String;", "getPattern", "successCount", "getSuccessCount", "setSuccessCount", "getWriteableName", "toXContent", "Lorg/opensearch/common/xcontent/XContentBuilder;", "builder", "p1", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "opensearch-cross-cluster-replication"})
public final class AutoFollowStat
implements Task.Status {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String pattern;
    private long failCount;
    @NotNull
    private Set<String> failedIndices;
    private long failCounterForRun;
    private long successCount;
    private long failedLeaderCall;
    private long lastExecutionTime;
    @NotNull
    private static final String NAME = "autofollow_stat";

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getPattern() {
        return this.pattern;
    }

    public final long getFailCount() {
        return this.failCount;
    }

    public final void setFailCount(long l) {
        this.failCount = l;
    }

    @NotNull
    public final Set<String> getFailedIndices() {
        return this.failedIndices;
    }

    public final void setFailedIndices(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.failedIndices = set;
    }

    public final long getFailCounterForRun() {
        return this.failCounterForRun;
    }

    public final void setFailCounterForRun(long l) {
        this.failCounterForRun = l;
    }

    public final long getSuccessCount() {
        return this.successCount;
    }

    public final void setSuccessCount(long l) {
        this.successCount = l;
    }

    public final long getFailedLeaderCall() {
        return this.failedLeaderCall;
    }

    public final void setFailedLeaderCall(long l) {
        this.failedLeaderCall = l;
    }

    public final long getLastExecutionTime() {
        return this.lastExecutionTime;
    }

    public final void setLastExecutionTime(long l) {
        this.lastExecutionTime = l;
    }

    public AutoFollowStat(@NotNull String name, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.failedIndices = new LinkedHashSet();
        this.name = name;
        this.pattern = pattern;
    }

    public AutoFollowStat(@NotNull StreamInput inp) {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        this.failedIndices = new LinkedHashSet();
        Object object = inp.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inp.readString()");
        this.name = object;
        object = inp.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inp.readString()");
        this.pattern = object;
        this.failCount = inp.readLong();
        object = inp.readSet(StreamInput::readString);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inp.readSet(StreamInput::readString)");
        this.failedIndices = object;
        this.successCount = inp.readLong();
        this.failedLeaderCall = inp.readLong();
        this.lastExecutionTime = inp.readLong();
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.name);
        out.writeString(this.pattern);
        out.writeLong(this.failCount);
        out.writeCollection((Collection)this.failedIndices, StreamOutput::writeString);
        out.writeLong(this.successCount);
        out.writeLong(this.failedLeaderCall);
        out.writeLong(this.lastExecutionTime);
    }

    @NotNull
    public String getWriteableName() {
        return NAME;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @Nullable ToXContent.Params p1) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.startObject();
        builder.field("name", this.name);
        builder.field("pattern", this.pattern);
        builder.field("num_success_start_replication", this.successCount);
        builder.field("num_failed_start_replication", this.failCount);
        builder.field("num_failed_leader_calls", this.failedLeaderCall);
        builder.field("failed_indices", (Iterable)this.failedIndices);
        builder.field("last_execution_time", this.lastExecutionTime);
        XContentBuilder xContentBuilder = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.endObject()");
        return xContentBuilder;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/replication/task/autofollow/AutoFollowStat$Companion;", "", "()V", "NAME", "", "getNAME", "()Ljava/lang/String;", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

