/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.deciders;

import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.decisionmaker.actions.Action;
import org.opensearch.performanceanalyzer.decisionmaker.actions.ActionListener;
import org.opensearch.performanceanalyzer.decisionmaker.actions.FlipFlopDetector;
import org.opensearch.performanceanalyzer.decisionmaker.actions.TimedFlipFlopDetector;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.Decision;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.EmptyFlowUnit;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.collator.Collator;
import org.opensearch.performanceanalyzer.rca.framework.core.NonLeafNode;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import org.opensearch.performanceanalyzer.rca.persistence.PublisherEventsPersistor;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;

public class Publisher
extends NonLeafNode<EmptyFlowUnit> {
    private static final Logger LOG = LogManager.getLogger(Publisher.class);
    private Collator collator;
    private FlipFlopDetector flipFlopDetector;
    private boolean isMuted = false;
    private List<ActionListener> actionListeners;

    public Publisher(int evalIntervalSeconds, Collator collator) {
        super(0, evalIntervalSeconds);
        this.collator = collator;
        this.actionListeners = new ArrayList<ActionListener>();
        this.flipFlopDetector = new TimedFlipFlopDetector(1L, TimeUnit.HOURS);
    }

    @Override
    public EmptyFlowUnit operate() {
        return new EmptyFlowUnit(Instant.now().toEpochMilli());
    }

    public void compute(FlowUnitOperationArgWrapper args) {
        ArrayList<Action> actionsPublished = new ArrayList<Action>();
        if (!this.collator.getFlowUnits().isEmpty()) {
            Decision decision = (Decision)this.collator.getFlowUnits().get(0);
            for (Action action : decision.getActions()) {
                if (this.flipFlopDetector.isFlipFlop(action)) continue;
                this.flipFlopDetector.recordAction(action);
                for (ActionListener listener : this.actionListeners) {
                    listener.actionPublished(action);
                }
                actionsPublished.add(action);
            }
        }
        PublisherEventsPersistor persistor = new PublisherEventsPersistor(args.getPersistable());
        persistor.persistAction(actionsPublished, Instant.now().toEpochMilli());
    }

    @Override
    public void generateFlowUnitListFromLocal(FlowUnitOperationArgWrapper args) {
        LOG.debug("Publisher: Executing fromLocal: {}", (Object)this.name());
        long startTime = System.currentTimeMillis();
        try {
            this.compute(args);
        }
        catch (Exception ex) {
            LOG.error("Publisher: Exception in compute", (Throwable)ex);
            PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat(ExceptionsAndErrors.EXCEPTION_IN_COMPUTE, this.name(), 1);
        }
        long duration = System.currentTimeMillis() - startTime;
        PerformanceAnalyzerApp.RCA_GRAPH_METRICS_AGGREGATOR.updateStat(RcaGraphMetrics.GRAPH_NODE_OPERATE_CALL, this.name(), duration);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public void persistFlowUnit(FlowUnitOperationArgWrapper args) {
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
    }

    @Override
    public void handleNodeMuted() {
    }

    @VisibleForTesting
    protected FlipFlopDetector getFlipFlopDetector() {
        return this.flipFlopDetector;
    }
}

