/* Utils.c generated by valac 0.56.3, the Vala compiler
 * generated from Utils.vala, do not modify */

/* Copyright 2011-2015 Switchboard Locale Plug Developers
*
* This program is free software: you can redistribute it
* and/or modify it under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program. If not, see http://www.gnu.org/licenses/.
*/

#include "locale-plug.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <polkit/polkit.h>
#include <libgnome-desktop/gnome-languages.h>
#include <gio/gio.h>
#include <gio/gunixinputstream.h>
#include <glib/gi18n-lib.h>
#include <unistd.h>

enum  {
	SWITCHBOARD_PLUG_LOCALE_UTILS_0_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_UTILS_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_locale_utils_properties[SWITCHBOARD_PLUG_LOCALE_UTILS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SwitchboardPlugLocaleUtilsGetMissingLanguagesData SwitchboardPlugLocaleUtilsGetMissingLanguagesData;
typedef struct _SwitchboardPlugLocaleUtilsGetBlacklistPackagesData SwitchboardPlugLocaleUtilsGetBlacklistPackagesData;
typedef struct _SwitchboardPlugLocaleUtilsGetDefaultRegionsData SwitchboardPlugLocaleUtilsGetDefaultRegionsData;

struct _SwitchboardPlugLocaleUtilsGetMissingLanguagesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar** result;
	gint result_length1;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	GPid pid;
	gint input;
	gint output;
	gint _error_;
	gchar** missing;
	gchar** _tmp4_;
	gint missing_length1;
	gint _missing_size_;
	gchar** missing_aux;
	gchar** _tmp5_;
	gint missing_aux_length1;
	gint _missing_aux_size_;
	gchar* res;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	GPid _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GUnixInputStream* read_stream;
	GUnixInputStream* _tmp17_;
	GDataInputStream* out_channel;
	GUnixInputStream* _tmp18_;
	GDataInputStream* _tmp19_;
	gchar* line;
	gchar* _tmp20_;
	GDataInputStream* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar** _tmp31_;
	gchar** _tmp32_;
	gint i;
	gboolean _tmp33_;
	gint _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	GeeArrayList* _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	const gchar* _tmp38_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	GError* e;
	GError* _tmp42_;
	const gchar* _tmp43_;
	gchar** _tmp44_;
	gint _tmp44__length1;
	GError* _inner_error0_;
};

struct _SwitchboardPlugLocaleUtilsGetBlacklistPackagesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GeeArrayList* result;
	GeeArrayList* blacklist_items;
	GeeArrayList* _tmp0_;
	GFile* file;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFileInputStream* _tmp5_;
	GFile* _tmp6_;
	GFileInputStream* _tmp7_;
	GDataInputStream* dis;
	GDataInputStream* _tmp8_;
	gchar* line;
	gchar* _tmp9_;
	GDataInputStream* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	GeeArrayList* _tmp14_;
	const gchar* _tmp15_;
	GError* e;
	const gchar* _tmp16_;
	GError* _inner_error0_;
};

struct _SwitchboardPlugLocaleUtilsGetDefaultRegionsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	GFile* file;
	GFile* _tmp6_;
	GFile* _tmp7_;
	guint8* _tmp8_;
	gsize _tmp9_;
	GError* e;
	GError* _tmp10_;
	const gchar* _tmp11_;
	gchar* contents;
	guint8* _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_;
	gchar** output_array;
	const gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint output_array_length1;
	gint _output_array_size_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar** line_collection;
	gint line_collection_length1;
	gint _line_collection_size_;
	gint line_it;
	gchar* _tmp18_;
	gchar* line;
	gboolean _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar** line_array;
	const gchar* _tmp22_;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gint line_array_length1;
	gint _line_array_size_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	GeeHashMap* _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	const gchar* _tmp30_;
	GeeHashMap* _tmp31_;
	GeeHashMap* _tmp32_;
	GError* _inner_error0_;
};

static gpointer switchboard_plug_locale_utils_parent_class = NULL;
static GeeArrayList* switchboard_plug_locale_utils_installed_languages;
static GeeArrayList* switchboard_plug_locale_utils_installed_languages = NULL;
static GeeArrayList* switchboard_plug_locale_utils_installed_locales;
static GeeArrayList* switchboard_plug_locale_utils_installed_locales = NULL;
static GeeHashMap* switchboard_plug_locale_utils_default_regions;
static GeeHashMap* switchboard_plug_locale_utils_default_regions = NULL;
static GeeArrayList* switchboard_plug_locale_utils_blacklist_packages;
static GeeArrayList* switchboard_plug_locale_utils_blacklist_packages = NULL;
static PolkitPermission* switchboard_plug_locale_utils_permission;
static PolkitPermission* switchboard_plug_locale_utils_permission = NULL;
static SwitchboardPlugLocaleUtils* switchboard_plug_locale_utils_instance;
static SwitchboardPlugLocaleUtils* switchboard_plug_locale_utils_instance = NULL;

static void switchboard_plug_locale_utils_get_missing_languages_data_free (gpointer _data);
static gboolean switchboard_plug_locale_utils_get_missing_languages_co (SwitchboardPlugLocaleUtilsGetMissingLanguagesData* _data_);
static void switchboard_plug_locale_utils_get_missing_languages_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void switchboard_plug_locale_utils_get_blacklist_packages_data_free (gpointer _data);
static gboolean switchboard_plug_locale_utils_get_blacklist_packages_co (SwitchboardPlugLocaleUtilsGetBlacklistPackagesData* _data_);
static void switchboard_plug_locale_utils_get_blacklist_packages_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
static void switchboard_plug_locale_utils_get_default_regions_data_free (gpointer _data);
static gboolean switchboard_plug_locale_utils_get_default_regions_co (SwitchboardPlugLocaleUtilsGetDefaultRegionsData* _data_);
static void switchboard_plug_locale_utils_get_default_regions_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static void switchboard_plug_locale_utils_finalize (GObject * obj);
static GType switchboard_plug_locale_utils_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

void
switchboard_plug_locale_utils_init (void)
{
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeArrayList* _tmp2_;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (switchboard_plug_locale_utils_installed_locales);
	switchboard_plug_locale_utils_installed_locales = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (switchboard_plug_locale_utils_default_regions);
	switchboard_plug_locale_utils_default_regions = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (switchboard_plug_locale_utils_blacklist_packages);
	switchboard_plug_locale_utils_blacklist_packages = _tmp2_;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GeeArrayList*
switchboard_plug_locale_utils_get_installed_languages (void)
{
	GeeArrayList* _tmp0_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* result;
	_tmp0_ = switchboard_plug_locale_utils_installed_languages;
	if (_tmp0_ != NULL) {
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		_tmp1_ = switchboard_plug_locale_utils_installed_languages;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp4_ = _tmp3_ = gnome_get_all_locales ();
	_tmp5_ = gee_array_list_new_wrap (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp4_, _vala_array_length (_tmp3_), NULL, NULL, NULL);
	_g_object_unref0 (switchboard_plug_locale_utils_installed_languages);
	switchboard_plug_locale_utils_installed_languages = _tmp5_;
	_tmp6_ = switchboard_plug_locale_utils_installed_languages;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

static void
switchboard_plug_locale_utils_get_missing_languages_data_free (gpointer _data)
{
	SwitchboardPlugLocaleUtilsGetMissingLanguagesData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (SwitchboardPlugLocaleUtilsGetMissingLanguagesData, _data_);
}

void
switchboard_plug_locale_utils_get_missing_languages (GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	SwitchboardPlugLocaleUtilsGetMissingLanguagesData* _data_;
	_data_ = g_slice_new0 (SwitchboardPlugLocaleUtilsGetMissingLanguagesData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, switchboard_plug_locale_utils_get_missing_languages_data_free);
	switchboard_plug_locale_utils_get_missing_languages_co (_data_);
}

gchar**
switchboard_plug_locale_utils_get_missing_languages_finish (GAsyncResult* _res_,
                                                            gint* result_length1)
{
	gchar** result;
	SwitchboardPlugLocaleUtilsGetMissingLanguagesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static void
switchboard_plug_locale_utils_get_missing_languages_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	SwitchboardPlugLocaleUtilsGetMissingLanguagesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	switchboard_plug_locale_utils_get_missing_languages_co (_data_);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
switchboard_plug_locale_utils_get_missing_languages_co (SwitchboardPlugLocaleUtilsGetMissingLanguagesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = switchboard_plug_locale_utils_blacklist_packages;
	_data_->_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_ == 0) {
		_data_->_state_ = 1;
		switchboard_plug_locale_utils_get_blacklist_packages (switchboard_plug_locale_utils_get_missing_languages_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = switchboard_plug_locale_utils_get_blacklist_packages_finish (_data_->_res_);
		_g_object_unref0 (switchboard_plug_locale_utils_blacklist_packages);
		switchboard_plug_locale_utils_blacklist_packages = _data_->_tmp3_;
	}
	_data_->_tmp4_ = g_new0 (gchar*, 0 + 1);
	_data_->missing = _data_->_tmp4_;
	_data_->missing_length1 = 0;
	_data_->_missing_size_ = _data_->missing_length1;
	_data_->_tmp5_ = g_new0 (gchar*, 0 + 1);
	_data_->missing_aux = _data_->_tmp5_;
	_data_->missing_aux_length1 = 0;
	_data_->_missing_aux_size_ = _data_->missing_aux_length1;
	{
		_data_->_tmp6_ = g_strdup ("");
		_data_->res = _data_->_tmp6_;
		_data_->_tmp7_ = g_strdup ("check-language-support");
		_data_->_tmp8_ = g_new0 (gchar*, 2 + 1);
		_data_->_tmp8_[0] = _data_->_tmp7_;
		_data_->_tmp8_[1] = NULL;
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp9__length1 = 2;
		_data_->_tmp11_ = _data_->_tmp10_ = g_get_environ ();
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp12__length1 = _vala_array_length (_data_->_tmp10_);
		_data_->_tmp13_ = 0;
		_data_->_tmp14_ = 0;
		_data_->_tmp15_ = 0;
		_data_->_tmp16_ = 0;
		g_spawn_async_with_pipes (NULL, _data_->_tmp9_, _data_->_tmp12_, G_SPAWN_SEARCH_PATH, NULL, NULL, &_data_->_tmp13_, &_data_->_tmp14_, &_data_->_tmp15_, &_data_->_tmp16_, &_data_->_inner_error0_);
		_data_->pid = _data_->_tmp13_;
		_data_->input = _data_->_tmp14_;
		_data_->output = _data_->_tmp15_;
		_data_->_error_ = _data_->_tmp16_;
		_data_->_tmp12_ = (_vala_array_free (_data_->_tmp12_, _data_->_tmp12__length1, (GDestroyNotify) g_free), NULL);
		_data_->_tmp9_ = (_vala_array_free (_data_->_tmp9_, _data_->_tmp9__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->res);
			goto __catch0_g_error;
		}
		_data_->_tmp17_ = (GUnixInputStream*) g_unix_input_stream_new (_data_->output, TRUE);
		_data_->read_stream = _data_->_tmp17_;
		_data_->_tmp18_ = _data_->read_stream;
		_data_->_tmp19_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp18_);
		_data_->out_channel = _data_->_tmp19_;
		_data_->line = NULL;
		while (TRUE) {
			_data_->_tmp21_ = _data_->out_channel;
			_data_->_state_ = 2;
			g_data_input_stream_read_line_async (_data_->_tmp21_, G_PRIORITY_DEFAULT, NULL, switchboard_plug_locale_utils_get_missing_languages_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp22_ = g_data_input_stream_read_line_finish (_data_->_tmp21_, _data_->_res_, NULL, &_data_->_inner_error0_);
			_data_->_tmp20_ = _data_->_tmp22_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_free0 (_data_->line);
				_g_object_unref0 (_data_->out_channel);
				_g_object_unref0 (_data_->read_stream);
				_g_free0 (_data_->res);
				goto __catch0_g_error;
			}
			_data_->_tmp23_ = _data_->_tmp20_;
			_data_->_tmp20_ = NULL;
			_g_free0 (_data_->line);
			_data_->line = _data_->_tmp23_;
			_data_->_tmp24_ = _data_->line;
			if (!(_data_->_tmp24_ != NULL)) {
				_g_free0 (_data_->_tmp20_);
				break;
			}
			_data_->_tmp25_ = _data_->res;
			_data_->_tmp26_ = _data_->line;
			_data_->_tmp27_ = g_strconcat (_data_->_tmp25_, _data_->_tmp26_, NULL);
			_g_free0 (_data_->res);
			_data_->res = _data_->_tmp27_;
			_g_free0 (_data_->_tmp20_);
		}
		_data_->_tmp28_ = _data_->res;
		_data_->_tmp29_ = string_strip (_data_->_tmp28_);
		_data_->_tmp30_ = _data_->_tmp29_;
		_data_->_tmp32_ = _data_->_tmp31_ = g_strsplit (_data_->_tmp30_, " ", 0);
		_data_->missing_aux = (_vala_array_free (_data_->missing_aux, _data_->missing_aux_length1, (GDestroyNotify) g_free), NULL);
		_data_->missing_aux = _data_->_tmp32_;
		_data_->missing_aux_length1 = _vala_array_length (_data_->_tmp31_);
		_data_->_missing_aux_size_ = _data_->missing_aux_length1;
		_g_free0 (_data_->_tmp30_);
		{
			_data_->i = 0;
			{
				_data_->_tmp33_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp33_) {
						_data_->_tmp34_ = _data_->i;
						_data_->i = _data_->_tmp34_ + 1;
					}
					_data_->_tmp33_ = FALSE;
					_data_->_tmp35_ = _data_->missing_aux;
					_data_->_tmp35__length1 = _data_->missing_aux_length1;
					if (!(_data_->i < _data_->_tmp35__length1)) {
						break;
					}
					_data_->_tmp36_ = switchboard_plug_locale_utils_blacklist_packages;
					_data_->_tmp37_ = _data_->missing_aux;
					_data_->_tmp37__length1 = _data_->missing_aux_length1;
					_data_->_tmp38_ = _data_->_tmp37_[_data_->i];
					if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp36_, _data_->_tmp38_)) {
						_data_->_tmp39_ = _data_->missing_aux;
						_data_->_tmp39__length1 = _data_->missing_aux_length1;
						_data_->_tmp40_ = _data_->_tmp39_[_data_->i];
						_data_->_tmp41_ = g_strdup (_data_->_tmp40_);
						_vala_array_add1 (&_data_->missing, &_data_->missing_length1, &_data_->_missing_size_, _data_->_tmp41_);
					}
				}
			}
		}
		_g_free0 (_data_->line);
		_g_object_unref0 (_data_->out_channel);
		_g_object_unref0 (_data_->read_stream);
		_g_free0 (_data_->res);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp42_ = _data_->e;
		_data_->_tmp43_ = _data_->_tmp42_->message;
		g_warning ("Utils.vala:79: %s", _data_->_tmp43_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_data_->missing_aux = (_vala_array_free (_data_->missing_aux, _data_->missing_aux_length1, (GDestroyNotify) g_free), NULL);
		_data_->missing = (_vala_array_free (_data_->missing, _data_->missing_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp44_ = _data_->missing;
	_data_->_tmp44__length1 = _data_->missing_length1;
	_data_->result_length1 = _data_->_tmp44__length1;
	_data_->result = _data_->_tmp44_;
	_data_->missing_aux = (_vala_array_free (_data_->missing_aux, _data_->missing_aux_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
switchboard_plug_locale_utils_get_blacklist_packages_data_free (gpointer _data)
{
	SwitchboardPlugLocaleUtilsGetBlacklistPackagesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	g_slice_free (SwitchboardPlugLocaleUtilsGetBlacklistPackagesData, _data_);
}

void
switchboard_plug_locale_utils_get_blacklist_packages (GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	SwitchboardPlugLocaleUtilsGetBlacklistPackagesData* _data_;
	_data_ = g_slice_new0 (SwitchboardPlugLocaleUtilsGetBlacklistPackagesData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, switchboard_plug_locale_utils_get_blacklist_packages_data_free);
	switchboard_plug_locale_utils_get_blacklist_packages_co (_data_);
}

GeeArrayList*
switchboard_plug_locale_utils_get_blacklist_packages_finish (GAsyncResult* _res_)
{
	GeeArrayList* result;
	SwitchboardPlugLocaleUtilsGetBlacklistPackagesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
switchboard_plug_locale_utils_get_blacklist_packages_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	SwitchboardPlugLocaleUtilsGetBlacklistPackagesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	switchboard_plug_locale_utils_get_blacklist_packages_co (_data_);
}

static gboolean
switchboard_plug_locale_utils_get_blacklist_packages_co (SwitchboardPlugLocaleUtilsGetBlacklistPackagesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_data_->blacklist_items = _data_->_tmp0_;
	_data_->_tmp1_ = g_build_path ("/", CONSTANTS_PKGDATADIR, "packages_blacklist", NULL);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_file_new_for_path (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_g_free0 (_data_->_tmp2_);
	_data_->file = _data_->_tmp4_;
	{
		_data_->_tmp6_ = _data_->file;
		_data_->_tmp7_ = g_file_read (_data_->_tmp6_, NULL, &_data_->_inner_error0_);
		_data_->_tmp5_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp8_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp5_);
		_data_->dis = _data_->_tmp8_;
		_data_->line = NULL;
		while (TRUE) {
			_data_->_tmp10_ = _data_->dis;
			_data_->_state_ = 1;
			g_data_input_stream_read_line_async (_data_->_tmp10_, G_PRIORITY_DEFAULT, NULL, switchboard_plug_locale_utils_get_blacklist_packages_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp11_ = g_data_input_stream_read_line_finish (_data_->_tmp10_, _data_->_res_, NULL, &_data_->_inner_error0_);
			_data_->_tmp9_ = _data_->_tmp11_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_free0 (_data_->line);
				_g_object_unref0 (_data_->dis);
				_g_object_unref0 (_data_->_tmp5_);
				goto __catch0_g_error;
			}
			_data_->_tmp12_ = _data_->_tmp9_;
			_data_->_tmp9_ = NULL;
			_g_free0 (_data_->line);
			_data_->line = _data_->_tmp12_;
			_data_->_tmp13_ = _data_->line;
			if (!(_data_->_tmp13_ != NULL)) {
				_g_free0 (_data_->_tmp9_);
				break;
			}
			_data_->_tmp14_ = _data_->blacklist_items;
			_data_->_tmp15_ = _data_->line;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp14_, _data_->_tmp15_);
			_g_free0 (_data_->_tmp9_);
		}
		_g_free0 (_data_->line);
		_g_object_unref0 (_data_->dis);
		_g_object_unref0 (_data_->_tmp5_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp16_ = _data_->e->message;
		g_error ("Utils.vala:97: %s", _data_->_tmp16_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->file);
		_g_object_unref0 (_data_->blacklist_items);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->blacklist_items;
	_g_object_unref0 (_data_->file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gchar*
switchboard_plug_locale_utils_get_default_for_lang (const gchar* lang)
{
	gchar* output = NULL;
	gint status = 0;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (lang != NULL, NULL);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_;
		gint _tmp3__length1;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gchar* _tmp9_;
		_tmp0_ = g_strdup ("/usr/share/language-tools/language2locale");
		_tmp1_ = g_strdup (lang);
		_tmp2_ = g_new0 (gchar*, 3 + 1);
		_tmp2_[0] = _tmp0_;
		_tmp2_[1] = _tmp1_;
		_tmp2_[2] = NULL;
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 3;
		_tmp5_ = _tmp4_ = g_get_environ ();
		_tmp6_ = _tmp5_;
		_tmp6__length1 = _vala_array_length (_tmp4_);
		g_spawn_sync (NULL, _tmp3_, _tmp6_, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp7_, NULL, &_tmp8_, &_inner_error0_);
		_g_free0 (output);
		output = _tmp7_;
		status = _tmp8_;
		_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
		_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = string_slice (output, (glong) 0, (glong) 5);
		result = _tmp9_;
		_g_free0 (output);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		_g_free0 (output);
		return result;
	}
	__finally0:
	_g_free0 (output);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
switchboard_plug_locale_utils_get_default_regions_data_free (gpointer _data)
{
	SwitchboardPlugLocaleUtilsGetDefaultRegionsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	g_slice_free (SwitchboardPlugLocaleUtilsGetDefaultRegionsData, _data_);
}

void
switchboard_plug_locale_utils_get_default_regions (GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	SwitchboardPlugLocaleUtilsGetDefaultRegionsData* _data_;
	_data_ = g_slice_new0 (SwitchboardPlugLocaleUtilsGetDefaultRegionsData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, switchboard_plug_locale_utils_get_default_regions_data_free);
	switchboard_plug_locale_utils_get_default_regions_co (_data_);
}

GeeHashMap*
switchboard_plug_locale_utils_get_default_regions_finish (GAsyncResult* _res_)
{
	GeeHashMap* result;
	SwitchboardPlugLocaleUtilsGetDefaultRegionsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
switchboard_plug_locale_utils_get_default_regions_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	SwitchboardPlugLocaleUtilsGetDefaultRegionsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	switchboard_plug_locale_utils_get_default_regions_co (_data_);
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gboolean
switchboard_plug_locale_utils_get_default_regions_co (SwitchboardPlugLocaleUtilsGetDefaultRegionsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = switchboard_plug_locale_utils_default_regions;
	_data_->_tmp1_ = gee_abstract_map_get_size ((GeeAbstractMap*) _data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_ > 0) {
		_data_->_tmp3_ = switchboard_plug_locale_utils_default_regions;
		_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
		_data_->result = _data_->_tmp4_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (switchboard_plug_locale_utils_default_regions);
	switchboard_plug_locale_utils_default_regions = _data_->_tmp5_;
	_data_->data_length1 = 0;
	_data_->_data_size_ = 0;
	{
		_data_->_tmp6_ = g_file_new_for_path ("/usr/share/language-tools/main-countries");
		_data_->file = _data_->_tmp6_;
		_data_->_tmp7_ = _data_->file;
		_data_->_tmp8_ = NULL;
		_data_->_tmp9_ = 0;
		_data_->_state_ = 1;
		g_file_load_contents_async (_data_->_tmp7_, NULL, switchboard_plug_locale_utils_get_default_regions_ready, _data_);
		return FALSE;
		_state_1:
		g_file_load_contents_finish (_data_->_tmp7_, _data_->_res_, &_data_->_tmp8_, &_data_->_tmp9_, NULL, &_data_->_inner_error0_);
		_data_->data = (g_free (_data_->data), NULL);
		_data_->data = _data_->_tmp8_;
		_data_->data_length1 = _data_->_tmp9_;
		_data_->_data_size_ = _data_->data_length1;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->file);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp10_ = _data_->e;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		g_warning ("Utils.vala:134: %s", _data_->_tmp11_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_data_->data = (g_free (_data_->data), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->data;
	_data_->_tmp12__length1 = _data_->data_length1;
	_data_->_tmp13_ = g_strdup ((const gchar*) _data_->_tmp12_);
	_data_->contents = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->contents;
	_data_->_tmp16_ = _data_->_tmp15_ = g_strsplit (_data_->_tmp14_, "\n", 0);
	_data_->output_array = _data_->_tmp16_;
	_data_->output_array_length1 = _vala_array_length (_data_->_tmp15_);
	_data_->_output_array_size_ = _data_->output_array_length1;
	_data_->_tmp17_ = _data_->output_array;
	_data_->_tmp17__length1 = _data_->output_array_length1;
	{
		_data_->line_collection_length1 = 0;
		_data_->_line_collection_size_ = 0;
		_data_->line_collection = _data_->_tmp17_;
		_data_->line_collection_length1 = _data_->_tmp17__length1;
		for (_data_->line_it = 0; _data_->line_it < _data_->line_collection_length1; _data_->line_it = _data_->line_it + 1) {
			_data_->_tmp18_ = g_strdup (_data_->line_collection[_data_->line_it]);
			_data_->line = _data_->_tmp18_;
			{
				_data_->_tmp20_ = _data_->line;
				if (g_strcmp0 (_data_->_tmp20_, "") != 0) {
					_data_->_tmp21_ = _data_->line;
					_data_->_tmp19_ = string_index_of (_data_->_tmp21_, "#", 0) == -1;
				} else {
					_data_->_tmp19_ = FALSE;
				}
				if (_data_->_tmp19_) {
					_data_->_tmp22_ = _data_->line;
					_data_->_tmp24_ = _data_->_tmp23_ = g_strsplit (_data_->_tmp22_, "\t", 0);
					_data_->line_array = _data_->_tmp24_;
					_data_->line_array_length1 = _vala_array_length (_data_->_tmp23_);
					_data_->_line_array_size_ = _data_->line_array_length1;
					_data_->_tmp25_ = _data_->line_array;
					_data_->_tmp25__length1 = _data_->line_array_length1;
					if (_data_->_tmp25__length1 > 1) {
						_data_->_tmp26_ = switchboard_plug_locale_utils_default_regions;
						_data_->_tmp27_ = _data_->line_array;
						_data_->_tmp27__length1 = _data_->line_array_length1;
						_data_->_tmp28_ = _data_->_tmp27_[0];
						_data_->_tmp29_ = _data_->line_array;
						_data_->_tmp29__length1 = _data_->line_array_length1;
						_data_->_tmp30_ = _data_->_tmp29_[1];
						gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp26_, _data_->_tmp28_, _data_->_tmp30_);
					}
					_data_->line_array = (_vala_array_free (_data_->line_array, _data_->line_array_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_free0 (_data_->line);
			}
		}
	}
	_data_->_tmp31_ = switchboard_plug_locale_utils_default_regions;
	_data_->_tmp32_ = _g_object_ref0 (_data_->_tmp31_);
	_data_->result = _data_->_tmp32_;
	_data_->output_array = (_vala_array_free (_data_->output_array, _data_->output_array_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_data_->contents);
	_data_->data = (g_free (_data_->data), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GeeHashSet*
switchboard_plug_locale_utils_get_locales_for_language_code (const gchar* language)
{
	GeeHashSet* locales = NULL;
	GeeHashSet* _tmp0_;
	GeeHashSet* result;
	g_return_val_if_fail (language != NULL, NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	locales = _tmp0_;
	{
		GeeArrayList* _locale_list = NULL;
		GeeArrayList* _tmp1_;
		gint _locale_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _locale_index = 0;
		_tmp1_ = switchboard_plug_locale_utils_get_installed_languages ();
		_locale_list = _tmp1_;
		_tmp2_ = _locale_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_locale_size = _tmp4_;
		_locale_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gchar* locale = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			gchar* code = NULL;
			const gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gboolean _tmp11_;
			const gchar* _tmp12_;
			_locale_index = _locale_index + 1;
			_tmp5_ = _locale_index;
			_tmp6_ = _locale_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _locale_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _locale_index);
			locale = (gchar*) _tmp8_;
			_tmp9_ = locale;
			_tmp11_ = gnome_parse_locale (_tmp9_, &_tmp10_, NULL, NULL, NULL);
			_g_free0 (code);
			code = _tmp10_;
			if (!_tmp11_) {
				_g_free0 (code);
				_g_free0 (locale);
				continue;
			}
			_tmp12_ = code;
			if (g_strcmp0 (_tmp12_, language) == 0) {
				GeeHashSet* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = locales;
				_tmp14_ = locale;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
			}
			_g_free0 (code);
			_g_free0 (locale);
		}
		_g_object_unref0 (_locale_list);
	}
	result = locales;
	return result;
}

gchar*
switchboard_plug_locale_utils_translate_language (const gchar* lang)
{
	gchar* lang_name = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (lang != NULL, NULL);
	textdomain ("iso_639");
	_tmp0_ = g_strdup (g_dgettext ("iso_639", lang));
	lang_name = _tmp0_;
	_tmp1_ = g_strdup (g_dgettext ("iso_639_3", lang));
	_g_free0 (lang_name);
	lang_name = _tmp1_;
	result = lang_name;
	return result;
}

gchar*
switchboard_plug_locale_utils_translate_country (const gchar* country)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (country != NULL, NULL);
	textdomain ("iso_3166");
	_tmp0_ = g_strdup (g_dgettext ("iso_3166", country));
	result = _tmp0_;
	return result;
}

gchar*
switchboard_plug_locale_utils_translate (const gchar* locale,
                                         const gchar* translation)
{
	gchar* current_language = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* lang_name = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (locale != NULL, NULL);
	_tmp0_ = g_getenv ("LANGUAGE");
	_tmp1_ = g_strdup (_tmp0_);
	current_language = _tmp1_;
	if (translation == NULL) {
		g_setenv ("LANGUAGE", locale, TRUE);
	} else {
		g_setenv ("LANGUAGE", translation, TRUE);
	}
	_tmp2_ = gnome_get_language_from_locale (locale, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = switchboard_plug_locale_utils_translate_language (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	lang_name = _tmp5_;
	_tmp6_ = current_language;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = current_language;
		g_setenv ("LANGUAGE", _tmp7_, TRUE);
	} else {
		g_unsetenv ("LANGUAGE");
	}
	result = lang_name;
	_g_free0 (current_language);
	return result;
}

gchar*
switchboard_plug_locale_utils_translate_region (const gchar* locale,
                                                const gchar* region,
                                                const gchar* translation)
{
	gchar* current_language = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* region_name = NULL;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (locale != NULL, NULL);
	g_return_val_if_fail (region != NULL, NULL);
	_tmp0_ = g_getenv ("LANGUAGE");
	_tmp1_ = g_strdup (_tmp0_);
	current_language = _tmp1_;
	if (translation == NULL) {
		g_setenv ("LANGUAGE", locale, TRUE);
	} else {
		g_setenv ("LANGUAGE", translation, TRUE);
	}
	_tmp2_ = g_strdup (region);
	region_name = _tmp2_;
	_tmp3_ = strlen (region);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 2) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = gnome_get_country_from_code (region, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = switchboard_plug_locale_utils_translate_country (_tmp6_);
		_g_free0 (region_name);
		region_name = _tmp7_;
		_g_free0 (_tmp6_);
	}
	_tmp8_ = current_language;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_;
		_tmp9_ = current_language;
		g_setenv ("LANGUAGE", _tmp9_, TRUE);
	} else {
		g_unsetenv ("LANGUAGE");
	}
	result = region_name;
	_g_free0 (current_language);
	return result;
}

PolkitPermission*
switchboard_plug_locale_utils_get_permission (void)
{
	PolkitPermission* _tmp0_;
	GError* _inner_error0_ = NULL;
	PolkitPermission* result;
	_tmp0_ = switchboard_plug_locale_utils_permission;
	if (_tmp0_ != NULL) {
		PolkitPermission* _tmp1_;
		PolkitPermission* _tmp2_;
		_tmp1_ = switchboard_plug_locale_utils_permission;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	{
		PolkitPermission* _tmp3_ = NULL;
		PolkitUnixProcess* _tmp4_;
		PolkitUnixProcess* _tmp5_;
		PolkitPermission* _tmp6_;
		PolkitPermission* _tmp7_;
		PolkitPermission* _tmp8_;
		PolkitPermission* _tmp9_;
		PolkitPermission* _tmp10_;
		_tmp4_ = (PolkitUnixProcess*) polkit_unix_process_new ((gint) getpid ());
		_tmp5_ = _tmp4_;
		_tmp6_ = (PolkitPermission*) polkit_permission_new_sync ("io.elementary.switchboard.locale.administration", (PolkitSubject*) _tmp5_, NULL, &_inner_error0_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_tmp3_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (switchboard_plug_locale_utils_permission);
		switchboard_plug_locale_utils_permission = _tmp8_;
		_tmp9_ = switchboard_plug_locale_utils_permission;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		result = _tmp10_;
		_g_object_unref0 (_tmp3_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_critical ("Utils.vala:236: %s", _tmp12_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gboolean
switchboard_plug_locale_utils_allowed_permission (void)
{
	PolkitPermission* permission = NULL;
	PolkitPermission* _tmp0_;
	PolkitPermission* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	_tmp0_ = switchboard_plug_locale_utils_get_permission ();
	permission = _tmp0_;
	_tmp1_ = permission;
	_tmp2_ = g_permission_get_allowed ((GPermission*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		{
			PolkitPermission* _tmp4_;
			_tmp4_ = permission;
			g_permission_acquire ((GPermission*) _tmp4_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_critical ("Utils.vala:247: %s", _tmp6_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (permission);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			_g_object_unref0 (permission);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp7_;
		}
	}
	result = TRUE;
	_g_object_unref0 (permission);
	return result;
}

SwitchboardPlugLocaleUtils*
switchboard_plug_locale_utils_get_default (void)
{
	SwitchboardPlugLocaleUtils* _tmp0_;
	SwitchboardPlugLocaleUtils* _tmp2_;
	SwitchboardPlugLocaleUtils* _tmp3_;
	SwitchboardPlugLocaleUtils* result;
	_tmp0_ = switchboard_plug_locale_utils_instance;
	if (_tmp0_ == NULL) {
		SwitchboardPlugLocaleUtils* _tmp1_;
		_tmp1_ = switchboard_plug_locale_utils_new ();
		_g_object_unref0 (switchboard_plug_locale_utils_instance);
		switchboard_plug_locale_utils_instance = _tmp1_;
	}
	_tmp2_ = switchboard_plug_locale_utils_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

SwitchboardPlugLocaleUtils*
switchboard_plug_locale_utils_construct (GType object_type)
{
	SwitchboardPlugLocaleUtils * self = NULL;
	self = (SwitchboardPlugLocaleUtils*) g_object_new (object_type, NULL);
	return self;
}

SwitchboardPlugLocaleUtils*
switchboard_plug_locale_utils_new (void)
{
	return switchboard_plug_locale_utils_construct (SWITCHBOARD_PLUG_LOCALE_TYPE_UTILS);
}

static void
switchboard_plug_locale_utils_class_init (SwitchboardPlugLocaleUtilsClass * klass,
                                          gpointer klass_data)
{
	switchboard_plug_locale_utils_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_locale_utils_finalize;
}

static void
switchboard_plug_locale_utils_instance_init (SwitchboardPlugLocaleUtils * self,
                                             gpointer klass)
{
}

static void
switchboard_plug_locale_utils_finalize (GObject * obj)
{
	SwitchboardPlugLocaleUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_TYPE_UTILS, SwitchboardPlugLocaleUtils);
	G_OBJECT_CLASS (switchboard_plug_locale_utils_parent_class)->finalize (obj);
}

static GType
switchboard_plug_locale_utils_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugLocaleUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_locale_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugLocaleUtils), 0, (GInstanceInitFunc) switchboard_plug_locale_utils_instance_init, NULL };
	GType switchboard_plug_locale_utils_type_id;
	switchboard_plug_locale_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "SwitchboardPlugLocaleUtils", &g_define_type_info, 0);
	return switchboard_plug_locale_utils_type_id;
}

GType
switchboard_plug_locale_utils_get_type (void)
{
	static volatile gsize switchboard_plug_locale_utils_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_locale_utils_type_id__once)) {
		GType switchboard_plug_locale_utils_type_id;
		switchboard_plug_locale_utils_type_id = switchboard_plug_locale_utils_get_type_once ();
		g_once_init_leave (&switchboard_plug_locale_utils_type_id__once, switchboard_plug_locale_utils_type_id);
	}
	return switchboard_plug_locale_utils_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

