/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership.cloud;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.catalina.tribes.membership.cloud.InsecureStreamProvider;
import org.apache.catalina.tribes.membership.cloud.StreamProvider;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class AbstractStreamProvider
implements StreamProvider {
    private static final Log log = LogFactory.getLog(AbstractStreamProvider.class);
    protected static final StringManager sm = StringManager.getManager(AbstractStreamProvider.class);
    protected static final TrustManager[] INSECURE_TRUST_MANAGERS = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }};

    protected abstract SSLSocketFactory getSocketFactory();

    public URLConnection openConnection(String string, Map<String, String> map, int n, int n2) throws IOException {
        URLConnection uRLConnection;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s opening connection: url [%s], headers [%s], connectTimeout [%s], readTimeout [%s]", this.getClass().getSimpleName(), string, map, Integer.toString(n), Integer.toString(n2)));
        }
        try {
            uRLConnection = new URI(string).toURL().openConnection();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException);
        }
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                uRLConnection.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException(String.format("Neither connectTimeout [%s] nor readTimeout [%s] can be less than 0 for URLConnection.", Integer.toString(n), Integer.toString(n2)));
        }
        uRLConnection.setConnectTimeout(n);
        uRLConnection.setReadTimeout(n2);
        return uRLConnection;
    }

    @Override
    public InputStream openStream(String string, Map<String, String> map, int n, int n2) throws IOException {
        URLConnection uRLConnection = this.openConnection(string, map, n, n2);
        if (uRLConnection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)uRLConnection).setSSLSocketFactory(this.getSocketFactory());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Using HttpsURLConnection with SSLSocketFactory [%s] for url [%s].", this.getSocketFactory(), string));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Using URLConnection for url [%s].", string));
        }
        return uRLConnection.getInputStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static TrustManager[] configureCaCert(String string) throws Exception {
        if (string == null) {
            log.warn((Object)sm.getString("abstractStream.CACertUndefined"));
            return InsecureStreamProvider.INSECURE_TRUST_MANAGERS;
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null);
            Collection<? extends Certificate> collection = certificateFactory.generateCertificates(bufferedInputStream);
            for (Certificate trustManagerArray2 : collection) {
                X509Certificate x509Certificate = (X509Certificate)trustManagerArray2;
                String string2 = x509Certificate.getSubjectX500Principal().getName();
                keyStore.setCertificateEntry(string2, x509Certificate);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            return trustManagerArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error((Object)sm.getString("abstractStream.fileNotFound", string));
            throw fileNotFoundException;
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("abstractStream.trustManagerError", string));
            throw exception;
        }
    }
}

