/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.image;

import java.io.File;
import org.fibs.geotag.image.FileTypes;
import org.fibs.geotag.image.ImageFile;
import org.fibs.geotag.image.JpegImageFile;
import org.fibs.geotag.image.RawImageFile;
import org.fibs.geotag.image.TiffImageFile;

public final class ImageFileFactory {
    private ImageFileFactory() {
    }

    public static ImageFile createImageFile(File file) {
        switch (FileTypes.fileType(file)) {
            case JPEG: {
                return new JpegImageFile(file);
            }
            case TIFF: {
                return new TiffImageFile(file);
            }
            case RAW_READ_ONLY: 
            case RAW_READ_WRITE: 
            case CUSTOM_FILE_WITH_XMP: {
                return new RawImageFile(file);
            }
            case UNKOWN: 
            case XMP: {
                return null;
            }
        }
        return null;
    }
}

