/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class UnlikelyArgumentCheck {
    public final TypeConstants.DangerousMethod dangerousMethod;
    public final TypeBinding typeToCheck;
    public final TypeBinding expectedType;
    public final TypeBinding typeToReport;

    private UnlikelyArgumentCheck(TypeConstants.DangerousMethod dangerousMethod, TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding typeBinding3) {
        this.dangerousMethod = dangerousMethod;
        this.typeToCheck = typeBinding;
        this.expectedType = typeBinding2;
        this.typeToReport = typeBinding3;
    }

    public boolean isDangerous(BlockScope blockScope) {
        TypeBinding typeBinding;
        TypeBinding typeBinding2 = this.typeToCheck;
        if (typeBinding2.isBaseType()) {
            typeBinding2 = blockScope.boxing(typeBinding2);
        }
        if ((typeBinding = this.expectedType).isBaseType()) {
            typeBinding = blockScope.boxing(typeBinding);
        }
        if (this.dangerousMethod != TypeConstants.DangerousMethod.Equals && blockScope.compilerOptions().reportUnlikelyCollectionMethodArgumentTypeStrict) {
            return !typeBinding2.isCompatibleWith(typeBinding, blockScope);
        }
        if (typeBinding2.isCapture() || !typeBinding2.isTypeVariable() || typeBinding.isCapture() || !typeBinding.isTypeVariable()) {
            typeBinding2 = typeBinding2.erasure();
            typeBinding = typeBinding.erasure();
        }
        return !typeBinding2.isCompatibleWith(typeBinding, blockScope) && !typeBinding.isCompatibleWith(typeBinding2, blockScope);
    }

    public static UnlikelyArgumentCheck determineCheckForNonStaticSingleArgumentMethod(TypeBinding typeBinding, Scope scope, char[] cArray, TypeBinding typeBinding2, TypeBinding[] typeBindingArray) {
        TypeConstants.DangerousMethod dangerousMethod;
        int n;
        block21: {
            ReferenceBinding referenceBinding;
            block23: {
                block22: {
                    if (typeBindingArray.length != 1) {
                        return null;
                    }
                    n = typeBindingArray[0].original().id;
                    if (n != 1 && n != 59) {
                        return null;
                    }
                    dangerousMethod = TypeConstants.DangerousMethod.detectSelector(cArray);
                    if (dangerousMethod == null) {
                        return null;
                    }
                    if (typeBinding2.hasTypeBit(256) && n == 1) {
                        switch (dangerousMethod) {
                            case ContainsKey: 
                            case Get: 
                            case Remove: {
                                referenceBinding = typeBinding2.findSuperTypeOriginatingFrom(91, false);
                                if (referenceBinding == null || !referenceBinding.isParameterizedType()) break;
                                return new UnlikelyArgumentCheck(dangerousMethod, typeBinding, ((ParameterizedTypeBinding)referenceBinding).typeArguments()[0], referenceBinding);
                            }
                            case ContainsValue: {
                                referenceBinding = typeBinding2.findSuperTypeOriginatingFrom(91, false);
                                if (referenceBinding == null || !referenceBinding.isParameterizedType()) break;
                                return new UnlikelyArgumentCheck(dangerousMethod, typeBinding, ((ParameterizedTypeBinding)referenceBinding).typeArguments()[1], referenceBinding);
                            }
                        }
                    }
                    if (!typeBinding2.hasTypeBit(512)) break block21;
                    if (n != 1) break block22;
                    switch (dangerousMethod) {
                        case Remove: 
                        case Contains: {
                            referenceBinding = typeBinding2.findSuperTypeOriginatingFrom(59, false);
                            if (referenceBinding != null && referenceBinding.isParameterizedType()) {
                                return new UnlikelyArgumentCheck(dangerousMethod, typeBinding, ((ParameterizedTypeBinding)referenceBinding).typeArguments()[0], referenceBinding);
                            } else {
                                break;
                            }
                        }
                    }
                    break block23;
                }
                if (n == 59) {
                    switch (dangerousMethod) {
                        case RemoveAll: 
                        case ContainsAll: 
                        case RetainAll: {
                            referenceBinding = typeBinding2.findSuperTypeOriginatingFrom(59, false);
                            ReferenceBinding referenceBinding2 = typeBinding.findSuperTypeOriginatingFrom(59, false);
                            if (referenceBinding == null || referenceBinding2 == null || !referenceBinding2.isParameterizedTypeWithActualArguments() || !referenceBinding.isParameterizedTypeWithActualArguments()) break;
                            return new UnlikelyArgumentCheck(dangerousMethod, ((ParameterizedTypeBinding)referenceBinding2).typeArguments()[0], ((ParameterizedTypeBinding)referenceBinding).typeArguments()[0], referenceBinding);
                        }
                    }
                }
            }
            if (typeBinding2.hasTypeBit(1024) && n == 1) {
                switch (dangerousMethod) {
                    case IndexOf: 
                    case LastIndexOf: {
                        referenceBinding = typeBinding2.findSuperTypeOriginatingFrom(92, false);
                        if (referenceBinding == null || !referenceBinding.isParameterizedType()) break;
                        return new UnlikelyArgumentCheck(dangerousMethod, typeBinding, ((ParameterizedTypeBinding)referenceBinding).typeArguments()[0], referenceBinding);
                    }
                }
            }
        }
        if (n == 1 && dangerousMethod == TypeConstants.DangerousMethod.Equals) {
            return new UnlikelyArgumentCheck(dangerousMethod, typeBinding, typeBinding2, typeBinding2);
        }
        return null;
    }

    public static UnlikelyArgumentCheck determineCheckForStaticTwoArgumentMethod(TypeBinding typeBinding, Scope scope, char[] cArray, TypeBinding typeBinding2, TypeBinding[] typeBindingArray, TypeBinding typeBinding3) {
        if (typeBindingArray.length != 2) {
            return null;
        }
        int n = typeBindingArray[0].original().id;
        int n2 = typeBindingArray[1].original().id;
        if (n != 1 || n2 != 1) {
            return null;
        }
        TypeConstants.DangerousMethod dangerousMethod = TypeConstants.DangerousMethod.detectSelector(cArray);
        if (dangerousMethod == null) {
            return null;
        }
        if (typeBinding3.id == 74 && dangerousMethod == TypeConstants.DangerousMethod.Equals) {
            return new UnlikelyArgumentCheck(dangerousMethod, typeBinding, typeBinding2, typeBinding2);
        }
        return null;
    }
}

