/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AccessController;
import javax.management.NotCompliantMBeanException;
import javax.management.relation.InvalidRoleInfoException;

public class RoleInfo
implements Serializable {
    private static final long oldSerialVersionUID = 7227256952085334351L;
    private static final long newSerialVersionUID = 2504952983494636987L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("myName", String.class), new ObjectStreamField("myIsReadableFlg", Boolean.TYPE), new ObjectStreamField("myIsWritableFlg", Boolean.TYPE), new ObjectStreamField("myDescription", String.class), new ObjectStreamField("myMinDegree", Integer.TYPE), new ObjectStreamField("myMaxDegree", Integer.TYPE), new ObjectStreamField("myRefMBeanClassName", String.class)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", String.class), new ObjectStreamField("isReadable", Boolean.TYPE), new ObjectStreamField("isWritable", Boolean.TYPE), new ObjectStreamField("description", String.class), new ObjectStreamField("minDegree", Integer.TYPE), new ObjectStreamField("maxDegree", Integer.TYPE), new ObjectStreamField("referencedMBeanClassName", String.class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    public static final int ROLE_CARDINALITY_INFINITY = -1;
    private String name = null;
    private boolean isReadable;
    private boolean isWritable;
    private String description = null;
    private int minDegree;
    private int maxDegree;
    private String referencedMBeanClassName = null;

    public RoleInfo(String roleName, String mbeanClassName, boolean read, boolean write, int min, int max, String descr) throws IllegalArgumentException, InvalidRoleInfoException, ClassNotFoundException, NotCompliantMBeanException {
        this.init(roleName, mbeanClassName, read, write, min, max, descr);
    }

    public RoleInfo(String roleName, String mbeanClassName, boolean read, boolean write) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        try {
            this.init(roleName, mbeanClassName, read, write, 1, 1, null);
        }
        catch (InvalidRoleInfoException invalidRoleInfoException) {
            // empty catch block
        }
    }

    public RoleInfo(String roleName, String mbeanClassName) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        try {
            this.init(roleName, mbeanClassName, true, true, 1, 1, null);
        }
        catch (InvalidRoleInfoException invalidRoleInfoException) {
            // empty catch block
        }
    }

    public RoleInfo(RoleInfo roleInfo) throws IllegalArgumentException {
        if (roleInfo == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        try {
            this.init(roleInfo.getName(), roleInfo.getRefMBeanClassName(), roleInfo.isReadable(), roleInfo.isWritable(), roleInfo.getMinDegree(), roleInfo.getMaxDegree(), roleInfo.getDescription());
        }
        catch (InvalidRoleInfoException invalidRoleInfoException) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMinDegree() {
        return this.minDegree;
    }

    public int getMaxDegree() {
        return this.maxDegree;
    }

    public String getRefMBeanClassName() {
        return this.referencedMBeanClassName;
    }

    public boolean checkMinDegree(int value) {
        return value >= -1 && (this.minDegree == -1 || value >= this.minDegree);
    }

    public boolean checkMaxDegree(int value) {
        return value >= -1 && (this.maxDegree == -1 || value != -1 && value <= this.maxDegree);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("role info name: " + this.name);
        result.append("; isReadable: " + this.isReadable);
        result.append("; isWritable: " + this.isWritable);
        result.append("; description: " + this.description);
        result.append("; minimum degree: " + this.minDegree);
        result.append("; maximum degree: " + this.maxDegree);
        result.append("; MBean class: " + this.referencedMBeanClassName);
        return result.toString();
    }

    private void init(String roleName, String mbeanClassName, boolean read, boolean write, int min, int max, String descr) throws IllegalArgumentException, InvalidRoleInfoException {
        if (roleName == null || mbeanClassName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        this.name = roleName;
        this.isReadable = read;
        this.isWritable = write;
        if (descr != null) {
            this.description = descr;
        }
        boolean invalidRoleInfoFlg = false;
        StringBuilder excMsgStrB = new StringBuilder();
        if (max != -1 && (min == -1 || min > max)) {
            excMsgStrB.append("Minimum degree ");
            excMsgStrB.append(min);
            excMsgStrB.append(" is greater than maximum degree ");
            excMsgStrB.append(max);
            invalidRoleInfoFlg = true;
        } else if (min < -1 || max < -1) {
            excMsgStrB.append("Minimum or maximum degree has an illegal value, must be [0, ROLE_CARDINALITY_INFINITY].");
            invalidRoleInfoFlg = true;
        }
        if (invalidRoleInfoFlg) {
            throw new InvalidRoleInfoException(excMsgStrB.toString());
        }
        this.minDegree = min;
        this.maxDegree = max;
        this.referencedMBeanClassName = mbeanClassName;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField fields = in.readFields();
            this.name = (String)fields.get("myName", null);
            if (fields.defaulted("myName")) {
                throw new NullPointerException("myName");
            }
            this.isReadable = fields.get("myIsReadableFlg", false);
            if (fields.defaulted("myIsReadableFlg")) {
                throw new NullPointerException("myIsReadableFlg");
            }
            this.isWritable = fields.get("myIsWritableFlg", false);
            if (fields.defaulted("myIsWritableFlg")) {
                throw new NullPointerException("myIsWritableFlg");
            }
            this.description = (String)fields.get("myDescription", null);
            if (fields.defaulted("myDescription")) {
                throw new NullPointerException("myDescription");
            }
            this.minDegree = fields.get("myMinDegree", 0);
            if (fields.defaulted("myMinDegree")) {
                throw new NullPointerException("myMinDegree");
            }
            this.maxDegree = fields.get("myMaxDegree", 0);
            if (fields.defaulted("myMaxDegree")) {
                throw new NullPointerException("myMaxDegree");
            }
            this.referencedMBeanClassName = (String)fields.get("myRefMBeanClassName", null);
            if (fields.defaulted("myRefMBeanClassName")) {
                throw new NullPointerException("myRefMBeanClassName");
            }
        } else {
            in.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("myName", this.name);
            fields.put("myIsReadableFlg", this.isReadable);
            fields.put("myIsWritableFlg", this.isWritable);
            fields.put("myDescription", this.description);
            fields.put("myMinDegree", this.minDegree);
            fields.put("myMaxDegree", this.maxDegree);
            fields.put("myRefMBeanClassName", this.referencedMBeanClassName);
            out.writeFields();
        } else {
            out.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = 7227256952085334351L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 2504952983494636987L;
        }
    }
}

