/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.InstanceManagerBindings;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.collections.CaseInsensitiveKeyMap;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.KeyStoreUtil;
import org.apache.tomcat.websocket.AsyncChannelGroupUtil;
import org.apache.tomcat.websocket.AsyncChannelWrapper;
import org.apache.tomcat.websocket.AsyncChannelWrapperNonSecure;
import org.apache.tomcat.websocket.AsyncChannelWrapperSecure;
import org.apache.tomcat.websocket.AuthenticationException;
import org.apache.tomcat.websocket.AuthenticationType;
import org.apache.tomcat.websocket.Authenticator;
import org.apache.tomcat.websocket.AuthenticatorFactory;
import org.apache.tomcat.websocket.BackgroundProcess;
import org.apache.tomcat.websocket.BackgroundProcessManager;
import org.apache.tomcat.websocket.ClientEndpointHolder;
import org.apache.tomcat.websocket.Constants;
import org.apache.tomcat.websocket.EndpointClassHolder;
import org.apache.tomcat.websocket.EndpointHolder;
import org.apache.tomcat.websocket.PojoClassHolder;
import org.apache.tomcat.websocket.PojoHolder;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.TransformationFactory;
import org.apache.tomcat.websocket.Util;
import org.apache.tomcat.websocket.WsFrameBase;
import org.apache.tomcat.websocket.WsFrameClient;
import org.apache.tomcat.websocket.WsHandshakeResponse;
import org.apache.tomcat.websocket.WsRemoteEndpointImplBase;
import org.apache.tomcat.websocket.WsRemoteEndpointImplClient;
import org.apache.tomcat.websocket.WsSession;

public class WsWebSocketContainer
implements WebSocketContainer,
BackgroundProcess {
    private static final StringManager sm = StringManager.getManager(WsWebSocketContainer.class);
    private static final Random RANDOM = new Random();
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] GET_BYTES = "GET ".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] ROOT_URI_BYTES = "/".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] HTTP_VERSION_BYTES = " HTTP/1.1\r\n".getBytes(StandardCharsets.ISO_8859_1);
    private volatile AsynchronousChannelGroup asynchronousChannelGroup = null;
    private final Object asynchronousChannelGroupLock = new Object();
    private final Log log = LogFactory.getLog(WsWebSocketContainer.class);
    private final Map<Object, Set<WsSession>> endpointSessionMap = new HashMap<Object, Set<WsSession>>();
    private final Map<WsSession, WsSession> sessions = new ConcurrentHashMap<WsSession, WsSession>();
    private final Object endPointSessionMapLock = new Object();
    private long defaultAsyncTimeout = -1L;
    private int maxBinaryMessageBufferSize = Constants.DEFAULT_BUFFER_SIZE;
    private int maxTextMessageBufferSize = Constants.DEFAULT_BUFFER_SIZE;
    private volatile long defaultMaxSessionIdleTimeout = 0L;
    private int backgroundProcessCount = 0;
    private int processPeriod = Constants.DEFAULT_PROCESS_PERIOD;
    private InstanceManager instanceManager;

    protected InstanceManager getInstanceManager(ClassLoader classLoader) {
        if (this.instanceManager != null) {
            return this.instanceManager;
        }
        return InstanceManagerBindings.get((ClassLoader)classLoader);
    }

    protected void setInstanceManager(InstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }

    public Session connectToServer(Object object, URI uRI) throws DeploymentException {
        ClientEndpointConfig clientEndpointConfig = this.createClientEndpointConfig(object.getClass());
        PojoHolder pojoHolder = new PojoHolder(object, clientEndpointConfig);
        return this.connectToServerRecursive(pojoHolder, clientEndpointConfig, uRI, new HashSet<URI>());
    }

    public Session connectToServer(Class<?> clazz, URI uRI) throws DeploymentException {
        ClientEndpointConfig clientEndpointConfig = this.createClientEndpointConfig(clazz);
        PojoClassHolder pojoClassHolder = new PojoClassHolder(clazz, clientEndpointConfig);
        return this.connectToServerRecursive(pojoClassHolder, clientEndpointConfig, uRI, new HashSet<URI>());
    }

    private ClientEndpointConfig createClientEndpointConfig(Class<?> clazz) throws DeploymentException {
        ClientEndpoint clientEndpoint = clazz.getAnnotation(ClientEndpoint.class);
        if (clientEndpoint == null) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.missingAnnotation", new Object[]{clazz.getName()}));
        }
        Class clazz2 = clientEndpoint.configurator();
        ClientEndpointConfig.Configurator configurator = null;
        if (!ClientEndpointConfig.Configurator.class.equals((Object)clazz2)) {
            try {
                configurator = (ClientEndpointConfig.Configurator)clazz2.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new DeploymentException(sm.getString("wsWebSocketContainer.defaultConfiguratorFail"), (Throwable)reflectiveOperationException);
            }
        }
        ClientEndpointConfig.Builder builder = ClientEndpointConfig.Builder.create();
        if (configurator != null) {
            builder.configurator(configurator);
        }
        ClientEndpointConfig clientEndpointConfig = builder.decoders(Arrays.asList(clientEndpoint.decoders())).encoders(Arrays.asList(clientEndpoint.encoders())).preferredSubprotocols(Arrays.asList(clientEndpoint.subprotocols())).build();
        return clientEndpointConfig;
    }

    public Session connectToServer(Class<? extends Endpoint> clazz, ClientEndpointConfig clientEndpointConfig, URI uRI) throws DeploymentException {
        EndpointClassHolder endpointClassHolder = new EndpointClassHolder(clazz);
        return this.connectToServerRecursive(endpointClassHolder, clientEndpointConfig, uRI, new HashSet<URI>());
    }

    public Session connectToServer(Endpoint endpoint, ClientEndpointConfig clientEndpointConfig, URI uRI) throws DeploymentException {
        EndpointHolder endpointHolder = new EndpointHolder(endpoint);
        return this.connectToServerRecursive(endpointHolder, clientEndpointConfig, uRI, new HashSet<URI>());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Session connectToServerRecursive(ClientEndpointHolder clientEndpointHolder, ClientEndpointConfig clientEndpointConfig, URI uRI, Set<URI> set) throws DeploymentException {
        String string;
        Object object;
        Object object2;
        Object object3;
        AsynchronousSocketChannel asynchronousSocketChannel;
        ArrayList<String> arrayList;
        URI uRI2;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("wsWebSocketContainer.connect.entry", new Object[]{clientEndpointHolder.getClassName(), uRI}));
        }
        boolean bl = false;
        ByteBuffer byteBuffer = null;
        String string2 = uRI.getScheme();
        if ("ws".equalsIgnoreCase(string2)) {
            uRI2 = URI.create("http" + uRI.toString().substring(2));
        } else {
            if (!"wss".equalsIgnoreCase(string2)) {
                throw new DeploymentException(sm.getString("wsWebSocketContainer.pathWrongScheme", new Object[]{string2}));
            }
            uRI2 = URI.create("https" + uRI.toString().substring(3));
            bl = true;
        }
        String string3 = uRI.getHost();
        if (string3 == null) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.pathNoHost"));
        }
        int n = uRI.getPort();
        SocketAddress socketAddress = null;
        List<Proxy> list = ProxySelector.getDefault().select(uRI2);
        Proxy proxy = null;
        for (Proxy proxy2 : list) {
            if (!proxy2.type().equals((Object)Proxy.Type.HTTP)) continue;
            socketAddress = proxy2.address();
            if (socketAddress instanceof InetSocketAddress && ((InetSocketAddress)((Object)(arrayList = (InetSocketAddress)socketAddress))).isUnresolved()) {
                socketAddress = new InetSocketAddress(((InetSocketAddress)((Object)arrayList)).getHostName(), ((InetSocketAddress)((Object)arrayList)).getPort());
            }
            proxy = proxy2;
            break;
        }
        if (n == -1) {
            n = "ws".equalsIgnoreCase(string2) ? 80 : 443;
        }
        Map map = clientEndpointConfig.getUserProperties();
        if (socketAddress == null) {
            socketAddress = new InetSocketAddress(string3, n);
        } else {
            byteBuffer = WsWebSocketContainer.createProxyRequest(string3, n, (String)map.get("Proxy-Authorization"));
        }
        Map<String, List<String>> map2 = WsWebSocketContainer.createRequestHeaders(string3, n, bl, clientEndpointConfig);
        clientEndpointConfig.getConfigurator().beforeRequest(map2);
        if (Constants.DEFAULT_ORIGIN_HEADER_VALUE != null && !map2.containsKey("Origin")) {
            arrayList = new ArrayList<String>(1);
            arrayList.add(Constants.DEFAULT_ORIGIN_HEADER_VALUE);
            map2.put("Origin", arrayList);
        }
        arrayList = WsWebSocketContainer.createRequest(uRI, map2);
        try {
            asynchronousSocketChannel = AsynchronousSocketChannel.open(this.getAsynchronousChannelGroup());
        }
        catch (IOException iOException) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.asynchronousSocketChannelFail"), (Throwable)iOException);
        }
        long l = 5000L;
        String string4 = (String)map.get("org.apache.tomcat.websocket.IO_TIMEOUT_MS");
        if (string4 != null) {
            l = Long.valueOf(string4).intValue();
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(this.getDefaultMaxBinaryMessageBufferSize());
        boolean bl2 = false;
        ArrayList<Extension> arrayList2 = new ArrayList<Extension>();
        Transformation transformation = null;
        AsyncChannelWrapper asyncChannelWrapper = null;
        try {
            object3 = asynchronousSocketChannel.connect(socketAddress);
            if (byteBuffer != null) {
                object3.get(l, TimeUnit.MILLISECONDS);
                asyncChannelWrapper = new AsyncChannelWrapperNonSecure(asynchronousSocketChannel);
                WsWebSocketContainer.writeRequest(asyncChannelWrapper, byteBuffer, l);
                object2 = this.processResponse(byteBuffer2, asyncChannelWrapper, l);
                if (((HttpResponse)object2).status == 407) {
                    Session session = this.processAuthenticationChallenge(clientEndpointHolder, clientEndpointConfig, uRI, set, map, (ByteBuffer)((Object)arrayList), (HttpResponse)object2, AuthenticationType.PROXY);
                    return session;
                }
                if (((HttpResponse)object2).getStatus() != 200) {
                    throw new DeploymentException(sm.getString("wsWebSocketContainer.proxyConnectFail", new Object[]{proxy, Integer.toString(((HttpResponse)object2).getStatus())}));
                }
            }
            if (bl) {
                object2 = this.createSSLEngine(map, string3, n);
                asyncChannelWrapper = new AsyncChannelWrapperSecure(asynchronousSocketChannel, (SSLEngine)object2);
            } else if (asyncChannelWrapper == null) {
                asyncChannelWrapper = new AsyncChannelWrapperNonSecure(asynchronousSocketChannel);
            }
            object3.get(l, TimeUnit.MILLISECONDS);
            object2 = asyncChannelWrapper.handshake();
            object2.get(l, TimeUnit.MILLISECONDS);
            if (this.log.isDebugEnabled()) {
                object = null;
                try {
                    object = asyncChannelWrapper.getLocalAddress();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.log.debug((Object)sm.getString("wsWebSocketContainer.connect.write", new Object[]{((Buffer)((Object)arrayList)).position(), ((Buffer)((Object)arrayList)).limit(), object}));
            }
            WsWebSocketContainer.writeRequest(asyncChannelWrapper, arrayList, l);
            object = this.processResponse(byteBuffer2, asyncChannelWrapper, l);
            int n2 = 20;
            String string5 = (String)map.get("org.apache.tomcat.websocket.MAX_REDIRECTIONS");
            if (string5 != null) {
                n2 = Integer.parseInt(string5);
            }
            if (((HttpResponse)object).status != 101) {
                if (WsWebSocketContainer.isRedirectStatus(((HttpResponse)object).status)) {
                    String string6;
                    List list2 = (List)((HttpResponse)object).getHandshakeResponse().getHeaders().get("Location");
                    if (list2 == null || list2.isEmpty() || list2.get(0) == null || ((String)list2.get(0)).isEmpty()) {
                        throw new DeploymentException(sm.getString("wsWebSocketContainer.missingLocationHeader", new Object[]{Integer.toString(((HttpResponse)object).status)}));
                    }
                    URI uRI3 = URI.create((String)list2.get(0)).normalize();
                    if (!uRI3.isAbsolute()) {
                        uRI3 = uRI.resolve(uRI3);
                    }
                    if ((string6 = uRI3.getScheme().toLowerCase()).startsWith("http")) {
                        uRI3 = new URI(string6.replace("http", "ws"), uRI3.getUserInfo(), uRI3.getHost(), uRI3.getPort(), uRI3.getPath(), uRI3.getQuery(), uRI3.getFragment());
                    }
                    if (set.add(uRI3) && set.size() <= n2) {
                        Session session = this.connectToServerRecursive(clientEndpointHolder, clientEndpointConfig, uRI3, set);
                        return session;
                    }
                    throw new DeploymentException(sm.getString("wsWebSocketContainer.redirectThreshold", new Object[]{uRI3, Integer.toString(set.size()), Integer.toString(n2)}));
                }
                if (((HttpResponse)object).status == 401) {
                    Session session = this.processAuthenticationChallenge(clientEndpointHolder, clientEndpointConfig, uRI, set, map, (ByteBuffer)((Object)arrayList), (HttpResponse)object, AuthenticationType.WWW);
                    return session;
                }
                throw new DeploymentException(sm.getString("wsWebSocketContainer.invalidStatus", new Object[]{Integer.toString(((HttpResponse)object).status)}));
            }
            HandshakeResponse handshakeResponse = ((HttpResponse)object).getHandshakeResponse();
            clientEndpointConfig.getConfigurator().afterResponse(handshakeResponse);
            List list3 = (List)handshakeResponse.getHeaders().get("Sec-WebSocket-Protocol");
            if (list3 == null || list3.size() == 0) {
                string = null;
            } else {
                if (list3.size() != 1) throw new DeploymentException(sm.getString("wsWebSocketContainer.invalidSubProtocol"));
                string = (String)list3.get(0);
            }
            List list4 = (List)handshakeResponse.getHeaders().get("Sec-WebSocket-Extensions");
            if (list4 != null) {
                for (Object object4 : list4) {
                    Util.parseExtensionHeader(arrayList2, (String)object4);
                }
            }
            TransformationFactory transformationFactory = TransformationFactory.getInstance();
            for (Extension extension : arrayList2) {
                ArrayList<List<Extension.Parameter>> arrayList3 = new ArrayList<List<Extension.Parameter>>(1);
                arrayList3.add(extension.getParameters());
                Transformation transformation2 = transformationFactory.create(extension.getName(), arrayList3, false);
                if (transformation2 == null) {
                    throw new DeploymentException(sm.getString("wsWebSocketContainer.invalidExtensionParameters"));
                }
                if (transformation == null) {
                    transformation = transformation2;
                    continue;
                }
                transformation.setNext(transformation2);
            }
            bl2 = true;
        }
        catch (EOFException | InterruptedException | URISyntaxException | ExecutionException | TimeoutException | SSLException | AuthenticationException exception) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.httpRequestFailed", new Object[]{uRI}), (Throwable)exception);
        }
        finally {
            if (!bl2) {
                if (asyncChannelWrapper != null) {
                    asyncChannelWrapper.close();
                } else {
                    try {
                        asynchronousSocketChannel.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        object3 = new WsRemoteEndpointImplClient(asyncChannelWrapper);
        object2 = new WsSession(clientEndpointHolder, (WsRemoteEndpointImplBase)object3, this, arrayList2, string, Collections.emptyMap(), bl, clientEndpointConfig);
        object = new WsFrameClient(byteBuffer2, asyncChannelWrapper, (WsSession)object2, transformation);
        ((WsRemoteEndpointImplBase)object3).setTransformation(((WsFrameBase)object).getTransformation());
        ((WsSession)object2).getLocal().onOpen((Session)object2, (EndpointConfig)clientEndpointConfig);
        this.registerSession(((WsSession)object2).getLocal(), (WsSession)object2);
        ((WsFrameClient)object).startInputProcessing();
        return object2;
    }

    private Session processAuthenticationChallenge(ClientEndpointHolder clientEndpointHolder, ClientEndpointConfig clientEndpointConfig, URI uRI, Set<URI> set, Map<String, Object> map, ByteBuffer byteBuffer, HttpResponse httpResponse, AuthenticationType authenticationType) throws DeploymentException, AuthenticationException {
        if (map.get(authenticationType.getAuthorizationHeaderName()) != null) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.failedAuthentication", new Object[]{httpResponse.status, authenticationType.getAuthorizationHeaderName()}));
        }
        List list = (List)httpResponse.getHandshakeResponse().getHeaders().get(authenticationType.getAuthenticateHeaderName());
        if (list == null || list.isEmpty() || list.get(0) == null || ((String)list.get(0)).isEmpty()) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.missingAuthenticateHeader", new Object[]{Integer.toString(httpResponse.status), authenticationType.getAuthenticateHeaderName()}));
        }
        String string = ((String)list.get(0)).split("\\s+", 2)[0];
        Authenticator authenticator = AuthenticatorFactory.getAuthenticator(string);
        if (authenticator == null) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.unsupportedAuthScheme", new Object[]{httpResponse.status, string}));
        }
        String string2 = new String(byteBuffer.array(), StandardCharsets.ISO_8859_1).split("\\s", 3)[1];
        map.put(authenticationType.getAuthorizationHeaderName(), authenticator.getAuthorization(string2, (String)list.get(0), (String)map.get(authenticationType.getUserNameProperty()), (String)map.get(authenticationType.getUserPasswordProperty()), (String)map.get(authenticationType.getUserRealmProperty())));
        return this.connectToServerRecursive(clientEndpointHolder, clientEndpointConfig, uRI, set);
    }

    private static void writeRequest(AsyncChannelWrapper asyncChannelWrapper, ByteBuffer byteBuffer, long l) throws TimeoutException, InterruptedException, ExecutionException {
        int n = byteBuffer.limit();
        Future<Integer> future = asyncChannelWrapper.write(byteBuffer);
        Integer n2 = future.get(l, TimeUnit.MILLISECONDS);
        n -= n2.intValue();
        while (n > 0) {
            future = asyncChannelWrapper.write(byteBuffer);
            n2 = future.get(l, TimeUnit.MILLISECONDS);
            n -= n2.intValue();
        }
    }

    private static boolean isRedirectStatus(int n) {
        boolean bl = false;
        switch (n) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 305: 
            case 307: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    private static ByteBuffer createProxyRequest(String string, int n, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CONNECT ");
        stringBuilder.append(string);
        stringBuilder.append(':');
        stringBuilder.append(n);
        stringBuilder.append(" HTTP/1.1\r\nProxy-Connection: keep-alive\r\nConnection: keepalive\r\nHost: ");
        stringBuilder.append(string);
        stringBuilder.append(':');
        stringBuilder.append(n);
        if (string2 != null) {
            stringBuilder.append("\r\n");
            stringBuilder.append("Proxy-Authorization");
            stringBuilder.append(':');
            stringBuilder.append(string2);
        }
        stringBuilder.append("\r\n\r\n");
        byte[] byArray = stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1);
        return ByteBuffer.wrap(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerSession(Object object2, WsSession wsSession) {
        if (!wsSession.isOpen()) {
            return;
        }
        Object object3 = this.endPointSessionMapLock;
        synchronized (object3) {
            if (this.endpointSessionMap.size() == 0) {
                BackgroundProcessManager.getInstance().register(this);
            }
            this.endpointSessionMap.computeIfAbsent(object2, object -> new HashSet()).add(wsSession);
        }
        this.sessions.put(wsSession, wsSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterSession(Object object, WsSession wsSession) {
        Object object2 = this.endPointSessionMapLock;
        synchronized (object2) {
            Set<WsSession> set = this.endpointSessionMap.get(object);
            if (set != null) {
                set.remove(wsSession);
                if (set.size() == 0) {
                    this.endpointSessionMap.remove(object);
                }
            }
            if (this.endpointSessionMap.size() == 0) {
                BackgroundProcessManager.getInstance().unregister(this);
            }
        }
        this.sessions.remove(wsSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Session> getOpenSessions(Object object) {
        HashSet<Session> hashSet = new HashSet<Session>();
        Object object2 = this.endPointSessionMapLock;
        synchronized (object2) {
            Set<WsSession> set = this.endpointSessionMap.get(object);
            if (set != null) {
                hashSet.addAll(set);
            }
        }
        return hashSet;
    }

    private static Map<String, List<String>> createRequestHeaders(String string, int n, boolean bl, ClientEndpointConfig clientEndpointConfig) {
        ArrayList<String> arrayList;
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        List list = clientEndpointConfig.getExtensions();
        List list2 = clientEndpointConfig.getPreferredSubprotocols();
        Map map = clientEndpointConfig.getUserProperties();
        if (map.get("Authorization") != null) {
            arrayList = new ArrayList<String>(1);
            arrayList.add((String)map.get("Authorization"));
            hashMap.put("Authorization", arrayList);
        }
        arrayList = new ArrayList(1);
        if (n == 80 && !bl || n == 443 && bl) {
            arrayList.add(string);
        } else {
            arrayList.add(string + ':' + n);
        }
        hashMap.put("Host", arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>(1);
        arrayList2.add("websocket");
        hashMap.put("Upgrade", arrayList2);
        ArrayList<String> arrayList3 = new ArrayList<String>(1);
        arrayList3.add("upgrade");
        hashMap.put("Connection", arrayList3);
        ArrayList<String> arrayList4 = new ArrayList<String>(1);
        arrayList4.add("13");
        hashMap.put("Sec-WebSocket-Version", arrayList4);
        ArrayList<String> arrayList5 = new ArrayList<String>(1);
        arrayList5.add(WsWebSocketContainer.generateWsKeyValue());
        hashMap.put("Sec-WebSocket-Key", arrayList5);
        if (list2 != null && list2.size() > 0) {
            hashMap.put("Sec-WebSocket-Protocol", list2);
        }
        if (list != null && list.size() > 0) {
            hashMap.put("Sec-WebSocket-Extensions", WsWebSocketContainer.generateExtensionHeaders(list));
        }
        return hashMap;
    }

    private static List<String> generateExtensionHeaders(List<Extension> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Extension extension : list) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(extension.getName());
            for (Extension.Parameter parameter : extension.getParameters()) {
                stringBuilder.append(';');
                stringBuilder.append(parameter.getName());
                String string = parameter.getValue();
                if (string == null || string.length() <= 0) continue;
                stringBuilder.append('=');
                stringBuilder.append(string);
            }
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    private static String generateWsKeyValue() {
        byte[] byArray = new byte[16];
        RANDOM.nextBytes(byArray);
        return Base64.encodeBase64String((byte[])byArray);
    }

    private static ByteBuffer createRequest(URI uRI, Map<String, List<String>> map) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
        byteBuffer.put(GET_BYTES);
        String string = uRI.getPath();
        if (null == string || string.isEmpty()) {
            byteBuffer.put(ROOT_URI_BYTES);
        } else {
            byteBuffer.put(uRI.getRawPath().getBytes(StandardCharsets.ISO_8859_1));
        }
        String string2 = uRI.getRawQuery();
        if (string2 != null) {
            byteBuffer.put((byte)63);
            byteBuffer.put(string2.getBytes(StandardCharsets.ISO_8859_1));
        }
        byteBuffer.put(HTTP_VERSION_BYTES);
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            byteBuffer = WsWebSocketContainer.addHeader(byteBuffer, entry.getKey(), entry.getValue());
        }
        byteBuffer.put(CRLF);
        byteBuffer.flip();
        return byteBuffer;
    }

    private static ByteBuffer addHeader(ByteBuffer byteBuffer, String string, List<String> list) {
        if (list.isEmpty()) {
            return byteBuffer;
        }
        byteBuffer = WsWebSocketContainer.putWithExpand(byteBuffer, string.getBytes(StandardCharsets.ISO_8859_1));
        byteBuffer = WsWebSocketContainer.putWithExpand(byteBuffer, ": ".getBytes(StandardCharsets.ISO_8859_1));
        byteBuffer = WsWebSocketContainer.putWithExpand(byteBuffer, StringUtils.join(list).getBytes(StandardCharsets.ISO_8859_1));
        byteBuffer = WsWebSocketContainer.putWithExpand(byteBuffer, CRLF);
        return byteBuffer;
    }

    private static ByteBuffer putWithExpand(ByteBuffer byteBuffer, byte[] byArray) {
        if (byArray.length > byteBuffer.remaining()) {
            int n = byArray.length > byteBuffer.capacity() ? 2 * byArray.length : byteBuffer.capacity() * 2;
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(n);
            byteBuffer.flip();
            byteBuffer2.put(byteBuffer);
            byteBuffer = byteBuffer2;
        }
        return byteBuffer.put(byArray);
    }

    private HttpResponse processResponse(ByteBuffer byteBuffer, AsyncChannelWrapper asyncChannelWrapper, long l) throws InterruptedException, ExecutionException, DeploymentException, EOFException, TimeoutException {
        CaseInsensitiveKeyMap caseInsensitiveKeyMap = new CaseInsensitiveKeyMap();
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        while (!bl2) {
            Integer n2;
            byteBuffer.clear();
            Future<Integer> future = asyncChannelWrapper.read(byteBuffer);
            try {
                n2 = future.get(l, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                TimeoutException timeoutException2 = new TimeoutException(sm.getString("wsWebSocketContainer.responseFail", new Object[]{Integer.toString(n), caseInsensitiveKeyMap}));
                timeoutException2.initCause(timeoutException);
                throw timeoutException2;
            }
            if (n2 == -1) {
                throw new EOFException(sm.getString("wsWebSocketContainer.responseFail", new Object[]{Integer.toString(n), caseInsensitiveKeyMap}));
            }
            byteBuffer.flip();
            while (byteBuffer.hasRemaining() && !bl2) {
                if ("\r\n".equals(string = string == null ? this.readLine(byteBuffer) : string + this.readLine(byteBuffer))) {
                    bl2 = true;
                    continue;
                }
                if (!string.endsWith("\r\n")) continue;
                if (bl) {
                    this.parseHeaders(string, (Map<String, List<String>>)caseInsensitiveKeyMap);
                } else {
                    n = this.parseStatus(string);
                    bl = true;
                }
                string = null;
            }
        }
        return new HttpResponse(n, new WsHandshakeResponse((Map<String, List<String>>)caseInsensitiveKeyMap));
    }

    private int parseStatus(String string) throws DeploymentException {
        String[] stringArray = string.trim().split(" ");
        if (stringArray.length < 2 || !"HTTP/1.0".equals(stringArray[0]) && !"HTTP/1.1".equals(stringArray[0])) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.invalidStatus", new Object[]{string}));
        }
        try {
            return Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.invalidStatus", new Object[]{string}));
        }
    }

    private void parseHeaders(String string2, Map<String, List<String>> map) {
        int n = string2.indexOf(58);
        if (n == -1) {
            this.log.warn((Object)sm.getString("wsWebSocketContainer.invalidHeader", new Object[]{string2}));
            return;
        }
        String string3 = string2.substring(0, n).trim().toLowerCase(Locale.ENGLISH);
        String string4 = string2.substring(n + 1).trim();
        List list = map.computeIfAbsent(string3, string -> new ArrayList(1));
        list.add(string4);
    }

    private String readLine(ByteBuffer byteBuffer) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = '\u0000';
        while (byteBuffer.hasRemaining()) {
            c = (char)byteBuffer.get();
            stringBuilder.append(c);
            if (c != '\n') continue;
            break;
        }
        return stringBuilder.toString();
    }

    private SSLEngine createSSLEngine(Map<String, Object> map, String string, int n) throws DeploymentException {
        try {
            Object object;
            String string2;
            Object object2;
            SSLContext sSLContext = (SSLContext)map.get("org.apache.tomcat.websocket.SSL_CONTEXT");
            if (sSLContext == null) {
                sSLContext = SSLContext.getInstance("TLS");
                object2 = (String)map.get("org.apache.tomcat.websocket.SSL_TRUSTSTORE");
                if (object2 != null) {
                    string2 = (String)map.get("org.apache.tomcat.websocket.SSL_TRUSTSTORE_PWD");
                    if (string2 == null) {
                        string2 = "changeit";
                    }
                    object = new File((String)object2);
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    try (Object object3 = new FileInputStream((File)object);){
                        KeyStoreUtil.load((KeyStore)keyStore, (InputStream)object3, (char[])string2.toCharArray());
                    }
                    object3 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    ((TrustManagerFactory)object3).init(keyStore);
                    sSLContext.init(null, ((TrustManagerFactory)object3).getTrustManagers(), null);
                } else {
                    sSLContext.init(null, null, null);
                }
            }
            object2 = sSLContext.createSSLEngine(string, n);
            string2 = (String)map.get("org.apache.tomcat.websocket.SSL_PROTOCOLS");
            if (string2 != null) {
                ((SSLEngine)object2).setEnabledProtocols(string2.split(","));
            }
            ((SSLEngine)object2).setUseClientMode(true);
            object = ((SSLEngine)object2).getSSLParameters();
            ((SSLParameters)object).setEndpointIdentificationAlgorithm("HTTPS");
            ((SSLEngine)object2).setSSLParameters((SSLParameters)object);
            return object2;
        }
        catch (Exception exception) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.sslEngineFail"), (Throwable)exception);
        }
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultMaxSessionIdleTimeout;
    }

    public void setDefaultMaxSessionIdleTimeout(long l) {
        this.defaultMaxSessionIdleTimeout = l;
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    public void setDefaultMaxBinaryMessageBufferSize(int n) {
        this.maxBinaryMessageBufferSize = n;
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public void setDefaultMaxTextMessageBufferSize(int n) {
        this.maxTextMessageBufferSize = n;
    }

    public Set<Extension> getInstalledExtensions() {
        return Collections.emptySet();
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncTimeout;
    }

    public void setAsyncSendTimeout(long l) {
        this.defaultAsyncTimeout = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        CloseReason closeReason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, sm.getString("wsWebSocketContainer.shutdown"));
        for (WsSession wsSession : this.sessions.keySet()) {
            try {
                wsSession.close(closeReason);
            }
            catch (IOException iOException) {
                this.log.debug((Object)sm.getString("wsWebSocketContainer.sessionCloseFail", new Object[]{wsSession.getId()}), (Throwable)iOException);
            }
        }
        if (this.asynchronousChannelGroup != null) {
            Object object = this.asynchronousChannelGroupLock;
            synchronized (object) {
                if (this.asynchronousChannelGroup != null) {
                    AsyncChannelGroupUtil.unregister();
                    this.asynchronousChannelGroup = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsynchronousChannelGroup getAsynchronousChannelGroup() {
        AsynchronousChannelGroup asynchronousChannelGroup = this.asynchronousChannelGroup;
        if (asynchronousChannelGroup == null) {
            Object object = this.asynchronousChannelGroupLock;
            synchronized (object) {
                if (this.asynchronousChannelGroup == null) {
                    this.asynchronousChannelGroup = AsyncChannelGroupUtil.register();
                }
                asynchronousChannelGroup = this.asynchronousChannelGroup;
            }
        }
        return asynchronousChannelGroup;
    }

    @Override
    public void backgroundProcess() {
        ++this.backgroundProcessCount;
        if (this.backgroundProcessCount >= this.processPeriod) {
            this.backgroundProcessCount = 0;
            for (WsSession wsSession : this.sessions.keySet()) {
                wsSession.checkExpiration();
            }
        }
    }

    @Override
    public void setProcessPeriod(int n) {
        this.processPeriod = n;
    }

    @Override
    public int getProcessPeriod() {
        return this.processPeriod;
    }

    private static class HttpResponse {
        private final int status;
        private final HandshakeResponse handshakeResponse;

        public HttpResponse(int n, HandshakeResponse handshakeResponse) {
            this.status = n;
            this.handshakeResponse = handshakeResponse;
        }

        public int getStatus() {
            return this.status;
        }

        public HandshakeResponse getHandshakeResponse() {
            return this.handshakeResponse;
        }
    }
}

