/* composer-email-entry.c generated by valac 0.56.3, the Vala compiler
 * generated from composer-email-entry.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include "geary-engine.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gdk/gdk.h>

enum  {
	COMPOSER_EMAIL_ENTRY_0_PROPERTY,
	COMPOSER_EMAIL_ENTRY_ADDRESSES_PROPERTY,
	COMPOSER_EMAIL_ENTRY_IS_VALID_PROPERTY,
	COMPOSER_EMAIL_ENTRY_IS_EMPTY_PROPERTY,
	COMPOSER_EMAIL_ENTRY_IS_MODIFIED_PROPERTY,
	COMPOSER_EMAIL_ENTRY_NUM_PROPERTIES
};
static GParamSpec* composer_email_entry_properties[COMPOSER_EMAIL_ENTRY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ComposerEmailEntryPrivate {
	GearyRFC822MailboxAddresses* _addresses;
	gboolean _is_valid;
	gboolean _is_modified;
	ComposerWidget* composer;
};

static gint ComposerEmailEntry_private_offset;
static gpointer composer_email_entry_parent_class = NULL;

static void composer_email_entry_validate_addresses (ComposerEmailEntry* self);
static void composer_email_entry_set_is_modified (ComposerEmailEntry* self,
                                           gboolean value);
static void composer_email_entry_set_is_valid (ComposerEmailEntry* self,
                                        gboolean value);
static void composer_email_entry_on_changed (ComposerEmailEntry* self);
static void _composer_email_entry_on_changed_gtk_editable_changed (GtkEditable* _sender,
                                                            gpointer self);
static gboolean composer_email_entry_on_key_press (ComposerEmailEntry* self,
                                            GtkWidget* widget,
                                            GdkEventKey* event);
static gboolean _composer_email_entry_on_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                        GdkEventKey* event,
                                                                        gpointer self);
static void composer_email_entry_finalize (GObject * obj);
static GType composer_email_entry_get_type_once (void);
static void _vala_composer_email_entry_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_composer_email_entry_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
composer_email_entry_get_instance_private (ComposerEmailEntry* self)
{
	return G_STRUCT_MEMBER_P (self, ComposerEmailEntry_private_offset);
}

GearyRFC822MailboxAddresses*
composer_email_entry_get_addresses (ComposerEmailEntry* self)
{
	GearyRFC822MailboxAddresses* result;
	GearyRFC822MailboxAddresses* _tmp0_;
	g_return_val_if_fail (COMPOSER_IS_EMAIL_ENTRY (self), NULL);
	_tmp0_ = self->priv->_addresses;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
composer_email_entry_set_addresses (ComposerEmailEntry* self,
                                    GearyRFC822MailboxAddresses* value)
{
	GearyRFC822MailboxAddresses* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (COMPOSER_IS_EMAIL_ENTRY (self));
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_addresses);
	self->priv->_addresses = _tmp0_;
	composer_email_entry_validate_addresses (self);
	composer_email_entry_set_is_modified (self, FALSE);
	_tmp1_ = geary_rf_c822_mailbox_addresses_to_full_display (value);
	_tmp2_ = _tmp1_;
	gtk_entry_set_text (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_get_type (), GtkEntry), _tmp2_);
	_g_free0 (_tmp2_);
	g_object_notify_by_pspec ((GObject *) self, composer_email_entry_properties[COMPOSER_EMAIL_ENTRY_ADDRESSES_PROPERTY]);
}

gboolean
composer_email_entry_get_is_valid (ComposerEmailEntry* self)
{
	gboolean result;
	g_return_val_if_fail (COMPOSER_IS_EMAIL_ENTRY (self), FALSE);
	result = self->priv->_is_valid;
	return result;
}

static void
composer_email_entry_set_is_valid (ComposerEmailEntry* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (COMPOSER_IS_EMAIL_ENTRY (self));
	old_value = composer_email_entry_get_is_valid (self);
	if (old_value != value) {
		self->priv->_is_valid = value;
		g_object_notify_by_pspec ((GObject *) self, composer_email_entry_properties[COMPOSER_EMAIL_ENTRY_IS_VALID_PROPERTY]);
	}
}

gboolean
composer_email_entry_get_is_empty (ComposerEmailEntry* self)
{
	gboolean result;
	GearyRFC822MailboxAddresses* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (COMPOSER_IS_EMAIL_ENTRY (self), FALSE);
	_tmp0_ = self->priv->_addresses;
	_tmp1_ = geary_rf_c822_mailbox_addresses_get_is_empty (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
composer_email_entry_get_is_modified (ComposerEmailEntry* self)
{
	gboolean result;
	g_return_val_if_fail (COMPOSER_IS_EMAIL_ENTRY (self), FALSE);
	result = self->priv->_is_modified;
	return result;
}

static void
composer_email_entry_set_is_modified (ComposerEmailEntry* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (COMPOSER_IS_EMAIL_ENTRY (self));
	old_value = composer_email_entry_get_is_modified (self);
	if (old_value != value) {
		self->priv->_is_modified = value;
		g_object_notify_by_pspec ((GObject *) self, composer_email_entry_properties[COMPOSER_EMAIL_ENTRY_IS_MODIFIED_PROPERTY]);
	}
}

static void
_composer_email_entry_on_changed_gtk_editable_changed (GtkEditable* _sender,
                                                       gpointer self)
{
	composer_email_entry_on_changed ((ComposerEmailEntry*) self);
}

static gboolean
_composer_email_entry_on_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                               GdkEventKey* event,
                                                               gpointer self)
{
	gboolean result;
	result = composer_email_entry_on_key_press ((ComposerEmailEntry*) self, _sender, event);
	return result;
}

ComposerEmailEntry*
composer_email_entry_construct (GType object_type,
                                ComposerWidget* composer)
{
	ComposerEmailEntry * self = NULL;
	g_return_val_if_fail (COMPOSER_IS_WIDGET (composer), NULL);
	self = (ComposerEmailEntry*) g_object_new (object_type, NULL);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_editable_get_type (), GtkEditable), "changed", (GCallback) _composer_email_entry_on_changed_gtk_editable_changed, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "key-press-event", (GCallback) _composer_email_entry_on_key_press_gtk_widget_key_press_event, self, 0);
	self->priv->composer = composer;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	return self;
}

ComposerEmailEntry*
composer_email_entry_new (ComposerWidget* composer)
{
	return composer_email_entry_construct (COMPOSER_TYPE_EMAIL_ENTRY, composer);
}

/** Marks the entry as being modified. */
void
composer_email_entry_set_modified (ComposerEmailEntry* self)
{
	g_return_if_fail (COMPOSER_IS_EMAIL_ENTRY (self));
	composer_email_entry_set_is_modified (self, TRUE);
}

static void
composer_email_entry_validate_addresses (ComposerEmailEntry* self)
{
	gboolean is_valid = FALSE;
	GearyRFC822MailboxAddresses* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (COMPOSER_IS_EMAIL_ENTRY (self));
	_tmp0_ = self->priv->_addresses;
	_tmp1_ = geary_rf_c822_mailbox_addresses_get_is_empty (_tmp0_);
	_tmp2_ = _tmp1_;
	is_valid = !_tmp2_;
	{
		GearyRFC822MailboxAddresses* _address_list = NULL;
		GearyRFC822MailboxAddresses* _tmp3_;
		GearyRFC822MailboxAddresses* _tmp4_;
		gint _address_size = 0;
		GearyRFC822MailboxAddresses* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _address_index = 0;
		_tmp3_ = composer_email_entry_get_addresses (self);
		_tmp4_ = _tmp3_;
		_address_list = _tmp4_;
		_tmp5_ = _address_list;
		_tmp6_ = geary_rf_c822_mailbox_addresses_get_size (_tmp5_);
		_tmp7_ = _tmp6_;
		_address_size = _tmp7_;
		_address_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			GearyRFC822MailboxAddress* address = NULL;
			GearyRFC822MailboxAddresses* _tmp10_;
			GearyRFC822MailboxAddress* _tmp11_;
			GearyRFC822MailboxAddress* _tmp12_;
			_address_index = _address_index + 1;
			_tmp8_ = _address_index;
			_tmp9_ = _address_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _address_list;
			_tmp11_ = geary_rf_c822_mailbox_addresses_get (_tmp10_, _address_index);
			address = _tmp11_;
			_tmp12_ = address;
			if (!geary_rf_c822_mailbox_address_is_valid (_tmp12_)) {
				is_valid = FALSE;
				_g_object_unref0 (address);
				return;
			}
			_g_object_unref0 (address);
		}
	}
	composer_email_entry_set_is_valid (self, is_valid);
}

static void
composer_email_entry_on_changed (ComposerEmailEntry* self)
{
	ContactEntryCompletion* completion = NULL;
	GtkEntryCompletion* _tmp0_;
	ContactEntryCompletion* _tmp1_;
	ContactEntryCompletion* _tmp2_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (COMPOSER_IS_EMAIL_ENTRY (self));
	composer_email_entry_set_is_modified (self, TRUE);
	_tmp0_ = gtk_entry_get_completion (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_get_type (), GtkEntry));
	_tmp1_ = _g_object_ref0 (IS_CONTACT_ENTRY_COMPLETION (_tmp0_) ? ((ContactEntryCompletion*) _tmp0_) : NULL);
	completion = _tmp1_;
	_tmp2_ = completion;
	if (_tmp2_ != NULL) {
		ContactEntryCompletion* _tmp3_;
		_tmp3_ = completion;
		contact_entry_completion_update_model (_tmp3_);
	}
	_tmp4_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_get_type (), GtkEntry));
	_tmp5_ = _tmp4_;
	if (geary_string_is_empty_or_whitespace (_tmp5_)) {
		GearyRFC822MailboxAddresses* _tmp6_;
		_tmp6_ = geary_rf_c822_mailbox_addresses_new (NULL);
		_g_object_unref0 (self->priv->_addresses);
		self->priv->_addresses = _tmp6_;
		composer_email_entry_set_is_valid (self, FALSE);
	} else {
		{
			GearyRFC822MailboxAddresses* _tmp7_ = NULL;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			GearyRFC822MailboxAddresses* _tmp10_;
			GearyRFC822MailboxAddresses* _tmp11_;
			_tmp8_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_get_type (), GtkEntry));
			_tmp9_ = _tmp8_;
			_tmp10_ = geary_rf_c822_mailbox_addresses_new_from_rfc822_string (_tmp9_, &_inner_error0_);
			_tmp7_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
					goto __catch0_geary_rf_c822_error;
				}
				_g_object_unref0 (completion);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp11_ = _tmp7_;
			_tmp7_ = NULL;
			_g_object_unref0 (self->priv->_addresses);
			self->priv->_addresses = _tmp11_;
			composer_email_entry_set_is_valid (self, TRUE);
			_g_object_unref0 (_tmp7_);
		}
		goto __finally0;
		__catch0_geary_rf_c822_error:
		{
			GearyRFC822MailboxAddresses* _tmp12_;
			g_clear_error (&_inner_error0_);
			_tmp12_ = geary_rf_c822_mailbox_addresses_new (NULL);
			_g_object_unref0 (self->priv->_addresses);
			self->priv->_addresses = _tmp12_;
			composer_email_entry_set_is_valid (self, FALSE);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (completion);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (completion);
}

static gboolean
composer_email_entry_on_key_press (ComposerEmailEntry* self,
                                   GtkWidget* widget,
                                   GdkEventKey* event)
{
	gboolean propagate = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean result;
	g_return_val_if_fail (COMPOSER_IS_EMAIL_ENTRY (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	propagate = GDK_EVENT_PROPAGATE;
	if (event->keyval == GDK_KEY_Tab) {
		ContactEntryCompletion* completion = NULL;
		GtkEntryCompletion* _tmp0_;
		ContactEntryCompletion* _tmp1_;
		ContactEntryCompletion* _tmp2_;
		_tmp0_ = gtk_entry_get_completion (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_get_type (), GtkEntry));
		_tmp1_ = _g_object_ref0 (IS_CONTACT_ENTRY_COMPLETION (_tmp0_) ? ((ContactEntryCompletion*) _tmp0_) : NULL);
		completion = _tmp1_;
		_tmp2_ = completion;
		if (_tmp2_ != NULL) {
			ContactEntryCompletion* _tmp3_;
			ComposerWidget* _tmp4_;
			_tmp3_ = completion;
			contact_entry_completion_trigger_selection (_tmp3_);
			_tmp4_ = self->priv->composer;
			gtk_widget_child_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), GTK_DIR_TAB_FORWARD);
			propagate = GDK_EVENT_STOP;
		}
		_g_object_unref0 (completion);
	}
	if (propagate == GDK_EVENT_PROPAGATE) {
		_tmp5_ = event->keyval != GDK_KEY_Escape;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GtkWindow* window = NULL;
		GtkWidget* _tmp6_;
		GtkWindow* _tmp7_;
		GtkWindow* _tmp8_;
		_tmp6_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp6_) : NULL);
		window = _tmp7_;
		_tmp8_ = window;
		if (_tmp8_ != NULL) {
			GtkWindow* _tmp9_;
			_tmp9_ = window;
			propagate = gtk_window_activate_key (_tmp9_, event);
		}
		_g_object_unref0 (window);
	}
	result = propagate;
	return result;
}

static void
composer_email_entry_class_init (ComposerEmailEntryClass * klass,
                                 gpointer klass_data)
{
	composer_email_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComposerEmailEntry_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_composer_email_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_composer_email_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = composer_email_entry_finalize;
	/** The entry's list of possibly valid email addresses. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSER_EMAIL_ENTRY_ADDRESSES_PROPERTY, composer_email_entry_properties[COMPOSER_EMAIL_ENTRY_ADDRESSES_PROPERTY] = g_param_spec_object ("addresses", "addresses", "addresses", GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Determines if the entry contains only valid email addresses. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSER_EMAIL_ENTRY_IS_VALID_PROPERTY, composer_email_entry_properties[COMPOSER_EMAIL_ENTRY_IS_VALID_PROPERTY] = g_param_spec_boolean ("is-valid", "is-valid", "is-valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if the entry contains any email addresses. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSER_EMAIL_ENTRY_IS_EMPTY_PROPERTY, composer_email_entry_properties[COMPOSER_EMAIL_ENTRY_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Determines if the entry has been modified.
	     *
	     * The entry is considered to be modified only if the text has
	     * been changed after it as been constructed or if modified after
	     * setting {@link addresses}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSER_EMAIL_ENTRY_IS_MODIFIED_PROPERTY, composer_email_entry_properties[COMPOSER_EMAIL_ENTRY_IS_MODIFIED_PROPERTY] = g_param_spec_boolean ("is-modified", "is-modified", "is-modified", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
composer_email_entry_instance_init (ComposerEmailEntry * self,
                                    gpointer klass)
{
	GearyRFC822MailboxAddresses* _tmp0_;
	self->priv = composer_email_entry_get_instance_private (self);
	_tmp0_ = geary_rf_c822_mailbox_addresses_new (NULL);
	self->priv->_addresses = _tmp0_;
	self->priv->_is_valid = FALSE;
	self->priv->_is_modified = FALSE;
}

static void
composer_email_entry_finalize (GObject * obj)
{
	ComposerEmailEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPOSER_TYPE_EMAIL_ENTRY, ComposerEmailEntry);
	_g_object_unref0 (self->priv->_addresses);
	G_OBJECT_CLASS (composer_email_entry_parent_class)->finalize (obj);
}

/**
 * A GTK entry for entering email addresses.
 */
static GType
composer_email_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComposerEmailEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) composer_email_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComposerEmailEntry), 0, (GInstanceInitFunc) composer_email_entry_instance_init, NULL };
	GType composer_email_entry_type_id;
	composer_email_entry_type_id = g_type_register_static (gtk_entry_get_type (), "ComposerEmailEntry", &g_define_type_info, 0);
	ComposerEmailEntry_private_offset = g_type_add_instance_private (composer_email_entry_type_id, sizeof (ComposerEmailEntryPrivate));
	return composer_email_entry_type_id;
}

GType
composer_email_entry_get_type (void)
{
	static volatile gsize composer_email_entry_type_id__once = 0;
	if (g_once_init_enter (&composer_email_entry_type_id__once)) {
		GType composer_email_entry_type_id;
		composer_email_entry_type_id = composer_email_entry_get_type_once ();
		g_once_init_leave (&composer_email_entry_type_id__once, composer_email_entry_type_id);
	}
	return composer_email_entry_type_id__once;
}

static void
_vala_composer_email_entry_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	ComposerEmailEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPOSER_TYPE_EMAIL_ENTRY, ComposerEmailEntry);
	switch (property_id) {
		case COMPOSER_EMAIL_ENTRY_ADDRESSES_PROPERTY:
		g_value_set_object (value, composer_email_entry_get_addresses (self));
		break;
		case COMPOSER_EMAIL_ENTRY_IS_VALID_PROPERTY:
		g_value_set_boolean (value, composer_email_entry_get_is_valid (self));
		break;
		case COMPOSER_EMAIL_ENTRY_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, composer_email_entry_get_is_empty (self));
		break;
		case COMPOSER_EMAIL_ENTRY_IS_MODIFIED_PROPERTY:
		g_value_set_boolean (value, composer_email_entry_get_is_modified (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_composer_email_entry_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	ComposerEmailEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPOSER_TYPE_EMAIL_ENTRY, ComposerEmailEntry);
	switch (property_id) {
		case COMPOSER_EMAIL_ENTRY_ADDRESSES_PROPERTY:
		composer_email_entry_set_addresses (self, g_value_get_object (value));
		break;
		case COMPOSER_EMAIL_ENTRY_IS_VALID_PROPERTY:
		composer_email_entry_set_is_valid (self, g_value_get_boolean (value));
		break;
		case COMPOSER_EMAIL_ENTRY_IS_MODIFIED_PROPERTY:
		composer_email_entry_set_is_modified (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

