/* conversation-list-view.c generated by valac 0.56.3, the Vala compiler
 * generated from conversation-list-view.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include "geary-engine.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define CONVERSATION_LIST_VIEW_LOAD_MORE_HEIGHT 100

enum  {
	CONVERSATION_LIST_VIEW_0_PROPERTY,
	CONVERSATION_LIST_VIEW_NUM_PROPERTIES
};
static GParamSpec* conversation_list_view_properties[CONVERSATION_LIST_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
#define __vala_GdkEventSequence_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventSequence_free (var), NULL)))
#define __vala_GdkEvent_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEvent_free (var), NULL)))
enum  {
	CONVERSATION_LIST_VIEW_CONVERSATIONS_SELECTED_SIGNAL,
	CONVERSATION_LIST_VIEW_CONVERSATION_ACTIVATED_SIGNAL,
	CONVERSATION_LIST_VIEW_LOAD_MORE_SIGNAL,
	CONVERSATION_LIST_VIEW_MARK_CONVERSATIONS_SIGNAL,
	CONVERSATION_LIST_VIEW_VISIBLE_CONVERSATIONS_CHANGED_SIGNAL,
	CONVERSATION_LIST_VIEW_NUM_SIGNALS
};
static guint conversation_list_view_signals[CONVERSATION_LIST_VIEW_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ConversationListViewPrivate {
	ApplicationConfiguration* config;
	gboolean enable_load_more;
	gboolean reset_adjustment;
	GeeSet* current_visible_conversations;
	GearySchedulerScheduled* scheduled_update_visible_conversations;
	GeeSet* selected;
	GearyIdleManager* selection_update;
	GtkGestureMultiPress* gesture;
	gboolean should_inhibit_autoselect;
};

static gint ConversationListView_private_offset;
static gpointer conversation_list_view_parent_class = NULL;
static GearyBaseInterfaceIface * conversation_list_view_geary_base_interface_parent_iface = NULL;

static void g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void conversation_list_view_real_load_more (ConversationListView* self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static GtkTreeViewColumn* conversation_list_view_create_column (ConversationListStoreColumn column,
                                                         GtkCellRenderer* renderer,
                                                         const gchar* attr,
                                                         gint width);
static void conversation_list_view_on_style_changed (ConversationListView* self);
static void _conversation_list_view_on_style_changed_gtk_widget_style_updated (GtkWidget* _sender,
                                                                        gpointer self);
static void conversation_list_view_on_vadjustment_changed (ConversationListView* self);
static void _conversation_list_view_on_vadjustment_changed_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static gboolean conversation_list_view_on_key_press (ConversationListView* self,
                                              GdkEventKey* event);
static gboolean _conversation_list_view_on_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                          GdkEventKey* event,
                                                                          gpointer self);
static gboolean conversation_list_view_on_button_press (ConversationListView* self,
                                                 GdkEventButton* event);
static gboolean _conversation_list_view_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                GdkEventButton* event,
                                                                                gpointer self);
static void conversation_list_view_on_gesture_pressed (ConversationListView* self,
                                                gint n_press,
                                                gdouble x,
                                                gdouble y);
static void _conversation_list_view_on_gesture_pressed_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                                                 gint n_press,
                                                                                 gdouble x,
                                                                                 gdouble y,
                                                                                 gpointer self);
static void conversation_list_view_on_display_preview_changed (ConversationListView* self);
static void _conversation_list_view_on_display_preview_changed_g_settings_changed (GSettings* _sender,
                                                                            const gchar* key,
                                                                            gpointer self);
static gboolean conversation_list_view_on_motion_notify_event (ConversationListView* self,
                                                        GdkEventMotion* event);
static gboolean _conversation_list_view_on_motion_notify_event_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                        GdkEventMotion* event,
                                                                                        gpointer self);
static gboolean conversation_list_view_on_leave_notify_event (ConversationListView* self);
static gboolean _conversation_list_view_on_leave_notify_event_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                                      GdkEventCrossing* event,
                                                                                      gpointer self);
static void conversation_list_view_do_selection_changed (ConversationListView* self);
static void _conversation_list_view_do_selection_changed_geary_idle_manager_idle_func (GearyIdleManager* manager,
                                                                                gpointer self);
static void conversation_list_view_real_destroy (GtkWidget* base);
static void conversation_list_view_on_scan_started (ConversationListView* self);
static void _conversation_list_view_on_scan_started_geary_app_conversation_monitor_scan_started (GearyAppConversationMonitor* _sender,
                                                                                          gpointer self);
static void conversation_list_view_on_scan_completed (ConversationListView* self);
static void _conversation_list_view_on_scan_completed_geary_app_conversation_monitor_scan_completed (GearyAppConversationMonitor* _sender,
                                                                                              gpointer self);
static void conversation_list_view_on_conversations_added (ConversationListView* self,
                                                    gboolean start);
static void _conversation_list_view_on_conversations_added_conversation_list_store_conversations_added (ConversationListStore* _sender,
                                                                                                 gboolean start,
                                                                                                 gpointer self);
static void conversation_list_view_on_conversations_removed (ConversationListView* self,
                                                      gboolean start);
static void _conversation_list_view_on_conversations_removed_conversation_list_store_conversations_removed (ConversationListStore* _sender,
                                                                                                     gboolean start,
                                                                                                     gpointer self);
static void conversation_list_view_on_rows_changed (ConversationListView* self);
static void _conversation_list_view_on_rows_changed_gtk_tree_model_row_inserted (GtkTreeModel* _sender,
                                                                          GtkTreePath* path,
                                                                          GtkTreeIter* iter,
                                                                          gpointer self);
static void _conversation_list_view_on_rows_changed_gtk_tree_model_rows_reordered (GtkTreeModel* _sender,
                                                                            GtkTreePath* path,
                                                                            GtkTreeIter* iter,
                                                                            gint* new_order,
                                                                            gpointer self);
static void _conversation_list_view_on_rows_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender,
                                                                         GtkTreePath* path,
                                                                         GtkTreeIter* iter,
                                                                         gpointer self);
static void _conversation_list_view_on_rows_changed_gtk_tree_model_row_deleted (GtkTreeModel* _sender,
                                                                         GtkTreePath* path,
                                                                         gpointer self);
static void conversation_list_view_on_selection_changed (ConversationListView* self);
static void _conversation_list_view_on_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                                                              gpointer self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
static void conversation_list_view_check_load_more (ConversationListView* self);
static void conversation_list_view_schedule_visible_conversations_changed (ConversationListView* self);
static GtkAdjustment* conversation_list_view_get_adjustment (ConversationListView* self);
static GdkEvent* _vala_GdkEvent_copy (GdkEvent* self);
static void _vala_GdkEventSequence_free (GdkEventSequence* self);
static void _vala_GdkEvent_free (GdkEvent* self);
VALA_EXTERN gboolean application_main_window_close_composer (ApplicationMainWindow* self,
                                                 gboolean should_prompt,
                                                 gboolean is_shutdown);
static void conversation_list_view_on_value_changed (ConversationListView* self);
static GList* conversation_list_view_get_all_selected_paths (ConversationListView* self);
static gboolean conversation_list_view_update_visible_conversations (ConversationListView* self);
static gboolean _conversation_list_view_update_visible_conversations_gsource_func (gpointer self);
static gboolean conversation_list_view_refresh_path (ConversationListView* self,
                                              GtkTreeModel* model,
                                              GtkTreePath* path,
                                              GtkTreeIter* iter);
static gboolean _conversation_list_view_refresh_path_gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                                           GtkTreePath* path,
                                                                           GtkTreeIter* iter,
                                                                           gpointer self);
static void conversation_list_view_set_hover_selected (ConversationListView* self,
                                                gboolean hover);
static void _conversation_list_view_on_value_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                            gpointer self);
static void conversation_list_view_finalize (GObject * obj);
static GType conversation_list_view_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

VALA_EXTERN const GtkTargetEntry FOLDER_LIST_TREE_TARGET_ENTRY_LIST[1];

static inline gpointer
conversation_list_view_get_instance_private (ConversationListView* self)
{
	return G_STRUCT_MEMBER_P (self, ConversationListView_private_offset);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static void
conversation_list_view_real_load_more (ConversationListView* self)
{
	self->priv->enable_load_more = FALSE;
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_conversation_list_view_on_style_changed_gtk_widget_style_updated (GtkWidget* _sender,
                                                                   gpointer self)
{
	conversation_list_view_on_style_changed ((ConversationListView*) self);
}

static void
_conversation_list_view_on_vadjustment_changed_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	conversation_list_view_on_vadjustment_changed ((ConversationListView*) self);
}

static gboolean
_conversation_list_view_on_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                 GdkEventKey* event,
                                                                 gpointer self)
{
	gboolean result;
	result = conversation_list_view_on_key_press ((ConversationListView*) self, event);
	return result;
}

static gboolean
_conversation_list_view_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                       GdkEventButton* event,
                                                                       gpointer self)
{
	gboolean result;
	result = conversation_list_view_on_button_press ((ConversationListView*) self, event);
	return result;
}

static void
_conversation_list_view_on_gesture_pressed_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                                            gint n_press,
                                                                            gdouble x,
                                                                            gdouble y,
                                                                            gpointer self)
{
	conversation_list_view_on_gesture_pressed ((ConversationListView*) self, n_press, x, y);
}

static void
_conversation_list_view_on_display_preview_changed_g_settings_changed (GSettings* _sender,
                                                                       const gchar* key,
                                                                       gpointer self)
{
	conversation_list_view_on_display_preview_changed ((ConversationListView*) self);
}

static gboolean
_conversation_list_view_on_motion_notify_event_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                               GdkEventMotion* event,
                                                                               gpointer self)
{
	gboolean result;
	result = conversation_list_view_on_motion_notify_event ((ConversationListView*) self, event);
	return result;
}

static gboolean
_conversation_list_view_on_leave_notify_event_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                             GdkEventCrossing* event,
                                                                             gpointer self)
{
	gboolean result;
	result = conversation_list_view_on_leave_notify_event ((ConversationListView*) self);
	return result;
}

static void
_conversation_list_view_do_selection_changed_geary_idle_manager_idle_func (GearyIdleManager* manager,
                                                                           gpointer self)
{
	conversation_list_view_do_selection_changed ((ConversationListView*) self);
}

ConversationListView*
conversation_list_view_construct (GType object_type,
                                  ApplicationConfiguration* config)
{
	ConversationListView * self = NULL;
	ApplicationConfiguration* _tmp0_;
	ConversationListCellRenderer* _tmp1_;
	ConversationListCellRenderer* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkTreeViewColumn* _tmp5_;
	GtkTreeViewColumn* _tmp6_;
	GtkTreeSelection* selection = NULL;
	GtkTreeSelection* _tmp7_;
	GtkTreeSelection* _tmp8_;
	GtkGestureMultiPress* _tmp9_;
	GtkGestureMultiPress* _tmp10_;
	ApplicationConfiguration* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	gchar* _tmp14_;
	GtkBindingSet* binding_set = NULL;
	GtkBindingSet* _tmp15_;
	GearyIdleManager* _tmp16_;
	GearyIdleManager* _tmp17_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), NULL);
	self = (ConversationListView*) g_object_new (object_type, NULL);
	geary_base_interface_base_ref (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_BASE_INTERFACE, GearyBaseInterface));
	gtk_tree_view_set_show_expanders (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), FALSE);
	gtk_tree_view_set_headers_visible (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), FALSE);
	gtk_tree_view_set_grid_lines (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), GTK_TREE_VIEW_GRID_LINES_HORIZONTAL);
	_tmp0_ = _g_object_ref0 (config);
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp0_;
	_tmp1_ = conversation_list_cell_renderer_new ();
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	_tmp3_ = conversation_list_store_column_to_string (CONVERSATION_LIST_STORE_COLUMN_CONVERSATION_DATA);
	_tmp4_ = _tmp3_;
	_tmp5_ = conversation_list_view_create_column (CONVERSATION_LIST_STORE_COLUMN_CONVERSATION_DATA, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_cell_renderer_get_type (), GtkCellRenderer), _tmp4_, 0);
	_tmp6_ = _tmp5_;
	gtk_tree_view_append_column (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), _tmp6_);
	_g_object_unref0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	_tmp7_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	_tmp8_ = _g_object_ref0 (_tmp7_);
	selection = _tmp8_;
	gtk_tree_selection_set_mode (selection, GTK_SELECTION_MULTIPLE);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "style-updated", (GCallback) _conversation_list_view_on_style_changed_gtk_widget_style_updated, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify::vadjustment", (GCallback) _conversation_list_view_on_vadjustment_changed_g_object_notify, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "key-press-event", (GCallback) _conversation_list_view_on_key_press_gtk_widget_key_press_event, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "button-press-event", (GCallback) _conversation_list_view_on_button_press_gtk_widget_button_press_event, self, 0);
	_tmp9_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->gesture);
	self->priv->gesture = _tmp9_;
	_tmp10_ = self->priv->gesture;
	g_signal_connect_object (_tmp10_, "pressed", (GCallback) _conversation_list_view_on_gesture_pressed_gtk_gesture_multi_press_pressed, self, 0);
	gtk_drag_source_set (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), GDK_BUTTON1_MASK, FOLDER_LIST_TREE_TARGET_ENTRY_LIST, (gint) G_N_ELEMENTS (FOLDER_LIST_TREE_TARGET_ENTRY_LIST), GDK_ACTION_COPY | GDK_ACTION_MOVE);
	_tmp11_ = self->priv->config;
	_tmp12_ = application_configuration_get_settings (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat ("changed::", APPLICATION_CONFIGURATION_DISPLAY_PREVIEW_KEY, NULL);
	g_signal_connect_object (_tmp13_, _tmp14_, (GCallback) _conversation_list_view_on_display_preview_changed_g_settings_changed, self, 0);
	_g_free0 (_tmp14_);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "motion-notify-event", (GCallback) _conversation_list_view_on_motion_notify_event_gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "leave-notify-event", (GCallback) _conversation_list_view_on_leave_notify_event_gtk_widget_leave_notify_event, self, 0);
	_tmp15_ = gtk_binding_set_find ("GtkTreeView");
	binding_set = _tmp15_;
	_vala_assert (binding_set != NULL, "binding_set != null");
	gtk_binding_entry_remove (binding_set, GDK_KEY_N, GDK_CONTROL_MASK);
	_tmp16_ = geary_idle_manager_new (_conversation_list_view_do_selection_changed_geary_idle_manager_idle_func, self);
	_g_object_unref0 (self->priv->selection_update);
	self->priv->selection_update = _tmp16_;
	_tmp17_ = self->priv->selection_update;
	_tmp17_->priority = GEARY_IDLE_MANAGER_PRIORITY_LOW;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
	_g_object_unref0 (selection);
	return self;
}

ConversationListView*
conversation_list_view_new (ApplicationConfiguration* config)
{
	return conversation_list_view_construct (TYPE_CONVERSATION_LIST_VIEW, config);
}

static void
conversation_list_view_real_destroy (GtkWidget* base)
{
	ConversationListView * self;
	GearyIdleManager* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CONVERSATION_LIST_VIEW, ConversationListView);
	_tmp0_ = self->priv->selection_update;
	geary_idle_manager_reset (_tmp0_);
	GTK_WIDGET_CLASS (conversation_list_view_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), gtk_widget_get_type (), GtkWidget));
}

ConversationListStore*
conversation_list_view_get_model (ConversationListView* self)
{
	GtkTreeModel* _tmp0_;
	ConversationListStore* _tmp1_;
	ConversationListStore* result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_VIEW (self), NULL);
	_tmp0_ = gtk_tree_view_get_model (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	_tmp1_ = _g_object_ref0 (IS_CONVERSATION_LIST_STORE (_tmp0_) ? ((ConversationListStore*) _tmp0_) : NULL);
	result = _tmp1_;
	return result;
}

static void
_conversation_list_view_on_scan_started_geary_app_conversation_monitor_scan_started (GearyAppConversationMonitor* _sender,
                                                                                     gpointer self)
{
	conversation_list_view_on_scan_started ((ConversationListView*) self);
}

static void
_conversation_list_view_on_scan_completed_geary_app_conversation_monitor_scan_completed (GearyAppConversationMonitor* _sender,
                                                                                         gpointer self)
{
	conversation_list_view_on_scan_completed ((ConversationListView*) self);
}

static void
_conversation_list_view_on_conversations_added_conversation_list_store_conversations_added (ConversationListStore* _sender,
                                                                                            gboolean start,
                                                                                            gpointer self)
{
	conversation_list_view_on_conversations_added ((ConversationListView*) self, start);
}

static void
_conversation_list_view_on_conversations_removed_conversation_list_store_conversations_removed (ConversationListStore* _sender,
                                                                                                gboolean start,
                                                                                                gpointer self)
{
	conversation_list_view_on_conversations_removed ((ConversationListView*) self, start);
}

static void
_conversation_list_view_on_rows_changed_gtk_tree_model_row_inserted (GtkTreeModel* _sender,
                                                                     GtkTreePath* path,
                                                                     GtkTreeIter* iter,
                                                                     gpointer self)
{
	conversation_list_view_on_rows_changed ((ConversationListView*) self);
}

static void
_conversation_list_view_on_rows_changed_gtk_tree_model_rows_reordered (GtkTreeModel* _sender,
                                                                       GtkTreePath* path,
                                                                       GtkTreeIter* iter,
                                                                       gint* new_order,
                                                                       gpointer self)
{
	conversation_list_view_on_rows_changed ((ConversationListView*) self);
}

static void
_conversation_list_view_on_rows_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender,
                                                                    GtkTreePath* path,
                                                                    GtkTreeIter* iter,
                                                                    gpointer self)
{
	conversation_list_view_on_rows_changed ((ConversationListView*) self);
}

static void
_conversation_list_view_on_rows_changed_gtk_tree_model_row_deleted (GtkTreeModel* _sender,
                                                                    GtkTreePath* path,
                                                                    gpointer self)
{
	conversation_list_view_on_rows_changed ((ConversationListView*) self);
}

static void
_conversation_list_view_on_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                                                         gpointer self)
{
	conversation_list_view_on_selection_changed ((ConversationListView*) self);
}

void
conversation_list_view_set_model (ConversationListView* self,
                                  ConversationListStore* new_store)
{
	ConversationListStore* old_store = NULL;
	ConversationListStore* _tmp0_;
	ConversationListStore* _tmp1_;
	GtkTreeSelection* selection = NULL;
	GtkTreeSelection* _tmp27_;
	GtkTreeSelection* _tmp28_;
	guint _tmp29_;
	GeeSet* _tmp30_;
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	g_return_if_fail ((new_store == NULL) || IS_CONVERSATION_LIST_STORE (new_store));
	_tmp0_ = conversation_list_view_get_model (self);
	old_store = _tmp0_;
	_tmp1_ = old_store;
	if (_tmp1_ != NULL) {
		ConversationListStore* _tmp2_;
		GearyAppConversationMonitor* _tmp3_;
		GearyAppConversationMonitor* _tmp4_;
		guint _tmp5_;
		ConversationListStore* _tmp6_;
		GearyAppConversationMonitor* _tmp7_;
		GearyAppConversationMonitor* _tmp8_;
		guint _tmp9_;
		ConversationListStore* _tmp10_;
		guint _tmp11_;
		ConversationListStore* _tmp12_;
		guint _tmp13_;
		ConversationListStore* _tmp14_;
		guint _tmp15_;
		ConversationListStore* _tmp16_;
		guint _tmp17_;
		ConversationListStore* _tmp18_;
		guint _tmp19_;
		ConversationListStore* _tmp20_;
		guint _tmp21_;
		ConversationListStore* _tmp22_;
		_tmp2_ = old_store;
		_tmp3_ = conversation_list_store_get_conversations (_tmp2_);
		_tmp4_ = _tmp3_;
		g_signal_parse_name ("scan-started", GEARY_APP_TYPE_CONVERSATION_MONITOR, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _conversation_list_view_on_scan_started_geary_app_conversation_monitor_scan_started, self);
		_tmp6_ = old_store;
		_tmp7_ = conversation_list_store_get_conversations (_tmp6_);
		_tmp8_ = _tmp7_;
		g_signal_parse_name ("scan-completed", GEARY_APP_TYPE_CONVERSATION_MONITOR, &_tmp9_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _conversation_list_view_on_scan_completed_geary_app_conversation_monitor_scan_completed, self);
		_tmp10_ = old_store;
		g_signal_parse_name ("conversations-added", TYPE_CONVERSATION_LIST_STORE, &_tmp11_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _conversation_list_view_on_conversations_added_conversation_list_store_conversations_added, self);
		_tmp12_ = old_store;
		g_signal_parse_name ("conversations-removed", TYPE_CONVERSATION_LIST_STORE, &_tmp13_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _conversation_list_view_on_conversations_removed_conversation_list_store_conversations_removed, self);
		_tmp14_ = old_store;
		g_signal_parse_name ("row-inserted", gtk_tree_model_get_type (), &_tmp15_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_tree_model_get_type (), GtkTreeModel), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _conversation_list_view_on_rows_changed_gtk_tree_model_row_inserted, self);
		_tmp16_ = old_store;
		g_signal_parse_name ("rows-reordered", gtk_tree_model_get_type (), &_tmp17_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_tree_model_get_type (), GtkTreeModel), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _conversation_list_view_on_rows_changed_gtk_tree_model_rows_reordered, self);
		_tmp18_ = old_store;
		g_signal_parse_name ("row-changed", gtk_tree_model_get_type (), &_tmp19_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_tree_model_get_type (), GtkTreeModel), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, 0, NULL, (GCallback) _conversation_list_view_on_rows_changed_gtk_tree_model_row_changed, self);
		_tmp20_ = old_store;
		g_signal_parse_name ("row-deleted", gtk_tree_model_get_type (), &_tmp21_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_tree_model_get_type (), GtkTreeModel), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp21_, 0, NULL, (GCallback) _conversation_list_view_on_rows_changed_gtk_tree_model_row_deleted, self);
		_tmp22_ = old_store;
		conversation_list_store_destroy (_tmp22_);
	}
	if (new_store != NULL) {
		GearyAppConversationMonitor* _tmp23_;
		GearyAppConversationMonitor* _tmp24_;
		GearyAppConversationMonitor* _tmp25_;
		GearyAppConversationMonitor* _tmp26_;
		_tmp23_ = conversation_list_store_get_conversations (new_store);
		_tmp24_ = _tmp23_;
		g_signal_connect_object (_tmp24_, "scan-started", (GCallback) _conversation_list_view_on_scan_started_geary_app_conversation_monitor_scan_started, self, 0);
		_tmp25_ = conversation_list_store_get_conversations (new_store);
		_tmp26_ = _tmp25_;
		g_signal_connect_object (_tmp26_, "scan-completed", (GCallback) _conversation_list_view_on_scan_completed_geary_app_conversation_monitor_scan_completed, self, 0);
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (new_store, gtk_tree_model_get_type (), GtkTreeModel), "row-inserted", (GCallback) _conversation_list_view_on_rows_changed_gtk_tree_model_row_inserted, self, 0);
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (new_store, gtk_tree_model_get_type (), GtkTreeModel), "rows-reordered", (GCallback) _conversation_list_view_on_rows_changed_gtk_tree_model_rows_reordered, self, 0);
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (new_store, gtk_tree_model_get_type (), GtkTreeModel), "row-changed", (GCallback) _conversation_list_view_on_rows_changed_gtk_tree_model_row_changed, self, 0);
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (new_store, gtk_tree_model_get_type (), GtkTreeModel), "row-deleted", (GCallback) _conversation_list_view_on_rows_changed_gtk_tree_model_row_deleted, self, 0);
		g_signal_connect_object (new_store, "conversations-removed", (GCallback) _conversation_list_view_on_conversations_removed_conversation_list_store_conversations_removed, self, 0);
		g_signal_connect_object (new_store, "conversations-added", (GCallback) _conversation_list_view_on_conversations_added_conversation_list_store_conversations_added, self, 0);
	}
	_tmp27_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	_tmp28_ = _g_object_ref0 (_tmp27_);
	selection = _tmp28_;
	g_signal_parse_name ("changed", gtk_tree_selection_get_type (), &_tmp29_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (selection, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp29_, 0, NULL, (GCallback) _conversation_list_view_on_selection_changed_gtk_tree_selection_changed, self);
	gtk_tree_view_set_model (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), G_TYPE_CHECK_INSTANCE_CAST (new_store, gtk_tree_model_get_type (), GtkTreeModel));
	_tmp30_ = self->priv->selected;
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_COLLECTION, GeeCollection));
	g_signal_connect_object (selection, "changed", (GCallback) _conversation_list_view_on_selection_changed_gtk_tree_selection_changed, self, 0);
	_g_object_unref0 (selection);
	_g_object_unref0 (old_store);
}

/** Returns a read-only iteration of the current selection. */
GeeSet*
conversation_list_view_get_selected (ConversationListView* self)
{
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_VIEW (self), NULL);
	_tmp0_ = self->priv->selected;
	_tmp1_ = gee_set_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/** Returns a copy of the current selection. */
GeeSet*
conversation_list_view_copy_selected (ConversationListView* self)
{
	GeeHashSet* copy = NULL;
	GeeHashSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_VIEW (self), NULL);
	_tmp0_ = gee_hash_set_new (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	copy = _tmp0_;
	_tmp1_ = self->priv->selected;
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (copy, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
	result = G_TYPE_CHECK_INSTANCE_CAST (copy, GEE_TYPE_SET, GeeSet);
	return result;
}

void
conversation_list_view_inhibit_next_autoselect (ConversationListView* self)
{
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	self->priv->should_inhibit_autoselect = TRUE;
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
	g_boxed_free (gtk_tree_iter_get_type (), self);
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
}

static gpointer
__vala_GtkTreeIter_copy0 (gpointer self)
{
	return self ? _vala_GtkTreeIter_copy (self) : NULL;
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
}

static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
}

void
conversation_list_view_scroll (ConversationListView* self,
                               GtkScrollType where)
{
	GtkTreeSelection* selection = NULL;
	GtkTreeSelection* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeModel* model = NULL;
	GList* selected = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeModel* _tmp3_ = NULL;
	GList* _tmp4_;
	GtkTreePath* target_path = NULL;
	GtkTreeIter* target_iter = NULL;
	GList* _tmp5_;
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	_tmp0_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	selection = _tmp1_;
	_tmp2_ = selection;
	_tmp4_ = gtk_tree_selection_get_selected_rows (_tmp2_, &_tmp3_);
	model = _tmp3_;
	selected = _tmp4_;
	target_path = NULL;
	target_iter = NULL;
	_tmp5_ = selected;
	if (g_list_length (_tmp5_) > ((guint) 0)) {
		GtkTreePath* _tmp38_;
		switch (where) {
			case GTK_SCROLL_STEP_UP:
			{
				GList* _tmp6_;
				GList* _tmp7_;
				gconstpointer _tmp8_;
				GtkTreePath* _tmp9_;
				GtkTreeModel* _tmp10_;
				GtkTreePath* _tmp11_;
				GtkTreeIter _tmp12_ = {0};
				GtkTreeIter _tmp13_;
				GtkTreeIter* _tmp14_;
				GtkTreeModel* _tmp15_;
				gboolean _tmp16_;
				_tmp6_ = selected;
				_tmp7_ = g_list_first (_tmp6_);
				_tmp8_ = _tmp7_->data;
				_tmp9_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp8_);
				__vala_GtkTreePath_free0 (target_path);
				target_path = _tmp9_;
				_tmp10_ = model;
				_tmp11_ = target_path;
				gtk_tree_model_get_iter (_tmp10_, &_tmp12_, _tmp11_);
				__vala_GtkTreeIter_free0 (target_iter);
				_tmp13_ = _tmp12_;
				_tmp14_ = __vala_GtkTreeIter_copy0 (&_tmp13_);
				target_iter = _tmp14_;
				_tmp15_ = model;
				_tmp16_ = gtk_tree_model_iter_previous (_tmp15_, target_iter);
				if (_tmp16_) {
					GtkTreeModel* _tmp17_;
					GtkTreeIter* _tmp18_;
					GtkTreeIter _tmp19_;
					GtkTreePath* _tmp20_;
					_tmp17_ = model;
					_tmp18_ = target_iter;
					_tmp19_ = *_tmp18_;
					_tmp20_ = gtk_tree_model_get_path (_tmp17_, &_tmp19_);
					__vala_GtkTreePath_free0 (target_path);
					target_path = _tmp20_;
				} else {
					GdkWindow* _tmp21_;
					_tmp21_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
					gdk_window_beep (_tmp21_);
				}
				break;
			}
			case GTK_SCROLL_STEP_DOWN:
			{
				GList* _tmp22_;
				GList* _tmp23_;
				gconstpointer _tmp24_;
				GtkTreePath* _tmp25_;
				GtkTreeModel* _tmp26_;
				GtkTreePath* _tmp27_;
				GtkTreeIter _tmp28_ = {0};
				GtkTreeIter _tmp29_;
				GtkTreeIter* _tmp30_;
				GtkTreeModel* _tmp31_;
				gboolean _tmp32_;
				_tmp22_ = selected;
				_tmp23_ = g_list_last (_tmp22_);
				_tmp24_ = _tmp23_->data;
				_tmp25_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp24_);
				__vala_GtkTreePath_free0 (target_path);
				target_path = _tmp25_;
				_tmp26_ = model;
				_tmp27_ = target_path;
				gtk_tree_model_get_iter (_tmp26_, &_tmp28_, _tmp27_);
				__vala_GtkTreeIter_free0 (target_iter);
				_tmp29_ = _tmp28_;
				_tmp30_ = __vala_GtkTreeIter_copy0 (&_tmp29_);
				target_iter = _tmp30_;
				_tmp31_ = model;
				_tmp32_ = gtk_tree_model_iter_next (_tmp31_, target_iter);
				if (_tmp32_) {
					GtkTreeModel* _tmp33_;
					GtkTreeIter* _tmp34_;
					GtkTreeIter _tmp35_;
					GtkTreePath* _tmp36_;
					_tmp33_ = model;
					_tmp34_ = target_iter;
					_tmp35_ = *_tmp34_;
					_tmp36_ = gtk_tree_model_get_path (_tmp33_, &_tmp35_);
					__vala_GtkTreePath_free0 (target_path);
					target_path = _tmp36_;
				} else {
					GdkWindow* _tmp37_;
					_tmp37_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
					gdk_window_beep (_tmp37_);
				}
				break;
			}
			default:
			{
				break;
			}
		}
		_tmp38_ = target_path;
		gtk_tree_view_set_cursor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), _tmp38_, NULL, FALSE);
	}
	__vala_GtkTreeIter_free0 (target_iter);
	__vala_GtkTreePath_free0 (target_path);
	(selected == NULL) ? NULL : (selected = (_g_list_free___vala_GtkTreePath_free0_ (selected), NULL));
	_g_object_unref0 (selection);
}

static void
conversation_list_view_check_load_more (ConversationListView* self)
{
	ConversationListStore* model = NULL;
	ConversationListStore* _tmp0_;
	GearyAppConversationMonitor* _tmp1_ = NULL;
	ConversationListStore* _tmp2_;
	GearyAppConversationMonitor* conversations = NULL;
	GearyAppConversationMonitor* _tmp6_;
	GearyAppConversationMonitor* _tmp7_;
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	_tmp0_ = conversation_list_view_get_model (self);
	model = _tmp0_;
	_tmp2_ = model;
	if (_tmp2_ != NULL) {
		ConversationListStore* _tmp3_;
		GearyAppConversationMonitor* _tmp4_;
		GearyAppConversationMonitor* _tmp5_;
		_tmp3_ = model;
		_tmp4_ = conversation_list_store_get_conversations (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = NULL;
	}
	_tmp6_ = _g_object_ref0 (_tmp1_);
	conversations = _tmp6_;
	_tmp7_ = conversations;
	if (_tmp7_ != NULL) {
		GtkAdjustment* adjustment = NULL;
		GtkAdjustment* _tmp8_;
		GtkAdjustment* _tmp9_;
		gdouble upper = 0.0;
		GtkAdjustment* _tmp10_;
		gdouble threshold = 0.0;
		GtkAdjustment* _tmp11_;
		gdouble _tmp12_;
		gdouble _tmp13_;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		_tmp8_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable));
		_tmp9_ = _g_object_ref0 (_tmp8_);
		adjustment = _tmp9_;
		_tmp10_ = adjustment;
		upper = gtk_adjustment_get_upper (_tmp10_);
		_tmp11_ = adjustment;
		_tmp12_ = gtk_adjustment_get_page_size (_tmp11_);
		_tmp13_ = _tmp12_;
		threshold = (upper - _tmp13_) - CONVERSATION_LIST_VIEW_LOAD_MORE_HEIGHT;
		if (gtk_widget_is_visible (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget))) {
			GearyAppConversationMonitor* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			_tmp16_ = conversations;
			_tmp17_ = geary_app_conversation_monitor_get_can_load_more (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp15_ = _tmp18_;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			GtkAdjustment* _tmp19_;
			_tmp19_ = adjustment;
			_tmp14_ = gtk_adjustment_get_value (_tmp19_) >= threshold;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			g_signal_emit (self, conversation_list_view_signals[CONVERSATION_LIST_VIEW_LOAD_MORE_SIGNAL], 0);
		}
		conversation_list_view_schedule_visible_conversations_changed (self);
		_g_object_unref0 (adjustment);
	}
	_g_object_unref0 (conversations);
	_g_object_unref0 (model);
}

static void
conversation_list_view_on_scan_started (ConversationListView* self)
{
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	self->priv->enable_load_more = FALSE;
}

static void
conversation_list_view_on_scan_completed (ConversationListView* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ApplicationConfiguration* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	self->priv->enable_load_more = TRUE;
	conversation_list_view_check_load_more (self);
	_tmp2_ = self->priv->config;
	_tmp3_ = application_configuration_get_autoselect (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp1_ = !self->priv->should_inhibit_autoselect;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkTreeSelection* _tmp5_;
		_tmp5_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
		_tmp0_ = gtk_tree_selection_count_selected_rows (_tmp5_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ApplicationMainWindow* parent = NULL;
		GtkWidget* _tmp6_;
		ApplicationMainWindow* _tmp7_;
		gboolean _tmp8_ = FALSE;
		ApplicationMainWindow* _tmp9_;
		_tmp6_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp7_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (_tmp6_) ? ((ApplicationMainWindow*) _tmp6_) : NULL);
		parent = _tmp7_;
		_tmp9_ = parent;
		if (_tmp9_ != NULL) {
			ApplicationMainWindow* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp10_ = parent;
			_tmp11_ = application_main_window_get_has_composer (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp8_ = !_tmp12_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			GtkTreePath* _tmp13_;
			GtkTreePath* _tmp14_;
			_tmp13_ = gtk_tree_path_new_from_indices (0, -1, -1);
			_tmp14_ = _tmp13_;
			gtk_tree_view_set_cursor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), _tmp14_, NULL, FALSE);
			__vala_GtkTreePath_free0 (_tmp14_);
		}
		_g_object_unref0 (parent);
	}
	self->priv->should_inhibit_autoselect = FALSE;
}

static void
conversation_list_view_on_conversations_added (ConversationListView* self,
                                               gboolean start)
{
	GtkAdjustment* adjustment = NULL;
	GtkAdjustment* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	_tmp0_ = conversation_list_view_get_adjustment (self);
	adjustment = _tmp0_;
	if (start) {
		gboolean _tmp1_ = FALSE;
		GtkAdjustment* _tmp2_;
		_tmp2_ = adjustment;
		if (_tmp2_ != NULL) {
			GtkAdjustment* _tmp3_;
			_tmp3_ = adjustment;
			_tmp1_ = gtk_adjustment_get_value (_tmp3_) == ((gdouble) 0);
		} else {
			_tmp1_ = FALSE;
		}
		self->priv->reset_adjustment = _tmp1_;
	} else {
		gboolean _tmp4_ = FALSE;
		if (self->priv->reset_adjustment) {
			GtkAdjustment* _tmp5_;
			_tmp5_ = adjustment;
			_tmp4_ = _tmp5_ != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			GtkAdjustment* _tmp6_;
			while (TRUE) {
				if (!gtk_events_pending ()) {
					break;
				}
				gtk_main_iteration ();
			}
			_tmp6_ = adjustment;
			gtk_adjustment_set_value (_tmp6_, (gdouble) 0);
		}
	}
	self->priv->reset_adjustment = FALSE;
	_g_object_unref0 (adjustment);
}

static void
conversation_list_view_on_conversations_removed (ConversationListView* self,
                                                 gboolean start)
{
	ApplicationConfiguration* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	_tmp0_ = self->priv->config;
	_tmp1_ = application_configuration_get_autoselect (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GtkSelectionMode _tmp3_ = 0;
		GtkSelectionMode mode = 0;
		GtkTreeSelection* _tmp4_;
		if (start) {
			_tmp3_ = GTK_SELECTION_NONE;
		} else {
			_tmp3_ = GTK_SELECTION_MULTIPLE;
		}
		mode = _tmp3_;
		_tmp4_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
		gtk_tree_selection_set_mode (_tmp4_, mode);
	}
}

static GtkAdjustment*
conversation_list_view_get_adjustment (ConversationListView* self)
{
	GtkScrolledWindow* parent = NULL;
	GtkContainer* _tmp0_;
	GtkScrolledWindow* _tmp1_;
	GtkScrolledWindow* _tmp2_;
	GtkScrolledWindow* _tmp3_;
	GtkAdjustment* _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkAdjustment* result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_VIEW (self), NULL);
	_tmp0_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_scrolled_window_get_type ()) ? ((GtkScrolledWindow*) _tmp0_) : NULL);
	parent = _tmp1_;
	_tmp2_ = parent;
	if (_tmp2_ == NULL) {
		g_debug ("conversation-list-view.vala:269: Parent was not scrolled window");
		result = NULL;
		_g_object_unref0 (parent);
		return result;
	}
	_tmp3_ = parent;
	_tmp4_ = gtk_scrolled_window_get_vadjustment (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	result = _tmp5_;
	_g_object_unref0 (parent);
	return result;
}

static GdkEvent*
_vala_GdkEvent_copy (GdkEvent* self)
{
	return g_boxed_copy (gdk_event_get_type (), self);
}

static gpointer
__vala_GdkEvent_copy0 (gpointer self)
{
	return self ? _vala_GdkEvent_copy (self) : NULL;
}

static void
_vala_GdkEventSequence_free (GdkEventSequence* self)
{
	g_boxed_free (gdk_event_sequence_get_type (), self);
}

static void
_vala_GdkEvent_free (GdkEvent* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}

static void
conversation_list_view_on_gesture_pressed (ConversationListView* self,
                                           gint n_press,
                                           gdouble x,
                                           gdouble y)
{
	GtkGestureMultiPress* _tmp0_;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreePath* _tmp2_;
	GearyAppConversation* c = NULL;
	ConversationListStore* _tmp3_;
	ConversationListStore* _tmp4_;
	GtkTreePath* _tmp5_;
	GearyAppConversation* _tmp6_;
	GearyAppConversation* _tmp7_;
	GearyAppConversation* _tmp8_;
	GdkEvent* event = NULL;
	GtkGestureMultiPress* _tmp9_;
	GtkGestureMultiPress* _tmp10_;
	GdkEventSequence* _tmp11_;
	GdkEventSequence* _tmp12_;
	GdkEvent* _tmp13_;
	GdkEvent* _tmp14_;
	GdkEvent* _tmp15_;
	GdkModifierType modifiers = 0U;
	GdkModifierType state_mask = 0U;
	GdkEvent* _tmp16_;
	GdkModifierType _tmp17_ = 0U;
	gboolean _tmp18_ = FALSE;
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	_tmp0_ = self->priv->gesture;
	if (gtk_gesture_single_get_current_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_gesture_single_get_type (), GtkGestureSingle)) != ((guint) GDK_BUTTON_PRIMARY)) {
		return;
	}
	gtk_tree_view_get_path_at_pos (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), (gint) x, (gint) y, &_tmp1_, NULL, NULL, NULL);
	__vala_GtkTreePath_free0 (path);
	path = _tmp1_;
	_tmp2_ = path;
	if (_tmp2_ == NULL) {
		__vala_GtkTreePath_free0 (path);
		return;
	}
	_tmp3_ = conversation_list_view_get_model (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = path;
	_tmp6_ = conversation_list_store_get_conversation_at_path (_tmp4_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp4_);
	c = _tmp7_;
	_tmp8_ = c;
	if (_tmp8_ == NULL) {
		_g_object_unref0 (c);
		__vala_GtkTreePath_free0 (path);
		return;
	}
	_tmp9_ = self->priv->gesture;
	_tmp10_ = self->priv->gesture;
	_tmp11_ = gtk_gesture_single_get_current_sequence (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_gesture_single_get_type (), GtkGestureSingle));
	_tmp12_ = _tmp11_;
	_tmp13_ = gtk_gesture_get_last_event (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_gesture_get_type (), GtkGesture), _tmp12_);
	_tmp14_ = __vala_GdkEvent_copy0 (_tmp13_);
	_tmp15_ = _tmp14_;
	__vala_GdkEventSequence_free0 (_tmp12_);
	event = _tmp15_;
	modifiers = gtk_accelerator_get_default_mod_mask ();
	_tmp16_ = event;
	gdk_event_get_state (_tmp16_, &_tmp17_);
	state_mask = _tmp17_;
	if ((state_mask & modifiers) == 0) {
		_tmp18_ = n_press == 1;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		GearyAppConversation* _tmp19_;
		_tmp19_ = c;
		g_signal_emit (self, conversation_list_view_signals[CONVERSATION_LIST_VIEW_CONVERSATION_ACTIVATED_SIGNAL], 0, _tmp19_, TRUE);
	} else {
		gboolean _tmp20_ = FALSE;
		if ((state_mask & modifiers) == GDK_SHIFT_MASK) {
			_tmp20_ = n_press == 2;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			GearyAppConversation* _tmp21_;
			_tmp21_ = c;
			g_signal_emit (self, conversation_list_view_signals[CONVERSATION_LIST_VIEW_CONVERSATION_ACTIVATED_SIGNAL], 0, _tmp21_, FALSE);
		}
	}
	__vala_GdkEvent_free0 (event);
	_g_object_unref0 (c);
	__vala_GtkTreePath_free0 (path);
}

static gboolean
conversation_list_view_on_key_press (ConversationListView* self,
                                     GdkEventKey* event)
{
	GeeSet* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GearyAppConversation* c = NULL;
	GeeSet* _tmp3_;
	gint _tmp4_ = 0;
	gpointer* _tmp5_;
	GearyAppConversation** _tmp6_;
	gint _tmp6__length1;
	GearyAppConversation* _tmp7_;
	GearyAppConversation* _tmp8_;
	GearyAppConversation* _tmp9_;
	GearyAppConversation* _tmp10_;
	GdkModifierType modifiers = 0U;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_VIEW (self), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->selected;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	if (_tmp2_ != 1) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->selected;
	_tmp5_ = gee_collection_to_array (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	_tmp7_ = _tmp6_[0];
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_object_unref), NULL);
	c = _tmp9_;
	_tmp10_ = c;
	if (_tmp10_ == NULL) {
		result = FALSE;
		_g_object_unref0 (c);
		return result;
	}
	modifiers = gtk_accelerator_get_default_mod_mask ();
	if (event->keyval == GDK_KEY_Return) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = event->keyval == GDK_KEY_ISO_Enter;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		_tmp13_ = event->keyval == GDK_KEY_KP_Enter;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = event->keyval == GDK_KEY_space;
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		_tmp11_ = event->keyval == GDK_KEY_KP_Space;
	}
	if (_tmp11_) {
		GearyAppConversation* _tmp15_;
		_tmp15_ = c;
		g_signal_emit (self, conversation_list_view_signals[CONVERSATION_LIST_VIEW_CONVERSATION_ACTIVATED_SIGNAL], 0, _tmp15_, !((event->state & modifiers) == GDK_SHIFT_MASK));
	}
	result = FALSE;
	_g_object_unref0 (c);
	return result;
}

static gboolean
conversation_list_view_on_button_press (ConversationListView* self,
                                        GdkEventButton* event)
{
	gint cell_x = 0;
	gint cell_y = 0;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkTreePath* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp45_ = FALSE;
	gboolean result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_VIEW (self), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_tree_view_get_path_at_pos (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), (gint) event->x, (gint) event->y, &_tmp0_, NULL, &_tmp1_, &_tmp2_);
	__vala_GtkTreePath_free0 (path);
	path = _tmp0_;
	cell_x = _tmp1_;
	cell_y = _tmp2_;
	_tmp3_ = path;
	if (_tmp3_ == NULL) {
		result = FALSE;
		__vala_GtkTreePath_free0 (path);
		return result;
	}
	if ((event->state & GDK_SHIFT_MASK) == 0) {
		_tmp5_ = (event->state & GDK_CONTROL_MASK) == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = event->type == GDK_BUTTON_PRESS;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean read_clicked = FALSE;
		gboolean star_clicked = FALSE;
		ApplicationConfiguration* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		GearyAppConversation* conversation = NULL;
		ConversationListStore* _tmp17_;
		ConversationListStore* _tmp18_;
		GtkTreePath* _tmp19_;
		GearyAppConversation* _tmp20_;
		GearyAppConversation* _tmp21_;
		GeeCollection* _tmp22_ = NULL;
		GeeSet* _tmp23_;
		GearyAppConversation* _tmp24_;
		GeeCollection* to_mark = NULL;
		GeeCollection* _tmp28_;
		read_clicked = FALSE;
		star_clicked = FALSE;
		_tmp6_ = self->priv->config;
		_tmp7_ = application_configuration_get_display_preview (_tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_) {
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			if (cell_x < 25) {
				_tmp10_ = cell_y >= 14;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				_tmp9_ = cell_y <= 30;
			} else {
				_tmp9_ = FALSE;
			}
			read_clicked = _tmp9_;
			if (cell_x < 25) {
				_tmp12_ = cell_y >= 40;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				_tmp11_ = cell_y <= 62;
			} else {
				_tmp11_ = FALSE;
			}
			star_clicked = _tmp11_;
		} else {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
			if (cell_x < 25) {
				_tmp14_ = cell_y >= 8;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				_tmp13_ = cell_y <= 22;
			} else {
				_tmp13_ = FALSE;
			}
			read_clicked = _tmp13_;
			if (cell_x < 25) {
				_tmp16_ = cell_y >= 28;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				_tmp15_ = cell_y <= 43;
			} else {
				_tmp15_ = FALSE;
			}
			star_clicked = _tmp15_;
		}
		_tmp17_ = conversation_list_view_get_model (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = path;
		_tmp20_ = conversation_list_store_get_conversation_at_path (_tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		_g_object_unref0 (_tmp18_);
		conversation = _tmp21_;
		_tmp23_ = self->priv->selected;
		_tmp24_ = conversation;
		if (gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_COLLECTION, GeeCollection), _tmp24_)) {
			GeeSet* _tmp25_;
			_tmp25_ = conversation_list_view_copy_selected (self);
			_g_object_unref0 (_tmp22_);
			_tmp22_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection);
		} else {
			GearyAppConversation* _tmp26_;
			GeeCollection* _tmp27_;
			_tmp26_ = conversation;
			_tmp27_ = geary_collection_single (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp26_);
			_g_object_unref0 (_tmp22_);
			_tmp22_ = _tmp27_;
		}
		_tmp28_ = _g_object_ref0 (_tmp22_);
		to_mark = _tmp28_;
		if (read_clicked) {
			GeeCollection* _tmp29_;
			GearyNamedFlag* _tmp30_;
			GearyNamedFlag* _tmp31_;
			GearyNamedFlag* _tmp32_;
			_tmp29_ = to_mark;
			_tmp30_ = geary_email_flags_get_UNREAD ();
			_tmp31_ = _tmp30_;
			_tmp32_ = _tmp31_;
			g_signal_emit (self, conversation_list_view_signals[CONVERSATION_LIST_VIEW_MARK_CONVERSATIONS_SIGNAL], 0, _tmp29_, _tmp32_);
			_g_object_unref0 (_tmp32_);
			result = TRUE;
			_g_object_unref0 (to_mark);
			_g_object_unref0 (_tmp22_);
			_g_object_unref0 (conversation);
			__vala_GtkTreePath_free0 (path);
			return result;
		} else {
			if (star_clicked) {
				GeeCollection* _tmp33_;
				GearyNamedFlag* _tmp34_;
				GearyNamedFlag* _tmp35_;
				GearyNamedFlag* _tmp36_;
				_tmp33_ = to_mark;
				_tmp34_ = geary_email_flags_get_FLAGGED ();
				_tmp35_ = _tmp34_;
				_tmp36_ = _tmp35_;
				g_signal_emit (self, conversation_list_view_signals[CONVERSATION_LIST_VIEW_MARK_CONVERSATIONS_SIGNAL], 0, _tmp33_, _tmp36_);
				_g_object_unref0 (_tmp36_);
				result = TRUE;
				_g_object_unref0 (to_mark);
				_g_object_unref0 (_tmp22_);
				_g_object_unref0 (conversation);
				__vala_GtkTreePath_free0 (path);
				return result;
			}
		}
		_g_object_unref0 (to_mark);
		_g_object_unref0 (_tmp22_);
		_g_object_unref0 (conversation);
	}
	if (event->type == GDK_BUTTON_PRESS) {
		GtkTreeSelection* _tmp38_;
		GtkTreePath* _tmp39_;
		_tmp38_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
		_tmp39_ = path;
		_tmp37_ = !gtk_tree_selection_path_is_selected (_tmp38_, _tmp39_);
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		ApplicationMainWindow* parent = NULL;
		GtkWidget* _tmp40_;
		ApplicationMainWindow* _tmp41_;
		gboolean _tmp42_ = FALSE;
		ApplicationMainWindow* _tmp43_;
		_tmp40_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp41_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (_tmp40_) ? ((ApplicationMainWindow*) _tmp40_) : NULL);
		parent = _tmp41_;
		_tmp43_ = parent;
		if (_tmp43_ != NULL) {
			ApplicationMainWindow* _tmp44_;
			_tmp44_ = parent;
			_tmp42_ = !application_main_window_close_composer (_tmp44_, FALSE, FALSE);
		} else {
			_tmp42_ = FALSE;
		}
		if (_tmp42_) {
			result = TRUE;
			_g_object_unref0 (parent);
			__vala_GtkTreePath_free0 (path);
			return result;
		}
		_g_object_unref0 (parent);
	}
	if (event->button == ((guint) 3)) {
		_tmp45_ = event->type == GDK_BUTTON_PRESS;
	} else {
		_tmp45_ = FALSE;
	}
	if (_tmp45_) {
		GearyAppConversation* conversation = NULL;
		ConversationListStore* _tmp46_;
		ConversationListStore* _tmp47_;
		GtkTreePath* _tmp48_;
		GearyAppConversation* _tmp49_;
		GearyAppConversation* _tmp50_;
		GMenu* context_menu_model = NULL;
		GMenu* _tmp51_;
		ApplicationMainWindow* main = NULL;
		GtkWidget* _tmp52_;
		ApplicationMainWindow* _tmp53_;
		ApplicationMainWindow* _tmp54_;
		GearyAppConversation* _tmp70_;
		GearyAppConversation* _tmp74_;
		GearyAppConversation* _tmp78_;
		gboolean _tmp85_ = FALSE;
		GearyAppConversation* _tmp86_;
		GearyFolder* _tmp87_;
		GearyFolder* _tmp88_;
		GearyFolderSpecialUse _tmp89_;
		GearyFolderSpecialUse _tmp90_;
		GMenu* actions_section = NULL;
		GMenu* _tmp99_;
		GMenu* _tmp100_;
		gchar* _tmp101_;
		gchar* _tmp102_;
		GMenu* _tmp103_;
		gchar* _tmp104_;
		gchar* _tmp105_;
		GMenu* _tmp106_;
		gchar* _tmp107_;
		gchar* _tmp108_;
		GMenu* _tmp109_;
		GMenu* _tmp110_;
		GtkPopover* context_menu = NULL;
		GMenu* _tmp111_;
		GtkPopover* _tmp112_;
		GdkRectangle dest = {0};
		GtkPopover* _tmp113_;
		GdkRectangle _tmp114_;
		GtkPopover* _tmp115_;
		GtkTreeSelection* _tmp116_;
		GtkTreePath* _tmp117_;
		_tmp46_ = conversation_list_view_get_model (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = path;
		_tmp49_ = conversation_list_store_get_conversation_at_path (_tmp47_, _tmp48_);
		_tmp50_ = _tmp49_;
		_g_object_unref0 (_tmp47_);
		conversation = _tmp50_;
		_tmp51_ = g_menu_new ();
		context_menu_model = _tmp51_;
		_tmp52_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp53_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (_tmp52_) ? ((ApplicationMainWindow*) _tmp52_) : NULL);
		main = _tmp53_;
		_tmp54_ = main;
		if (_tmp54_ != NULL) {
			ApplicationMainWindow* _tmp55_;
			gboolean _tmp56_;
			gboolean _tmp57_;
			_tmp55_ = main;
			_tmp56_ = application_main_window_get_is_shift_down (_tmp55_);
			_tmp57_ = _tmp56_;
			if (!_tmp57_) {
				GMenu* _tmp58_;
				GeeSet* _tmp59_;
				gint _tmp60_;
				gint _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				_tmp58_ = context_menu_model;
				_tmp59_ = self->priv->selected;
				_tmp60_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp61_ = _tmp60_;
				_tmp62_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_TRASH_CONVERSATION);
				_tmp63_ = _tmp62_;
				g_menu_append (_tmp58_, ngettext ("Move conversation to _Trash", "Move conversations to _Trash", (gulong) _tmp61_), _tmp63_);
				_g_free0 (_tmp63_);
			} else {
				GMenu* _tmp64_;
				GeeSet* _tmp65_;
				gint _tmp66_;
				gint _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				_tmp64_ = context_menu_model;
				_tmp65_ = self->priv->selected;
				_tmp66_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp67_ = _tmp66_;
				_tmp68_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_DELETE_CONVERSATION);
				_tmp69_ = _tmp68_;
				g_menu_append (_tmp64_, ngettext ("_Delete conversation", "_Delete conversations", (gulong) _tmp67_), _tmp69_);
				_g_free0 (_tmp69_);
			}
		}
		_tmp70_ = conversation;
		if (geary_app_conversation_is_unread (_tmp70_)) {
			GMenu* _tmp71_;
			gchar* _tmp72_;
			gchar* _tmp73_;
			_tmp71_ = context_menu_model;
			_tmp72_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_READ);
			_tmp73_ = _tmp72_;
			g_menu_append (_tmp71_, _ ("Mark as _Read"), _tmp73_);
			_g_free0 (_tmp73_);
		}
		_tmp74_ = conversation;
		if (geary_app_conversation_has_any_read_message (_tmp74_)) {
			GMenu* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			_tmp75_ = context_menu_model;
			_tmp76_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_UNREAD);
			_tmp77_ = _tmp76_;
			g_menu_append (_tmp75_, _ ("Mark as _Unread"), _tmp77_);
			_g_free0 (_tmp77_);
		}
		_tmp78_ = conversation;
		if (geary_app_conversation_is_flagged (_tmp78_)) {
			GMenu* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			_tmp79_ = context_menu_model;
			_tmp80_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_UNSTARRED);
			_tmp81_ = _tmp80_;
			g_menu_append (_tmp79_, _ ("U_nstar"), _tmp81_);
			_g_free0 (_tmp81_);
		} else {
			GMenu* _tmp82_;
			gchar* _tmp83_;
			gchar* _tmp84_;
			_tmp82_ = context_menu_model;
			_tmp83_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_MARK_AS_STARRED);
			_tmp84_ = _tmp83_;
			g_menu_append (_tmp82_, _ ("_Star"), _tmp84_);
			_g_free0 (_tmp84_);
		}
		_tmp86_ = conversation;
		_tmp87_ = geary_app_conversation_get_base_folder (_tmp86_);
		_tmp88_ = _tmp87_;
		_tmp89_ = geary_folder_get_used_as (_tmp88_);
		_tmp90_ = _tmp89_;
		if (_tmp90_ != GEARY_FOLDER_SPECIAL_USE_ARCHIVE) {
			GearyAppConversation* _tmp91_;
			GearyFolder* _tmp92_;
			GearyFolder* _tmp93_;
			GearyFolderSpecialUse _tmp94_;
			GearyFolderSpecialUse _tmp95_;
			_tmp91_ = conversation;
			_tmp92_ = geary_app_conversation_get_base_folder (_tmp91_);
			_tmp93_ = _tmp92_;
			_tmp94_ = geary_folder_get_used_as (_tmp93_);
			_tmp95_ = _tmp94_;
			_tmp85_ = _tmp95_ != GEARY_FOLDER_SPECIAL_USE_ALL_MAIL;
		} else {
			_tmp85_ = FALSE;
		}
		if (_tmp85_) {
			GMenu* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			_tmp96_ = context_menu_model;
			_tmp97_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_ARCHIVE_CONVERSATION);
			_tmp98_ = _tmp97_;
			g_menu_append (_tmp96_, _ ("Archive conversation"), _tmp98_);
			_g_free0 (_tmp98_);
		}
		_tmp99_ = g_menu_new ();
		actions_section = _tmp99_;
		_tmp100_ = actions_section;
		_tmp101_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_REPLY_CONVERSATION);
		_tmp102_ = _tmp101_;
		g_menu_append (_tmp100_, _ ("_Reply"), _tmp102_);
		_g_free0 (_tmp102_);
		_tmp103_ = actions_section;
		_tmp104_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_REPLY_ALL_CONVERSATION);
		_tmp105_ = _tmp104_;
		g_menu_append (_tmp103_, _ ("R_eply All"), _tmp105_);
		_g_free0 (_tmp105_);
		_tmp106_ = actions_section;
		_tmp107_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_FORWARD_CONVERSATION);
		_tmp108_ = _tmp107_;
		g_menu_append (_tmp106_, _ ("_Forward"), _tmp108_);
		_g_free0 (_tmp108_);
		_tmp109_ = context_menu_model;
		_tmp110_ = actions_section;
		g_menu_append_section (_tmp109_, NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp110_, g_menu_model_get_type (), GMenuModel));
		_tmp111_ = context_menu_model;
		_tmp112_ = (GtkPopover*) gtk_popover_new_from_model (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, g_menu_model_get_type (), GMenuModel));
		g_object_ref_sink (_tmp112_);
		context_menu = _tmp112_;
		memset (&dest, 0, sizeof (GdkRectangle));
		dest.x = (gint) event->x;
		dest.y = (gint) event->y;
		_tmp113_ = context_menu;
		_tmp114_ = dest;
		gtk_popover_set_pointing_to (_tmp113_, &_tmp114_);
		_tmp115_ = context_menu;
		gtk_popover_popup (_tmp115_);
		_tmp116_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
		_tmp117_ = path;
		result = gtk_tree_selection_path_is_selected (_tmp116_, _tmp117_);
		_g_object_unref0 (context_menu);
		_g_object_unref0 (actions_section);
		_g_object_unref0 (main);
		_g_object_unref0 (context_menu_model);
		_g_object_unref0 (conversation);
		__vala_GtkTreePath_free0 (path);
		return result;
	}
	result = FALSE;
	__vala_GtkTreePath_free0 (path);
	return result;
}

static void
conversation_list_view_on_style_changed (ConversationListView* self)
{
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	conversation_list_cell_renderer_style_changed (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	conversation_list_view_schedule_visible_conversations_changed (self);
}

static void
conversation_list_view_on_value_changed (ConversationListView* self)
{
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	if (self->priv->enable_load_more) {
		conversation_list_view_check_load_more (self);
	}
}

static GtkTreeViewColumn*
conversation_list_view_create_column (ConversationListStoreColumn column,
                                      GtkCellRenderer* renderer,
                                      const gchar* attr,
                                      gint width)
{
	GtkTreeViewColumn* view_column = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkTreeViewColumn* _tmp2_;
	GtkTreeViewColumn* _tmp3_;
	GtkTreeViewColumn* _tmp4_;
	GtkTreeViewColumn* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (renderer, gtk_cell_renderer_get_type ()), NULL);
	g_return_val_if_fail (attr != NULL, NULL);
	_tmp0_ = conversation_list_store_column_to_string (column);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_tree_view_column_new_with_attributes (_tmp1_, renderer, attr, column, NULL);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	view_column = _tmp3_;
	_tmp4_ = view_column;
	gtk_tree_view_column_set_resizable (_tmp4_, TRUE);
	if (width != 0) {
		GtkTreeViewColumn* _tmp5_;
		GtkTreeViewColumn* _tmp6_;
		_tmp5_ = view_column;
		gtk_tree_view_column_set_sizing (_tmp5_, GTK_TREE_VIEW_COLUMN_FIXED);
		_tmp6_ = view_column;
		gtk_tree_view_column_set_fixed_width (_tmp6_, width);
	}
	result = view_column;
	return result;
}

static GList*
conversation_list_view_get_all_selected_paths (ConversationListView* self)
{
	GtkTreeModel* model = NULL;
	GtkTreeSelection* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GList* _tmp2_;
	GtkTreeModel* _tmp3_;
	GList* result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_VIEW (self), NULL);
	_tmp0_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	_tmp2_ = gtk_tree_selection_get_selected_rows (_tmp0_, &_tmp1_);
	_g_object_unref0 (model);
	_tmp3_ = _g_object_ref0 (_tmp1_);
	model = _tmp3_;
	result = _tmp2_;
	_g_object_unref0 (model);
	return result;
}

static void
conversation_list_view_on_selection_changed (ConversationListView* self)
{
	GearyIdleManager* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	_tmp0_ = self->priv->selection_update;
	geary_idle_manager_schedule (_tmp0_);
}

static void
conversation_list_view_do_selection_changed (ConversationListView* self)
{
	GeeHashSet* new_selection = NULL;
	GeeHashSet* _tmp0_;
	GList* paths = NULL;
	GList* _tmp1_;
	GList* _tmp2_;
	gboolean _tmp13_ = FALSE;
	GeeSet* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GeeHashSet* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	_tmp0_ = gee_hash_set_new (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	new_selection = _tmp0_;
	_tmp1_ = conversation_list_view_get_all_selected_paths (self);
	paths = _tmp1_;
	_tmp2_ = paths;
	if (g_list_length (_tmp2_) != ((guint) 0)) {
		GList* _tmp3_;
		_tmp3_ = paths;
		{
			GList* path_collection = NULL;
			GList* path_it = NULL;
			path_collection = _tmp3_;
			for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
				GtkTreePath* _tmp4_;
				GtkTreePath* path = NULL;
				_tmp4_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) path_it->data);
				path = _tmp4_;
				{
					GearyAppConversation* conversation = NULL;
					ConversationListStore* _tmp5_;
					ConversationListStore* _tmp6_;
					GtkTreePath* _tmp7_;
					GearyAppConversation* _tmp8_;
					GearyAppConversation* _tmp9_;
					GearyAppConversation* _tmp10_;
					_tmp5_ = conversation_list_view_get_model (self);
					_tmp6_ = _tmp5_;
					_tmp7_ = path;
					_tmp8_ = conversation_list_store_get_conversation_at_path (_tmp6_, _tmp7_);
					_tmp9_ = _tmp8_;
					_g_object_unref0 (_tmp6_);
					conversation = _tmp9_;
					_tmp10_ = conversation;
					if (_tmp10_ != NULL) {
						GeeHashSet* _tmp11_;
						GearyAppConversation* _tmp12_;
						_tmp11_ = new_selection;
						_tmp12_ = conversation;
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp12_);
					}
					_g_object_unref0 (conversation);
					__vala_GtkTreePath_free0 (path);
				}
			}
		}
	}
	_tmp14_ = self->priv->selected;
	_tmp15_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp16_ = _tmp15_;
	_tmp17_ = new_selection;
	_tmp18_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp19_ = _tmp18_;
	if (_tmp16_ != _tmp19_) {
		_tmp13_ = TRUE;
	} else {
		GeeSet* _tmp20_;
		GeeHashSet* _tmp21_;
		_tmp20_ = self->priv->selected;
		_tmp21_ = new_selection;
		_tmp13_ = !gee_collection_contains_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
	}
	if (_tmp13_) {
		GeeHashSet* _tmp22_;
		GeeSet* _tmp23_;
		GeeSet* _tmp24_;
		GeeSet* _tmp25_;
		GeeSet* _tmp26_;
		GeeSet* _tmp27_;
		_tmp22_ = new_selection;
		_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_SET, GeeSet));
		_g_object_unref0 (self->priv->selected);
		self->priv->selected = _tmp23_;
		_tmp24_ = self->priv->selected;
		_tmp25_ = gee_set_get_read_only_view (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_;
		g_signal_emit (self, conversation_list_view_signals[CONVERSATION_LIST_VIEW_CONVERSATIONS_SELECTED_SIGNAL], 0, _tmp27_);
		_g_object_unref0 (_tmp27_);
	}
	(paths == NULL) ? NULL : (paths = (_g_list_free___vala_GtkTreePath_free0_ (paths), NULL));
	_g_object_unref0 (new_selection);
}

GeeSet*
conversation_list_view_get_visible_conversations (ConversationListView* self)
{
	GeeHashSet* visible_conversations = NULL;
	GeeHashSet* _tmp0_;
	GtkTreePath* start_path = NULL;
	GtkTreePath* end_path = NULL;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreePath* _tmp2_ = NULL;
	gboolean _tmp3_;
	GeeSet* result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_VIEW (self), NULL);
	_tmp0_ = gee_hash_set_new (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	visible_conversations = _tmp0_;
	_tmp3_ = gtk_tree_view_get_visible_range (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), &_tmp1_, &_tmp2_);
	__vala_GtkTreePath_free0 (start_path);
	start_path = _tmp1_;
	__vala_GtkTreePath_free0 (end_path);
	end_path = _tmp2_;
	if (!_tmp3_) {
		result = G_TYPE_CHECK_INSTANCE_CAST (visible_conversations, GEE_TYPE_SET, GeeSet);
		__vala_GtkTreePath_free0 (end_path);
		__vala_GtkTreePath_free0 (start_path);
		return result;
	}
	while (TRUE) {
		GtkTreePath* _tmp4_;
		GtkTreePath* _tmp5_;
		GearyAppConversation* conversation = NULL;
		ConversationListStore* _tmp6_;
		ConversationListStore* _tmp7_;
		GtkTreePath* _tmp8_;
		GearyAppConversation* _tmp9_;
		GearyAppConversation* _tmp10_;
		GearyAppConversation* _tmp11_;
		GtkTreePath* _tmp14_;
		_tmp4_ = start_path;
		_tmp5_ = end_path;
		if (!(gtk_tree_path_compare (_tmp4_, _tmp5_) <= 0)) {
			break;
		}
		_tmp6_ = conversation_list_view_get_model (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = start_path;
		_tmp9_ = conversation_list_store_get_conversation_at_path (_tmp7_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp7_);
		conversation = _tmp10_;
		_tmp11_ = conversation;
		if (_tmp11_ != NULL) {
			GeeHashSet* _tmp12_;
			GearyAppConversation* _tmp13_;
			_tmp12_ = visible_conversations;
			_tmp13_ = conversation;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp13_);
		}
		_tmp14_ = start_path;
		gtk_tree_path_next (_tmp14_);
		_g_object_unref0 (conversation);
	}
	result = G_TYPE_CHECK_INSTANCE_CAST (visible_conversations, GEE_TYPE_SET, GeeSet);
	__vala_GtkTreePath_free0 (end_path);
	__vala_GtkTreePath_free0 (start_path);
	return result;
}

static gboolean
conversation_list_view_update_visible_conversations (ConversationListView* self)
{
	gboolean changed = FALSE;
	GeeSet* visible_conversations = NULL;
	GeeSet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GeeSet* _tmp3_;
	gboolean result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_VIEW (self), FALSE);
	changed = FALSE;
	_tmp0_ = conversation_list_view_get_visible_conversations (self);
	visible_conversations = _tmp0_;
	_tmp3_ = self->priv->current_visible_conversations;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GeeSet* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		GeeSet* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp4_ = self->priv->current_visible_conversations;
		_tmp5_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp6_ = _tmp5_;
		_tmp7_ = visible_conversations;
		_tmp8_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp9_ = _tmp8_;
		_tmp2_ = _tmp6_ != _tmp9_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GeeSet* _tmp10_;
		GeeSet* _tmp11_;
		_tmp10_ = self->priv->current_visible_conversations;
		_tmp11_ = visible_conversations;
		_tmp1_ = !gee_collection_contains_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection));
	}
	if (_tmp1_) {
		GeeSet* _tmp12_;
		GeeSet* _tmp13_;
		GeeSet* _tmp14_;
		GeeSet* _tmp15_;
		GeeSet* _tmp16_;
		GeeSet* _tmp17_;
		_tmp12_ = visible_conversations;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_g_object_unref0 (self->priv->current_visible_conversations);
		self->priv->current_visible_conversations = _tmp13_;
		_tmp14_ = self->priv->current_visible_conversations;
		_tmp15_ = gee_set_get_read_only_view (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		g_signal_emit (self, conversation_list_view_signals[CONVERSATION_LIST_VIEW_VISIBLE_CONVERSATIONS_CHANGED_SIGNAL], 0, _tmp17_);
		_g_object_unref0 (_tmp17_);
		changed = TRUE;
	}
	result = changed;
	_g_object_unref0 (visible_conversations);
	return result;
}

static gboolean
_conversation_list_view_update_visible_conversations_gsource_func (gpointer self)
{
	gboolean result;
	result = conversation_list_view_update_visible_conversations ((ConversationListView*) self);
	return result;
}

static void
conversation_list_view_schedule_visible_conversations_changed (ConversationListView* self)
{
	GearySchedulerScheduled* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	_tmp0_ = geary_scheduler_on_idle (_conversation_list_view_update_visible_conversations_gsource_func, self, G_PRIORITY_DEFAULT_IDLE);
	_g_object_unref0 (self->priv->scheduled_update_visible_conversations);
	self->priv->scheduled_update_visible_conversations = _tmp0_;
}

void
conversation_list_view_select_conversations (ConversationListView* self,
                                             GeeCollection* new_selection)
{
	gboolean _tmp0_ = FALSE;
	GeeSet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_selection, GEE_TYPE_COLLECTION));
	_tmp1_ = self->priv->selected;
	_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_collection_get_size (new_selection);
	_tmp5_ = _tmp4_;
	if (_tmp3_ != _tmp5_) {
		_tmp0_ = TRUE;
	} else {
		GeeSet* _tmp6_;
		_tmp6_ = self->priv->selected;
		_tmp0_ = !gee_collection_contains_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection), new_selection);
	}
	if (_tmp0_) {
		GtkTreeSelection* selection = NULL;
		GtkTreeSelection* _tmp7_;
		GtkTreeSelection* _tmp8_;
		GtkTreeSelection* _tmp9_;
		ConversationListStore* model = NULL;
		ConversationListStore* _tmp10_;
		ConversationListStore* _tmp11_;
		_tmp7_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
		_tmp8_ = _g_object_ref0 (_tmp7_);
		selection = _tmp8_;
		_tmp9_ = selection;
		gtk_tree_selection_unselect_all (_tmp9_);
		_tmp10_ = conversation_list_view_get_model (self);
		model = _tmp10_;
		_tmp11_ = model;
		if (_tmp11_ != NULL) {
			{
				GeeIterator* _conversation_it = NULL;
				GeeIterator* _tmp12_;
				_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (new_selection, GEE_TYPE_ITERABLE, GeeIterable));
				_conversation_it = _tmp12_;
				while (TRUE) {
					GeeIterator* _tmp13_;
					GearyAppConversation* conversation = NULL;
					GeeIterator* _tmp14_;
					gpointer _tmp15_;
					GtkTreePath* path = NULL;
					ConversationListStore* _tmp16_;
					GearyAppConversation* _tmp17_;
					GtkTreePath* _tmp18_;
					GtkTreePath* _tmp19_;
					_tmp13_ = _conversation_it;
					if (!gee_iterator_next (_tmp13_)) {
						break;
					}
					_tmp14_ = _conversation_it;
					_tmp15_ = gee_iterator_get (_tmp14_);
					conversation = (GearyAppConversation*) _tmp15_;
					_tmp16_ = model;
					_tmp17_ = conversation;
					_tmp18_ = conversation_list_store_get_path_for_conversation (_tmp16_, _tmp17_);
					path = _tmp18_;
					_tmp19_ = path;
					if (_tmp19_ != NULL) {
						GtkTreeSelection* _tmp20_;
						GtkTreePath* _tmp21_;
						_tmp20_ = selection;
						_tmp21_ = path;
						gtk_tree_selection_select_path (_tmp20_, _tmp21_);
					}
					__vala_GtkTreePath_free0 (path);
					_g_object_unref0 (conversation);
				}
				_g_object_unref0 (_conversation_it);
			}
		}
		_g_object_unref0 (model);
		_g_object_unref0 (selection);
	}
}

static void
conversation_list_view_on_rows_changed (ConversationListView* self)
{
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	conversation_list_view_schedule_visible_conversations_changed (self);
}

static gboolean
_conversation_list_view_refresh_path_gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                                  GtkTreePath* path,
                                                                  GtkTreeIter* iter,
                                                                  gpointer self)
{
	gboolean result;
	result = conversation_list_view_refresh_path ((ConversationListView*) self, model, path, iter);
	return result;
}

static void
conversation_list_view_on_display_preview_changed (ConversationListView* self)
{
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp1_;
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "style-updated");
	_tmp0_ = gtk_tree_view_get_model (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	_tmp1_ = _tmp0_;
	gtk_tree_model_foreach (_tmp1_, _conversation_list_view_refresh_path_gtk_tree_model_foreach_func, self);
	conversation_list_view_schedule_visible_conversations_changed (self);
}

static gboolean
conversation_list_view_refresh_path (ConversationListView* self,
                                     GtkTreeModel* model,
                                     GtkTreePath* path,
                                     GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_VIEW (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (model, gtk_tree_model_get_type ()), FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	gtk_tree_model_row_changed (model, path, &_tmp0_);
	result = FALSE;
	return result;
}

static void
conversation_list_view_set_hover_selected (ConversationListView* self,
                                           gboolean hover)
{
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	conversation_list_cell_renderer_set_hover_selected (hover);
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static gboolean
conversation_list_view_on_motion_notify_event (ConversationListView* self,
                                               GdkEventMotion* event)
{
	GtkTreeSelection* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_VIEW (self), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	if (gtk_tree_selection_count_selected_rows (_tmp0_) > 0) {
		GtkTreePath* path = NULL;
		gint cell_x = 0;
		gint cell_y = 0;
		GtkTreePath* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gboolean _tmp4_ = FALSE;
		GtkTreePath* _tmp5_;
		path = NULL;
		gtk_tree_view_get_path_at_pos (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), (gint) event->x, (gint) event->y, &_tmp1_, NULL, &_tmp2_, &_tmp3_);
		__vala_GtkTreePath_free0 (path);
		path = _tmp1_;
		cell_x = _tmp2_;
		cell_y = _tmp3_;
		_tmp5_ = path;
		if (_tmp5_ != NULL) {
			GtkTreeSelection* _tmp6_;
			GtkTreePath* _tmp7_;
			_tmp6_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
			_tmp7_ = path;
			_tmp4_ = gtk_tree_selection_path_is_selected (_tmp6_, _tmp7_);
		} else {
			_tmp4_ = FALSE;
		}
		conversation_list_view_set_hover_selected (self, _tmp4_);
		__vala_GtkTreePath_free0 (path);
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
conversation_list_view_on_leave_notify_event (ConversationListView* self)
{
	GtkTreeSelection* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_VIEW (self), FALSE);
	_tmp0_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	if (gtk_tree_selection_count_selected_rows (_tmp0_) > 0) {
		conversation_list_view_set_hover_selected (self, FALSE);
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static void
_conversation_list_view_on_value_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                       gpointer self)
{
	conversation_list_view_on_value_changed ((ConversationListView*) self);
}

static void
conversation_list_view_on_vadjustment_changed (ConversationListView* self)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	g_return_if_fail (IS_CONVERSATION_LIST_VIEW (self));
	_tmp0_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable));
	_tmp1_ = _tmp0_;
	g_signal_connect_object (_tmp1_, "value-changed", (GCallback) _conversation_list_view_on_value_changed_gtk_adjustment_value_changed, self, 0);
}

static void
conversation_list_view_class_init (ConversationListViewClass * klass,
                                   gpointer klass_data)
{
	conversation_list_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConversationListView_private_offset);
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) conversation_list_view_real_destroy;
	((ConversationListViewClass *) klass)->load_more = conversation_list_view_real_load_more;
	G_OBJECT_CLASS (klass)->finalize = conversation_list_view_finalize;
	conversation_list_view_signals[CONVERSATION_LIST_VIEW_CONVERSATIONS_SELECTED_SIGNAL] = g_signal_new ("conversations-selected", TYPE_CONVERSATION_LIST_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_SET);
	conversation_list_view_signals[CONVERSATION_LIST_VIEW_CONVERSATION_ACTIVATED_SIGNAL] = g_signal_new ("conversation-activated", TYPE_CONVERSATION_LIST_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN, G_TYPE_NONE, 2, GEARY_APP_TYPE_CONVERSATION, G_TYPE_BOOLEAN);
	conversation_list_view_signals[CONVERSATION_LIST_VIEW_LOAD_MORE_SIGNAL] = g_signal_new ("load-more", TYPE_CONVERSATION_LIST_VIEW, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ConversationListViewClass, load_more), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	conversation_list_view_signals[CONVERSATION_LIST_VIEW_MARK_CONVERSATIONS_SIGNAL] = g_signal_new ("mark-conversations", TYPE_CONVERSATION_LIST_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEE_TYPE_COLLECTION, GEARY_TYPE_NAMED_FLAG);
	conversation_list_view_signals[CONVERSATION_LIST_VIEW_VISIBLE_CONVERSATIONS_CHANGED_SIGNAL] = g_signal_new ("visible-conversations-changed", TYPE_CONVERSATION_LIST_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_SET);
}

static void
conversation_list_view_geary_base_interface_interface_init (GearyBaseInterfaceIface * iface,
                                                            gpointer iface_data)
{
	conversation_list_view_geary_base_interface_parent_iface = g_type_interface_peek_parent (iface);
}

static void
conversation_list_view_instance_init (ConversationListView * self,
                                      gpointer klass)
{
	GeeHashSet* _tmp0_;
	self->priv = conversation_list_view_get_instance_private (self);
	self->priv->enable_load_more = TRUE;
	self->priv->reset_adjustment = FALSE;
	self->priv->current_visible_conversations = NULL;
	self->priv->scheduled_update_visible_conversations = NULL;
	_tmp0_ = gee_hash_set_new (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->selected = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SET, GeeSet);
	self->priv->should_inhibit_autoselect = FALSE;
}

static void
conversation_list_view_finalize (GObject * obj)
{
	ConversationListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONVERSATION_LIST_VIEW, ConversationListView);
	geary_base_interface_base_unref (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_BASE_INTERFACE, GearyBaseInterface));
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->current_visible_conversations);
	_g_object_unref0 (self->priv->scheduled_update_visible_conversations);
	_g_object_unref0 (self->priv->selected);
	_g_object_unref0 (self->priv->selection_update);
	_g_object_unref0 (self->priv->gesture);
	G_OBJECT_CLASS (conversation_list_view_parent_class)->finalize (obj);
}

static GType
conversation_list_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConversationListViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) conversation_list_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConversationListView), 0, (GInstanceInitFunc) conversation_list_view_instance_init, NULL };
	static const GInterfaceInfo geary_base_interface_info = { (GInterfaceInitFunc) conversation_list_view_geary_base_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType conversation_list_view_type_id;
	conversation_list_view_type_id = g_type_register_static (gtk_tree_view_get_type (), "ConversationListView", &g_define_type_info, 0);
	g_type_add_interface_static (conversation_list_view_type_id, GEARY_TYPE_BASE_INTERFACE, &geary_base_interface_info);
	ConversationListView_private_offset = g_type_add_instance_private (conversation_list_view_type_id, sizeof (ConversationListViewPrivate));
	return conversation_list_view_type_id;
}

GType
conversation_list_view_get_type (void)
{
	static volatile gsize conversation_list_view_type_id__once = 0;
	if (g_once_init_enter (&conversation_list_view_type_id__once)) {
		GType conversation_list_view_type_id;
		conversation_list_view_type_id = conversation_list_view_get_type_once ();
		g_once_init_leave (&conversation_list_view_type_id__once, conversation_list_view_type_id);
	}
	return conversation_list_view_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

